/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.NamedClass;
import org.eclipse.sisu.space.ResourceEnumeration;
import org.osgi.framework.Bundle;

public final class BundleClassSpace
implements ClassSpace {
    private static final URL[] NO_URLS = new URL[0];
    private static final Enumeration<URL> NO_ENTRIES = Collections.enumeration(Collections.emptySet());
    private final Bundle bundle;
    private URL[] bundleClassPath;

    public BundleClassSpace(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Class<?> loadClass(String name2) {
        try {
            return this.bundle.loadClass(name2);
        }
        catch (Exception e2) {
            throw new TypeNotPresentException(name2, e2);
        }
        catch (LinkageError e3) {
            throw new TypeNotPresentException(name2, e3);
        }
    }

    @Override
    public DeferredClass<?> deferLoadClass(String name2) {
        return new NamedClass(this, name2);
    }

    @Override
    public URL getResource(String name2) {
        return this.bundle.getResource(name2);
    }

    @Override
    public Enumeration<URL> getResources(String name2) {
        try {
            Enumeration<URL> resources = this.bundle.getResources(name2);
            return resources != null ? resources : NO_ENTRIES;
        }
        catch (IOException iOException) {
            return NO_ENTRIES;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        URL[] classPath = this.getBundleClassPath();
        Enumeration<URL> entries = this.bundle.findEntries(path != null ? path : "/", glob, recurse);
        if (classPath.length > 0) {
            return new ChainedEnumeration<URL>(entries, new ResourceEnumeration(path, glob, recurse, classPath));
        }
        return entries != null ? entries : NO_ENTRIES;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof BundleClassSpace) {
            return this.bundle.equals(((BundleClassSpace)rhs).bundle);
        }
        return false;
    }

    public String toString() {
        return this.bundle.toString();
    }

    private synchronized URL[] getBundleClassPath() {
        if (this.bundleClassPath == null) {
            String path = (String)this.bundle.getHeaders().get("Bundle-ClassPath");
            if (path == null) {
                this.bundleClassPath = NO_URLS;
            } else {
                ArrayList<URL> classPath = new ArrayList<URL>();
                HashSet<String> visited = new HashSet<String>();
                visited.add(".");
                String[] stringArray = path.trim().split("\\s*,\\s*");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    URL url;
                    String entry = stringArray[n3];
                    if (visited.add(entry) && (url = this.bundle.getEntry(entry)) != null) {
                        classPath.add(url);
                    }
                    ++n3;
                }
                this.bundleClassPath = classPath.isEmpty() ? NO_URLS : classPath.toArray(new URL[classPath.size()]);
            }
        }
        return this.bundleClassPath;
    }

    private static final class ChainedEnumeration<T>
    implements Enumeration<T> {
        private final Enumeration<T>[] enumerations;
        private int index;

        ChainedEnumeration(Enumeration<T> ... enumerations) {
            this.enumerations = enumerations;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.index < this.enumerations.length) {
                if (this.enumerations[this.index] != null && this.enumerations[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public T nextElement() {
            if (this.hasMoreElements()) {
                return this.enumerations[this.index].nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

