/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.listener;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;

public final class ChainedRepositoryListener
extends AbstractRepositoryListener {
    private final List<RepositoryListener> listeners = new CopyOnWriteArrayList<RepositoryListener>();

    public static RepositoryListener newInstance(RepositoryListener listener1, RepositoryListener listener2) {
        if (listener1 == null) {
            return listener2;
        }
        if (listener2 == null) {
            return listener1;
        }
        return new ChainedRepositoryListener(listener1, listener2);
    }

    public ChainedRepositoryListener(RepositoryListener ... listeners) {
        if (listeners != null) {
            this.add(Arrays.asList(listeners));
        }
    }

    public ChainedRepositoryListener(Collection<? extends RepositoryListener> listeners) {
        this.add(listeners);
    }

    public void add(Collection<? extends RepositoryListener> listeners) {
        if (listeners != null) {
            for (RepositoryListener repositoryListener : listeners) {
                this.add(repositoryListener);
            }
        }
    }

    public void add(RepositoryListener listener2) {
        if (listener2 != null) {
            this.listeners.add(listener2);
        }
    }

    public void remove(RepositoryListener listener2) {
        if (listener2 != null) {
            this.listeners.remove(listener2);
        }
    }

    protected void handleError(RepositoryEvent event, RepositoryListener listener2, RuntimeException error2) {
    }

    @Override
    public void artifactDeployed(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactDeployed(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactDeploying(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactDeploying(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactDescriptorInvalid(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactDescriptorMissing(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactDownloaded(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactDownloaded(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactDownloading(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactDownloading(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactInstalled(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactInstalled(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactInstalling(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactInstalling(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactResolved(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactResolved(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void artifactResolving(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.artifactResolving(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataDeployed(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataDeployed(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataDeploying(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataDeploying(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataDownloaded(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataDownloaded(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataDownloading(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataDownloading(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataInstalled(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataInstalled(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataInstalling(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataInstalling(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataInvalid(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataResolved(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataResolved(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }

    @Override
    public void metadataResolving(RepositoryEvent event) {
        for (RepositoryListener listener2 : this.listeners) {
            try {
                listener2.metadataResolving(event);
            }
            catch (RuntimeException e2) {
                this.handleError(event, listener2, e2);
            }
        }
    }
}

