/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.visitor;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.Stack;

public class CloningDependencyVisitor
implements DependencyVisitor {
    private final Map<DependencyNode, DependencyNode> clones;
    private final Stack<DependencyNode> parents = new Stack();
    private DependencyNode root;

    public CloningDependencyVisitor() {
        this.clones = new IdentityHashMap<DependencyNode, DependencyNode>(256);
    }

    public final DependencyNode getRootNode() {
        return this.root;
    }

    protected DependencyNode clone(DependencyNode node2) {
        return new DefaultDependencyNode(node2);
    }

    @Override
    public final boolean visitEnter(DependencyNode node2) {
        boolean recurse = true;
        DependencyNode clone = this.clones.get(node2);
        if (clone == null) {
            clone = this.clone(node2);
            this.clones.put(node2, clone);
        } else {
            recurse = false;
        }
        DependencyNode parent2 = this.parents.peek();
        if (parent2 == null) {
            this.root = clone;
        } else {
            parent2.getChildren().add(clone);
        }
        this.parents.push(clone);
        return recurse;
    }

    @Override
    public final boolean visitLeave(DependencyNode node2) {
        this.parents.pop();
        return true;
    }
}

