/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.resolution;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.graph.DependencyCycle;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;

public final class DependencyResult {
    private final DependencyRequest request;
    private DependencyNode root;
    private List<DependencyCycle> cycles;
    private List<Exception> collectExceptions;
    private List<ArtifactResult> artifactResults;

    public DependencyResult(DependencyRequest request2) {
        this.request = Objects.requireNonNull(request2, "dependency request cannot be null");
        this.root = request2.getRoot();
        this.cycles = Collections.emptyList();
        this.collectExceptions = Collections.emptyList();
        this.artifactResults = Collections.emptyList();
    }

    public DependencyRequest getRequest() {
        return this.request;
    }

    public DependencyNode getRoot() {
        return this.root;
    }

    public DependencyResult setRoot(DependencyNode root2) {
        this.root = root2;
        return this;
    }

    public List<DependencyCycle> getCycles() {
        return this.cycles;
    }

    public DependencyResult setCycles(List<DependencyCycle> cycles) {
        this.cycles = cycles == null ? Collections.emptyList() : cycles;
        return this;
    }

    public List<Exception> getCollectExceptions() {
        return this.collectExceptions;
    }

    public DependencyResult setCollectExceptions(List<Exception> exceptions) {
        this.collectExceptions = exceptions == null ? Collections.emptyList() : exceptions;
        return this;
    }

    public List<ArtifactResult> getArtifactResults() {
        return this.artifactResults;
    }

    public DependencyResult setArtifactResults(List<ArtifactResult> results2) {
        this.artifactResults = results2 == null ? Collections.emptyList() : results2;
        return this;
    }

    public String toString() {
        return String.valueOf(this.artifactResults);
    }
}

