/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public class PrettyPrintXMLWriter
implements XMLWriter {
    protected static final String LS = System.getProperty("line.separator");
    private PrintWriter writer;
    private LinkedList<String> elementStack = new LinkedList();
    private boolean tagInProgress;
    private int depth;
    private String lineIndenter;
    private String lineSeparator;
    private String encoding;
    private String docType;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;
    private static final Pattern amp = Pattern.compile("&");
    private static final Pattern lt = Pattern.compile("<");
    private static final Pattern gt = Pattern.compile(">");
    private static final Pattern dqoute = Pattern.compile("\"");
    private static final Pattern sqoute = Pattern.compile("'");
    private static final String crlf_str = "\r\n";
    private static final Pattern crlf = Pattern.compile("\r\n");
    private static final Pattern lowers = Pattern.compile("([\u0000-\u001f])");

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndenter) {
        this(writer, lineIndenter, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndenter) {
        this(new PrintWriter(writer), lineIndenter);
    }

    public PrettyPrintXMLWriter(PrintWriter writer) {
        this(writer, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndenter, String encoding, String doctype) {
        this(writer, lineIndenter, LS, encoding, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndenter, String encoding, String doctype) {
        this(new PrintWriter(writer), lineIndenter, encoding, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String encoding, String doctype) {
        this(writer, "  ", encoding, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer, String encoding, String doctype) {
        this(new PrintWriter(writer), encoding, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndenter, String lineSeparator, String encoding, String doctype) {
        this.setWriter(writer);
        this.setLineIndenter(lineIndenter);
        this.setLineSeparator(lineSeparator);
        this.setEncoding(encoding);
        this.setDocType(doctype);
        if (doctype != null || encoding != null) {
            this.writeDocumentHeaders();
        }
    }

    @Override
    public void startElement(String name2) {
        this.tagIsEmpty = false;
        this.finishTag();
        this.write("<");
        this.write(name2);
        this.elementStack.addLast(name2);
        this.tagInProgress = true;
        this.setDepth(this.getDepth() + 1);
        this.readyForNewLine = true;
        this.tagIsEmpty = true;
    }

    @Override
    public void writeText(String text2) {
        this.writeText(text2, true);
    }

    @Override
    public void writeMarkup(String text2) {
        this.writeText(text2, false);
    }

    private void writeText(String text2, boolean escapeXml) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        if (escapeXml) {
            text2 = PrettyPrintXMLWriter.escapeXml(text2);
        }
        this.write(StringUtils.unifyLineSeparators(text2, this.lineSeparator));
    }

    private static String escapeXml(String text2) {
        if (text2.indexOf(38) >= 0) {
            text2 = amp.matcher(text2).replaceAll("&amp;");
        }
        if (text2.indexOf(60) >= 0) {
            text2 = lt.matcher(text2).replaceAll("&lt;");
        }
        if (text2.indexOf(62) >= 0) {
            text2 = gt.matcher(text2).replaceAll("&gt;");
        }
        if (text2.indexOf(34) >= 0) {
            text2 = dqoute.matcher(text2).replaceAll("&quot;");
        }
        if (text2.indexOf(39) >= 0) {
            text2 = sqoute.matcher(text2).replaceAll("&apos;");
        }
        return text2;
    }

    private static String escapeXmlAttribute(String text2) {
        text2 = PrettyPrintXMLWriter.escapeXml(text2);
        Matcher crlfmatcher = crlf.matcher(text2);
        if (text2.contains(crlf_str)) {
            text2 = crlfmatcher.replaceAll("&#10;");
        }
        Matcher m = lowers.matcher(text2);
        StringBuffer b2 = new StringBuffer();
        while (m.find()) {
            m = m.appendReplacement(b2, "&#" + Integer.toString(m.group(1).charAt(0)) + ";");
        }
        m.appendTail(b2);
        return b2.toString();
    }

    @Override
    public void addAttribute(String key2, String value2) {
        this.write(" ");
        this.write(key2);
        this.write("=\"");
        this.write(PrettyPrintXMLWriter.escapeXmlAttribute(value2));
        this.write("\"");
    }

    @Override
    public void endElement() {
        this.setDepth(this.getDepth() - 1);
        if (this.tagIsEmpty) {
            this.write("/");
            this.readyForNewLine = false;
            this.finishTag();
            this.elementStack.removeLast();
        } else {
            this.finishTag();
            this.write("</");
            this.write(this.elementStack.removeLast());
            this.write(">");
        }
        this.readyForNewLine = true;
    }

    private void write(String str) {
        this.getWriter().write(str);
    }

    private void finishTag() {
        if (this.tagInProgress) {
            this.write(">");
        }
        this.tagInProgress = false;
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected String getLineIndenter() {
        return this.lineIndenter;
    }

    protected void setLineIndenter(String lineIndenter) {
        this.lineIndenter = lineIndenter;
    }

    protected String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    protected void endOfLine() {
        this.write(this.getLineSeparator());
        for (int i2 = 0; i2 < this.getDepth(); ++i2) {
            this.write(this.getLineIndenter());
        }
    }

    private void writeDocumentHeaders() {
        this.write("<?xml version=\"1.0\"");
        if (this.getEncoding() != null) {
            this.write(" encoding=\"" + this.getEncoding() + "\"");
        }
        this.write("?>");
        this.endOfLine();
        if (this.getDocType() != null) {
            this.write("<!DOCTYPE ");
            this.write(this.getDocType());
            this.write(">");
            this.endOfLine();
        }
    }

    protected void setWriter(PrintWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer could not be null");
        }
        this.writer = writer;
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected void setDepth(int depth) {
        this.depth = depth;
    }

    protected int getDepth() {
        return this.depth;
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected void setDocType(String docType) {
        this.docType = docType;
    }

    protected String getDocType() {
        return this.docType;
    }

    protected LinkedList<String> getElementStack() {
        return this.elementStack;
    }
}

