/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import org.codehaus.plexus.util.MatchPatterns;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScanner
implements Scanner {
    public static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/project.pj", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"};
    protected String[] includes;
    private MatchPatterns includesPatterns;
    protected String[] excludes;
    private MatchPatterns excludesPatterns;
    protected boolean isCaseSensitive = true;
    protected Comparator<String> filenameComparator;

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    protected static boolean matchPatternStart(String pattern2, String str) {
        return SelectorUtils.matchPatternStart(pattern2, str);
    }

    protected static boolean matchPatternStart(String pattern2, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern2, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern2, String str) {
        return SelectorUtils.matchPath(pattern2, str);
    }

    protected static boolean matchPath(String pattern2, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern2, str, isCaseSensitive);
    }

    public static boolean match(String pattern2, String str) {
        return SelectorUtils.match(pattern2, str);
    }

    protected static boolean match(String pattern2, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern2, str, isCaseSensitive);
    }

    @Override
    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            ArrayList<String> list = new ArrayList<String>(includes.length);
            for (String include : includes) {
                if (include == null) continue;
                list.add(this.normalizePattern(include));
            }
            this.includes = list.toArray(new String[0]);
        }
    }

    @Override
    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            ArrayList<String> list = new ArrayList<String>(excludes.length);
            for (String exclude : excludes) {
                if (exclude == null) continue;
                list.add(this.normalizePattern(exclude));
            }
            this.excludes = list.toArray(new String[0]);
        }
    }

    private String normalizePattern(String pattern2) {
        if ((pattern2 = pattern2.trim()).startsWith("%regex[")) {
            pattern2 = File.separatorChar == '\\' ? StringUtils.replace(pattern2, "/", "\\\\") : StringUtils.replace(pattern2, "\\\\", "/");
        } else if ((pattern2 = pattern2.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern2 = pattern2 + "**";
        }
        return pattern2;
    }

    protected boolean isIncluded(String name2) {
        return this.includesPatterns.matches(name2, this.isCaseSensitive);
    }

    protected boolean isIncluded(String name2, String[] tokenizedName) {
        return this.includesPatterns.matches(name2, tokenizedName, this.isCaseSensitive);
    }

    protected boolean isIncluded(String name2, char[][] tokenizedName) {
        return this.includesPatterns.matches(name2, tokenizedName, this.isCaseSensitive);
    }

    protected boolean couldHoldIncluded(String name2) {
        return this.includesPatterns.matchesPatternStart(name2, this.isCaseSensitive);
    }

    protected boolean isExcluded(String name2) {
        return this.excludesPatterns.matches(name2, this.isCaseSensitive);
    }

    protected boolean isExcluded(String name2, String[] tokenizedName) {
        return this.excludesPatterns.matches(name2, tokenizedName, this.isCaseSensitive);
    }

    protected boolean isExcluded(String name2, char[][] tokenizedName) {
        return this.excludesPatterns.matches(name2, tokenizedName, this.isCaseSensitive);
    }

    @Override
    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i2 = 0; i2 < DEFAULTEXCLUDES.length; ++i2) {
            newExcludes[i2 + excludesLength] = DEFAULTEXCLUDES[i2].replace('/', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    protected void setupDefaultFilters() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    protected void setupMatchPatterns() {
        this.includesPatterns = MatchPatterns.from(this.includes);
        this.excludesPatterns = MatchPatterns.from(this.excludes);
    }

    @Override
    public void setFilenameComparator(Comparator<String> filenameComparator) {
        this.filenameComparator = filenameComparator;
    }
}

