/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.inheritance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.inheritance.InheritanceAssembler;
import org.apache.maven.model.merge.MavenModelMerger;
import org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultInheritanceAssembler
implements InheritanceAssembler {
    private InheritanceModelMerger merger = new InheritanceModelMerger();
    private static final String CHILD_DIRECTORY = "child-directory";
    private static final String CHILD_DIRECTORY_PROPERTY = "project.directory";

    @Override
    public void assembleModelInheritance(Model child, Model parent2, ModelBuildingRequest request2, ModelProblemCollector problems) {
        HashMap<String, String> hints = new HashMap<String, String>();
        String childPath = child.getProperties().getProperty(CHILD_DIRECTORY_PROPERTY, child.getArtifactId());
        hints.put(CHILD_DIRECTORY, childPath);
        hints.put("child-path-adjustment", this.getChildPathAdjustment(child, parent2, childPath));
        this.merger.merge(child, parent2, false, hints);
    }

    private String getChildPathAdjustment(Model child, Model parent2, String childDirectory) {
        String adjustment = "";
        if (parent2 != null) {
            String childName = child.getArtifactId();
            if (child.getProjectDirectory() != null) {
                childName = child.getProjectDirectory().getName();
            }
            for (String module : parent2.getModules()) {
                int lastSlash;
                String moduleName;
                if ((module = module.replace('\\', '/')).regionMatches(true, module.length() - 4, ".xml", 0, 4)) {
                    module = module.substring(0, module.lastIndexOf(47) + 1);
                }
                if ((moduleName = module).endsWith("/")) {
                    moduleName = moduleName.substring(0, moduleName.length() - 1);
                }
                if (!(moduleName = moduleName.substring((lastSlash = moduleName.lastIndexOf(47)) + 1)).equals(childName) && !moduleName.equals(childDirectory) || lastSlash < 0) continue;
                adjustment = module.substring(0, lastSlash);
                break;
            }
        }
        return adjustment;
    }

    protected static class InheritanceModelMerger
    extends MavenModelMerger {
        protected InheritanceModelMerger() {
        }

        @Override
        protected String extrapolateChildUrl(String parentUrl, boolean appendPath, Map<Object, Object> context) {
            Object childDirectory = context.get(DefaultInheritanceAssembler.CHILD_DIRECTORY);
            Object childPathAdjustment = context.get("child-path-adjustment");
            if (StringUtils.isBlank(parentUrl) || childDirectory == null || childPathAdjustment == null || !appendPath) {
                return parentUrl;
            }
            return this.appendPath(parentUrl, childDirectory.toString(), childPathAdjustment.toString());
        }

        private String appendPath(String parentUrl, String childPath, String pathAdjustment) {
            StringBuilder url = new StringBuilder(parentUrl.length() + pathAdjustment.length() + childPath.length() + (pathAdjustment.length() == 0 ? 1 : 2));
            url.append(parentUrl);
            this.concatPath(url, pathAdjustment);
            this.concatPath(url, childPath);
            return url.toString();
        }

        private void concatPath(StringBuilder url, String path) {
            if (path.length() > 0) {
                boolean pathStartsWithSlash;
                boolean initialUrlEndsWithSlash = url.charAt(url.length() - 1) == '/';
                boolean bl = pathStartsWithSlash = path.charAt(0) == '/';
                if (pathStartsWithSlash) {
                    if (initialUrlEndsWithSlash) {
                        url.setLength(url.length() - 1);
                    }
                } else if (!initialUrlEndsWithSlash) {
                    url.append('/');
                }
                url.append(path);
                if (initialUrlEndsWithSlash && !path.endsWith("/")) {
                    url.append('/');
                }
            }
        }

        @Override
        protected void mergeModelBase_Properties(ModelBase target2, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
            Properties merged = new Properties();
            if (sourceDominant) {
                merged.putAll((Map<?, ?>)target2.getProperties());
                this.putAll(merged, source.getProperties(), DefaultInheritanceAssembler.CHILD_DIRECTORY_PROPERTY);
            } else {
                this.putAll(merged, source.getProperties(), DefaultInheritanceAssembler.CHILD_DIRECTORY_PROPERTY);
                merged.putAll((Map<?, ?>)target2.getProperties());
            }
            target2.setProperties(merged);
            target2.setLocation("properties", InputLocation.merge(target2.getLocation("properties"), source.getLocation("properties"), sourceDominant));
        }

        private void putAll(Map<Object, Object> s2, Map<Object, Object> t, Object excludeKey) {
            for (Map.Entry<Object, Object> e2 : t.entrySet()) {
                if (e2.getKey().equals(excludeKey)) continue;
                s2.put(e2.getKey(), e2.getValue());
            }
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer target2, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List<Plugin> src2 = source.getPlugins();
            if (!src2.isEmpty()) {
                List<Plugin> tgt = target2.getPlugins();
                LinkedHashMap<Object, Object> master = new LinkedHashMap<Object, Object>(src2.size() * 2);
                for (Plugin element2 : src2) {
                    if (!element2.isInherited() && element2.getExecutions().isEmpty()) continue;
                    Plugin plugin = new Plugin();
                    plugin.setLocation("", element2.getLocation(""));
                    plugin.setGroupId(null);
                    this.mergePlugin(plugin, element2, sourceDominant, context);
                    Object key2 = this.getPluginKey(element2);
                    master.put(key2, plugin);
                }
                LinkedHashMap predecessors = new LinkedHashMap();
                ArrayList<Plugin> pending = new ArrayList<Plugin>();
                for (Plugin element3 : tgt) {
                    Object key3 = this.getPluginKey(element3);
                    Plugin existing = (Plugin)master.get(key3);
                    if (existing != null) {
                        this.mergePlugin(element3, existing, sourceDominant, context);
                        master.put(key3, element3);
                        if (pending.isEmpty()) continue;
                        predecessors.put(key3, pending);
                        pending = new ArrayList();
                        continue;
                    }
                    pending.add(element3);
                }
                ArrayList<Plugin> result2 = new ArrayList<Plugin>(src2.size() + tgt.size());
                for (Map.Entry entry : master.entrySet()) {
                    List pre = (List)predecessors.get(entry.getKey());
                    if (pre != null) {
                        result2.addAll(pre);
                    }
                    result2.add((Plugin)entry.getValue());
                }
                result2.addAll(pending);
                target2.setPlugins(result2);
            }
        }

        @Override
        protected void mergePlugin(Plugin target2, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            if (source.isInherited()) {
                this.mergeConfigurationContainer(target2, source, sourceDominant, context);
            }
            this.mergePlugin_GroupId(target2, source, sourceDominant, context);
            this.mergePlugin_ArtifactId(target2, source, sourceDominant, context);
            this.mergePlugin_Version(target2, source, sourceDominant, context);
            this.mergePlugin_Extensions(target2, source, sourceDominant, context);
            this.mergePlugin_Dependencies(target2, source, sourceDominant, context);
            this.mergePlugin_Executions(target2, source, sourceDominant, context);
        }

        @Override
        protected void mergeReporting_Plugins(Reporting target2, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List<ReportPlugin> src2 = source.getPlugins();
            if (!src2.isEmpty()) {
                Object key2;
                List<ReportPlugin> tgt = target2.getPlugins();
                LinkedHashMap<Object, ReportPlugin> merged = new LinkedHashMap<Object, ReportPlugin>((src2.size() + tgt.size()) * 2);
                for (ReportPlugin element2 : src2) {
                    key2 = this.getReportPluginKey(element2);
                    if (!element2.isInherited()) continue;
                    ReportPlugin plugin = new ReportPlugin();
                    plugin.setLocation("", element2.getLocation(""));
                    plugin.setGroupId(null);
                    this.mergeReportPlugin(plugin, element2, sourceDominant, context);
                    merged.put(key2, plugin);
                }
                for (ReportPlugin element2 : tgt) {
                    key2 = this.getReportPluginKey(element2);
                    ReportPlugin existing = (ReportPlugin)merged.get(key2);
                    if (existing != null) {
                        this.mergeReportPlugin(element2, existing, sourceDominant, context);
                    }
                    merged.put(key2, element2);
                }
                target2.setPlugins(new ArrayList<ReportPlugin>(merged.values()));
            }
        }
    }
}

