/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.InitializationException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAliasType;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.annotations.XStreamConverters;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamImplicitCollection;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterMatcher;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.DependencyInjectionFactory;
import com.thoughtworks.xstream.core.util.TypedNull;
import com.thoughtworks.xstream.mapper.AnnotationConfiguration;
import com.thoughtworks.xstream.mapper.AttributeMapper;
import com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import com.thoughtworks.xstream.mapper.ElementIgnoringMapper;
import com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import com.thoughtworks.xstream.mapper.LocalConversionMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMapper
extends MapperWrapper
implements AnnotationConfiguration {
    private boolean locked;
    private transient Object[] arguments;
    private final ConverterRegistry converterRegistry;
    private transient ClassAliasingMapper classAliasingMapper;
    private transient DefaultImplementationsMapper defaultImplementationsMapper;
    private transient ImplicitCollectionMapper implicitCollectionMapper;
    private transient FieldAliasingMapper fieldAliasingMapper;
    private transient ElementIgnoringMapper elementIgnoringMapper;
    private transient AttributeMapper attributeMapper;
    private transient LocalConversionMapper localConversionMapper;
    private final Map<Class<?>, Map<List<Object>, Converter>> converterCache = new HashMap();
    private final Set<Class<?>> annotatedTypes = Collections.synchronizedSet(new HashSet());

    public AnnotationMapper(Mapper wrapped, ConverterRegistry converterRegistry, ConverterLookup converterLookup, ClassLoaderReference classLoaderReference, ReflectionProvider reflectionProvider) {
        super(wrapped);
        this.converterRegistry = converterRegistry;
        this.annotatedTypes.add(Object.class);
        this.setupMappers();
        this.locked = true;
        ClassLoader classLoader = classLoaderReference.getReference();
        this.arguments = new Object[]{this, classLoaderReference, reflectionProvider, converterLookup, new JVM(), classLoader != null ? classLoader : new TypedNull(ClassLoader.class)};
    }

    public AnnotationMapper(Mapper wrapped, ConverterRegistry converterRegistry, ConverterLookup converterLookup, ClassLoader classLoader, ReflectionProvider reflectionProvider, JVM jvm) {
        this(wrapped, converterRegistry, converterLookup, new ClassLoaderReference(classLoader), reflectionProvider);
    }

    @Override
    public String realMember(Class type2, String serialized) {
        if (!this.locked) {
            this.processAnnotations(type2);
        }
        return super.realMember(type2, serialized);
    }

    @Override
    public String serializedClass(Class type2) {
        if (!this.locked) {
            this.processAnnotations(type2);
        }
        return super.serializedClass(type2);
    }

    @Override
    public Class defaultImplementationOf(Class type2) {
        if (!this.locked) {
            this.processAnnotations(type2);
        }
        Class defaultImplementation = super.defaultImplementationOf(type2);
        if (!this.locked) {
            this.processAnnotations(defaultImplementation);
        }
        return defaultImplementation;
    }

    @Override
    public Converter getLocalConverter(Class definedIn, String fieldName) {
        if (!this.locked) {
            this.processAnnotations(definedIn);
        }
        return super.getLocalConverter(definedIn, fieldName);
    }

    @Override
    public void autodetectAnnotations(boolean mode) {
        this.locked = !mode;
    }

    @Override
    public void processAnnotations(Class[] initialTypes) {
        if (initialTypes == null || initialTypes.length == 0) {
            return;
        }
        this.locked = true;
        UnprocessedTypesSet types2 = new UnprocessedTypesSet();
        for (Class initialType : initialTypes) {
            types2.add(initialType);
        }
        this.processTypes(types2);
    }

    private void processAnnotations(Class initialType) {
        if (initialType == null) {
            return;
        }
        UnprocessedTypesSet types2 = new UnprocessedTypesSet();
        types2.add(initialType);
        this.processTypes(types2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processTypes(Set<Class<?>> types2) {
        while (!types2.isEmpty()) {
            Iterator<Class<?>> iter = types2.iterator();
            Class<?> type2 = iter.next();
            iter.remove();
            Class<?> clazz = type2;
            synchronized (clazz) {
                if (this.annotatedTypes.contains(type2)) {
                    continue;
                }
                try {
                    if (type2.isPrimitive()) {
                        continue;
                    }
                    this.addParametrizedTypes(type2, types2);
                    this.processConverterAnnotations(type2);
                    this.processAliasAnnotation(type2, types2);
                    this.processAliasTypeAnnotation(type2);
                    if (type2.isInterface()) {
                        continue;
                    }
                    this.processImplicitCollectionAnnotation(type2);
                    Field[] fields = type2.getDeclaredFields();
                    for (int i2 = 0; i2 < fields.length; ++i2) {
                        Field field = fields[i2];
                        if (field.isEnumConstant() || (field.getModifiers() & 0x88) > 0) continue;
                        this.addParametrizedTypes(field.getGenericType(), types2);
                        if (field.isSynthetic()) continue;
                        this.processFieldAliasAnnotation(field);
                        this.processAsAttributeAnnotation(field);
                        this.processImplicitAnnotation(field);
                        this.processOmitFieldAnnotation(field);
                        this.processLocalConverterAnnotation(field);
                    }
                }
                finally {
                    this.annotatedTypes.add(type2);
                }
            }
        }
        return;
    }

    private void addParametrizedTypes(Type type2, final Set<Class<?>> types2) {
        final HashSet<Type> processedTypes = new HashSet<Type>();
        LinkedHashSet<Type> localTypes = new LinkedHashSet<Type>(){

            @Override
            public boolean add(Type o2) {
                if (o2 instanceof Class) {
                    return types2.add((Class)o2);
                }
                return o2 == null || processedTypes.contains(o2) ? false : super.add(o2);
            }
        };
        while (type2 != null) {
            processedTypes.add(type2);
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                types2.add(clazz);
                if (!clazz.isPrimitive()) {
                    TypeVariable<Class<T>>[] typeParameters = clazz.getTypeParameters();
                    for (Type type3 : typeParameters) {
                        localTypes.add(type3);
                    }
                    localTypes.add(clazz.getGenericSuperclass());
                    for (Type type4 : clazz.getGenericInterfaces()) {
                        localTypes.add(type4);
                    }
                }
            } else if (type2 instanceof TypeVariable) {
                Type[] bounds;
                TypeVariable typeVariable = (TypeVariable)type2;
                for (Type type5 : bounds = typeVariable.getBounds()) {
                    localTypes.add(type5);
                }
            } else if (type2 instanceof ParameterizedType) {
                ParameterizedType parametrizedType = (ParameterizedType)type2;
                localTypes.add(parametrizedType.getRawType());
                Type[] actualArguments = parametrizedType.getActualTypeArguments();
                for (Type type6 : actualArguments) {
                    localTypes.add(type6);
                }
            } else if (type2 instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type2;
                localTypes.add(arrayType.getGenericComponentType());
            }
            if (!localTypes.isEmpty()) {
                Iterator iter = localTypes.iterator();
                type2 = (Type)iter.next();
                iter.remove();
                continue;
            }
            type2 = null;
        }
    }

    private void processConverterAnnotations(Class<?> type2) {
        if (this.converterRegistry != null) {
            ArrayList<XStreamConverter> annotations;
            XStreamConverters convertersAnnotation = type2.getAnnotation(XStreamConverters.class);
            XStreamConverter converterAnnotation = type2.getAnnotation(XStreamConverter.class);
            ArrayList<XStreamConverter> arrayList = annotations = convertersAnnotation != null ? new ArrayList<XStreamConverter>(Arrays.asList(convertersAnnotation.value())) : new ArrayList();
            if (converterAnnotation != null) {
                annotations.add(converterAnnotation);
            }
            for (XStreamConverter annotation : annotations) {
                Converter converter = this.cacheConverter(annotation, converterAnnotation != null ? type2 : null);
                if (converter == null) continue;
                if (converterAnnotation != null || converter.canConvert(type2)) {
                    this.converterRegistry.registerConverter(converter, annotation.priority());
                    continue;
                }
                throw new InitializationException("Converter " + annotation.value().getName() + " cannot handle annotated class " + type2.getName());
            }
        }
    }

    private void processAliasAnnotation(Class<?> type2, Set<Class<?>> types2) {
        XStreamAlias aliasAnnotation = type2.getAnnotation(XStreamAlias.class);
        if (aliasAnnotation != null) {
            if (this.classAliasingMapper == null) {
                throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
            }
            this.classAliasingMapper.addClassAlias(aliasAnnotation.value(), type2);
            if (aliasAnnotation.impl() != Void.class) {
                this.defaultImplementationsMapper.addDefaultImplementation(aliasAnnotation.impl(), type2);
                if (type2.isInterface()) {
                    types2.add(aliasAnnotation.impl());
                }
            }
        }
    }

    private void processAliasTypeAnnotation(Class<?> type2) {
        XStreamAliasType aliasAnnotation = type2.getAnnotation(XStreamAliasType.class);
        if (aliasAnnotation != null) {
            if (this.classAliasingMapper == null) {
                throw new InitializationException("No " + ClassAliasingMapper.class.getName() + " available");
            }
            this.classAliasingMapper.addTypeAlias(aliasAnnotation.value(), type2);
        }
    }

    @Deprecated
    private void processImplicitCollectionAnnotation(Class<?> type2) {
        XStreamImplicitCollection implicitColAnnotation = type2.getAnnotation(XStreamImplicitCollection.class);
        if (implicitColAnnotation != null) {
            Field field;
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String fieldName = implicitColAnnotation.value();
            String itemFieldName = implicitColAnnotation.item();
            try {
                field = type2.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e2) {
                throw new InitializationException(type2.getName() + " does not have a field named '" + fieldName + "' as required by " + XStreamImplicitCollection.class.getName());
            }
            Class<?> itemType = null;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type typeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                itemType = this.getClass(typeArgument);
            }
            if (itemType == null) {
                this.implicitCollectionMapper.add(type2, fieldName, null, Object.class);
            } else if (itemFieldName.equals("")) {
                this.implicitCollectionMapper.add(type2, fieldName, null, itemType);
            } else {
                this.implicitCollectionMapper.add(type2, fieldName, itemFieldName, itemType);
            }
        }
    }

    private void processFieldAliasAnnotation(Field field) {
        XStreamAlias aliasAnnotation = field.getAnnotation(XStreamAlias.class);
        if (aliasAnnotation != null) {
            if (this.fieldAliasingMapper == null) {
                throw new InitializationException("No " + FieldAliasingMapper.class.getName() + " available");
            }
            this.fieldAliasingMapper.addFieldAlias(aliasAnnotation.value(), field.getDeclaringClass(), field.getName());
        }
    }

    private void processAsAttributeAnnotation(Field field) {
        XStreamAsAttribute asAttributeAnnotation = field.getAnnotation(XStreamAsAttribute.class);
        if (asAttributeAnnotation != null) {
            if (this.attributeMapper == null) {
                throw new InitializationException("No " + AttributeMapper.class.getName() + " available");
            }
            this.attributeMapper.addAttributeFor(field);
        }
    }

    private void processImplicitAnnotation(Field field) {
        XStreamImplicit implicitAnnotation = field.getAnnotation(XStreamImplicit.class);
        if (implicitAnnotation != null) {
            Type genericType;
            if (this.implicitCollectionMapper == null) {
                throw new InitializationException("No " + ImplicitCollectionMapper.class.getName() + " available");
            }
            String fieldName = field.getName();
            String itemFieldName = implicitAnnotation.itemFieldName();
            String keyFieldName = implicitAnnotation.keyFieldName();
            boolean isMap = Map.class.isAssignableFrom(field.getType());
            Class<?> itemType = null;
            if (!field.getType().isArray() && (genericType = field.getGenericType()) instanceof ParameterizedType) {
                Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
                Type typeArgument = actualTypeArguments[isMap ? 1 : 0];
                itemType = this.getClass(typeArgument);
            }
            if (isMap) {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemFieldName != null && !"".equals(itemFieldName) ? itemFieldName : null, itemType, keyFieldName != null && !"".equals(keyFieldName) ? keyFieldName : null);
            } else if (itemFieldName != null && !"".equals(itemFieldName)) {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemFieldName, itemType);
            } else {
                this.implicitCollectionMapper.add(field.getDeclaringClass(), fieldName, itemType);
            }
        }
    }

    private void processOmitFieldAnnotation(Field field) {
        XStreamOmitField omitFieldAnnotation = field.getAnnotation(XStreamOmitField.class);
        if (omitFieldAnnotation != null) {
            if (this.elementIgnoringMapper == null) {
                throw new InitializationException("No " + ElementIgnoringMapper.class.getName() + " available");
            }
            this.elementIgnoringMapper.omitField(field.getDeclaringClass(), field.getName());
        }
    }

    private void processLocalConverterAnnotation(Field field) {
        Converter converter;
        XStreamConverter annotation = field.getAnnotation(XStreamConverter.class);
        if (annotation != null && (converter = this.cacheConverter(annotation, field.getType())) != null) {
            if (this.localConversionMapper == null) {
                throw new InitializationException("No " + LocalConversionMapper.class.getName() + " available");
            }
            this.localConversionMapper.registerLocalConverter(field.getDeclaringClass(), field.getName(), converter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Converter cacheConverter(XStreamConverter annotation, Class targetType) {
        Converter result2 = null;
        ArrayList<Object> parameter = new ArrayList<Object>();
        if (targetType != null && annotation.useImplicitType()) {
            parameter.add(targetType);
        }
        ArrayList<Object[]> arrays = new ArrayList<Object[]>();
        arrays.add(annotation.booleans());
        arrays.add(annotation.bytes());
        arrays.add(annotation.chars());
        arrays.add(annotation.doubles());
        arrays.add(annotation.floats());
        arrays.add(annotation.ints());
        arrays.add(annotation.longs());
        arrays.add(annotation.shorts());
        arrays.add(annotation.strings());
        arrays.add(annotation.types());
        for (Object e2 : arrays) {
            if (e2 == null) continue;
            int length = Array.getLength(e2);
            for (int i2 = 0; i2 < length; ++i2) {
                parameter.add(Array.get(e2, i2));
            }
        }
        for (Class<?> type2 : annotation.nulls()) {
            TypedNull nullType = new TypedNull(type2);
            parameter.add(nullType);
        }
        Class<? extends ConverterMatcher> converterType = annotation.value();
        Map<List<Object>, Converter> map2 = this.converterCache.get(converterType);
        if (map2 != null) {
            result2 = map2.get(parameter);
        }
        if (result2 == null) {
            void var8_11;
            Converter converter;
            Object[] args2;
            int size = parameter.size();
            if (size > 0) {
                Object[] args3 = new Object[this.arguments.length + size];
                System.arraycopy(this.arguments, 0, args3, size, this.arguments.length);
                System.arraycopy(parameter.toArray(new Object[size]), 0, args3, 0, size);
            } else {
                args2 = this.arguments;
            }
            try {
                if (SingleValueConverter.class.isAssignableFrom(converterType) && !Converter.class.isAssignableFrom(converterType)) {
                    SingleValueConverter svc = (SingleValueConverter)DependencyInjectionFactory.newInstance(converterType, args2);
                    converter = new SingleValueConverterWrapper(svc);
                } else {
                    converter = (Converter)DependencyInjectionFactory.newInstance(converterType, args2);
                }
            }
            catch (Exception e2) {
                throw new InitializationException("Cannot instantiate converter " + converterType.getName() + (targetType != null ? " for type " + targetType.getName() : ""), e2);
            }
            if (map2 == null) {
                HashMap hashMap = new HashMap();
                this.converterCache.put(converterType, hashMap);
            }
            var8_11.put(parameter, converter);
            result2 = converter;
        }
        return result2;
    }

    private Class<?> getClass(Type typeArgument) {
        Class type2 = null;
        if (typeArgument instanceof ParameterizedType) {
            type2 = (Class)((ParameterizedType)typeArgument).getRawType();
        } else if (typeArgument instanceof Class) {
            type2 = (Class)typeArgument;
        }
        return type2;
    }

    private void setupMappers() {
        this.classAliasingMapper = (ClassAliasingMapper)this.lookupMapperOfType(ClassAliasingMapper.class);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.lookupMapperOfType(DefaultImplementationsMapper.class);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.lookupMapperOfType(ImplicitCollectionMapper.class);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.lookupMapperOfType(FieldAliasingMapper.class);
        this.elementIgnoringMapper = (ElementIgnoringMapper)this.lookupMapperOfType(ElementIgnoringMapper.class);
        this.attributeMapper = (AttributeMapper)this.lookupMapperOfType(AttributeMapper.class);
        this.localConversionMapper = (LocalConversionMapper)this.lookupMapperOfType(LocalConversionMapper.class);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int max = this.arguments.length - 2;
        out.writeInt(max);
        for (int i2 = 0; i2 < max; ++i2) {
            out.writeObject(this.arguments[i2]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setupMappers();
        int max = in.readInt();
        this.arguments = new Object[max + 2];
        for (int i2 = 0; i2 < max; ++i2) {
            this.arguments[i2] = in.readObject();
            if (!(this.arguments[i2] instanceof ClassLoaderReference)) continue;
            this.arguments[max + 1] = ((ClassLoaderReference)this.arguments[i2]).getReference();
        }
        this.arguments[max] = new JVM();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UnprocessedTypesSet
    extends LinkedHashSet<Class<?>> {
        private UnprocessedTypesSet() {
        }

        @Override
        public boolean add(Class<?> type2) {
            Class<?>[] incTypes;
            XStreamInclude inc;
            boolean ret;
            if (type2 == null) {
                return false;
            }
            while (type2.isArray()) {
                type2 = type2.getComponentType();
            }
            String name2 = type2.getName();
            if (name2.startsWith("java.") || name2.startsWith("javax.")) {
                return false;
            }
            boolean bl = ret = AnnotationMapper.this.annotatedTypes.contains(type2) ? false : super.add(type2);
            if (ret && (inc = type2.getAnnotation(XStreamInclude.class)) != null && (incTypes = inc.value()) != null) {
                for (Class<?> incType : incTypes) {
                    this.add(incType);
                }
            }
            return ret;
        }
    }
}

