/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml.xppdom;

import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class XppDomComparator
implements Comparator {
    private final ThreadLocal xpath;

    public XppDomComparator() {
        this(null);
    }

    public XppDomComparator(ThreadLocal xpath) {
        this.xpath = xpath;
    }

    public int compare(Object dom1, Object dom2) {
        StringBuffer xpath = new StringBuffer("/");
        int s2 = this.compareInternal((XppDom)dom1, (XppDom)dom2, xpath, -1);
        if (this.xpath != null) {
            if (s2 != 0) {
                this.xpath.set(xpath.toString());
            } else {
                this.xpath.set(null);
            }
        }
        return s2;
    }

    private int compareInternal(XppDom dom1, XppDom dom2, StringBuffer xpath, int count) {
        int len;
        int pathlen = xpath.length();
        String name2 = dom1.getName();
        int s2 = name2.compareTo(dom2.getName());
        xpath.append(name2);
        if (count >= 0) {
            xpath.append('[').append(count).append(']');
        }
        if (s2 != 0) {
            xpath.append('?');
            return s2;
        }
        Object[] attributes2 = dom1.getAttributeNames();
        Object[] attributes22 = dom2.getAttributeNames();
        s2 = attributes22.length - (len = attributes2.length);
        if (s2 != 0) {
            xpath.append("::count(@*)");
            return s2 < 0 ? 1 : -1;
        }
        Arrays.sort(attributes2);
        Arrays.sort(attributes22);
        for (int i2 = 0; i2 < len; ++i2) {
            Object attribute = attributes2[i2];
            s2 = ((String)attribute).compareTo((String)attributes22[i2]);
            if (s2 != 0) {
                xpath.append("[@").append((String)attribute).append("?]");
                return s2;
            }
            s2 = dom1.getAttribute((String)attribute).compareTo(dom2.getAttribute((String)attribute));
            if (s2 == 0) continue;
            xpath.append("[@").append((String)attribute).append(']');
            return s2;
        }
        int children2 = dom1.getChildCount();
        s2 = dom2.getChildCount() - children2;
        if (s2 != 0) {
            xpath.append("::count(*)");
            return s2 < 0 ? 1 : -1;
        }
        if (children2 > 0) {
            if (dom1.getValue() != null || dom2.getValue() != null) {
                throw new IllegalArgumentException("XppDom cannot handle mixed mode at " + xpath + "::text()");
            }
            xpath.append('/');
            HashMap<String, int[]> names2 = new HashMap<String, int[]>();
            for (int i3 = 0; i3 < children2; ++i3) {
                XppDom child1 = dom1.getChild(i3);
                XppDom child2 = dom2.getChild(i3);
                String child = child1.getName();
                if (!names2.containsKey(child)) {
                    names2.put(child, new int[1]);
                }
                int[] nArray = (int[])names2.get(child);
                int n = nArray[0];
                nArray[0] = n + 1;
                s2 = this.compareInternal(child1, child2, xpath, n);
                if (s2 == 0) continue;
                return s2;
            }
        } else {
            String value2 = dom2.getValue();
            String value1 = dom1.getValue();
            if (value1 == null) {
                s2 = value2 == null ? 0 : -1;
            } else {
                int n = s2 = value2 == null ? 1 : value1.compareTo(value2);
            }
            if (s2 != 0) {
                xpath.append("::text()");
                return s2;
            }
        }
        xpath.setLength(pathlen);
        return s2;
    }
}

