/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.javabean;

import com.thoughtworks.xstream.converters.javabean.BeanProperty;
import com.thoughtworks.xstream.converters.javabean.NativePropertySorter;
import com.thoughtworks.xstream.converters.javabean.PropertySorter;
import com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PropertyDictionary
implements Caching {
    private transient Map propertyNameCache = Collections.synchronizedMap(new HashMap());
    private final PropertySorter sorter;

    public PropertyDictionary() {
        this(new NativePropertySorter());
    }

    public PropertyDictionary(PropertySorter sorter) {
        this.sorter = sorter;
    }

    public Iterator serializablePropertiesFor(Class type2) {
        ArrayList<BeanProperty> beanProperties = new ArrayList<BeanProperty>();
        Collection descriptors = this.buildMap(type2).values();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            PropertyDescriptor descriptor2 = (PropertyDescriptor)iter.next();
            if (descriptor2.getReadMethod() == null || descriptor2.getWriteMethod() == null) continue;
            beanProperties.add(new BeanProperty(type2, descriptor2.getName(), descriptor2.getPropertyType()));
        }
        return beanProperties.iterator();
    }

    public BeanProperty property(Class cls, String name2) {
        BeanProperty beanProperty = null;
        PropertyDescriptor descriptor2 = this.propertyDescriptorOrNull(cls, name2);
        if (descriptor2 == null) {
            throw new MissingFieldException(cls.getName(), name2);
        }
        if (descriptor2.getReadMethod() != null && descriptor2.getWriteMethod() != null) {
            beanProperty = new BeanProperty(cls, descriptor2.getName(), descriptor2.getPropertyType());
        }
        return beanProperty;
    }

    public Iterator propertiesFor(Class type2) {
        return this.buildMap(type2).values().iterator();
    }

    public PropertyDescriptor propertyDescriptor(Class type2, String name2) {
        PropertyDescriptor descriptor2 = this.propertyDescriptorOrNull(type2, name2);
        if (descriptor2 == null) {
            throw new MissingFieldException(type2.getName(), name2);
        }
        return descriptor2;
    }

    public PropertyDescriptor propertyDescriptorOrNull(Class type2, String name2) {
        return (PropertyDescriptor)this.buildMap(type2).get(name2);
    }

    private Map buildMap(Class type2) {
        Map nameMap = (Map)this.propertyNameCache.get(type2);
        if (nameMap == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(type2, Object.class);
            }
            catch (IntrospectionException e2) {
                ObjectAccessException oaex = new ObjectAccessException("Cannot get BeanInfo of type", e2);
                oaex.add("bean-type", type2.getName());
                throw oaex;
            }
            nameMap = new OrderRetainingMap();
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            for (int i2 = 0; i2 < propertyDescriptors.length; ++i2) {
                PropertyDescriptor descriptor2 = propertyDescriptors[i2];
                nameMap.put(descriptor2.getName(), descriptor2);
            }
            nameMap = this.sorter.sort(type2, nameMap);
            this.propertyNameCache.put(type2, nameMap);
        }
        return nameMap;
    }

    public void flushCache() {
        this.propertyNameCache.clear();
    }
}

