/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.javabean;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.javabean.ComparingPropertySorter;
import com.thoughtworks.xstream.converters.javabean.JavaBeanProvider;
import com.thoughtworks.xstream.converters.javabean.NativePropertySorter;
import com.thoughtworks.xstream.converters.javabean.PropertyDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class BeanProvider
implements JavaBeanProvider {
    protected static final Object[] NO_PARAMS = new Object[0];
    protected PropertyDictionary propertyDictionary;

    public BeanProvider() {
        this(new PropertyDictionary(new NativePropertySorter()));
    }

    public BeanProvider(Comparator propertyNameComparator) {
        this(new PropertyDictionary(new ComparingPropertySorter(propertyNameComparator)));
    }

    public BeanProvider(PropertyDictionary propertyDictionary) {
        this.propertyDictionary = propertyDictionary;
    }

    public Object newInstance(Class type2) {
        ErrorWritingException ex = null;
        if (type2 == Void.TYPE || type2 == Void.class) {
            ex = new ConversionException("Security alert: Marshalling rejected");
        } else {
            try {
                return type2.newInstance();
            }
            catch (InstantiationException e2) {
                ex = new ConversionException("Cannot construct type", e2);
            }
            catch (IllegalAccessException e3) {
                ex = new ObjectAccessException("Cannot construct type", e3);
            }
            catch (SecurityException e4) {
                ex = new ObjectAccessException("Cannot construct type", e4);
            }
            catch (ExceptionInInitializerError e5) {
                ex = new ConversionException("Cannot construct type", e5);
            }
        }
        ex.add("construction-type", type2.getName());
        throw ex;
    }

    public void visitSerializableProperties(Object object, JavaBeanProvider.Visitor visitor2) {
        PropertyDescriptor[] propertyDescriptors = this.getSerializableProperties(object);
        for (int i2 = 0; i2 < propertyDescriptors.length; ++i2) {
            ErrorWritingException ex = null;
            PropertyDescriptor property = propertyDescriptors[i2];
            try {
                Method readMethod = property.getReadMethod();
                String name2 = property.getName();
                Class<?> definedIn = readMethod.getDeclaringClass();
                if (visitor2.shouldVisit(name2, definedIn)) {
                    Object value2 = readMethod.invoke(object, new Object[0]);
                    visitor2.visit(name2, property.getPropertyType(), definedIn, value2);
                }
            }
            catch (IllegalArgumentException e2) {
                ex = new ConversionException("Cannot get property", e2);
            }
            catch (IllegalAccessException e3) {
                ex = new ObjectAccessException("Cannot access property", e3);
            }
            catch (InvocationTargetException e4) {
                ex = new ConversionException("Cannot get property", e4.getTargetException());
            }
            if (ex == null) continue;
            ex.add("property", object.getClass() + "." + property.getName());
            throw ex;
        }
    }

    public void writeProperty(Object object, String propertyName, Object value2) {
        ErrorWritingException ex = null;
        PropertyDescriptor property = this.getProperty(propertyName, object.getClass());
        try {
            property.getWriteMethod().invoke(object, value2);
        }
        catch (IllegalArgumentException e2) {
            ex = new ConversionException("Cannot set property", e2);
        }
        catch (IllegalAccessException e3) {
            ex = new ObjectAccessException("Cannot access property", e3);
        }
        catch (InvocationTargetException e4) {
            ex = new ConversionException("Cannot set property", e4.getTargetException());
        }
        if (ex != null) {
            ex.add("property", object.getClass() + "." + property.getName());
            throw ex;
        }
    }

    public Class getPropertyType(Object object, String name2) {
        return this.getProperty(name2, object.getClass()).getPropertyType();
    }

    public boolean propertyDefinedInClass(String name2, Class type2) {
        return this.propertyDictionary.propertyDescriptorOrNull(type2, name2) != null;
    }

    public boolean canInstantiate(Class type2) {
        try {
            return type2 != null && this.newInstance(type2) != null;
        }
        catch (ErrorWritingException e2) {
            return false;
        }
    }

    protected Constructor getDefaultConstrutor(Class type2) {
        Constructor<?>[] constructors = type2.getConstructors();
        for (int i2 = 0; i2 < constructors.length; ++i2) {
            Constructor<?> c2 = constructors[i2];
            if (c2.getParameterTypes().length != 0 || !Modifier.isPublic(c2.getModifiers())) continue;
            return c2;
        }
        return null;
    }

    protected PropertyDescriptor[] getSerializableProperties(Object object) {
        ArrayList<PropertyDescriptor> result2 = new ArrayList<PropertyDescriptor>();
        Iterator iter = this.propertyDictionary.propertiesFor(object.getClass());
        while (iter.hasNext()) {
            PropertyDescriptor descriptor2 = (PropertyDescriptor)iter.next();
            if (!this.canStreamProperty(descriptor2)) continue;
            result2.add(descriptor2);
        }
        return result2.toArray(new PropertyDescriptor[result2.size()]);
    }

    protected boolean canStreamProperty(PropertyDescriptor descriptor2) {
        return descriptor2.getReadMethod() != null && descriptor2.getWriteMethod() != null;
    }

    public boolean propertyWriteable(String name2, Class type2) {
        PropertyDescriptor property = this.getProperty(name2, type2);
        return property.getWriteMethod() != null;
    }

    protected PropertyDescriptor getProperty(String name2, Class type2) {
        return this.propertyDictionary.propertyDescriptor(type2, name2);
    }

    public static interface Visitor
    extends JavaBeanProvider.Visitor {
    }
}

