/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import javax.activation.ActivationDataFlavor;

public class ActivationDataFlavorConverter
implements Converter {
    static /* synthetic */ Class class$java$lang$Class;

    public boolean canConvert(Class type2) {
        return type2 == ActivationDataFlavor.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class representationClass;
        String name2;
        ActivationDataFlavor dataFlavor = (ActivationDataFlavor)source;
        String mimeType = dataFlavor.getMimeType();
        if (mimeType != null) {
            writer.startNode("mimeType");
            writer.setValue(mimeType);
            writer.endNode();
        }
        if ((name2 = dataFlavor.getHumanPresentableName()) != null) {
            writer.startNode("humanRepresentableName");
            writer.setValue(name2);
            writer.endNode();
        }
        if ((representationClass = dataFlavor.getRepresentationClass()) != null) {
            writer.startNode("representationClass");
            context.convertAnother(representationClass);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String mimeType = null;
        String name2 = null;
        Class type2 = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String elementName = reader.getNodeName();
            if (elementName.equals("mimeType")) {
                mimeType = reader.getValue();
            } else if (elementName.equals("humanRepresentableName")) {
                name2 = reader.getValue();
            } else if (elementName.equals("representationClass")) {
                type2 = (Class)context.convertAnother(null, class$java$lang$Class == null ? ActivationDataFlavorConverter.class$("java.lang.Class") : class$java$lang$Class);
            } else {
                ConversionException exception = new ConversionException("Unknown child element");
                exception.add("element", reader.getNodeName());
                throw exception;
            }
            reader.moveUp();
        }
        ActivationDataFlavor dataFlavor = null;
        try {
            dataFlavor = type2 == null ? new ActivationDataFlavor(mimeType, name2) : (mimeType == null ? new ActivationDataFlavor(type2, name2) : new ActivationDataFlavor(type2, mimeType, name2));
        }
        catch (IllegalArgumentException ex) {
            throw new ConversionException(ex);
        }
        catch (NullPointerException ex) {
            throw new ConversionException(ex);
        }
        return dataFlavor;
    }
}

