/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlInjectableRawInput;
import com.intellij.sql.psi.patterns.SqlFunctionCallPattern;
import com.intellij.sql.psi.patterns.SqlPatterns;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlElementPattern<T extends SqlElement, Self extends SqlElementPattern<T, Self>>
extends PsiElementPattern<T, Self> {
    protected SqlElementPattern(Class<T> aClass) {
        super(aClass);
    }

    public SqlElementPattern(@NotNull InitialPatternCondition<T> condition2) {
        if (condition2 == null) {
            SqlElementPattern.$$$reportNull$$$0(0);
        }
        super(condition2);
    }

    public Self forDialect(final ElementPattern<String> dialects) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>("forDialect"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                SqlLanguageDialectEx dialect;
                String id;
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("OracleSqlPlus".equals(id = (dialect = SqlImplUtil.getSqlDialectSafe(t)).getID())) {
                    id = "Oracle";
                }
                return dialects.accepts((Object)id, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$1", "accepts"));
            }
        })));
    }

    public Self forDialects(String ... dialects) {
        return this.forDialect((ElementPattern<String>)StandardPatterns.string().oneOf(dialects));
    }

    public Self binaryExpressionArgument(final int index2, final ElementPattern<? extends SqlBinaryExpression> binExprPattern) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>("binaryExpressionArgument"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                SqlBinaryExpression expr;
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((expr = (SqlBinaryExpression)ObjectUtils.tryCast((Object)SqlElementPattern.this.getParent(t), SqlBinaryExpression.class)) == null) {
                    return false;
                }
                if (index2 == 0 && t != expr.getLOperand()) {
                    return false;
                }
                if (index2 == 1 && t != expr.getROperand()) {
                    return false;
                }
                return binExprPattern.accepts((Object)expr, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$2", "accepts"));
            }
        })));
    }

    public Self is(final ElementPattern<? extends T> pattern2) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>("is"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                return pattern2.accepts(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$3", "accepts"));
            }
        })));
    }

    public Self functionArgument(int index2, String name2, int nargs) {
        return this.functionArgument(index2, (ElementPattern<? extends SqlFunctionCallExpression>)((SqlFunctionCallPattern)((Object)SqlPatterns.sqlFunctionCall().name(name2))).params((ElementPattern<? extends List<? extends SqlExpression>>)SqlPatterns.sqlExpressions().count(nargs)));
    }

    public Self functionArgument(int index2, ElementPattern<? extends SqlFunctionCallExpression> pattern2) {
        return this.functionArgument(index2, index2, 1, pattern2);
    }

    public Self functionArgument(final int from, final int to_, final int every, final ElementPattern<? extends SqlFunctionCallExpression> pattern2) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>("functionArgument"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                int to;
                SqlExpressionList args2;
                if (t == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((args2 = (SqlExpressionList)ObjectUtils.tryCast((Object)SqlElementPattern.this.getParent(t), SqlExpressionList.class)) == null) {
                    return false;
                }
                SqlFunctionCallExpression call2 = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)SqlElementPattern.this.getParent((PsiElement)args2), SqlFunctionCallExpression.class);
                if (call2 == null) {
                    return false;
                }
                List<SqlExpression> parameters2 = SqlFunctionCallPattern.getExpressions(args2, context);
                int n = to = to_ < 0 ? Math.max(parameters2.size() + to_, 0) : Math.min(to_, parameters2.size() - 1);
                if (from > to || every <= 0) {
                    return false;
                }
                int start2 = t.getTextRange().getStartOffset();
                boolean found = false;
                for (int i2 = from; i2 <= to; i2 += every) {
                    SqlExpression p2 = parameters2.get(i2);
                    if (p2 == t) {
                        found = true;
                        break;
                    }
                    if (p2.getTextRange().getStartOffset() > start2) break;
                }
                if (!found) {
                    return false;
                }
                return pattern2.accepts((Object)call2, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$4", "accepts"));
            }
        })));
    }

    public Self insertWithFormatInput(final String formatName) {
        return (Self)((Object)((SqlElementPattern)this.with(new PatternCondition<T>(""){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiElement kw;
                SqlInjectableRawInput input;
                if (t == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((input = (SqlInjectableRawInput)((Object)ObjectUtils.tryCast(t, SqlInjectableRawInput.class))) == null) {
                    return false;
                }
                PsiElement p2 = input.getParent();
                if (!(input.getParent() instanceof SqlDmlInstruction)) {
                    return false;
                }
                SqlClause format2 = (SqlClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)input, SqlClause.class);
                PsiElement psiElement = kw = format2 == null ? null : format2.getFirstChild();
                if (kw == null || !"format".equalsIgnoreCase(kw.getText())) {
                    return false;
                }
                PsiElement name2 = format2.getLastChild();
                return name2 != null && formatName.equals(name2.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/sql/psi/patterns/SqlElementPattern$5", "accepts"));
            }
        })));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/sql/psi/patterns/SqlElementPattern", "<init>"));
    }

    public static class Capture<T extends SqlElement>
    extends SqlElementPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition2) {
            if (condition2 == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(condition2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/sql/psi/patterns/SqlElementPattern$Capture", "<init>"));
        }
    }
}

