/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasScopeAware;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.DasSymbolObject;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileAttributes;
import com.intellij.sql.psi.SqlFileResolveMode;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlAlterInstructionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlResolveCacheImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.symbols.virtual.DasVirtualSymbol;
import com.intellij.util.CachedValueBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFileImpl
extends PsiFileBase
implements SqlFile {
    private final NamespaceImpl myRootMirror;
    private final ConcurrentMap<Object, GroupImpl> myMirrors;
    private final CachedValue<List<SqlElement>> myDdl;
    private final CachedValue<State> myState;
    private final CachedValue<List<SqlDeclareStatement>> myDeclares;
    private final CachedValue<SqlResolveCacheImpl> myResolveCache;
    private final ModificationTracker myMaximalDependenciesTracker;

    @NotNull
    private <T> Supplier<T> mayChangeOnPsiChange(Supplier<T> supplier2) {
        Supplier<Object> supplier3 = () -> CachedValuesManager.getCachedValue((PsiElement)this, () -> SqlFileImpl.lambda$mayChangeOnPsiChange$0((Supplier)supplier2));
        if (supplier3 == null) {
            SqlFileImpl.$$$reportNull$$$0(0);
        }
        return supplier3;
    }

    public SqlFileImpl(FileViewProvider viewProvider, @NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(1);
        }
        this(viewProvider, (Language)dialect);
    }

    public SqlFileImpl(FileViewProvider viewProvider) {
        this(viewProvider, (Language)SqlLanguage.INSTANCE);
    }

    private SqlFileImpl(FileViewProvider viewProvider, @NotNull Language language) {
        if (language == null) {
            SqlFileImpl.$$$reportNull$$$0(2);
        }
        super(viewProvider, language);
        this.myRootMirror = new NamespaceImpl(null, DasUtil.NO_NAME, DasUtil.NO_NAME, ObjectKind.ROOT, true);
        this.myMirrors = new ConcurrentHashMap<Object, GroupImpl>();
        this.myMaximalDependenciesTracker = ((Supplier<Long>)this.mayChangeOnPsiChange(this::getAllDependenciesCounter))::get;
        Project project = this.getProject();
        CachedValuesManager cm = CachedValuesManager.getManager((Project)project);
        this.myDdl = cm.createCachedValue(() -> CachedValueProvider.Result.create(this.calcDdl(), (Object[])new Object[]{this}), false);
        this.myState = cm.createCachedValue(() -> CachedValueProvider.Result.create((Object)this.calcState(), (Object[])new Object[]{this.getMaximalDependencies()}), false);
        this.myDeclares = cm.createCachedValue(() -> CachedValueProvider.Result.create(this.calcDeclares(), (Object[])new Object[]{this}), false);
        this.myResolveCache = cm.createCachedValue(() -> CachedValueProvider.Result.create((Object)new SqlResolveCacheImpl(), (Object[])new Object[]{this.getMaximalDependencies()}), false);
    }

    private long getAllDependenciesCounter() {
        long res2 = this.getViewProvider().getVirtualFile().getModificationStamp() + this.getModificationStamp() + (long)(this.isValid() ? 0 : 1);
        VirtualFile vFile = this.getTopLevelFile();
        List<DbDataSource> dataSources2 = SqlImplUtil.getDataSources((PsiElement)this);
        for (DbDataSource dataSource2 : dataSources2) {
            res2 += SqlFileImpl.getDataSourceModificationCount(dataSource2, vFile);
        }
        return res2;
    }

    public ModificationTracker getMaximalDependencies() {
        return this.myMaximalDependenciesTracker;
    }

    public static List<Object> getMaximalDependencies(@NotNull PsiElement e2) {
        PsiFile file;
        if (e2 == null) {
            SqlFileImpl.$$$reportNull$$$0(3);
        }
        return (file = e2.getContainingFile()) instanceof SqlFileImpl ? Arrays.asList(e2, ((SqlFileImpl)file).getMaximalDependencies()) : Collections.singletonList(DbPsiFacade.getInstance(e2.getProject()));
    }

    private static long getDataSourceModificationCount(DbDataSource dbDs, VirtualFile file) {
        SqlDataSource ds = (SqlDataSource)ObjectUtils.tryCast((Object)dbDs.getDelegate(), SqlDataSource.class);
        if (ds != null && ds.containsFile(file)) {
            return ds.getModelModificationCount();
        }
        return dbDs.getModificationTracker().getModificationCount();
    }

    @NotNull
    public MetaModel getMetaModel() {
        BasicMetaModel<?> basicMetaModel = DbImplUtilCore.getMetaModel(this.getSqlLanguage().getDbms());
        if (basicMetaModel == null) {
            SqlFileImpl.$$$reportNull$$$0(4);
        }
        return basicMetaModel;
    }

    public void clearCaches() {
        ((CachedValueBase)this.myState).clear();
        ((CachedValueBase)this.myDeclares).clear();
        ((CachedValueBase)this.myDdl).clear();
        ((CachedValueBase)this.myResolveCache).clear();
        super.clearCaches();
    }

    @NotNull
    public List<SqlElement> getDdl() {
        List list = (List)this.myDdl.getValue();
        if (list == null) {
            SqlFileImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public <T> T getAttributeAt(@NotNull Key<T> attr, int offset) {
        if (attr == null) {
            SqlFileImpl.$$$reportNull$$$0(6);
        }
        if (attr == SqlFileAttributes.DELIMITER) {
            return (T)this.getSqlLanguage().getDelimiterAt(this, offset);
        }
        return null;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable<DasSymbolObject> jBIterable = this.myRootMirror.children();
        if (jBIterable == null) {
            SqlFileImpl.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlFileImpl.$$$reportNull$$$0(8);
        }
        Casing casing = this.getCasingProvider().getCasing(kind, context);
        if (casing == null) {
            SqlFileImpl.$$$reportNull$$$0(9);
        }
        return casing;
    }

    @NotNull
    public CasingProvider getCasingProvider() {
        CasingProvider casingProvider = ((State)this.myState.getValue()).casingProvider;
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(10);
        }
        return casingProvider;
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            SqlFileImpl.$$$reportNull$$$0(11);
        }
        return jBTreeTraverser;
    }

    public boolean contains(@Nullable DasObject o2) {
        return o2 instanceof SqlElement && ((SqlElement)o2).getContainingFile() == this;
    }

    @Nullable
    public DasNamespace getCurrentRootNamespace() {
        return null;
    }

    @Nullable
    public DasObject findDbParent(SqlDefinition o2) {
        return ((State)this.myState.getValue()).children.get(o2);
    }

    private List<SqlElement> calcDdl() {
        StubElement stub = this.getStub();
        if (stub != null) {
            return (List)JBIterable.from((Iterable)stub.getChildrenStubs()).transform(SqlImplUtil.STUB_TO_PSI).filter(SqlCompositeElement.class).addAllTo(new ArrayList());
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        return (List)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)this).expand(e2 -> dialect.canContainDdl((PsiElement)e2))).traverse().filter(element2 -> element2 instanceof StubBasedPsiElement && !(element2 instanceof SqlLocalDefinition)).filter(SqlCompositeElement.class).addAllTo(new ArrayList());
    }

    @NotNull
    private State calcState() {
        SqlDialectImplUtilCore.ObjectTracer<?> initialContext;
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        final CasingProvider delegateCasing = SqlImplUtil.getCasingProvider(dialect, SqlImplUtil.getDataSources((PsiElement)this));
        CasingProvider casingProvider = new CasingProvider(){

            @Override
            @NotNull
            public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
                if (kind == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context instanceof DbElement) {
                    Casing casing = ((DbElement)context).getDataSource().getModel().getCasing(kind, context);
                    if (casing == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return casing;
                }
                Casing casing = delegateCasing.getCasing(kind, context);
                if (casing == null) {
                    1.$$$reportNull$$$0(2);
                }
                return casing;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCasing";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getCasing";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        SqlFileResolveMode resolveMode = DbSqlUtilCore.getFileResolveMode((PsiElement)this);
        State state = new State(casingProvider);
        SqlReferenceExpression recentUseRef = null;
        SqlDialectImplUtilCore.ObjectTracer<?> currentContext = initialContext = this.getInitialContext();
        List<SqlElement> ddlList = this.getDdl();
        for (SqlElement ddl : ddlList) {
            if (resolveMode == SqlFileResolveMode.SCRIPT && ddl instanceof SqlUseDatabaseStatement) {
                SqlReferenceExpression useRef = (SqlReferenceExpression)ContainerUtil.getFirstItem((List)((SqlUseDatabaseStatement)ddl).getUseReferences());
                if (useRef != recentUseRef) {
                    recentUseRef = useRef;
                    currentContext = SqlFileImpl.trace((SqlNameElement)recentUseRef, null, dialect);
                }
                this.addDefinitionToMap(null, state, currentContext);
            }
            if (ddl instanceof SqlDefinition) {
                SqlDefinition definition2;
                this.addDefinitionToMap(definition2, state, dialect.respectsCurrentTracerContext(definition2 = (SqlDefinition)ddl) ? currentContext : initialContext);
                continue;
            }
            if (ddl instanceof SqlAlterStatement) {
                for (SqlAlterInstruction i2 : ((SqlAlterStatement)ddl).getAlterInstructions()) {
                    IElementType instructionType = i2.getInstructionType();
                    if (instructionType != SqlCompositeElementTypes.SQL_RENAME_TO_CLAUSE && instructionType != SqlCommonKeywords.SQL_ADD && instructionType != SqlCommonKeywords.SQL_MODIFY) continue;
                    for (SqlDefinition def : ((SqlAlterInstructionImpl)i2).getDefinitions()) {
                        if (def.getKind() == ObjectKind.COLUMN) continue;
                        this.addDefinitionToMap(def, state, currentContext);
                    }
                }
                List renames = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)ddl, SqlRenameToClause.class);
                for (SqlRenameToClause rename : renames) {
                    this.addDefinitionToMap((SqlDefinition)rename, state, currentContext);
                }
                continue;
            }
            for (SqlRenameToClause renamed : SqlImplUtil.childrenIt((PsiElement)ddl).filter(SqlRenameToClause.class)) {
                this.addDefinitionToMap((SqlDefinition)renamed, state, currentContext);
            }
        }
        state.seal(this.myMirrors);
        State state2 = state;
        if (state2 == null) {
            SqlFileImpl.$$$reportNull$$$0(12);
        }
        return state2;
    }

    @Nullable
    private SqlDialectImplUtilCore.ObjectTracer<?> getInitialContext() {
        ObjectPath path = this.getInitialPath();
        return path == null ? null : new PathTracer(path);
    }

    @Nullable
    public ObjectPath getInitialPath() {
        VirtualFile vFile = this.getTopLevelFile();
        List<DbDataSource> dss2 = SqlImplUtil.getDataSources((PsiElement)this);
        if (ContainerUtil.find(dss2, ds -> ds.getDelegate() instanceof SqlDataSource && ((SqlDataSource)ds.getDelegate()).containsFile(vFile)) == null) {
            return null;
        }
        TreePattern initial = SqlDialectImplUtilCore.getImportCheckerAt((SqlFile)this, null).state;
        return this.extractInitialContext(initial);
    }

    private VirtualFile getTopLevelFile() {
        return SqlImplUtil.getTopLevelSqlFile(this.getOriginalFile()).getViewProvider().getVirtualFile();
    }

    @Nullable
    private ObjectPath extractInitialContext(@NotNull TreePattern initial) {
        TreePatternNode dsNode;
        if (initial == null) {
            SqlFileImpl.$$$reportNull$$$0(13);
        }
        if ((dsNode = SqlFileImpl.singlePositiveNode(initial.root.getGroup(ObjectKind.ROOT))) == null) {
            return null;
        }
        TreePattern example = new TreePattern(TreePatternUtils.create(dsNode.naming.names, ObjectKind.ROOT, this.createExamplePattern(dsNode.groups)));
        TreePattern applied = this.getSqlLanguage().applyImplicitImports(dsNode.naming.names, example);
        TreePattern implicit = TreePatternUtils.minus(initial, applied);
        return SqlFileImpl.extractInitialContext(null, SqlFileImpl.singlePositiveNode(implicit.root.getGroup(ObjectKind.ROOT)));
    }

    private TreePatternNode.Group[] createExamplePattern(TreePatternNode.Group[] groups2) {
        return (TreePatternNode.Group[])ContainerUtil.map((Object[])groups2, this::createExamplePattern, (Object[])TreePatternNode.NO_GROUPS);
    }

    private TreePatternNode.Group createExamplePattern(TreePatternNode.Group group2) {
        TreePatternNode[] nodes = group2.children;
        TreePatternUtils.GroupBuilder res2 = new TreePatternUtils.GroupBuilder();
        res2.add(new TreePatternNode(TreePatternNode.PositiveNaming.DUMMY, TreePatternNode.NO_GROUPS));
        if (nodes != null) {
            for (TreePatternNode node2 : nodes) {
                TreePatternNode.Group[] subGroups = node2.groups;
                if (subGroups.length == 0) continue;
                res2.add(new TreePatternNode(node2.naming, this.createExamplePattern(subGroups)));
            }
        }
        return res2.build(group2.kind);
    }

    @Nullable
    private static TreePatternNode singlePositiveNode(@Nullable TreePatternNode.Group g2) {
        if (g2 == null || g2.children == null || g2.children.length > 2) {
            return null;
        }
        TreePatternNode n = g2.children[0];
        if (SqlFileImpl.isFakeOrNegative(n)) {
            if (g2.children.length < 2) {
                return null;
            }
            n = g2.children[1];
            if (n.naming instanceof TreePatternNode.NegativeNaming) {
                return null;
            }
        } else if (g2.children.length > 1 && !SqlFileImpl.isFakeOrNegative(g2.children[1])) {
            return null;
        }
        return n.naming.names.length == 1 ? n : null;
    }

    private static boolean isFakeOrNegative(TreePatternNode n) {
        return SqlFileImpl.isFake(n) || n.naming instanceof TreePatternNode.NegativeNaming;
    }

    private static boolean isFake(@NotNull TreePatternNode n) {
        if (n == null) {
            SqlFileImpl.$$$reportNull$$$0(14);
        }
        return n.naming.matches(SqlImportUtil.NON_MATCHING_NAME, null);
    }

    @Nullable
    private static ObjectPath extractInitialContext(@Nullable ObjectPath p2, @Nullable TreePatternNode n) {
        if (n == null || n.groups.length != 1) {
            return p2;
        }
        TreePatternNode.Group g2 = n.groups[0];
        TreePatternNode c2 = SqlFileImpl.singlePositiveNode(g2);
        if (c2 == null) {
            return p2;
        }
        ObjectName name2 = c2.naming.names[0];
        return SqlFileImpl.extractInitialContext(ObjectPath.create(name2.name, g2.kind, name2.quoted, null, p2), c2);
    }

    private void addDefinitionToMap(@Nullable SqlDefinition o2, @NotNull State newState, @Nullable SqlDialectImplUtilCore.ObjectTracer<?> context) {
        if (newState == null) {
            SqlFileImpl.$$$reportNull$$$0(15);
        }
        if (o2 == null && context == null) {
            return;
        }
        SqlLanguageDialectEx dialect = this.getSqlLanguage();
        List<Trinity<ObjectKind, Boolean, String>> parts = this.getParts(o2, context, dialect);
        if (parts == null) {
            return;
        }
        this.addDefinitionToMap(o2, parts, newState, dialect);
    }

    private List<Trinity<ObjectKind, Boolean, String>> getParts(@Nullable SqlDefinition o2, @Nullable SqlDialectImplUtilCore.ObjectTracer<?> context, @NotNull SqlLanguageDialectEx dialect) {
        ArrayList<Trinity<ObjectKind, Boolean, String>> parts;
        ObjectKind curKind;
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(16);
        }
        if ((curKind = SqlFileImpl.splitRef(dialect, o2, context, parts = new ArrayList<Trinity<ObjectKind, Boolean, String>>(4))) == ObjectKind.NONE) {
            return null;
        }
        List<ObjectKind> path = SqlFileImpl.chooseBestPath(o2, curKind, dialect);
        if (path.isEmpty()) {
            return parts.isEmpty() ? null : parts;
        }
        SqlFileImpl.addSkippedParts(parts, path, ObjectKind.ROOT, o2, dialect);
        return parts;
    }

    private void addDefinitionToMap(@Nullable SqlDefinition o2, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts, @NotNull State newState, @NotNull SqlLanguageDialectEx dialect) {
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(17);
        }
        if (newState == null) {
            SqlFileImpl.$$$reportNull$$$0(18);
        }
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(19);
        }
        BasicMetaModel<?> metaModel = DbImplUtilCore.getMetaModel(dialect.getDbms());
        GroupImpl parent2 = this.myRootMirror;
        Trinity<ObjectKind, String, ?> parentKey = null;
        for (int i2 = parts.size() - 1; i2 >= 0; --i2) {
            boolean wrap2;
            Trinity<ObjectKind, Boolean, String> part = parts.get(i2);
            parentKey = SqlFileImpl.createKey(part, newState.casingProvider, parentKey);
            String name2 = (String)parentKey.second;
            ObjectKind kind = (ObjectKind)part.first;
            Boolean quoted = (Boolean)part.second;
            String uncased = (String)part.third;
            boolean isNamespace = metaModel.getNamespaces().contains(kind);
            GroupImpl mirror = (GroupImpl)this.myMirrors.get(parentKey);
            boolean bl = isNamespace || dialect.shouldWrap((SqlDefinition)(i2 == 0 ? o2 : null), kind) ? true : (wrap2 = false);
            if (mirror == null && wrap2) {
                mirror = isNamespace ? new NamespaceImpl(parent2, name2, uncased, kind, quoted) : new FileGroupImpl(parent2, name2, uncased, kind, quoted);
                mirror = (GroupImpl)ConcurrencyUtil.cacheOrGet(this.myMirrors, parentKey, (Object)mirror);
            }
            if (mirror == null && o2 == null) {
                throw new AssertionError((Object)("Unable to add " + parentKey));
            }
            newState.children.put(mirror != null ? mirror : o2, parent2);
            if (i2 == 0 && o2 != null && mirror != null) {
                newState.delegates.put(o2, mirror);
            }
            parent2 = mirror != null ? mirror : parent2;
        }
    }

    @NotNull
    private static Trinity<ObjectKind, String, ?> createKey(@NotNull Trinity<ObjectKind, Boolean, String> part, @NotNull CasingProvider casingProvider, @Nullable Trinity<ObjectKind, String, ?> parent2) {
        if (part == null) {
            SqlFileImpl.$$$reportNull$$$0(20);
        }
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(21);
        }
        Trinity trinity = Trinity.create((Object)((ObjectKind)part.first), (Object)SqlFileImpl.getCasedName(part, casingProvider), parent2);
        if (trinity == null) {
            SqlFileImpl.$$$reportNull$$$0(22);
        }
        return trinity;
    }

    private static String getCasedName(Trinity<ObjectKind, Boolean, String> part, @NotNull CasingProvider casingProvider) {
        if (casingProvider == null) {
            SqlFileImpl.$$$reportNull$$$0(23);
        }
        ObjectKind kind = (ObjectKind)part.first;
        Boolean quoted = (Boolean)part.second;
        String uncased = (String)part.third;
        Case aCase = casingProvider.getCasing(kind, null).choose(quoted == false);
        String name2 = aCase.apply(uncased);
        return name2;
    }

    static void splitRef(@NotNull SqlLanguageDialectEx dialect, @Nullable SqlReferenceExpression useRef, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(24);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(25);
        }
        SqlFileImpl.splitRef(dialect, null, SqlFileImpl.trace((SqlNameElement)useRef, null, dialect), parts);
    }

    @NotNull
    private static ObjectKind fillParts(@NotNull SqlDialectImplUtilCore.ObjectTracer<?> tracer, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        int before2;
        if (tracer == null) {
            SqlFileImpl.$$$reportNull$$$0(26);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(27);
        }
        ObjectKind curKind = (before2 = parts.size()) == 0 ? tracer.getKind() : (ObjectKind)parts.get((int)(before2 - 1)).first;
        SqlDialectImplUtilCore.ObjectTracer.ObjectTraceIt<?> it2 = tracer.trace();
        while (it2.hasNext()) {
            it2.next();
            ObjectKind kind = it2.getKind();
            if (kind == ObjectKind.NONE || kind == ObjectKind.ROOT) break;
            if (SqlFileImpl.isDuplicate(parts, before2, kind)) continue;
            curKind = kind;
            parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)kind, (Object)it2.isQuoted(), (Object)it2.getName()));
        }
        ObjectKind objectKind = curKind;
        if (objectKind == null) {
            SqlFileImpl.$$$reportNull$$$0(28);
        }
        return objectKind;
    }

    private static boolean isDuplicate(@NotNull List<Trinity<ObjectKind, Boolean, String>> parts, int before2, ObjectKind kind) {
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(29);
        }
        boolean duplicate2 = false;
        for (int i2 = 0; i2 < before2; ++i2) {
            if (parts.get((int)i2).first != kind) continue;
            duplicate2 = true;
            break;
        }
        return duplicate2;
    }

    @NotNull
    static ObjectKind splitRef(@NotNull SqlLanguageDialectEx dialect, @Nullable SqlDefinition o2, @Nullable SqlDialectImplUtilCore.ObjectTracer<?> useTracer, @NotNull List<Trinity<ObjectKind, Boolean, String>> parts) {
        ObjectKind curKind;
        SqlNameElement nameElement;
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(30);
        }
        if (parts == null) {
            SqlFileImpl.$$$reportNull$$$0(31);
        }
        if (o2 == null && useTracer == null) {
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                SqlFileImpl.$$$reportNull$$$0(32);
            }
            return objectKind;
        }
        SqlNameElement sqlNameElement = nameElement = o2 != null ? o2.getNameElement() : null;
        if (o2 != null) {
            if (nameElement != null) {
                SqlDialectImplUtilCore.ObjectTracer<?> tracer = SqlFileImpl.trace(nameElement, o2, dialect);
                curKind = SqlFileImpl.fillParts(tracer, parts);
            } else {
                curKind = o2.getKind();
                parts.add((Trinity<ObjectKind, Boolean, String>)Trinity.create((Object)curKind, (Object)true, (Object)""));
            }
            if (useTracer == null || useTracer.getKind() == ObjectKind.NONE) {
                ObjectKind objectKind = curKind;
                if (objectKind == null) {
                    SqlFileImpl.$$$reportNull$$$0(33);
                }
                return objectKind;
            }
            SmartList parentTypes = new SmartList();
            DbImplUtilCore.getMetaModel(dialect.getDbms()).getParentKinds(dialect.unaliased(curKind)).addAllTo((Collection)parentTypes);
            if (!parentTypes.contains(useTracer.getKind())) {
                List<ObjectKind> path = SqlFileImpl.chooseBestPath(o2, curKind, dialect);
                if (path.contains(useTracer.getKind())) {
                    SqlFileImpl.addSkippedParts(parts, path, useTracer.getKind(), o2, dialect);
                } else {
                    SqlDialectImplUtilCore.ObjectTracer<?> trimmedUse;
                    for (trimmedUse = useTracer; trimmedUse != null && !path.contains(trimmedUse.getKind()); trimmedUse = trimmedUse.getParent(1)) {
                    }
                    if (trimmedUse != null) {
                        curKind = SqlFileImpl.fillParts(trimmedUse, parts);
                    }
                    ObjectKind objectKind = curKind;
                    if (objectKind == null) {
                        SqlFileImpl.$$$reportNull$$$0(34);
                    }
                    return objectKind;
                }
            }
        }
        ObjectKind objectKind = curKind = SqlFileImpl.fillParts(useTracer, parts);
        if (objectKind == null) {
            SqlFileImpl.$$$reportNull$$$0(35);
        }
        return objectKind;
    }

    private static List<ObjectKind> chooseBestPath(@Nullable SqlDefinition o2, @NotNull ObjectKind kind, @NotNull SqlLanguageDialect dialect) {
        ObjectKind expectedParent;
        JBIterable allPaths;
        List list;
        if (kind == null) {
            SqlFileImpl.$$$reportNull$$$0(36);
        }
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(37);
        }
        if ((list = (List)(allPaths = DbImplUtilCore.getMetaModel(dialect.getDbms()).getPathsToRoot(dialect.unaliased(kind)).sort(Comparator.comparing(SqlFileImpl::getPathNamespacesCost))).first()) == null) {
            return Collections.emptyList();
        }
        if (kind == ObjectKind.BODY) {
            expectedParent = SqlImplUtil.getBodyParentKind(o2);
        } else {
            SqlStubbedDefinitionImpl def = (SqlStubbedDefinitionImpl)((Object)ObjectUtils.tryCast((Object)o2, SqlStubbedDefinitionImpl.class));
            SqlReferenceElementType expectedParentType = def == null ? null : def.getExpectedParentType();
            ObjectKind objectKind = expectedParent = expectedParentType == null ? null : expectedParentType.getTargetKind();
            if (expectedParent == null) {
                expectedParent = SqlDbElementType.ANY;
            }
        }
        if (expectedParent != SqlDbElementType.ANY) {
            for (List path : allPaths) {
                if (!path.contains(expectedParent)) continue;
                list = path;
                break;
            }
        }
        return list.subList(1, list.size());
    }

    private static long getPathNamespacesCost(@NotNull List<ObjectKind> path) {
        if (path == null) {
            SqlFileImpl.$$$reportNull$$$0(38);
        }
        return path.stream().filter(DbImplUtilCore::isExternalNamespace).count();
    }

    private static void addSkippedParts(List<Trinity<ObjectKind, Boolean, String>> parts, Iterable<ObjectKind> path, ObjectKind upToKind, SqlDefinition o2, SqlLanguageDialectEx dialect) {
        for (ObjectKind kind : path) {
            if (kind == upToKind) break;
            parts.add(dialect.getImplicitParentInfo(o2, kind));
        }
    }

    @NotNull
    private List<SqlDeclareStatement> calcDeclares() {
        List list = SqlImplUtil.sqlChildren((PsiElement)this).filter(SqlDeclareStatement.class).toList();
        if (list == null) {
            SqlFileImpl.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    public FileType getFileType() {
        SqlFileType sqlFileType = SqlFileType.INSTANCE;
        if (sqlFileType == null) {
            SqlFileImpl.$$$reportNull$$$0(40);
        }
        return sqlFileType;
    }

    public String toString() {
        return "SqlFile:" + this.getName();
    }

    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlFile((SqlFile)this);
    }

    public void acceptChildren(SqlVisitor visitor2) {
        SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
    }

    @NotNull
    public SqlLanguageDialectEx getSqlLanguage() {
        Language language = this.getLanguage();
        if (language instanceof SqlLanguageDialectEx) {
            SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)language;
            if (sqlLanguageDialectEx == null) {
                SqlFileImpl.$$$reportNull$$$0(41);
            }
            return sqlLanguageDialectEx;
        }
        SqlDialectMappings dialectMappings = SqlDialectMappings.getInstance(this.getProject());
        FileViewProvider viewProvider = this.getOriginalFile().getViewProvider();
        SqlLanguageDialect dialect = dialectMappings != null ? dialectMappings.getMapping(viewProvider.isPhysical() ? viewProvider.getVirtualFile() : null) : SqlDialectMappings.getDefaultSqlDialect();
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialect;
        if (sqlLanguageDialectEx == null) {
            SqlFileImpl.$$$reportNull$$$0(42);
        }
        return sqlLanguageDialectEx;
    }

    public boolean processDeclarations(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        PsiFile file;
        if (processor2 == null) {
            SqlFileImpl.$$$reportNull$$$0(43);
        }
        if (state == null) {
            SqlFileImpl.$$$reportNull$$$0(44);
        }
        if (place == null) {
            SqlFileImpl.$$$reportNull$$$0(45);
        }
        if ((file = this.getOriginalFile()) != this) {
            return !(file instanceof SqlFile) || ((SqlFile)file).processDeclarations(processor2, state, lastParent, place);
        }
        SqlImportState importState = SqlDialectImplUtilCore.getImportCheckerAt(this, place);
        Condition<DasObject> importedCondition = SqlFileImpl.importedCondition(importState, null);
        for (DasSymbol symbol : ((State)this.myState.getValue()).children(this.myRootMirror)) {
            if (!(symbol instanceof DasNamespace ? !SqlFileImpl.processDeclarationsImpl(processor2, state, symbol, importedCondition, true, place) : !processor2.execute(symbol, state))) continue;
            return false;
        }
        if (this.getStub() == null && this == place.getContainingFile().getOriginalFile()) {
            for (SqlDeclareStatement o2 : (List)this.myDeclares.getValue()) {
                if (o2.processDeclarations(processor2, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean processCandidateObjects(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull JBIterable<DasObject> objects2, @Nullable Function<? super DasObject, ? extends DasSymbol> mapper) {
        if (processor2 == null) {
            SqlFileImpl.$$$reportNull$$$0(46);
        }
        if (state == null) {
            SqlFileImpl.$$$reportNull$$$0(47);
        }
        if (objects2 == null) {
            SqlFileImpl.$$$reportNull$$$0(48);
        }
        SqlLanguageDialect dialect = processor2.getDialect();
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor2);
        for (DasObject object : objects2) {
            ProgressManager.checkCanceled();
            DasSymbol symbol = mapper != null ? (DasSymbol)mapper.fun((Object)object) : (DasSymbol)ObjectUtils.tryCast((Object)object, DasSymbol.class);
            if (symbol == null) continue;
            if (!processor2.execute(symbol, state)) {
                return false;
            }
            if (!majorChildExpected || !dialect.shouldSkipFromQualification(object.getKind())) continue;
            for (ObjectKind majorKind : dialect.getMajorChildKinds()) {
                for (DasObject major : object.getDasChildren(majorKind)) {
                    DasSymbol majorSymbol = mapper != null ? (DasSymbol)mapper.fun((Object)major) : (DasSymbol)ObjectUtils.tryCast((Object)major, DasSymbol.class);
                    if (majorSymbol == null || processor2.execute(majorSymbol, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static Condition<? super DasObject> getFullExpandConditon(@NotNull Condition<? super DasObject> importCondition, @Nullable DasObject element2, @NotNull SqlScopeProcessor processor2, @NotNull PsiElement place) {
        DbDataSource ds;
        if (importCondition == null) {
            SqlFileImpl.$$$reportNull$$$0(49);
        }
        if (processor2 == null) {
            SqlFileImpl.$$$reportNull$$$0(50);
        }
        if (place == null) {
            SqlFileImpl.$$$reportNull$$$0(51);
        }
        Condition expandCondition = importCondition;
        SqlLanguageDialect dialect = processor2.getDialect();
        Condition dialectCondition = dialect.getAdditionalExpandCondition(processor2, place);
        Condition dialectFilter = dialect.getAdditionalExpandFilter(processor2, place);
        if (dialectCondition != null) {
            expandCondition = Conditions.or(expandCondition, (Condition)dialectCondition);
        }
        if ((ds = (DbDataSource)ObjectUtils.tryCast((Object)element2, DbDataSource.class)) != null) {
            TreePattern scope = DbImplUtilCore.getIntrospectionScope(ds);
            expandCondition = Conditions.and((Condition)expandCondition, o2 -> DbImplUtilCore.isExpandable(o2, scope));
        }
        if (dialectFilter != null) {
            expandCondition = Conditions.and((Condition)expandCondition, (Condition)dialectFilter);
        }
        Condition condition2 = expandCondition;
        if (condition2 == null) {
            SqlFileImpl.$$$reportNull$$$0(52);
        }
        return condition2;
    }

    static boolean processDeclarationsImpl(@NotNull SqlScopeProcessor processor2, ResolveState state, DasSymbol symbol, Condition<? super DasObject> expandCondition, boolean processElement, PsiElement place) {
        Function mapper;
        DasObject element2;
        if (processor2 == null) {
            SqlFileImpl.$$$reportNull$$$0(53);
        }
        if (!((element2 = symbol.getDasObject()) instanceof DasDataSource) && !expandCondition.value((Object)element2)) {
            return !processElement || processor2.execute(symbol, state);
        }
        expandCondition = SqlFileImpl.getFullExpandConditon(expandCondition, element2, processor2, place);
        DbDataSource ds = (DbDataSource)ObjectUtils.tryCast((Object)element2, DbDataSource.class);
        Function function2 = mapper = ds != null ? ds.mapper() : null;
        if (processor2.getReferenceName() != null && ds != null) {
            return SqlFileImpl.processNameIndex(processor2, state, ds.getNameIndex(), expandCondition, mapper);
        }
        JBTreeTraverser traverser2 = ds != null ? ds.getModel().traverser() : (JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)element2);
        JBIterable objects2 = ((JBTreeTraverser)traverser2.expand(expandCondition)).bfsTraversal();
        if (!processElement) {
            objects2 = objects2.filter(o2 -> o2 != element2);
        }
        return SqlFileImpl.processCandidateObjects(processor2, state, (JBIterable<DasObject>)objects2, mapper);
    }

    public static boolean processNameIndex(SqlScopeProcessor processor2, ResolveState state, ModelNameIndex nameIndex, Condition<? super DasObject> expandCondition, @Nullable Function<? super DasObject, ? extends DasSymbol> mapper) {
        return SqlFileImpl.processNameIndex(processor2, state, nameIndex, expandCondition, mapper, false);
    }

    public static boolean processNameIndex(SqlScopeProcessor processor2, ResolveState state, ModelNameIndex nameIndex, Condition<? super DasObject> expandCondition, @Nullable Function<? super DasObject, ? extends DasSymbol> mapper, boolean processParents) {
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor2);
        HashMap<DasObject, Boolean> cache2 = new HashMap<DasObject, Boolean>();
        for (DasObject object : nameIndex.getObjectsByNameInsensitive(processor2.getReferenceName())) {
            DasSymbol symbol;
            ProgressManager.checkCanceled();
            if (!processor2.mayAccept(object.getKind())) continue;
            DasObject parent2 = object.getDasParent();
            if (processParents && parent2 != null) {
                parent2 = parent2.getDasParent();
            }
            if (!SqlFileImpl.isChildrenAccessible(parent2, object, cache2, expandCondition, majorChildExpected, processor2.getDialect()) || (symbol = mapper != null ? (DasSymbol)mapper.fun((Object)object) : (DasSymbol)ObjectUtils.tryCast((Object)object, DasSymbol.class)) == null || processor2.execute(symbol, state)) continue;
            return false;
        }
        return true;
    }

    private static boolean isChildrenAccessible(@Nullable DasObject parent2, @NotNull DasObject child, Map<DasObject, Boolean> cache2, Condition<? super DasObject> expandCondition, boolean majorChildExpected, SqlLanguageDialect dialect) {
        if (child == null) {
            SqlFileImpl.$$$reportNull$$$0(54);
        }
        if (parent2 == null || parent2.getKind() == ObjectKind.ROOT) {
            return true;
        }
        Boolean res2 = cache2.get(parent2);
        if (res2 != null) {
            return res2;
        }
        res2 = SqlFileImpl.isChildrenAccessible(parent2.getDasParent(), parent2, cache2, expandCondition, majorChildExpected, dialect);
        if (res2.booleanValue() && !(res2 = Boolean.valueOf(expandCondition.value((Object)parent2))).booleanValue() && majorChildExpected && dialect.shouldSkipFromQualification(parent2.getKind()) && dialect.getMajorChildKinds().contains(child.getKind())) {
            res2 = true;
        }
        cache2.put(parent2, res2);
        return res2;
    }

    @NotNull
    public static Condition<DasObject> importedCondition(@NotNull SqlImportState checker, @Nullable DasDataSource dataSource2) {
        if (checker == null) {
            SqlFileImpl.$$$reportNull$$$0(55);
        }
        return SqlFileImpl.importedCondition(checker, dataSource2, false);
    }

    @NotNull
    public static Condition<DasObject> importedCondition(@NotNull SqlImportState checker, @Nullable DasDataSource dataSource2, boolean includeAllTopLevelNamespaces) {
        if (checker == null) {
            SqlFileImpl.$$$reportNull$$$0(56);
        }
        DasDataSource ds = dataSource2 instanceof DbDataSource ? ((DbDataSource)dataSource2).getDelegate() : dataSource2;
        Condition condition2 = element2 -> {
            if (element2.getKind() == ObjectKind.ROOT) {
                return true;
            }
            if (!SqlFileImpl.hasChildren(element2)) {
                return false;
            }
            if (includeAllTopLevelNamespaces && (element2.getKind() == ObjectKind.DATABASE || element2.getKind() == ObjectKind.SCHEMA)) {
                return true;
            }
            return element2 instanceof DasNamespace && SqlDialectImplUtilCore.checkImports(checker, ds, element2);
        };
        if (condition2 == null) {
            SqlFileImpl.$$$reportNull$$$0(57);
        }
        return condition2;
    }

    private static boolean hasChildren(DasObject e2) {
        BasicElement unwrapped = (BasicElement)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap(e2), BasicElement.class);
        return unwrapped == null || unwrapped.hasChildren();
    }

    public static boolean isEmptyFakeNamespace(@Nullable DasObject target2) {
        return target2 instanceof GroupImpl && target2 instanceof DasNamespace && ((GroupImpl)target2).delegates().isEmpty() && ((GroupImpl)target2).children().isEmpty();
    }

    @NotNull
    public SqlResolveCache getResolveCache() {
        SqlResolveCache sqlResolveCache = (SqlResolveCache)this.myResolveCache.getValue();
        if (sqlResolveCache == null) {
            SqlFileImpl.$$$reportNull$$$0(58);
        }
        return sqlResolveCache;
    }

    @NotNull
    Couple<GroupImpl> getMirror(@NotNull SqlDefinition o2) {
        if (o2 == null) {
            SqlFileImpl.$$$reportNull$$$0(59);
        }
        GroupImpl parent2 = ((State)this.myState.getValue()).children.get(o2);
        GroupImpl delegate = ((State)this.myState.getValue()).delegates.get(o2);
        if (parent2 == null && delegate == null) {
            Couple couple = Couple.getEmpty();
            if (couple == null) {
                SqlFileImpl.$$$reportNull$$$0(60);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)parent2, (Object)delegate);
        if (couple == null) {
            SqlFileImpl.$$$reportNull$$$0(61);
        }
        return couple;
    }

    public static boolean isUnresolved(PsiElement target2) {
        return SqlFileImpl.isFakeGroup(target2) && target2 instanceof GroupImpl && !SqlFileImpl.isResolvedGrouping((GroupImpl)target2);
    }

    private static boolean isResolvedGrouping(GroupImpl target2) {
        return target2 instanceof DasNamespace || SqlImplUtil.getSqlDialectSafe(target2.getContextElement()).shouldWrap(null, target2.getKind());
    }

    public static boolean isFakeGroup(@Nullable PsiElement e2) {
        return e2 instanceof GroupImpl && ((GroupImpl)e2).delegates().isEmpty();
    }

    @Nullable
    private static SqlDialectImplUtilCore.ObjectTracer<?> trace(@Nullable SqlNameElement ref2, @Nullable SqlDefinition def, @NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlFileImpl.$$$reportNull$$$0(62);
        }
        return ref2 == null ? null : new SqlObjectTracer(ref2, def, dialect);
    }

    public static GroupImpl mergeRoots(@NotNull JBIterable<SqlFile> files2, @NotNull PsiElement context) {
        if (files2 == null) {
            SqlFileImpl.$$$reportNull$$$0(63);
        }
        if (context == null) {
            SqlFileImpl.$$$reportNull$$$0(64);
        }
        return SqlFileImpl.merge(null, files2.map(f -> ((SqlFileImpl)f).myRootMirror).toList(), context);
    }

    private static GroupImpl merge(@Nullable GroupImpl parent2, @NotNull List<GroupImpl> groups2, @NotNull PsiElement context) {
        if (groups2 == null) {
            SqlFileImpl.$$$reportNull$$$0(65);
        }
        if (context == null) {
            SqlFileImpl.$$$reportNull$$$0(66);
        }
        if (groups2.isEmpty()) {
            return null;
        }
        return groups2.get(0) instanceof DasNamespace ? new MergedNamespaceImpl(parent2, groups2, context) : new MergedGroupImpl(parent2, groups2, context);
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$mayChangeOnPsiChange$0(Supplier supplier2) {
        return CachedValueProvider.Result.create(supplier2.get(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 8, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 29, 30, 31, 36, 37, 38, 43, 44, 45, 46, 47, 48, 49, 50, 51, 53, 54, 55, 56, 59, 62, 63, 64, 65, 66 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl";
                break;
            }
            case 1: 
            case 16: 
            case 19: 
            case 24: 
            case 30: 
            case 37: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 8: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newState";
                break;
            }
            case 17: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracer";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 43: 
            case 46: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importCondition";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "mayChangeOnPsiChange";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelRoots";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcState";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createKey";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "fillParts";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRef";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclares";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlLanguage";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullExpandConditon";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "importedCondition";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveCache";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMaximalDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeAt";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractInitialContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFake";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDefinitionToMap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParts";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createKey";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCasedName";
                break;
            }
            case 24: 
            case 25: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "splitRef";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fillParts";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicate";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "chooseBestPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPathNamespacesCost";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processCandidateObjects";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getFullExpandConditon";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsImpl";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isChildrenAccessible";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "importedCondition";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "trace";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "mergeRoots";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 8, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 29, 30, 31, 36, 37, 38, 43, 44, 45, 46, 47, 48, 49, 50, 51, 53, 54, 55, 56, 59, 62, 63, 64, 65, 66 -> new IllegalArgumentException(string);
        };
    }

    private class NamespaceImpl
    extends FileGroupImpl
    implements DasNamespace {
        NamespaceImpl(@NotNull GroupImpl parent2, @Nullable String name2, @NotNull String originalName, ObjectKind kind, boolean quoted) {
            if (name2 == null) {
                NamespaceImpl.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                NamespaceImpl.$$$reportNull$$$0(1);
            }
            super(parent2, name2, originalName, kind, quoted);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$NamespaceImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class GroupImpl
    extends DasVirtualSymbol
    implements DasScopeAware {
        @NotNull
        private final ObjectKind myKind;
        @Nullable
        private final GroupImpl myParent;
        private final boolean myQuoted;
        @Nullable
        private final String myOriginalName;

        GroupImpl(@Nullable GroupImpl parent2, @NotNull String name2, @Nullable String originalName, @NotNull ObjectKind kind, boolean quoted, @NotNull PsiElement context) {
            if (name2 == null) {
                GroupImpl.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                GroupImpl.$$$reportNull$$$0(1);
            }
            if (context == null) {
                GroupImpl.$$$reportNull$$$0(2);
            }
            super(name2, context);
            this.myParent = parent2;
            this.myKind = kind;
            this.myQuoted = quoted;
            this.myOriginalName = originalName;
        }

        @Override
        @NotNull
        public JBIterable<? extends PsiElement> getPsiDeclarations() {
            JBIterable<SqlDefinition> jBIterable = this.delegates();
            if (jBIterable == null) {
                GroupImpl.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public DasObject getDasParent() {
            return this.myParent;
        }

        @NotNull
        public JBIterable<DasObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.empty().append(this.children()).append(this.delegates(), o2 -> o2.getDasChildren(null).filter(PsiObject.class)).filter(DasUtil.byKind(kind));
            if (jBIterable == null) {
                GroupImpl.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public String getOriginalName() {
            SqlDefinition o2 = (SqlDefinition)this.delegates().first();
            return o2 != null ? o2.getName() : this.myOriginalName;
        }

        @Override
        public boolean isQuoted() {
            return this.myQuoted;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.myKind;
            if (objectKind == null) {
                GroupImpl.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @Override
        @Nullable
        public PsiElement getNavigationElement() {
            PsiElement element2 = super.getNavigationElement();
            if (element2 != null) {
                return element2;
            }
            PsiElement child = DasSymbolUtil.getSinglePsiSource((DasSymbol)this.children().first());
            return child != null ? child.getNavigationElement() : null;
        }

        @Override
        public boolean processDeclarations(@NotNull DasScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            Condition<DasObject> importedCondition;
            if (processor2 == null) {
                GroupImpl.$$$reportNull$$$0(6);
            }
            if (state == null) {
                GroupImpl.$$$reportNull$$$0(7);
            }
            if (place == null) {
                GroupImpl.$$$reportNull$$$0(8);
            }
            if (!(processor2 instanceof SqlScopeProcessor)) {
                return true;
            }
            SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)this.getContextElement(), SqlFile.class);
            if (file == null) {
                file = (SqlFile)ObjectUtils.tryCast((Object)SqlImplUtil.getTopLevelSqlFile(place.getContainingFile()), SqlFile.class);
            }
            Condition<DasObject> condition2 = importedCondition = file == null ? Conditions.alwaysTrue() : SqlFileImpl.importedCondition(SqlDialectImplUtilCore.getImportCheckerAt(file, place), null);
            return SqlFileImpl.processDeclarationsImpl((SqlScopeProcessor)processor2, state, this, (Condition<? super DasObject>)((Condition)o2 -> o2 == this || importedCondition.value(o2)), false, place);
        }

        public abstract JBIterable<SqlDefinition> delegates();

        public abstract JBIterable<DasSymbolObject> children();

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof GroupImpl)) {
                return false;
            }
            GroupImpl group2 = (GroupImpl)o2;
            if (!super.equals(o2)) {
                return false;
            }
            return Objects.equals(this.myParent, group2.myParent);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myParent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$GroupImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiDeclarations";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processDeclarations";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static class State {
        final Map<DasSymbolObject, GroupImpl> children = new LinkedHashMap<DasSymbolObject, GroupImpl>();
        final Map<SqlDefinition, GroupImpl> delegates = new LinkedHashMap<SqlDefinition, GroupImpl>();
        final CasingProvider casingProvider;

        State(CasingProvider provider) {
            this.casingProvider = provider;
        }

        void seal(Map<Object, GroupImpl> mirrors) {
            Set used = JBIterable.from(this.delegates.values()).append(this.children.values()).toSet();
            Iterator<GroupImpl> it2 = mirrors.values().iterator();
            while (it2.hasNext()) {
                GroupImpl next = it2.next();
                if (next instanceof DasNamespace || used.contains(next)) continue;
                it2.remove();
            }
        }

        JBIterable<DasSymbolObject> children(GroupImpl o2) {
            return this.forMirror(o2, this.children);
        }

        JBIterable<SqlDefinition> delegates(GroupImpl o2) {
            return this.forMirror(o2, this.delegates);
        }

        <T> JBIterable<T> forMirror(GroupImpl group2, Map<T, GroupImpl> map2) {
            return JBIterable.from(map2.entrySet()).filter(entry -> entry.getValue() == group2).transform(Map.Entry::getKey);
        }
    }

    private static class PathTracer
    extends SqlDialectImplUtilCore.ObjectTracer<ObjectPath> {
        private final ObjectPath myPath;

        PathTracer(@NotNull ObjectPath path) {
            if (path == null) {
                PathTracer.$$$reportNull$$$0(0);
            }
            this.myPath = path;
        }

        @Override
        public SqlDialectImplUtilCore.ObjectTracer.ObjectTraceIt<ObjectPath> trace() {
            return new SqlDialectImplUtilCore.ObjectTracer.ObjectTraceIt<ObjectPath>(JBIterable.generate((Object)this.myPath, p2 -> p2.parent).iterator()){
                private ObjectPath myCurrent;

                @Override
                public ObjectPath next() {
                    this.myCurrent = (ObjectPath)super.next();
                    return this.myCurrent;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myCurrent.kind;
                }

                @Override
                public String getName() {
                    return this.myCurrent.name;
                }

                @Override
                public boolean isQuoted() {
                    return this.myCurrent.isQuoted();
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myPath.kind;
        }

        @Override
        public String getName() {
            return this.myPath.name;
        }

        @Override
        @Nullable
        public SqlDialectImplUtilCore.ObjectTracer<ObjectPath> getParent(int steps2) {
            ObjectPath p2 = this.myPath.getParent(steps2);
            return p2 == null ? null : new PathTracer(p2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/psi/impl/SqlFileImpl$PathTracer", "<init>"));
        }
    }

    public class FileGroupImpl
    extends GroupImpl {
        FileGroupImpl(@NotNull GroupImpl parent2, @Nullable String name2, @NotNull String originalName, ObjectKind kind, boolean quoted) {
            if (name2 == null) {
                FileGroupImpl.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                FileGroupImpl.$$$reportNull$$$0(1);
            }
            super(parent2, name2, originalName, kind, quoted, (PsiElement)SqlFileImpl.this);
        }

        @Override
        public JBIterable<SqlDefinition> delegates() {
            SqlFileImpl file = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)SqlFileImpl.this.getContainingFile(), SqlFileImpl.class));
            return file == null ? JBIterable.empty() : ((State)file.myState.getValue()).delegates(this);
        }

        @Override
        public JBIterable<DasSymbolObject> children() {
            SqlFileImpl file = (SqlFileImpl)((Object)ObjectUtils.tryCast((Object)SqlFileImpl.this.getContainingFile(), SqlFileImpl.class));
            return file == null ? JBIterable.empty() : ((State)file.myState.getValue()).children(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$FileGroupImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SqlObjectTracer
    extends SqlDialectImplUtilCore.ObjectTracer<SqlNameElement> {
        private final SqlNameElement myRef;
        private final SqlReferenceExpression myParentRef;
        private final SqlLanguageDialectEx myDialect;
        @NotNull
        private final ObjectKind myBaseKind;

        SqlObjectTracer(@NotNull SqlNameElement ref2, @Nullable SqlDefinition def, @NotNull SqlLanguageDialectEx dialect) {
            if (ref2 == null) {
                SqlObjectTracer.$$$reportNull$$$0(0);
            }
            if (dialect == null) {
                SqlObjectTracer.$$$reportNull$$$0(1);
            }
            this.myRef = ref2;
            this.myDialect = dialect;
            if (def != null) {
                this.myBaseKind = def.getKind();
                this.myParentRef = def.getParentRef();
            } else if (ref2 instanceof SqlReferenceExpression) {
                ObjectKind kind = ((SqlReferenceExpression)ref2).getReferenceElementType().getTargetKind();
                this.myBaseKind = kind == SqlDbElementType.ANY ? ObjectKind.SCHEMA : kind;
                this.myParentRef = null;
            } else if (ref2.getParent() instanceof SqlDefinition) {
                this.myBaseKind = ((SqlDefinition)ref2.getParent()).getKind();
                this.myParentRef = null;
            } else {
                this.myBaseKind = ref2 instanceof DasObject ? ((DasObject)ref2).getKind() : ObjectKind.NONE;
                this.myParentRef = null;
            }
        }

        @Override
        public SqlDialectImplUtilCore.ObjectTracer.ObjectTraceIt<SqlNameElement> trace() {
            return new SqlDialectImplUtilCore.ObjectTracer.ObjectTraceIt<SqlNameElement>((this.myParentRef != null ? JBIterable.of((Object)this.myRef).append((Iterable)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)this.myParentRef)).filter(SqlReferenceExpression.class)) : (this.myRef instanceof SqlReferenceExpression ? ((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)this.myRef)).filter(SqlReferenceExpression.class) : JBIterable.of((Object)this.myRef))).iterator()){
                private int myLevel;
                private final List<ObjectKind> myParentTypes;
                private ObjectKind myKind;
                private String myName;
                private boolean myQuoted;
                {
                    super(it2);
                    this.myParentTypes = new SmartList();
                    this.myLevel = myRef.getLastChild() instanceof PsiErrorElement ? 1 : 0;
                    this.myKind = myBaseKind;
                    myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                }

                @Override
                public SqlNameElement next() {
                    SqlNameElement item = (SqlNameElement)super.next();
                    if (this.myLevel++ > 0) {
                        SqlReferenceExpression current = (SqlReferenceExpression)ObjectUtils.tryCast((Object)item, SqlReferenceExpression.class);
                        ObjectKind k = current != null ? current.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
                        ObjectKind objectKind = this.myKind = k != SqlDbElementType.ANY && k != SqlDbElementType.QUERY_PARAMETER && k != ObjectKind.VARIABLE ? k : (ObjectKind)ContainerUtil.getFirstItem(this.myParentTypes, (Object)ObjectKind.NONE);
                        if (this.myKind != ObjectKind.NONE) {
                            this.myParentTypes.clear();
                            myDialect.getParentDbTypes(this.myParentTypes, this.myKind);
                        }
                    }
                    this.myName = this.myKind == ObjectKind.BODY ? "" : item.getName();
                    this.myQuoted = DbSqlUtilCore.isQuoted(item);
                    return item;
                }

                @Override
                public ObjectKind getKind() {
                    return this.myKind;
                }

                @Override
                public String getName() {
                    return this.myName;
                }

                @Override
                public boolean isQuoted() {
                    return this.myQuoted;
                }
            };
        }

        @Override
        public ObjectKind getKind() {
            return this.myBaseKind;
        }

        @Override
        public String getName() {
            return this.myRef.getName();
        }

        @Override
        @Nullable
        public SqlDialectImplUtilCore.ObjectTracer<SqlNameElement> getParent(int steps2) {
            if (this.myParentRef == null) {
                return null;
            }
            return new SqlObjectTracer((SqlNameElement)this.myParentRef, null, this.myDialect);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialect";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$SqlObjectTracer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergedNamespaceImpl
    extends MergedGroupImpl
    implements DasNamespace {
        MergedNamespaceImpl(@Nullable GroupImpl parent2, @NotNull List<GroupImpl> groups2, @NotNull PsiElement context) {
            if (groups2 == null) {
                MergedNamespaceImpl.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MergedNamespaceImpl.$$$reportNull$$$0(1);
            }
            super(parent2, groups2, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groups";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$MergedNamespaceImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergedGroupImpl
    extends GroupImpl {
        @NotNull
        private final List<GroupImpl> myGroups;
        volatile List<DasSymbolObject> myChildren;
        volatile List<SqlDefinition> myDelegates;

        MergedGroupImpl(@Nullable GroupImpl parent2, @NotNull List<GroupImpl> groups2, @NotNull PsiElement context) {
            if (groups2 == null) {
                MergedGroupImpl.$$$reportNull$$$0(0);
            }
            if (context == null) {
                MergedGroupImpl.$$$reportNull$$$0(1);
            }
            super(parent2, groups2.get(0).getName(), groups2.get(0).getOriginalName(), groups2.get(0).getKind(), groups2.get(0).isQuoted(), context);
            this.myGroups = groups2;
        }

        @Override
        public boolean isValid() {
            return super.isValid() && ContainerUtil.all(this.myGroups, DasSymbol::isValid);
        }

        @Override
        public JBIterable<SqlDefinition> delegates() {
            List delegates = this.myDelegates;
            if (delegates == null) {
                this.myDelegates = delegates = JBIterable.from(this.myGroups).flatten(g2 -> g2.delegates()).toList();
            }
            return JBIterable.from(delegates);
        }

        @Override
        public JBIterable<DasSymbolObject> children() {
            List children2 = this.myChildren;
            if (children2 == null) {
                MultiMap grouped = ContainerUtil.groupBy((Iterable)JBIterable.from(this.myGroups).flatten(g2 -> g2.children()), s2 -> s2);
                this.myChildren = children2 = ContainerUtil.mapNotNull((Collection)grouped.entrySet(), e2 -> {
                    if (e2.getKey() instanceof GroupImpl) {
                        List groups2 = (List)e2.getValue();
                        return SqlFileImpl.merge(this, groups2, this.getContextElement());
                    }
                    return (DasSymbolObject)e2.getKey();
                });
            }
            return JBIterable.from(children2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "groups";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/psi/impl/SqlFileImpl$MergedGroupImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class FakeDefinition
    extends RenameableFakePsiElement
    implements SqlDefinition,
    SqlNameElement {
        private String myName;

        protected FakeDefinition(@NotNull PsiElement parent2, @NotNull String name2) {
            if (parent2 == null) {
                FakeDefinition.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                FakeDefinition.$$$reportNull$$$0(1);
            }
            super(parent2);
            this.myName = name2;
        }

        public boolean isPlainIdentifier() {
            return !this.isQuotedIdentifier();
        }

        public boolean isQuotedIdentifier() {
            return this.isNameQuoted();
        }

        public SqlFile getContainingFile() {
            return (SqlFile)super.getContainingFile();
        }

        @Nullable
        public TextRange getTextRange() {
            PsiElement element2 = this.getNavigationElement();
            return element2 != this ? element2.getTextRange() : super.getTextRange();
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FakeDefinition.$$$reportNull$$$0(2);
            }
            return string;
        }

        public FakeDefinition setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
            if (name2 == null) {
                FakeDefinition.$$$reportNull$$$0(3);
            }
            this.myName = name2;
            return this;
        }

        public String getTypeName() {
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)this).getDbms();
            return DbPresentationCore.getPresentableName(this.getKind(), dbms);
        }

        public Icon getIcon() {
            return DbPresentationCore.getIcon((DasObject)((Object)this));
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return this;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return this.getNameElement();
        }

        @Nullable
        public DasObject getDasParent() {
            PsiElement parent2 = this.getParent();
            return parent2 instanceof DasObject ? (DasObject)parent2 : null;
        }

        public boolean isEquivalentTo(PsiElement another) {
            return this.equals(another);
        }

        public boolean equals(Object another) {
            return ((Object)((Object)this)).getClass() == another.getClass() && this.myName.equals(((FakeDefinition)((Object)another)).myName) && this.getParent().equals(((PsiElement)another).getParent());
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = result2 * 31 + this.getParent().hashCode();
            return result2;
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlImplUtil.getSqlDialectDbms(this.getParent());
            if (dbms == null) {
                FakeDefinition.$$$reportNull$$$0(4);
            }
            return dbms;
        }

        public String toString() {
            return this.getKind() + ":" + this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFileImpl$FakeDefinition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4 -> new IllegalStateException(string);
            };
        }
    }
}

