/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyStub;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateIndexStatementImpl
extends SqlKIFKImpl<SqlTableKeyStub<SqlCreateIndexStatement>>
implements SqlCreateIndexStatement,
SqlTargetContextProvider {
    public SqlCreateIndexStatementImpl(@NotNull ASTNode node2) {
        if (node2 == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(0);
        }
        super(node2);
    }

    public SqlCreateIndexStatementImpl(SqlTableKeyStub<SqlCreateIndexStatement> stub) {
        super(stub);
    }

    @Override
    public String getTableName() {
        SqlReferenceExpression ref2 = this.getTargetReference();
        return ref2 == null ? null : ref2.getText();
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateIndexStatement((SqlCreateIndexStatement)this);
    }

    @Nullable
    public SqlReferenceExpression getTargetReference() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getStub();
        if (stub != null) {
            SqlTableColumnsList columnList2 = stub.getKeyColumnList();
            return columnList2 == null ? null : columnList2.getTableReference();
        }
        SqlOnTargetClauseImpl clause = this.findTargetClause();
        return clause == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)clause.getTargetExpression(), SqlReferenceExpression.class);
    }

    @Nullable
    private SqlTableColumnsList getTableColumnsList() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getStub();
        if (stub != null) {
            return stub.getKeyColumnList();
        }
        return (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)this.findTargetClause(), SqlTableColumnsList.class);
    }

    private SqlOnTargetClauseImpl findTargetClause() {
        return (SqlOnTargetClauseImpl)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
    }

    @NotNull
    public DasIndex.Sorting getColumnSorting(@NotNull String column2) {
        SqlTableColumnsList list;
        if (column2 == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(1);
        }
        SqlReferenceList exprList = (list = this.getTableColumnsList()) == null ? null : list.getColumnsReferenceList();
        for (SqlExpression expression : SqlImplUtil.sqlChildren((PsiElement)exprList).filter(SqlExpression.class)) {
            if (!SqlCreateIndexStatementImpl.columnMatches(column2, expression)) continue;
            return SqlCreateIndexStatementImpl.getColumnSorting(expression);
        }
        DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
        if (sorting == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(2);
        }
        return sorting;
    }

    @NotNull
    private static DasIndex.Sorting getColumnSorting(SqlExpression expression) {
        for (PsiElement s2 = expression.getNextSibling(); s2 != null && !(s2 instanceof SqlExpression); s2 = s2.getNextSibling()) {
            IElementType type2 = PsiUtilCore.getElementType((PsiElement)s2);
            if (type2 == SqlCommonKeywords.SQL_ASC) {
                DasIndex.Sorting sorting = DasIndex.Sorting.ASCENDING;
                if (sorting == null) {
                    SqlCreateIndexStatementImpl.$$$reportNull$$$0(3);
                }
                return sorting;
            }
            if (type2 != SqlCommonKeywords.SQL_DESC) continue;
            DasIndex.Sorting sorting = DasIndex.Sorting.DESCENDING;
            if (sorting == null) {
                SqlCreateIndexStatementImpl.$$$reportNull$$$0(4);
            }
            return sorting;
        }
        DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
        if (sorting == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(5);
        }
        return sorting;
    }

    private static boolean columnMatches(@NotNull String column2, SqlExpression expression) {
        if (column2 == null) {
            SqlCreateIndexStatementImpl.$$$reportNull$$$0(6);
        }
        if (expression instanceof SqlReferenceExpression) {
            return column2.equalsIgnoreCase(expression.getName());
        }
        return column2.equalsIgnoreCase(expression.getText());
    }

    @Override
    @Nullable
    public SqlReferenceList getColumnsList() {
        SqlTableColumnsList tableColumnsList = this.getTableColumnsList();
        return tableColumnsList == null ? null : tableColumnsList.getColumnsReferenceList();
    }

    public List<SqlReferenceExpression> getColumnReferences() {
        return SqlImplUtil.getReferenceList(this.getTableColumnsList());
    }

    @Override
    @Nullable
    public DasTable getTable() {
        SqlReferenceExpression ref2 = this.getTargetReference();
        if (ref2 == null) {
            return null;
        }
        for (ResolveResult result2 : ref2.multiResolve(false)) {
            if (!(result2.getElement() instanceof DasTable)) continue;
            return (DasTable)result2.getElement();
        }
        return null;
    }

    public boolean isUnique() {
        SqlTableKeyStub stub = (SqlTableKeyStub)this.getGreenStub();
        if (stub != null) {
            return ((DasIndex)((Object)stub.getElement())).isUnique();
        }
        return this.findChildByType((IElementType)SqlCommonKeywords.SQL_UNIQUE) != null;
    }

    public boolean isFunctionBased() {
        return false;
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlReferenceExpression reference = this.getTargetReference();
        if (reference != null && !SqlImplUtil.processQualifier(reference, processor2, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    @Nullable
    public SqlReferenceExpression getTargetContextExpression() {
        return this.getTargetReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateIndexStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateIndexStatementImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnSorting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumnSorting";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "columnMatches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

