/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.IntentionUtilsKt;
import com.intellij.sql.intentions.SqlMergeInsertStatementsIntention;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/sql/intentions/SqlMergeInsertStatementsIntention;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlMergeInsertStatementsIntention
extends BaseIntentionAction
implements DumbAware {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.merge.insert.statements", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (editor2 == null) {
            return false;
        }
        Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)file).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (dbms2.isOracle() || dbms2.isSybase()) {
            return false;
        }
        Sequence<SqlInsertStatement> statements2 = IntentionUtilsKt.getInsertStatements(editor2, file, true);
        if (!SequencesKt.any(statements2) || SequencesKt.singleOrNull(statements2) != null) {
            return false;
        }
        if (editor2.getSelectionModel().hasSelection()) {
            this.setText(SqlBundle.message((String)"intention.name.merge.selected.insert.statements", (Object[])new Object[0]));
        } else {
            this.setText(SqlBundle.message((String)"intention.name.merge.successive.insert.statements", (Object[])new Object[0]));
        }
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        DdlBuilder ddlBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        List statements2 = SequencesKt.toList(IntentionUtilsKt.getInsertStatements(editor2, file, true));
        SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)CollectionsKt.firstOrNull((List)statements2);
        if (sqlInsertStatement == null) {
            return;
        }
        SqlInsertStatement anchor2 = sqlInsertStatement;
        String string = UtilsKt.getValuesKeyword(anchor2);
        if (string == null) {
            return;
        }
        String valuesKeyword2 = string;
        DdlBuilder $this$invoke_u24lambda_u240 = ddlBuilder = new DdlBuilder();
        boolean bl = false;
        $this$invoke_u24lambda_u240.plain("INSERT INTO foo " + valuesKeyword2 + " ");
        $this$invoke_u24lambda_u240.plain(CollectionsKt.joinToString$default((Iterable)statements2, null, null, null, (int)0, null, (Function1)invoke.insertText.1.1.INSTANCE, (int)31, null));
        String string2 = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStatement(...)");
        String insertText2 = string2;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlStatement newInsert = SqlPsiElementFactory.createStatementFromText(insertText2, dialect, project, null);
        SqlInsertStatement sqlInsertStatement2 = newInsert instanceof SqlInsertStatement ? (SqlInsertStatement)newInsert : null;
        if (sqlInsertStatement2 == null || (sqlInsertStatement2 = sqlInsertStatement2.getDmlInstruction()) == null || (sqlInsertStatement2 = sqlInsertStatement2.getValuesExpression()) == null) {
            return;
        }
        SqlInsertStatement newValues = sqlInsertStatement2;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = anchor2.getDmlInstruction();
        Intrinsics.checkNotNull((Object)sqlInsertDmlInstruction);
        SqlValuesExpression sqlValuesExpression = sqlInsertDmlInstruction.getValuesExpression();
        Intrinsics.checkNotNull((Object)sqlValuesExpression);
        sqlValuesExpression.replace((PsiElement)newValues);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)anchor2);
        PsiElement psiElement = anchor2.getNextSibling();
        if (psiElement == null || (psiElement = psiElement.getTextRange()) == null) {
            return;
        }
        int deleteFrom = psiElement.getStartOffset();
        SqlInsertStatement sqlInsertStatement3 = (SqlInsertStatement)CollectionsKt.lastOrNull((List)statements2);
        if (sqlInsertStatement3 == null) {
            return;
        }
        int deleteTo = PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)sqlInsertStatement3));
        doc.deleteString(deleteFrom, deleteTo);
    }
}

