/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J!\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\u0014\u001a\u00020\u0013*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getInfo", "Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention$Info;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "isNot", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "dbms", "Lcom/intellij/database/Dbms;", "Info", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlConvertComparisonToBetweenIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlConvertComparisonToBetweenIntention.kt\ncom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n288#2,2:88\n*S KotlinDebug\n*F\n+ 1 SqlConvertComparisonToBetweenIntention.kt\ncom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention\n*L\n54#1:88,2\n*E\n"})
public final class SqlConvertComparisonToBetweenIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.comparison.with.between.expression", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getInfo(element2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Info info2 = this.getInfo(element2);
        if (info2 == null) {
            return;
        }
        Info info3 = info2;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(info3.getElementToReplace());
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        String string = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect()).plain(info3.getSubject().getText()).keyword(info3.isNot() ? " not between " : " between ").plain(info3.getLowerBound().getText()).keyword(" and ").plain(info3.getUpperBound().getText()).getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String betweenExprText = string;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(betweenExprText, dialect, project, null);
        Intrinsics.checkNotNull((Object)sqlExpression);
        SqlExpression betweenExpr = sqlExpression;
        info3.getElementToReplace().replace((PsiElement)betweenExpr);
    }

    /*
     * WARNING - void declaration
     */
    private final Info getInfo(PsiElement element2) {
        PsiElement parent2;
        SqlExpression sqlExpression;
        Object v2;
        Dbms dbms;
        block13: {
            void $this$firstOrNull$iv;
            Dbms dbms2 = SqlImplUtil.getSqlDialectSafe(element2).getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"getDbms(...)");
            dbms = dbms2;
            JBIterable jBIterable = SqlImplUtil.sqlParents(element2).filter(SqlBinaryExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBinaryExpression it2 = (SqlBinaryExpression)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                if (!UtilsKt.isAnd(it2, dbms)) continue;
                v2 = element$iv;
                break block13;
            }
            v2 = null;
        }
        SqlBinaryExpression sqlBinaryExpression = v2;
        if (sqlBinaryExpression == null) {
            return null;
        }
        SqlBinaryExpression andExpr = sqlBinaryExpression;
        Pair<SqlReferenceExpression, SqlExpression> pair = andExpr.getLOperand();
        SqlBinaryExpression sqlBinaryExpression2 = pair instanceof SqlBinaryExpression ? (SqlBinaryExpression)pair : null;
        if (sqlBinaryExpression2 == null) {
            return null;
        }
        SqlBinaryExpression leftCmp = sqlBinaryExpression2;
        SqlExpression sqlExpression2 = andExpr.getROperand();
        SqlBinaryExpression sqlBinaryExpression3 = sqlExpression2 instanceof SqlBinaryExpression ? (SqlBinaryExpression)sqlExpression2 : null;
        if (sqlBinaryExpression3 == null) {
            return null;
        }
        SqlBinaryExpression rightCmp = sqlBinaryExpression3;
        Pair<SqlReferenceExpression, SqlExpression> pair2 = UtilsKt.splitWithReference(leftCmp);
        if (pair2 == null) {
            return null;
        }
        pair = pair2;
        SqlReferenceExpression leftRef = (SqlReferenceExpression)pair.component1();
        SqlExpression leftExpr = (SqlExpression)pair.component2();
        Pair<SqlReferenceExpression, SqlExpression> pair3 = UtilsKt.splitWithReference(rightCmp);
        if (pair3 == null) {
            return null;
        }
        Pair<SqlReferenceExpression, SqlExpression> pair4 = pair3;
        SqlReferenceExpression rightRef = (SqlReferenceExpression)pair4.component1();
        SqlExpression rightExpr = (SqlExpression)pair4.component2();
        if (!UtilsKt.checkEquivalence(leftRef, rightRef)) {
            return null;
        }
        SqlExpression lowerBound = null;
        SqlExpression upperBound = null;
        if (Intrinsics.areEqual((Object)leftCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_LE) && Intrinsics.areEqual((Object)rightCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_GE)) {
            upperBound = leftExpr;
            lowerBound = rightExpr;
        } else if (Intrinsics.areEqual((Object)leftCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_GE) && Intrinsics.areEqual((Object)rightCmp.getOpSign(), (Object)SqlCommonTokens.SQL_OP_LE)) {
            lowerBound = leftExpr;
            upperBound = rightExpr;
        }
        if ((sqlExpression = UtilsKt.topParenthesized((SqlExpression)andExpr)) == null) {
            sqlExpression = (SqlExpression)andExpr;
        }
        boolean isNot = (parent2 = sqlExpression.getParent()) instanceof SqlUnaryExpression && this.isNot((SqlUnaryExpression)parent2, dbms);
        PsiElement psiElement = isNot ? parent2 : (PsiElement)andExpr;
        Intrinsics.checkNotNull((Object)psiElement);
        SqlExpression sqlExpression3 = lowerBound;
        if (sqlExpression3 == null) {
            return null;
        }
        SqlExpression sqlExpression4 = upperBound;
        if (sqlExpression4 == null) {
            return null;
        }
        return new Info(isNot, psiElement, leftRef, sqlExpression3, sqlExpression4);
    }

    private final boolean isNot(SqlUnaryExpression $this$isNot, Dbms dbms) {
        IElementType iElementType = $this$isNot.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOpSign(...)");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_NOT)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NOT2) && (dbms.isHive() || dbms.is(Dbms.SPARK));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlConvertComparisonToBetweenIntention$Info;", "", "isNot", "", "elementToReplace", "Lcom/intellij/psi/PsiElement;", "subject", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "lowerBound", "Lcom/intellij/sql/psi/SqlExpression;", "upperBound", "(ZLcom/intellij/psi/PsiElement;Lcom/intellij/sql/psi/SqlReferenceExpression;Lcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlExpression;)V", "getElementToReplace", "()Lcom/intellij/psi/PsiElement;", "()Z", "getLowerBound", "()Lcom/intellij/sql/psi/SqlExpression;", "getSubject", "()Lcom/intellij/sql/psi/SqlReferenceExpression;", "getUpperBound", "intellij.database.sql.impl"})
    private static final class Info {
        private final boolean isNot;
        @NotNull
        private final PsiElement elementToReplace;
        @NotNull
        private final SqlReferenceExpression subject;
        @NotNull
        private final SqlExpression lowerBound;
        @NotNull
        private final SqlExpression upperBound;

        public Info(boolean isNot, @NotNull PsiElement elementToReplace, @NotNull SqlReferenceExpression subject, @NotNull SqlExpression lowerBound, @NotNull SqlExpression upperBound) {
            Intrinsics.checkNotNullParameter((Object)elementToReplace, (String)"elementToReplace");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
            Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
            this.isNot = isNot;
            this.elementToReplace = elementToReplace;
            this.subject = subject;
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public final boolean isNot() {
            return this.isNot;
        }

        @NotNull
        public final PsiElement getElementToReplace() {
            return this.elementToReplace;
        }

        @NotNull
        public final SqlReferenceExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final SqlExpression getLowerBound() {
            return this.lowerBound;
        }

        @NotNull
        public final SqlExpression getUpperBound() {
            return this.upperBound;
        }
    }
}

