/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalUnknownInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.GotoInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PopInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushValueInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.SwapInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.database.Dbms;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.SqlDfaJoinType;
import com.intellij.sql.inspections.dataflow.SqlDfaPsiUtilKt;
import com.intellij.sql.inspections.dataflow.SqlDfaUnionType;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.inspections.dataflow.SqlPsiRangeSetUtilKt;
import com.intellij.sql.inspections.dataflow.sql.SqlFlowAnalyser;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlClauseAnchor;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlExpressionAnchor;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlNAryExpressionPartAnchor;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlAssignAliasInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBetweenInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBinaryInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanAllAnyInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanAndOrInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanBinaryInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanInInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanLikeInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanRelationInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlBooleanXorInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlCrossJoinInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlDeleteInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlFilteringInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlFunctionCallInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlGroupByInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlInsertInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlJoinByConditionInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlJoinByUsingInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlLimitInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlNaturalJoinInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlNotInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlNumericBinaryInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlOffsetInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlOrderByInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlParenthesizeInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlReferenceAccessInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlSelectInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlStringConcatInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlUnionInstruction;
import com.intellij.sql.inspections.dataflow.sql.inst.SqlUpdateInstruction;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElseClause;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlIntersectExpression;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLimitClause;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlNAryExpression;
import com.intellij.sql.psi.SqlOffsetClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlUnionExpression;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhenThenClause;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.SqlWithQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlTypeConversionUtilKt;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0003,-.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0017H\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020\u0017H\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020+H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser;", "Lcom/intellij/psi/PsiElementVisitor;", "element", "Lcom/intellij/psi/PsiElement;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)V", "currentFlow", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow;", "dbms", "Lcom/intellij/database/Dbms;", "Lorg/jetbrains/annotations/NotNull;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "getElement", "()Lcom/intellij/psi/PsiElement;", "getFactory", "()Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "sqlVisitor", "Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor;", "addInstruction", "", "i", "Lcom/intellij/codeInspection/dataFlow/lang/ir/Instruction;", "buildControlFlow", "createEmptyTable", "o", "Lcom/intellij/sql/psi/SqlTableExpression;", "finishElement", "getInstructionCount", "", "pop", "push", "dfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "pushUnknown", "startElement", "visitElement", "visitErrorElement", "Lcom/intellij/psi/PsiErrorElement;", "CannotAnalyzeException", "Companion", "Visitor", "intellij.database.sql.core.impl"})
public final class SqlFlowAnalyser
extends PsiElementVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement element;
    @NotNull
    private final DfaValueFactory factory;
    @NotNull
    private final SqlLanguageDialectEx dialect;
    private ControlFlow currentFlow;
    @NotNull
    private final Visitor sqlVisitor;
    @NotNull
    private final Dbms dbms;

    public SqlFlowAnalyser(@NotNull PsiElement element2, @NotNull DfaValueFactory factory, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        this.element = element2;
        this.factory = factory;
        this.dialect = dialect;
        this.sqlVisitor = new Visitor();
        Dbms dbms = this.dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        this.dbms = dbms;
    }

    @NotNull
    public final PsiElement getElement() {
        return this.element;
    }

    @NotNull
    public final DfaValueFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final SqlLanguageDialectEx getDialect() {
        return this.dialect;
    }

    private final ControlFlow buildControlFlow() {
        this.currentFlow = new ControlFlow(this.factory, this.element);
        this.addInstruction((Instruction)new FinishElementInstruction(null));
        try {
            this.element.accept((PsiElementVisitor)this);
        }
        catch (CannotAnalyzeException e2) {
            return null;
        }
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.finish();
        ControlFlow controlFlow2 = this.currentFlow;
        if (controlFlow2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow2 = null;
        }
        return controlFlow2;
    }

    private final void startElement(PsiElement element2) {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.startElement(element2);
    }

    private final void finishElement(PsiElement element2) {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.finishElement(element2);
        if (element2 instanceof SqlStatement || element2 instanceof SqlQueryExpression) {
            this.addInstruction((Instruction)new FinishElementInstruction(element2));
        }
    }

    private final void addInstruction(Instruction i2) {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        controlFlow.addInstruction(i2);
    }

    private final void push(DfType dfType, SqlExpression expression) {
        this.addInstruction((Instruction)new PushValueInstruction(dfType, (DfaAnchor)SqlExpressionAnchor.Companion.getAnchor(expression)));
    }

    private final void pop() {
        this.addInstruction((Instruction)new PopInstruction());
    }

    private final void pushUnknown() {
        this.addInstruction((Instruction)new PushValueInstruction(DfType.TOP, null));
    }

    private final void createEmptyTable(SqlTableExpression o2) {
        SqlExpressionAnchor sqlExpressionAnchor = SqlExpressionAnchor.Companion.getAnchor((SqlExpression)o2);
        this.addInstruction((Instruction)new EvalInstruction(o2, sqlExpressionAnchor){
            final /* synthetic */ SqlTableExpression $o;
            {
                this.$o = $o;
                super((DfaAnchor)$super_call_param$1, 0);
            }

            @NotNull
            public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
                Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
                return SqlDfaUtilKt.createTableValue((PsiElement)this.$o, null, factory, state, SqlDfTypesKt.getEMPTY_TABLE());
            }

            @NotNull
            public String toString() {
                return "EMPTY_TABLE";
            }
        });
    }

    public final int getInstructionCount() {
        ControlFlow controlFlow = this.currentFlow;
        if (controlFlow == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentFlow");
            controlFlow = null;
        }
        return controlFlow.getInstructionCount();
    }

    public void visitElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (element2 instanceof SqlElement) {
            ((SqlElement)element2).accept((SqlVisitor)this.sqlVisitor);
        }
    }

    public void visitErrorElement(@NotNull PsiErrorElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        throw new CannotAnalyzeException();
    }

    @JvmStatic
    @Nullable
    public static final ControlFlow buildFlow(@NotNull PsiElement element2, @NotNull DfaValueFactory valueFactory, @NotNull SqlLanguageDialectEx dialect) {
        return Companion.buildFlow(element2, valueFactory, dialect);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$CannotAnalyzeException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "intellij.database.sql.core.impl"})
    private static final class CannotAnalyzeException
    extends RuntimeException {
        public CannotAnalyzeException() {
            super(null, null, false, false);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Companion;", "", "()V", "buildFlow", "Lcom/intellij/codeInspection/dataFlow/lang/ir/ControlFlow;", "element", "Lcom/intellij/psi/PsiElement;", "valueFactory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ControlFlow buildFlow(@NotNull PsiElement element2, @NotNull DfaValueFactory valueFactory, @NotNull SqlLanguageDialectEx dialect) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)valueFactory, (String)"valueFactory");
            Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
            return new SqlFlowAnalyser(element2, valueFactory, dialect).buildControlFlow();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0002J(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J4\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000fH\u0016J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0019H\u0016J\u0010\u00101\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020 H\u0016J\u0010\u0010@\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020WH\u0016J\u0010\u0010X\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001cH\u0016J\u0010\u0010]\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020`H\u0016J\u0010\u0010a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020fH\u0016J\f\u0010g\u001a\u00020\u0004*\u00020hH\u0002J\u000e\u0010i\u001a\u0004\u0018\u00010\u0013*\u00020 H\u0002\u00a8\u0006j"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor;", "Lcom/intellij/sql/psi/SqlVisitor;", "(Lcom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser;)V", "acceptNAryExpression", "", "o", "Lcom/intellij/sql/psi/SqlNAryExpression;", "acceptOrPushUnknown", "element", "Lcom/intellij/sql/psi/SqlElement;", "acceptSqlDeleteInstruction", "Lcom/intellij/sql/psi/SqlDmlInstruction;", "acceptSqlUpdateInstruction", "generateBinOp", "expression", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "op", "Lcom/intellij/psi/tree/IElementType;", "opElement", "Lcom/intellij/psi/PsiElement;", "resType", "Lcom/intellij/database/types/DasTypeCategory;", "generateBinOpChain", "operands", "", "Lcom/intellij/sql/psi/SqlExpression;", "expressionChain", "getOperand", "Lcom/intellij/sql/psi/SqlUnaryExpression;", "isAssignment", "", "isMssqlOuterApply", "Lcom/intellij/sql/psi/SqlJoinExpression;", "visitMssqlOuterApply", "visitSqlAsExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "visitSqlBetweenExpression", "Lcom/intellij/sql/psi/SqlBetweenExpression;", "visitSqlBinaryExpression", "visitSqlCaseExpression", "Lcom/intellij/sql/psi/SqlCaseExpression;", "visitSqlDeleteStatement", "Lcom/intellij/sql/psi/SqlDeleteStatement;", "visitSqlDmlInstruction", "visitSqlElseClause", "Lcom/intellij/sql/psi/SqlElseClause;", "visitSqlExplicitTableExpression", "Lcom/intellij/sql/psi/SqlExplicitTableExpression;", "visitSqlExpression", "visitSqlExpressionList", "Lcom/intellij/sql/psi/SqlExpressionList;", "visitSqlFromClause", "Lcom/intellij/sql/psi/SqlFromClause;", "visitSqlFunctionCallExpression", "Lcom/intellij/sql/psi/SqlFunctionCallExpression;", "visitSqlGroupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "visitSqlHavingClause", "Lcom/intellij/sql/psi/SqlHavingClause;", "visitSqlInsertStatement", "Lcom/intellij/sql/psi/SqlInsertStatement;", "visitSqlIntersectExpression", "Lcom/intellij/sql/psi/SqlIntersectExpression;", "visitSqlJoinExpression", "visitSqlLimitClause", "Lcom/intellij/sql/psi/SqlLimitClause;", "visitSqlLiteralExpression", "Lcom/intellij/sql/psi/SqlLiteralExpression;", "visitSqlMergeStatement", "Lcom/intellij/sql/psi/SqlMergeStatement;", "visitSqlOffsetClause", "Lcom/intellij/sql/psi/SqlOffsetClause;", "visitSqlOrderByClause", "Lcom/intellij/sql/psi/SqlOrderByClause;", "visitSqlParenthesizedExpression", "Lcom/intellij/sql/psi/SqlParenthesizedExpression;", "visitSqlQueryExpression", "Lcom/intellij/sql/psi/SqlQueryExpression;", "visitSqlReferenceExpression", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "visitSqlReferenceList", "Lcom/intellij/sql/psi/SqlReferenceList;", "visitSqlSelectClause", "Lcom/intellij/sql/psi/SqlSelectClause;", "visitSqlSelectStatement", "Lcom/intellij/sql/psi/SqlSelectStatement;", "visitSqlSetAssignment", "Lcom/intellij/sql/psi/SqlSetAssignment;", "visitSqlTableExpression", "Lcom/intellij/sql/psi/SqlTableExpression;", "visitSqlThenClause", "Lcom/intellij/sql/psi/SqlThenClause;", "visitSqlUnaryExpression", "visitSqlUnionExpression", "Lcom/intellij/sql/psi/SqlUnionExpression;", "visitSqlUpdateStatement", "Lcom/intellij/sql/psi/SqlUpdateStatement;", "visitSqlWhenClause", "Lcom/intellij/sql/psi/SqlWhenClause;", "visitSqlWhereClause", "Lcom/intellij/sql/psi/SqlWhereClause;", "visitSqlWithQueryExpression", "Lcom/intellij/sql/psi/SqlWithQueryExpression;", "accept", "Lcom/intellij/sql/psi/SqlInsertDmlInstruction;", "getOpSignElementSafe", "intellij.database.sql.core.impl"})
    @SourceDebugExtension(value={"SMAP\nSqlFlowAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFlowAnalyser.kt\ncom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,650:1\n1#2:651\n1#2:653\n2634#3:652\n1855#3,2:654\n1855#3,2:656\n1855#3,2:658\n1855#3,2:660\n1855#3,2:662\n1855#3,2:664\n1855#3,2:668\n1855#3,2:670\n1855#3,2:672\n1855#3,2:674\n1855#3,2:678\n13309#4,2:666\n13309#4,2:676\n*S KotlinDebug\n*F\n+ 1 SqlFlowAnalyser.kt\ncom/intellij/sql/inspections/dataflow/sql/SqlFlowAnalyser$Visitor\n*L\n181#1:653\n181#1:652\n247#1:654,2\n256#1:656,2\n319#1:658,2\n426#1:660,2\n427#1:662,2\n432#1:664,2\n494#1:668,2\n498#1:670,2\n504#1:672,2\n511#1:674,2\n552#1:678,2\n443#1:666,2\n517#1:676,2\n*E\n"})
    private final class Visitor
    extends SqlVisitor {
        private final void acceptOrPushUnknown(SqlElement element2) {
            SqlElement sqlElement = element2;
            if (sqlElement != null) {
                sqlElement.accept((SqlVisitor)this);
            } else {
                SqlFlowAnalyser.this.pushUnknown();
            }
        }

        public void visitSqlUnaryExpression(@NotNull SqlUnaryExpression o2) {
            SqlExpression sqlExpression;
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlExpression sqlExpression2 = SqlImplUtil.skipParenthesizedExprDown(this.getOperand(o2));
            if (sqlExpression2 != null) {
                SqlExpression sqlExpression3;
                SqlExpression it2 = sqlExpression3 = sqlExpression2;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
                sqlExpression = sqlExpression3;
            } else {
                sqlExpression = null;
            }
            SqlExpression operand = sqlExpression;
            IElementType op = PsiTreeUtilKt.getElementType((PsiElement)o2.getOpSignElement());
            if (operand == null || op == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o2);
                return;
            }
            DasType dasType = operand.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType type2 = dasType;
            if (SqlPsiUtilKt.isLogicalNot(op, SqlFlowAnalyser.this.dbms)) {
                SqlFlowAnalyser.this.addInstruction((Instruction)new SqlNotInstruction((SqlExpression)o2));
            } else if (Intrinsics.areEqual((Object)op, (Object)SqlCommonTokens.SQL_OP_MINUS) && (DasTypeUtilsKt.getCategory(type2) == DasTypeCategory.INTEGER || SqlFlowAnalyser.this.dbms.isMysql() && DasTypeUtilsKt.getCategory(type2) != DasTypeCategory.STRING)) {
                SqlFlowAnalyser.this.addInstruction((Instruction)new PushValueInstruction((DfType)SqlDfTypesKt.intValue(0)));
                SqlFlowAnalyser.this.addInstruction((Instruction)new SwapInstruction());
                SqlFlowAnalyser.this.addInstruction((Instruction)new SqlNumericBinaryInstruction(LongRangeBinOp.MINUS, (SqlExpression)o2));
            } else {
                SqlFlowAnalyser.this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor((SqlExpression)o2), 1));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        private final SqlExpression getOperand(SqlUnaryExpression expression) {
            SqlExpression sqlExpression;
            SqlExpression sqlExpression2 = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)expression), SqlExpression.class);
            if (sqlExpression2 != null) {
                SqlExpression $this$getOperand_u24lambda_u241 = sqlExpression2;
                boolean bl = false;
                sqlExpression = $this$getOperand_u24lambda_u241 instanceof SqlReferenceExpression ? (SqlExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)((PsiElement)$this$getOperand_u24lambda_u241), SqlExpression.class) : $this$getOperand_u24lambda_u241;
            } else {
                sqlExpression = null;
            }
            return sqlExpression;
        }

        public void visitSqlSelectStatement(@NotNull SqlSelectStatement o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlQueryExpression sqlQueryExpression = o2.getQueryExpression();
            this.acceptOrPushUnknown((SqlElement)(sqlQueryExpression != null ? (SqlExpression)sqlQueryExpression : (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlExpression.class)));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlUpdateStatement(@NotNull SqlUpdateStatement o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlDmlInstruction sqlDmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlDmlInstruction.class);
            if (sqlDmlInstruction != null) {
                SqlDmlInstruction it2 = sqlDmlInstruction;
                boolean bl = false;
                this.acceptSqlUpdateInstruction(it2);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlDeleteStatement(@NotNull SqlDeleteStatement o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlDmlInstruction sqlDmlInstruction = (SqlDmlInstruction)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlDmlInstruction.class);
            if (sqlDmlInstruction != null) {
                SqlDmlInstruction it2 = sqlDmlInstruction;
                boolean bl = false;
                this.acceptSqlDeleteInstruction(it2);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlInsertStatement(@NotNull SqlInsertStatement o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlInsertDmlInstruction sqlInsertDmlInstruction = o2.getDmlInstruction();
            if (sqlInsertDmlInstruction != null) {
                this.accept(sqlInsertDmlInstruction);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        private final void accept(SqlInsertDmlInstruction $this$accept) {
            Unit unit;
            SqlValuesExpression sqlValuesExpression;
            SqlFlowAnalyser.this.startElement((PsiElement)$this$accept);
            SqlExpression sqlExpression = $this$accept.getTargetExpression();
            if (sqlExpression != null) {
                sqlExpression.accept((SqlVisitor)this);
            }
            if ((sqlValuesExpression = $this$accept.getValuesExpression()) != null && (sqlValuesExpression = sqlValuesExpression.getExpressions()) != null) {
                Object object;
                Iterable $this$onEach$iv = (Iterable)sqlValuesExpression;
                boolean $i$f$onEach = false;
                Iterable $this$onEach_u24lambda_u2416$iv = object = $this$onEach$iv;
                boolean bl = false;
                for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                    SqlExpression it2 = (SqlExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept((SqlVisitor)this);
                }
                JBIterable jBIterable = (JBIterable)object;
                object = SqlFlowAnalyser.this;
                JBIterable $this$accept_u24lambda_u245 = jBIterable;
                boolean bl3 = false;
                ((SqlFlowAnalyser)((Object)object)).addInstruction((Instruction)new SqlInsertInstruction($this$accept, $this$accept_u24lambda_u245.size()));
                unit = Unit.INSTANCE;
            } else {
                SqlResultSetExpression sqlResultSetExpression = $this$accept.getResultSetExpression();
                if (sqlResultSetExpression != null) {
                    SqlResultSetExpression sqlResultSetExpression2;
                    SqlResultSetExpression it3 = sqlResultSetExpression2 = sqlResultSetExpression;
                    boolean bl = false;
                    it3.accept((SqlVisitor)this);
                    SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                    SqlResultSetExpression $this$accept_u24lambda_u247 = sqlResultSetExpression2;
                    boolean bl4 = false;
                    sqlFlowAnalyser.addInstruction((Instruction)new SqlInsertInstruction($this$accept, 1));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (unit == null) {
                SqlFlowAnalyser.this.addInstruction((Instruction)new SqlInsertInstruction($this$accept, 0));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)$this$accept);
        }

        private final void acceptSqlUpdateInstruction(SqlDmlInstruction o2) {
            SqlSetAssignment[] sqlSetAssignmentArray;
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlExpression sqlExpression = o2.getTargetExpression();
            if (sqlExpression != null) {
                sqlExpression.accept((SqlVisitor)this);
            }
            SqlWhereClause sqlWhereClause = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlWhereClause.class);
            if (sqlWhereClause != null) {
                sqlWhereClause.accept((SqlVisitor)this);
            }
            SqlSetClause setClause = (SqlSetClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlSetClause.class);
            SqlSetAssignment[] sqlSetAssignmentArray2 = (SqlSetAssignment[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)setClause), SqlSetAssignment.class);
            if (sqlSetAssignmentArray2 != null) {
                SqlSetAssignment[] sqlSetAssignmentArray3;
                for (SqlSetAssignment it2 : sqlSetAssignmentArray3 = sqlSetAssignmentArray2) {
                    boolean bl = false;
                    it2.accept((SqlVisitor)this);
                }
                sqlSetAssignmentArray = sqlSetAssignmentArray3;
            } else {
                sqlSetAssignmentArray = null;
            }
            SqlSetAssignment[] setAssignments = sqlSetAssignmentArray;
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUpdateInstruction(o2, setAssignments != null ? setAssignments.length : 0));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlSetAssignment(@NotNull SqlSetAssignment o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            o2.getLValue().accept((SqlVisitor)this);
            SqlElement sqlElement = o2.getRValue();
            if (sqlElement != null) {
                sqlElement.accept((SqlVisitor)this);
            }
            SqlFlowAnalyser.this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)SqlClauseAnchor.Companion.getAnchor((SqlClause)o2), o2.getRValue() != null ? 2 : 1));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        private final void acceptSqlDeleteInstruction(SqlDmlInstruction o2) {
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlExpression sqlExpression = o2.getTargetExpression();
            if (sqlExpression != null) {
                sqlExpression.accept((SqlVisitor)this);
            }
            SqlWhereClause sqlWhereClause = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlWhereClause.class);
            if (sqlWhereClause != null) {
                sqlWhereClause.accept((SqlVisitor)this);
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlReferenceExpression.class);
            if (sqlReferenceExpression != null) {
                SqlReferenceExpression sqlReferenceExpression2 = sqlReferenceExpression;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlReferenceExpression $this$acceptSqlDeleteInstruction_u24lambda_u249 = sqlReferenceExpression2;
                boolean bl = false;
                sqlFlowAnalyser.pop();
                sqlFlowAnalyser.push(SqlDfTypesKt.typedObject$default($this$acceptSqlDeleteInstruction_u24lambda_u249.getDasType(), sqlFlowAnalyser.getDialect(), null, 4, null), (SqlExpression)$this$acceptSqlDeleteInstruction_u24lambda_u249);
            }
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlDeleteInstruction(o2));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlDmlInstruction(@Nullable SqlDmlInstruction o2) {
            IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)o2));
            if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_INSERT_DML_INSTRUCTION)) {
                SqlInsertDmlInstruction sqlInsertDmlInstruction = o2 instanceof SqlInsertDmlInstruction ? (SqlInsertDmlInstruction)o2 : null;
                if (sqlInsertDmlInstruction != null) {
                    this.accept(sqlInsertDmlInstruction);
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_DELETE_DML_INSTRUCTION)) {
                SqlDmlInstruction sqlDmlInstruction = o2;
                if (sqlDmlInstruction == null) {
                    return;
                }
                this.acceptSqlDeleteInstruction(sqlDmlInstruction);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_UPDATE_DML_INSTRUCTION)) {
                SqlDmlInstruction sqlDmlInstruction = o2;
                if (sqlDmlInstruction == null) {
                    return;
                }
                this.acceptSqlUpdateInstruction(sqlDmlInstruction);
            }
        }

        public void visitSqlMergeStatement(@NotNull SqlMergeStatement o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            super.visitSqlMergeStatement(o2);
        }

        public void visitSqlExplicitTableExpression(@NotNull SqlExplicitTableExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            this.acceptOrPushUnknown((SqlElement)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlExpression.class));
        }

        public void visitSqlParenthesizedExpression(@NotNull SqlParenthesizedExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            List list = o2.getExpressionList();
            SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
            List $this$visitSqlParenthesizedExpression_u24lambda_u2411 = list;
            boolean bl = false;
            switch ($this$visitSqlParenthesizedExpression_u24lambda_u2411.size()) {
                case 0: {
                    sqlFlowAnalyser.pushUnknown();
                    break;
                }
                case 1: {
                    Intrinsics.checkNotNull((Object)$this$visitSqlParenthesizedExpression_u24lambda_u2411);
                    ((SqlExpression)CollectionsKt.first((List)$this$visitSqlParenthesizedExpression_u24lambda_u2411)).accept((SqlVisitor)this);
                    break;
                }
                default: {
                    if (!(o2.getDasType() instanceof SqlTableType)) {
                        sqlFlowAnalyser.pushUnknown();
                        return;
                    }
                    sqlFlowAnalyser.startElement((PsiElement)o2);
                    Intrinsics.checkNotNull((Object)$this$visitSqlParenthesizedExpression_u24lambda_u2411);
                    Iterable $this$forEach$iv = $this$visitSqlParenthesizedExpression_u24lambda_u2411;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl2 = false;
                        it2.accept((SqlVisitor)this);
                    }
                    sqlFlowAnalyser.addInstruction((Instruction)new SqlParenthesizeInstruction(o2, $this$visitSqlParenthesizedExpression_u24lambda_u2411.size()));
                    sqlFlowAnalyser.finishElement((PsiElement)o2);
                }
            }
        }

        public void visitSqlReferenceList(@NotNull SqlReferenceList o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            List list = o2.getReferenceList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getReferenceList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlReferenceExpression it2 = (SqlReferenceExpression)element$iv;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
            }
        }

        public void visitSqlWhereClause(@NotNull SqlWhereClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlExpression.class);
            if (sqlExpression != null) {
                SqlExpression sqlExpression2 = sqlExpression;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression it2 = sqlExpression2;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
                sqlFlowAnalyser.addInstruction((Instruction)new SqlFilteringInstruction((SqlClause)o2));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlCaseExpression(@NotNull SqlCaseExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            ControlFlow.DeferredOffset returnOffset = new ControlFlow.DeferredOffset();
            List list = o2.getBranches();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBranches(...)");
            List branches = list;
            boolean foundElse = false;
            for (IndexedValue item : CollectionsKt.withIndex((Iterable)branches)) {
                SqlClause branch = (SqlClause)item.getValue();
                if (branch instanceof SqlWhenThenClause) {
                    SqlThenClause thenClause;
                    ControlFlow.DeferredOffset skipThenOffset = new ControlFlow.DeferredOffset();
                    SqlWhenClause whenClause = ((SqlWhenThenClause)branch).getWhenClause();
                    if (whenClause != null) {
                        whenClause.accept((SqlVisitor)this);
                        SqlFlowAnalyser.this.addInstruction((Instruction)new ConditionalGotoInstruction((ControlFlow.ControlFlowOffset)skipThenOffset, (DfType)SqlDfTypesKt.getFALSE(), (PsiElement)whenClause));
                    }
                    if ((thenClause = ((SqlWhenThenClause)branch).getThenClause()) != null) {
                        SqlFlowAnalyser.this.addInstruction((Instruction)new FinishElementInstruction(null));
                        thenClause.accept((SqlVisitor)this);
                        SqlFlowAnalyser.this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)returnOffset));
                    } else {
                        SqlFlowAnalyser.this.pushUnknown();
                    }
                    skipThenOffset.setOffset(SqlFlowAnalyser.this.getInstructionCount());
                    continue;
                }
                if (!(branch instanceof SqlElseClause)) continue;
                foundElse = true;
                SqlFlowAnalyser.this.addInstruction((Instruction)new FinishElementInstruction(null));
                branch.accept((SqlVisitor)this);
                SqlFlowAnalyser.this.addInstruction((Instruction)new GotoInstruction((ControlFlow.ControlFlowOffset)returnOffset));
            }
            if (!foundElse) {
                SqlFlowAnalyser.this.pushUnknown();
            }
            returnOffset.setOffset(SqlFlowAnalyser.this.getInstructionCount());
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlFromClause(@NotNull SqlFromClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            this.acceptOrPushUnknown((SqlElement)o2.getFromExpression());
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlFunctionCallExpression(@NotNull SqlFunctionCallExpression o2) {
            SqlFunctionCallInstruction sqlFunctionCallInstruction;
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            Object object = o2.getParameterList();
            if (object != null && (object = object.getExpressionList()) != null) {
                Object $this$visitSqlFunctionCallExpression_u24lambda_u2415 = object;
                boolean bl = false;
                Iterable $this$forEach$iv = (Iterable)$this$visitSqlFunctionCallExpression_u24lambda_u2415;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlExpression it2 = (SqlExpression)element$iv;
                    boolean bl2 = false;
                    it2.accept((SqlVisitor)this);
                }
                sqlFunctionCallInstruction = new SqlFunctionCallInstruction(o2, $this$visitSqlFunctionCallExpression_u24lambda_u2415.size());
            } else {
                sqlFunctionCallInstruction = new SqlFunctionCallInstruction(o2, 0);
            }
            SqlFunctionCallInstruction instruction2 = sqlFunctionCallInstruction;
            SqlFlowAnalyser.this.addInstruction((Instruction)instruction2);
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlHavingClause(@NotNull SqlHavingClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlExpression sqlExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlExpression.class);
            if (sqlExpression != null) {
                SqlExpression sqlExpression2 = sqlExpression;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression $this$visitSqlHavingClause_u24lambda_u2416 = sqlExpression2;
                boolean bl = false;
                $this$visitSqlHavingClause_u24lambda_u2416.accept((SqlVisitor)this);
                sqlFlowAnalyser.addInstruction((Instruction)new SqlFilteringInstruction((SqlClause)o2));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlLiteralExpression(@NotNull SqlLiteralExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlFlowAnalyser.this.push(SqlDfaPsiUtilKt.fromLiteral(o2, SqlFlowAnalyser.this.getDialect()), (SqlExpression)o2);
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlBinaryExpression(@NotNull SqlBinaryExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            PsiElement opElement = o2.getOpSignElement();
            IElementType op = o2.getOpSign();
            if (opElement == null || op == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o2);
                return;
            }
            JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)o2).expandAndFilter(arg_0 -> Visitor.visitSqlBinaryExpression$lambda$17(visitSqlBinaryExpression.traversed.1.INSTANCE, arg_0))).expandAndFilter(arg_0 -> Visitor.visitSqlBinaryExpression$lambda$18((Function1)new Function1<PsiElement, Boolean>(op){
                final /* synthetic */ IElementType $op;
                {
                    this.$op = $op;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(PsiElement it2) {
                    Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlBinaryExpression");
                    return Intrinsics.areEqual((Object)((SqlBinaryExpression)it2).getOpSign(), (Object)this.$op);
                }
            }, arg_0))).filter(SqlBinaryExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            JBIterable traversed2 = jBIterable;
            SqlBinaryExpression sqlBinaryExpression = (SqlBinaryExpression)traversed2.last();
            JBIterable jBIterable2 = traversed2.map(arg_0 -> Visitor.visitSqlBinaryExpression$lambda$19(visitSqlBinaryExpression.operands.1.INSTANCE, arg_0)).append(sqlBinaryExpression != null ? sqlBinaryExpression.getLOperand() : null).filterNotNull();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filterNotNull(...)");
            List operands2 = CollectionsKt.reversed((Iterable)((Iterable)jBIterable2));
            if (operands2.size() <= 1) {
                SqlFlowAnalyser.this.pushUnknown();
            } else {
                this.generateBinOpChain(op, opElement, operands2, CollectionsKt.reversed((Iterable)((Iterable)traversed2)));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        private final void generateBinOpChain(IElementType op, PsiElement opElement, List<? extends SqlExpression> operands2, List<? extends SqlBinaryExpression> expressionChain) {
            SqlExpression sqlExpression;
            SqlExpression it2 = sqlExpression = operands2.get(0);
            boolean bl = false;
            it2.accept((SqlVisitor)this);
            SqlExpression lExpr = sqlExpression;
            DasType dasType = lExpr.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasTypeCategory lType = DasTypeUtilsKt.getCategoryOrUnknown(dasType);
            int n = operands2.size();
            for (int i2 = 1; i2 < n; ++i2) {
                SqlExpression sqlExpression2;
                SqlExpression it3 = sqlExpression2 = operands2.get(i2);
                boolean bl2 = false;
                it3.accept((SqlVisitor)this);
                SqlExpression rExpr = sqlExpression2;
                DasType dasType2 = rExpr.getDasType();
                Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"getDasType(...)");
                DasTypeCategory rType = DasTypeUtilsKt.getCategoryOrUnknown(dasType2);
                SqlBinaryExpression expression = expressionChain.get(i2 - 1);
                DasTypeCategory resType = SqlTypeConversionUtilKt.calcTypeForBinaryExpression(lType, rType, op, SqlFlowAnalyser.this.getDialect());
                this.generateBinOp(expression, op, opElement, resType);
                lType = resType;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isAssignment(SqlBinaryExpression expression, IElementType op) {
            if (!SqlFlowAnalyser.this.getDialect().getDbms().isMicrosoft()) return false;
            if (!Intrinsics.areEqual((Object)op, (Object)SqlCommonTokens.SQL_OP_EQ)) return false;
            SqlExpression sqlExpression = expression.getLOperand();
            if (!(sqlExpression instanceof SqlReferenceExpression)) return false;
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
            Object object = sqlReferenceExpression;
            if (sqlReferenceExpression == null) return false;
            String string = object.getName();
            object = string;
            if (string == null) return false;
            if (!StringsKt.startsWith$default((String)object, (String)"@", (boolean)false, (int)2, null)) return false;
            return true;
        }

        private final void generateBinOp(SqlBinaryExpression expression, IElementType op, PsiElement opElement, DasTypeCategory resType) {
            ExpressionPushingInstruction expressionPushingInstruction;
            if (resType == DasTypeCategory.STRING && SqlPsiUtilKt.isStringConcat(op, SqlFlowAnalyser.this.dbms)) {
                expressionPushingInstruction = new SqlStringConcatInstruction(expression);
            } else if (resType == DasTypeCategory.BOOLEAN) {
                SqlBinaryInstruction sqlBinaryInstruction;
                if (SqlPsiUtilKt.isLogicalAnd(op) || SqlPsiUtilKt.isBitwiseAnd(op, SqlFlowAnalyser.this.dbms)) {
                    sqlBinaryInstruction = new SqlBooleanAndOrInstruction(expression, false);
                } else if (SqlPsiUtilKt.isLogicalOr(op) || SqlPsiUtilKt.isBitwiseOr(op, SqlFlowAnalyser.this.dbms)) {
                    sqlBinaryInstruction = new SqlBooleanAndOrInstruction(expression, true);
                } else if (SqlPsiUtilKt.isLogicalXor(op, SqlFlowAnalyser.this.dbms) || SqlPsiUtilKt.isBitwiseXor(op, SqlFlowAnalyser.this.dbms)) {
                    sqlBinaryInstruction = new SqlBooleanXorInstruction(expression);
                } else if (Intrinsics.areEqual((Object)op, (Object)SqlCommonKeywords.SQL_LIKE)) {
                    sqlBinaryInstruction = new SqlBooleanLikeInstruction(expression, expression.isNot());
                } else if (Intrinsics.areEqual((Object)op, (Object)SqlCommonKeywords.SQL_IN)) {
                    sqlBinaryInstruction = new SqlBooleanInInstruction(expression, expression.isNot());
                } else if (Intrinsics.areEqual((Object)op, (Object)SqlCommonKeywords.SQL_IS)) {
                    RelationType rel = SqlDfaPsiUtilKt.getRelationForIsExpression(expression, opElement);
                    sqlBinaryInstruction = new SqlBooleanRelationInstruction(expression, rel);
                } else if (this.isAssignment(expression, op)) {
                    sqlBinaryInstruction = SqlBooleanBinaryInstruction.Companion.unknown(expression);
                } else {
                    RelationType relationType = SqlDfaPsiUtilKt.getRelationByToken(op, SqlFlowAnalyser.this.dbms);
                    if (relationType != null) {
                        IElementType suffix2;
                        RelationType $this$generateBinOp_u24lambda_u2422 = relationType;
                        boolean bl = false;
                        IElementType iElementType = suffix2 = PsiTreeUtilKt.getElementType((PsiElement)opElement) instanceof SqlCompositeElementType ? (opElement.getChildren().length == 2 ? PsiTreeUtilKt.getElementType((PsiElement)opElement.getLastChild()) : null) : PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtilKt.nextLeaf((PsiElement)opElement, (Function1)generateBinOp.instruction.1.suffix.1.INSTANCE));
                        sqlBinaryInstruction = Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_ALL) ? (SqlBooleanBinaryInstruction)new SqlBooleanAllAnyInstruction(expression, $this$generateBinOp_u24lambda_u2422, true) : ((Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_ANY) ? true : Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_SOME)) ? (SqlBooleanBinaryInstruction)new SqlBooleanAllAnyInstruction(expression, $this$generateBinOp_u24lambda_u2422, false) : (SqlBooleanBinaryInstruction)new SqlBooleanRelationInstruction(expression, $this$generateBinOp_u24lambda_u2422));
                    } else {
                        sqlBinaryInstruction = SqlBooleanBinaryInstruction.Companion.unknown(expression);
                    }
                }
                expressionPushingInstruction = sqlBinaryInstruction;
            } else {
                expressionPushingInstruction = resType == DasTypeCategory.INTEGER || resType == DasTypeCategory.REAL ? (ExpressionPushingInstruction)new SqlNumericBinaryInstruction(SqlPsiRangeSetUtilKt.binOpFromToken(op, SqlFlowAnalyser.this.dbms), (SqlExpression)expression) : (ExpressionPushingInstruction)new EvalUnknownInstruction((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor((SqlExpression)expression), 2);
            }
            ExpressionPushingInstruction instruction2 = expressionPushingInstruction;
            SqlFlowAnalyser.this.addInstruction((Instruction)instruction2);
        }

        public void visitSqlQueryExpression(@NotNull SqlQueryExpression o2) {
            SqlLimitClause it2;
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlTableExpression sqlTableExpression = o2.getTableExpression();
            if (sqlTableExpression != null) {
                sqlTableExpression.accept((SqlVisitor)this);
            }
            SqlSelectClause sqlSelectClause = o2.getSelectClause();
            if (sqlSelectClause != null) {
                sqlSelectClause.accept((SqlVisitor)this);
            }
            SqlOrderByClause sqlOrderByClause = (SqlOrderByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlOrderByClause.class);
            if (sqlOrderByClause != null) {
                sqlOrderByClause.accept((SqlVisitor)this);
            }
            JBIterable jBIterable = o2.getLimitClauses();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getLimitClauses(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (SqlLimitClause)element$iv;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
            }
            JBIterable jBIterable2 = o2.getOffsetClauses();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"getOffsetClauses(...)");
            $this$forEach$iv = (Iterable)jBIterable2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it2 = (SqlOffsetClause)element$iv;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlWithQueryExpression(@NotNull SqlWithQueryExpression o2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                JBIterable jBIterable = o2.getWithClause().getQueryDefinitions();
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getQueryDefinitions(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlAsExpression it2 = (SqlAsExpression)element$iv;
                    boolean bl = false;
                    it2.accept((SqlVisitor)this);
                }
                SqlExpression sqlExpression = o2.getExpression();
                if (sqlExpression == null) break block1;
                sqlExpression.accept((SqlVisitor)this);
            }
        }

        public void visitSqlIntersectExpression(@NotNull SqlIntersectExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            this.acceptNAryExpression((SqlNAryExpression)o2);
        }

        public void visitSqlGroupByClause(@NotNull SqlGroupByClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)o2), SqlExpression.class);
            if (sqlExpressionArray != null) {
                SqlExpression[] sqlExpressionArray2 = sqlExpressionArray;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression[] $this$visitSqlGroupByClause_u24lambda_u2427 = sqlExpressionArray2;
                boolean bl = false;
                SqlExpression[] $this$forEach$iv = $this$visitSqlGroupByClause_u24lambda_u2427;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    SqlExpression element$iv;
                    SqlExpression it2 = element$iv = $this$forEach$iv[j];
                    boolean bl2 = false;
                    it2.accept((SqlVisitor)this);
                }
                sqlFlowAnalyser.addInstruction((Instruction)new SqlGroupByInstruction(o2, $this$visitSqlGroupByClause_u24lambda_u2427.length));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlUnionExpression(@NotNull SqlUnionExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            this.acceptNAryExpression((SqlNAryExpression)o2);
        }

        private final void acceptNAryExpression(SqlNAryExpression o2) {
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            List list = o2.getOperands();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOperands(...)");
            List operands2 = list;
            ((SqlExpression)CollectionsKt.first((List)operands2)).accept((SqlVisitor)this);
            int n = operands2.size();
            for (int i2 = 1; i2 < n; ++i2) {
                ((SqlExpression)operands2.get(i2)).accept((SqlVisitor)this);
                PsiElement op = o2.getOpSignElement(i2 - 1);
                SqlNAryExpressionPartAnchor anchor2 = new SqlNAryExpressionPartAnchor(o2, i2);
                IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)op);
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_UNION)) {
                    PsiElement psiElement = op;
                    Intrinsics.checkNotNull((Object)psiElement);
                    if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)PsiTreeUtilKt.nextLeaf((PsiElement)psiElement, (Function1)acceptNAryExpression.1.INSTANCE)), (Object)SqlCommonKeywords.SQL_ALL)) {
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor2, SqlDfaUnionType.UNION_ALL));
                        continue;
                    }
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor2, SqlDfaUnionType.UNION_DISTINCT));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_EXCEPT)) {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor2, SqlDfaUnionType.EXCEPT));
                    continue;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonKeywords.SQL_INTERSECT)) {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlUnionInstruction(anchor2, SqlDfaUnionType.INTERSECT));
                    continue;
                }
                new EvalUnknownInstruction((DfaAnchor)anchor2, 2);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlExpression(@NotNull SqlExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlFlowAnalyser.this.pushUnknown();
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlReferenceExpression(@NotNull SqlReferenceExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlReferenceAccessInstruction(o2, SqlFlowAnalyser.this.getDialect()));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlWhenClause(@NotNull SqlWhenClause o2) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
                SqlExpression sqlExpression = o2.getExpression();
                if (sqlExpression == null) break block0;
                sqlExpression.accept((SqlVisitor)this);
            }
        }

        public void visitSqlThenClause(@NotNull SqlThenClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            JBIterable jBIterable = o2.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getBody(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlElement it2 = (SqlElement)element$iv;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
            }
        }

        public void visitSqlElseClause(@NotNull SqlElseClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            JBIterable jBIterable = o2.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getBody(...)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlCompositeElement it2 = (SqlCompositeElement)element$iv;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
            }
        }

        public void visitSqlSelectClause(@NotNull SqlSelectClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            List list = o2.getExpressions();
            SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
            List $this$visitSqlSelectClause_u24lambda_u2431 = list;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$visitSqlSelectClause_u24lambda_u2431);
            Iterable $this$forEach$iv = $this$visitSqlSelectClause_u24lambda_u2431;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlExpression it2 = (SqlExpression)element$iv;
                boolean bl2 = false;
                it2.accept((SqlVisitor)this);
            }
            sqlFlowAnalyser.addInstruction((Instruction)new SqlSelectInstruction(o2, $this$visitSqlSelectClause_u24lambda_u2431.size()));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlExpressionList(@NotNull SqlExpressionList o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            List list = o2.getExpressionList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressionList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlExpression it2 = (SqlExpression)element$iv;
                boolean bl = false;
                it2.accept((SqlVisitor)this);
            }
        }

        public void visitSqlOrderByClause(@NotNull SqlOrderByClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlExpression[] sqlExpressionArray = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)o2), SqlExpression.class);
            if (sqlExpressionArray != null) {
                SqlExpression[] sqlExpressionArray2 = sqlExpressionArray;
                SqlFlowAnalyser sqlFlowAnalyser = SqlFlowAnalyser.this;
                SqlExpression[] $this$visitSqlOrderByClause_u24lambda_u2434 = sqlExpressionArray2;
                boolean bl = false;
                SqlExpression[] $this$forEach$iv = $this$visitSqlOrderByClause_u24lambda_u2434;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    SqlExpression element$iv;
                    SqlExpression it2 = element$iv = $this$forEach$iv[j];
                    boolean bl2 = false;
                    it2.accept((SqlVisitor)this);
                }
                sqlFlowAnalyser.addInstruction((Instruction)new SqlOrderByInstruction((SqlClause)o2, $this$visitSqlOrderByClause_u24lambda_u2434.length));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlJoinExpression(@NotNull SqlJoinExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            if (this.isMssqlOuterApply(o2)) {
                this.visitMssqlOuterApply(o2);
                return;
            }
            PsiElement psiElement = this.getOpSignElementSafe(o2);
            IElementType op = psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null;
            SqlExpression sqlExpression = o2.getLOperand();
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
            SqlExpression lOperand = sqlExpression;
            SqlExpression rOperand = o2.getROperand();
            SqlDfaJoinType joinType = SqlDfaJoinType.Companion.fromToken(op);
            if (joinType == null || rOperand == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o2);
                return;
            }
            lOperand.accept((SqlVisitor)this);
            rOperand.accept((SqlVisitor)this);
            switch (WhenMappings.$EnumSwitchMapping$0[joinType.ordinal()]) {
                case 1: {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlCrossJoinInstruction(o2));
                    break;
                }
                case 2: {
                    SqlFlowAnalyser.this.addInstruction((Instruction)new SqlNaturalJoinInstruction(o2));
                    break;
                }
                default: {
                    SqlClause conditionClause = (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)o2), SqlClause.class);
                    if (conditionClause instanceof SqlJoinConditionClause) {
                        this.acceptOrPushUnknown((SqlElement)((SqlJoinConditionClause)conditionClause).getExpression());
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlJoinByConditionInstruction(o2, joinType));
                        break;
                    }
                    if (conditionClause instanceof SqlUsingClause) {
                        int n;
                        SqlReferenceList sqlReferenceList = ((SqlUsingClause)conditionClause).getReferenceList();
                        if (sqlReferenceList != null) {
                            SqlReferenceList references = sqlReferenceList;
                            boolean bl = false;
                            List refList = references.getReferenceList();
                            Intrinsics.checkNotNull((Object)refList);
                            Iterable $this$forEach$iv = refList;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                SqlReferenceExpression it2 = (SqlReferenceExpression)element$iv;
                                boolean bl2 = false;
                                it2.accept((SqlVisitor)this);
                            }
                            n = refList.size();
                        } else {
                            n = 0;
                        }
                        int args2 = n;
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlJoinByUsingInstruction(o2, joinType, args2));
                        break;
                    }
                    if (conditionClause == null && joinType == SqlDfaJoinType.INNER && SqlFlowAnalyser.this.dbms.isMysql()) {
                        SqlFlowAnalyser.this.addInstruction((Instruction)new SqlCrossJoinInstruction(o2));
                        break;
                    }
                    SqlFlowAnalyser.this.addInstruction((Instruction)new EvalUnknownInstruction((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor((SqlExpression)o2), 2));
                }
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        private final boolean isMssqlOuterApply(SqlJoinExpression o2) {
            if (!SqlFlowAnalyser.this.getDialect().getDbms().in(Dbms.MSSQL_LIKE)) {
                return false;
            }
            PsiElement psiElement = this.getOpSignElementSafe(o2);
            if (psiElement == null) {
                return false;
            }
            PsiElement opSign = psiElement;
            PsiElement psiElement2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)opSign);
            if (psiElement2 == null) {
                return false;
            }
            PsiElement sibling = psiElement2;
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)opSign), (Object)SqlCommonKeywords.SQL_OUTER) && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)sibling), (Object)SqlCommonKeywords.SQL_APPLY);
        }

        private final void visitMssqlOuterApply(SqlJoinExpression o2) {
            SqlExpression sqlExpression = o2.getLOperand();
            Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
            SqlExpression lOperand = sqlExpression;
            SqlExpression rOperand = o2.getROperand();
            if (rOperand == null) {
                SqlFlowAnalyser.this.pushUnknown();
                SqlFlowAnalyser.this.finishElement((PsiElement)o2);
                return;
            }
            lOperand.accept((SqlVisitor)this);
            rOperand.accept((SqlVisitor)this);
            SqlFlowAnalyser.this.pushUnknown();
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlJoinByConditionInstruction(o2, SqlDfaJoinType.LEFT));
        }

        private final PsiElement getOpSignElementSafe(SqlJoinExpression $this$getOpSignElementSafe) {
            for (ASTNode child = $this$getOpSignElementSafe.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
                IElementType type2;
                Intrinsics.checkNotNullExpressionValue((Object)child.getElementType(), (String)"getElementType(...)");
                if (!(type2 instanceof SqlKeywordTokenType) && type2 != SqlCommonTokens.SQL_COMMA) continue;
                return child.getPsi();
            }
            return null;
        }

        public void visitSqlAsExpression(@NotNull SqlAsExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            this.acceptOrPushUnknown((SqlElement)o2.getExpression());
            if (o2.getDasType() instanceof SqlTableType) {
                SqlFlowAnalyser.this.addInstruction((Instruction)new SqlAssignAliasInstruction(o2));
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlTableExpression(@NotNull SqlTableExpression o2) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            if (Intrinsics.areEqual((Object)o2.getText(), (Object)"")) {
                return;
            }
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            SqlFromClause sqlFromClause = o2.getFromClause();
            if (sqlFromClause != null) {
                sqlFromClause.accept((SqlVisitor)this);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                SqlFlowAnalyser.this.createEmptyTable(o2);
            }
            SqlWhereClause sqlWhereClause = o2.getWhereClause();
            if (sqlWhereClause != null) {
                sqlWhereClause.accept((SqlVisitor)this);
            }
            SqlGroupByClause sqlGroupByClause = o2.getGroupByClause();
            if (sqlGroupByClause != null) {
                sqlGroupByClause.accept((SqlVisitor)this);
            }
            SqlHavingClause sqlHavingClause = o2.getHavingClause();
            if (sqlHavingClause != null) {
                sqlHavingClause.accept((SqlVisitor)this);
            }
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlBetweenExpression(@NotNull SqlBetweenExpression o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            o2.getSubject().accept((SqlVisitor)this);
            this.acceptOrPushUnknown((SqlElement)o2.getLowerBound());
            this.acceptOrPushUnknown((SqlElement)o2.getUpperBound());
            PsiElement psiElement = o2.getOperation();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOperation(...)");
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlBetweenInstruction(o2, SqlPsiUtilKt.isNegateOperation(psiElement)));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlLimitClause(@NotNull SqlLimitClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            this.acceptOrPushUnknown((SqlElement)o2.getRowCountExpression());
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlLimitInstruction(o2));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        public void visitSqlOffsetClause(@NotNull SqlOffsetClause o2) {
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o");
            SqlFlowAnalyser.this.startElement((PsiElement)o2);
            this.acceptOrPushUnknown((SqlElement)o2.getOffsetExpression());
            SqlFlowAnalyser.this.addInstruction((Instruction)new SqlOffsetInstruction(o2));
            SqlFlowAnalyser.this.finishElement((PsiElement)o2);
        }

        private static final boolean visitSqlBinaryExpression$lambda$17(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean visitSqlBinaryExpression$lambda$18(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final SqlExpression visitSqlBinaryExpression$lambda$19(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (SqlExpression)$tmp0.invoke(p0);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SqlDfaJoinType.values().length];
                try {
                    nArray[SqlDfaJoinType.CROSS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SqlDfaJoinType.NATURAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

