/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001b\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/editor/SqlPasteProvider;", "Lcom/intellij/ide/PasteProvider;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getElementsToPaste", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/actionSystem/DataContext;)[Ljava/lang/Object;", "getSqlFile", "Lcom/intellij/sql/psi/SqlFile;", "isPasteEnabled", "", "isPastePossible", "performPaste", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlPasteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlPasteProvider.kt\ncom/intellij/sql/editor/SqlPasteProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,98:1\n12271#2,2:99\n*S KotlinDebug\n*F\n+ 1 SqlPasteProvider.kt\ncom/intellij/sql/editor/SqlPasteProvider\n*L\n92#1:99,2\n*E\n"})
public final class SqlPasteProvider
implements PasteProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getSqlFile(dataContext) != null && this.getElementsToPaste(dataContext) != null;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document doc = document;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        psiDocumentManager.commitDocument(doc);
        PsiFile psiFile = psiDocumentManager.getPsiFile(doc);
        SqlFile sqlFile = psiFile instanceof SqlFile ? (SqlFile)psiFile : null;
        if (sqlFile == null) {
            return;
        }
        SqlFile file = sqlFile;
        if (!FileModificationService.getInstance().prepareFileForWrite((PsiFile)file)) {
            return;
        }
        Object[] objectArray = this.getElementsToPaste(dataContext);
        if (objectArray == null) {
            return;
        }
        Object[] elementsToPaste = objectArray;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project2, dialect).withDialect(dialect.getDatabaseDialect());
        int n = elementsToPaste.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Object object;
            if (i2 > 0) {
                builder.symbol(",\n");
            }
            DbElement dbElement = (object = elementsToPaste[i2]) instanceof DbElement ? (DbElement)object : null;
            if (dbElement == null) {
                return;
            }
            DbElement target2 = dbElement;
            DbElement parent2 = target2.getDasParent();
            if (parent2 != null && dialect.canBeQualifier(parent2)) {
                SqlEditorOptions.QualificationType qualification;
                Intrinsics.checkNotNullExpressionValue((Object)DbSqlUtilCore.getQualificationByParentKind(parent2.getKind()).and(SqlEditorOptions.getInstance().getDragAndDropQualification()), (String)"and(...)");
                int candidateCount2 = target2.getDataSource().getNameIndex().getObjectsByNameInsensitive(target2.getName()).filter(arg_0 -> SqlPasteProvider.performPaste$lambda$0((Function1)new Function1<DasObject, Boolean>(target2){
                    final /* synthetic */ DbElement $target;
                    {
                        this.$target = $target;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(DasObject it2) {
                        return Intrinsics.areEqual((Object)it2.getKind(), (Object)this.$target.getKind());
                    }
                }, arg_0)).size();
                if (qualification.shouldQualify(candidateCount2)) {
                    builder.identifier(parent2, parent2.getName()).symbol(".");
                }
            }
            builder.identifier(target2);
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> SqlPasteProvider.performPaste$lambda$2(psiDocumentManager, doc, editor3, builder), SqlBundle.message((String)"SqlPasteProvider.command.name.pasting.database.object.references", (Object[])new Object[0]), null);
    }

    private final SqlFile getSqlFile(DataContext dataContext) {
        Editor editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor2 == null || (editor2 = editor2.getDocument()) == null) {
            return null;
        }
        Editor doc = editor2;
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile psiFile = psiDocumentManager.getPsiFile((Document)doc);
        return psiFile instanceof SqlFile ? (SqlFile)psiFile : null;
    }

    private final Object[] getElementsToPaste(DataContext dataContext) {
        Object[] objectArray;
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        if (producer == null) {
            return null;
        }
        Producer producer2 = producer;
        Transferable transferable = (Transferable)producer2.produce();
        if (transferable == null) {
            return null;
        }
        Transferable transferable2 = transferable;
        try {
            boolean bl;
            Object[] data;
            block6: {
                Object object = transferable2.getTransferData(DnDEventImpl.ourDataFlavor);
                Object[] objectArray2 = object instanceof Object[] ? (Object[])object : null;
                if (objectArray2 == null) {
                    return null;
                }
                Object[] $this$all$iv = data = objectArray2;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int j = 0; j < n; ++j) {
                    Object element$iv;
                    Object it2 = element$iv = $this$all$iv[j];
                    boolean bl2 = false;
                    if (it2 instanceof DasObject) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            objectArray = bl ? data : null;
        }
        catch (Exception ignored) {
            objectArray = null;
        }
        return objectArray;
    }

    private static final boolean performPaste$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void performPaste$lambda$2$lambda$1(PsiDocumentManager $psiDocumentManager, Document $doc, Editor $editor, DdlBuilder $builder) {
        Intrinsics.checkNotNullParameter((Object)$doc, (String)"$doc");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        $psiDocumentManager.doPostponedOperationsAndUnblockDocument($doc);
        $psiDocumentManager.commitDocument($doc);
        EditorModificationUtil.deleteSelectedText((Editor)$editor);
        EditorModificationUtil.insertStringAtCaret((Editor)$editor, (String)$builder.getStatement());
    }

    private static final void performPaste$lambda$2(PsiDocumentManager $psiDocumentManager, Document $doc, Editor $editor, DdlBuilder $builder) {
        Intrinsics.checkNotNullParameter((Object)$doc, (String)"$doc");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        ApplicationManager.getApplication().runWriteAction(() -> SqlPasteProvider.performPaste$lambda$2$lambda$1($psiDocumentManager, $doc, $editor, $builder));
    }
}

