/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.dialects.snowflake.SFlakeDialect;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\u0004*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/dialects/snowflake/refactoring/SFlakeExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "()V", "supportsTableFunctions", "", "getSupportsTableFunctions", "()Z", "isInjectedExpression", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "findAnchor", "element", "container", "findTopmostBlock", "generateBody", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "generateTableCallExpression", "intellij.database.dialects.snowflake"})
public final class SFlakeExtractFunctionHelper
extends SqlExtractFunctionHelper {
    @NotNull
    public static final SFlakeExtractFunctionHelper INSTANCE = new SFlakeExtractFunctionHelper();

    private SFlakeExtractFunctionHelper() {
    }

    private final boolean isInjectedExpression(PsiElement $this$isInjectedExpression) {
        PsiFile file = $this$isInjectedExpression.getContainingFile();
        return file instanceof SqlCodeFragment && Intrinsics.areEqual((Object)((SqlCodeFragment)file).getElementType(), (Object)SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION);
    }

    @Override
    public boolean getSupportsTableFunctions() {
        return true;
    }

    @Override
    @Nullable
    public PsiElement findTopmostBlock(@Nullable PsiElement element2) {
        PsiElement psiElement = element2;
        Object object = psiElement != null ? psiElement.getContainingFile() : null;
        if (object == null) {
            return null;
        }
        PsiFile containingFile = object;
        if (this.isInjectedExpression(element2)) {
            PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
            if (psiLanguageInjectionHost == null) {
                return null;
            }
            PsiLanguageInjectionHost host = psiLanguageInjectionHost;
            return SqlImplUtil.getSqlDialectSafe((PsiElement)host) instanceof SFlakeDialect ? this.findTopmostBlock((PsiElement)host) : null;
        }
        return (PsiElement)containingFile;
    }

    @Override
    @Nullable
    public PsiElement findAnchor(@NotNull PsiElement element2, @NotNull PsiElement container) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.isInjectedExpression(element2)) {
            return super.findAnchor(element2, container);
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)element2.getProject()).getInjectionHost(element2);
        if (psiLanguageInjectionHost == null) {
            return null;
        }
        PsiLanguageInjectionHost host = psiLanguageInjectionHost;
        return this.findAnchor((PsiElement)host, container);
    }

    @Override
    public void generateBody(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generateBody_u24lambda_u240 = builder;
        boolean bl = false;
        $this$generateBody_u24lambda_u240.keyword("as ");
        $this$generateBody_u24lambda_u240.symbol("'");
        if (functionInfo.getCodeInfo().isTableFunction() && !functionInfo.getCodeInfo().isQuery()) {
            $this$generateBody_u24lambda_u240.keyword("select ").symbol("*").keyword(" from ");
        }
        $this$generateBody_u24lambda_u240.plain(StringUtil.escapeChar((String)functionInfo.getSubstitutedExpression().getText(), (char)'\''));
        $this$generateBody_u24lambda_u240.symbol("'");
    }

    @Override
    protected void generateTableCallExpression(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        builder.keyword("table");
        builder.symbol("(");
        this.generateCallExpression(builder, functionInfo);
        builder.symbol(")");
    }
}

