/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgLexerBase
extends SqlLexer {
    public static final String OP_CHARS = "+-*/<>=~!@#%^&|`?";
    private static final Pattern DOLLAR_QUOTE = Pattern.compile("^(\\$\\w*\\$).*$");

    protected PgLexerBase(SqlLanguageDialectBase dialect, FlexLexer flexLexer) {
        super(dialect, flexLexer);
    }

    @Override
    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            PgLexerBase.$$$reportNull$$$0(0);
        }
        if (!(this.lookAheadRangeOperator(baseLexer) || this.lookAheadCustomQuotation(baseLexer) || this.lookAheadVariable(baseLexer) || this.lookAheadCustomOperator(baseLexer))) {
            super.lookAhead(baseLexer);
        }
    }

    protected boolean lookAheadVariable(Lexer baseLexer) {
        char nextChar;
        CharSequence text2 = baseLexer.getBufferSequence();
        int tokenStart = baseLexer.getTokenStart();
        int len = baseLexer.getBufferEnd();
        if (len > tokenStart + 1 && text2.charAt(tokenStart) == '$' && (nextChar = text2.charAt(tokenStart + 1)) >= '0' && nextChar <= '9') {
            char c2;
            int tokenEnd;
            for (tokenEnd = tokenStart + 2; tokenEnd < len && (c2 = text2.charAt(tokenEnd)) >= '0' && c2 <= '9'; ++tokenEnd) {
            }
            this.addToken(tokenEnd, (IElementType)SqlTokens.SQL_IDENT);
            baseLexer.start(text2, tokenEnd, baseLexer.getBufferEnd(), 0);
            return true;
        }
        return false;
    }

    private boolean lookAheadCustomOperator(Lexer baseLexer) {
        CharSequence bufferSequence = baseLexer.getBufferSequence();
        int tokenStart = baseLexer.getTokenStart();
        int tokenEnd = baseLexer.getTokenEnd();
        int bufferEnd = baseLexer.getBufferEnd();
        for (int i2 = tokenStart; i2 <= bufferEnd; ++i2) {
            int j;
            int idx;
            char ch = i2 < bufferEnd ? bufferSequence.charAt(i2) : (char)'\u0000';
            int n = idx = ch > '\u0000' ? OP_CHARS.indexOf(ch) : -1;
            if (idx != -1) continue;
            if (i2 == tokenStart) {
                return false;
            }
            String op = bufferSequence.subSequence(tokenStart, i2).toString();
            if (this.consumeCustomOperator(op, bufferSequence, baseLexer, tokenStart)) {
                return true;
            }
            int fix1 = op.indexOf("--");
            int fix2 = op.indexOf("/*");
            int p2 = Math.min(fix2 < 0 ? i2 : tokenStart + fix2, fix1 < 0 ? i2 : tokenStart + fix1);
            boolean qRemoved = op.charAt(op.length() - 1) == '?' && op.length() > 1 && op.charAt(op.length() - 2) != '?';
            int n3 = p2 = qRemoved ? p2 - 1 : p2;
            if (p2 == tokenEnd && baseLexer.getTokenType() != SqlTokens.SQL_IDENT) {
                return false;
            }
            boolean anychar = false;
            int oplen = p2 - tokenStart;
            for (j = 0; j < oplen; ++j) {
                char c2 = op.charAt(j);
                anychar |= OP_CHARS.indexOf(c2) >= 7;
            }
            j = p2;
            while (j - tokenStart >= 2) {
                oplen = j - tokenStart;
                boolean valid = anychar || op.charAt(oplen - 1) != '+' && op.charAt(oplen - 1) != '-';
                int offs = j;
                if (!valid && qRemoved) {
                    offs = p2 + 1;
                    valid = true;
                }
                if (valid) {
                    this.addToken(offs, (IElementType)SqlCommonTokens.PG_OP_CUSTOM);
                    baseLexer.start(bufferSequence, offs, bufferEnd, 0);
                    return true;
                }
                --j;
            }
            return false;
        }
        return false;
    }

    protected boolean consumeCustomOperator(@NotNull String op, @NotNull CharSequence bufferSequence, @NotNull Lexer baseLexer, int tokenStart) {
        if (op == null) {
            PgLexerBase.$$$reportNull$$$0(1);
        }
        if (bufferSequence == null) {
            PgLexerBase.$$$reportNull$$$0(2);
        }
        if (baseLexer == null) {
            PgLexerBase.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    @Nullable
    protected String getDollarQuotingIdent(@NotNull Lexer baseLexer) {
        IElementType tokenType;
        String identText;
        if (baseLexer == null) {
            PgLexerBase.$$$reportNull$$$0(4);
        }
        String string = identText = (tokenType = baseLexer.getTokenType()) == SqlTokens.SQL_IDENT_DELIMITED || tokenType == TokenType.BAD_CHARACTER ? baseLexer.getTokenText() : null;
        if (identText == null) {
            return null;
        }
        if (tokenType == TokenType.BAD_CHARACTER) {
            Matcher matcher = DOLLAR_QUOTE.matcher(identText);
            return matcher.lookingAt() ? matcher.group(1) : null;
        }
        int len = identText.length();
        return len >= 2 && identText.charAt(0) == '$' && identText.charAt(len - 1) == '$' ? identText : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bufferSequence";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/postgres/PgLexerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeCustomOperator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDollarQuotingIdent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

