/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportBuilder;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.postgres.PgBaseImportBuilder;
import com.intellij.sql.dialects.postgres.PgDateTimeLanguageHelper;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.refactoring.PgExtractVariableHelper;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateDomainStatement;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlFunctionCallExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedQueryDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessorBase;
import com.intellij.sql.psi.stubs.SqlFileElementType;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialectBase
extends SqlLanguageDialectBase {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData;

    @Nullable
    protected SqlExpression getQualifier(@NotNull PsiElement element2) {
        SqlReferenceExpression ref2;
        if (element2 == null) {
            PgDialectBase.$$$reportNull$$$0(0);
        }
        return (ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)element2, SqlReferenceExpression.class)) == null ? null : ref2.getQualifierExpression();
    }

    public static boolean inPl(PsiElement element2) {
        return SqlFileElementType.isInPl(element2);
    }

    public final ReservedEntity getNewTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias;
    }

    public final ReservedEntity getOldTableAlias() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias;
    }

    public final Map<String, ReservedEntity> getTriggerStringImplicits() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerStringImplicits;
    }

    public final ReservedEntity getTriggerNArgsColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerNArgsColumn;
    }

    public final ReservedEntity getTriggerArgVColumn() {
        return ((LazyInstanceData)this.myInstanceData.getValue()).myTriggerArgVColumn;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "dpn", "double precision", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "bigint", "bigint", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "numeric", "numeric", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "dp", "double precision", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "bytea", "bytea", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "name", "name", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "oid", "oid", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "gobject", "geometric object", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "circle", "circle", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "path", "path", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "box", "box", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "polygon", "polygon", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "lseg", "lseg", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "point", "point", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "line", "line", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "cidr", "cidr", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "inet", "inet", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "macaddr", "macaddr", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "tsvector", "tsvector", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "tsquery", "tsquery", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "trigger", "trigger", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "range", "range", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "int4range", "int4range", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "int4multirange", "int4multirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "int8range", "int8range", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "int8multirange", "int8multirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "numrange", "numrange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "nummultirange", "nummultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "tsrange", "tsrange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "tsmultirange", "tsmultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "tstzrange", "tstzrange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "tstzmultirange", "tstzmultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "daterange", "daterange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "datemultirange", "datemultirange", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "txid_snapshot", "txid_snapshot", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "void", "void", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "record", "record", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "enum", "enum", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "xml", "xml", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "float4", "float4", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "int2vector", "int2vector", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "json", "json", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "jsonb", "jsonb", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "jsonpath", "jsonpath", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "regclass", "regclass", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "regdictionary", "regdictionary", (SqlLanguageDialectEx)this);
    }

    protected PgDialectBase(@NotNull String id) {
        if (id == null) {
            PgDialectBase.$$$reportNull$$$0(1);
        }
        super(id);
        this.myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        BuiltinFunction definition2;
        SqlReferenceExpression ref2;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            PgDialectBase.$$$reportNull$$$0(3);
        }
        SqlExpression qualifier = (ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class)) == null ? null : ref2.getQualifierExpression();
        boolean isFunctionCall = place.getParent() instanceof SqlFunctionCallExpression;
        BuiltinFunction builtinFunction = definition2 = name2 == null || qualifier == null || isFunctionCall ? null : this.getSupportedFunctions().get(name2);
        if (definition2 != null) {
            for (BuiltinFunction.Prototype prototype : definition2.getPrototypes()) {
                DasType type2;
                if (prototype.getParams().length != 1 || processor2.executeTarget((DasSymbol)definition2, type2 = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType(prototype, ref2, (PsiElement)qualifier, (PsiElement)ref2), null, ResolveState.initial())) continue;
                return false;
            }
        }
        DasTypeSystemBase typeSystem = this.getTypeSystem();
        if (PgDialectBase.inPl(place) && this.getQualifier(place) == null) {
            if (SqlImplUtil.equalsInsensitiveOrTrue(((LazyInstanceData)this.myInstanceData.getValue()).myFoundColumn.name, name2, resolve2) && !processor2.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).myFoundColumn, typeSystem.getBooleanType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue(((LazyInstanceData)this.myInstanceData.getValue()).mySqlStateColumn.name, name2, resolve2) && !processor2.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).mySqlStateColumn, typeSystem.getIntType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (SqlImplUtil.equalsInsensitiveOrTrue(((LazyInstanceData)this.myInstanceData.getValue()).mySqlErrmColumn.name, name2, resolve2) && !processor2.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).mySqlErrmColumn, typeSystem.getStringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        return !PgDialectBase.inIndexExpression(place) && !PgDialectBase.inDomainCheck(place) || processor2.executeTarget((DasSymbol)((LazyInstanceData)this.myInstanceData.getValue()).myValueColumn, DasTypeSystemBase.UNKNOWN, Boolean.valueOf(false), ResolveState.initial());
    }

    private static boolean inIndexExpression(@NotNull PsiElement place) {
        SqlReferenceList refList;
        SqlOnTargetClauseImpl onTargetClause;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(4);
        }
        return (onTargetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.getParentOfType((PsiElement)(refList = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)place, SqlReferenceList.class)), SqlOnTargetClauseImpl.class)) != null && onTargetClause.getParent() instanceof SqlCreateIndexStatement;
    }

    private static boolean inDomainCheck(@NotNull PsiElement place) {
        SqlConstraintDefinition constraint;
        if (place == null) {
            PgDialectBase.$$$reportNull$$$0(5);
        }
        return (constraint = (SqlConstraintDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, SqlConstraintDefinition.class)) != null && constraint.getKind() == ObjectKind.CHECK && constraint.getParent() instanceof SqlCreateDomainStatement;
    }

    private static boolean raiseStatement(@NotNull PsiElement element2) {
        SqlStatement statement2;
        if (element2 == null) {
            PgDialectBase.$$$reportNull$$$0(6);
        }
        return (statement2 = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlStatement.class)) != null && statement2.getNode().getElementType() == PgElementTypes.Misc.PG_RAISE_STATEMENT;
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiReference ref2) {
        if (processor2 == null) {
            PgDialectBase.$$$reportNull$$$0(7);
        }
        if (state == null) {
            PgDialectBase.$$$reportNull$$$0(8);
        }
        if (ref2 == null) {
            PgDialectBase.$$$reportNull$$$0(9);
        }
        PsiElement place = ref2.getElement();
        if (processor2.isExpected(ObjectKind.ROUTINE)) {
            List exprs;
            SqlFunctionCallExpression callExpression = (SqlFunctionCallExpression)ObjectUtils.tryCast((Object)place.getParent(), SqlFunctionCallExpression.class);
            SqlExpressionList params2 = callExpression == null ? null : callExpression.getParameterList();
            List list = exprs = params2 == null ? Collections.emptyList() : params2.getExpressionList();
            if (exprs.size() == 1) {
                SqlTableType type2 = (SqlTableType)ObjectUtils.tryCast((Object)((SqlExpression)exprs.get(0)).getDasType(), SqlTableType.class);
                if (type2 == null) {
                    return true;
                }
                Set expected = processor2.getInitialExpectedTypes();
                processor2.setExpectedKinds(Collections.singleton(ObjectKind.COLUMN));
                boolean res2 = SqlImplUtil.processDeclarationsInType(type2, processor2, state, place);
                processor2.setExpectedKinds(expected);
                if (!res2) {
                    return false;
                }
            }
        }
        return super.processUnqualifiedResolve(processor2, state, ref2);
    }

    @Override
    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull SqlReference ref2, @NotNull SqlExpression qualifier) {
        DasSymbol qualifierSymbol;
        if (processor2 == null) {
            PgDialectBase.$$$reportNull$$$0(10);
        }
        if (state == null) {
            PgDialectBase.$$$reportNull$$$0(11);
        }
        if (ref2 == null) {
            PgDialectBase.$$$reportNull$$$0(12);
        }
        if (qualifier == null) {
            PgDialectBase.$$$reportNull$$$0(13);
        }
        if (SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.COLUMN, ObjectKind.VARIABLE) && qualifier instanceof SqlReferenceExpression && ((qualifierSymbol = ((SqlReferenceExpression)qualifier).resolveSymbol()) == ((LazyInstanceData)this.myInstanceData.getValue()).myOldTableAlias || qualifierSymbol == ((LazyInstanceData)this.myInstanceData.getValue()).myNewTableAlias)) {
            return processor2.executeTarget(DasSymbolUtil.getInlineSymbol(ref2), null, Boolean.valueOf(false), state);
        }
        if (!processor2.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (processor2.getReferenceName() == null && qualifier.getDasType() == DasTypeSystemBase.UNKNOWN) {
            return true;
        }
        if (DasTypeUtilsKt.getCategory(qualifier.getDasType()) == DasTypeCategory.RECORD) {
            return processor2.executeTarget(DasSymbolUtil.getInlineSymbol(ref2), DasTypeSystemBase.UNKNOWN, Boolean.valueOf(false), state);
        }
        SqlScopeProcessorBase filteringProcessor = PgDialectBase.filterSingleArgumentRoutines(processor2);
        SqlReferenceImpl refImpl = (SqlReferenceImpl)ObjectUtils.tryCast((Object)ref2, SqlReferenceImpl.class);
        if (refImpl != null && !refImpl.processUnqualifiedResolveVariants(filteringProcessor, ResolveState.initial())) {
            return false;
        }
        return super.processQualifiedResolve(processor2, state, ref2, qualifier);
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type2) {
        if (type2 == ObjectKind.COLUMN) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return super.getParentDbTypes(result2, type2);
    }

    @Override
    @NotNull
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        PgDateTimeLanguageHelper pgDateTimeLanguageHelper = PgDateTimeLanguageHelper.INSTANCE;
        if (pgDateTimeLanguageHelper == null) {
            PgDialectBase.$$$reportNull$$$0(14);
        }
        return pgDateTimeLanguageHelper;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type2, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            PgDialectBase.$$$reportNull$$$0(15);
        }
        if (strict) {
            return false;
        }
        if (type2 == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.VARIABLE)) {
            return true;
        }
        if (type2 == ObjectKind.AGGREGATE && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        if (ModelConsts.TABLE_OR_VIEW_KINDS.contains(type2) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            DasObject o2;
            DasObject dasObject = o2 = symbol != null ? symbol.getDasObject() : null;
            if (place == null || !(o2 instanceof PsiObject) || !PsiTreeUtil.isContextAncestor((PsiElement)((PsiObject)o2), (PsiElement)place, (boolean)true)) {
                return true;
            }
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) && type2 == ObjectKind.ROUTINE) {
            if (place instanceof SqlReferenceExpression) {
                return ((SqlReferenceExpression)place).getQualifierExpression() != null;
            }
            return true;
        }
        if (expectedTypes.contains(ObjectKind.COLUMN) || expectedTypes.contains(SqlDbElementType.ANY)) {
            boolean isTable = false;
            if (type2 == SqlDbElementType.LOCAL_ALIAS) {
                if (symbol == null) {
                    isTable = true;
                } else if (symbol instanceof SqlNamedQueryDefinitionImpl) {
                    isTable = true;
                } else if (symbol instanceof SqlAsExpression) {
                    SqlAsExpression alias = (SqlAsExpression)symbol;
                    if (!this.getDbms().isRedshift() || !(alias.getDasType() instanceof SqlTableType)) {
                        PsiElement parent2 = alias.getParent();
                        isTable = parent2 instanceof SqlFromClause || parent2 instanceof SqlJoinExpression;
                    }
                }
            } else if (type2 == ObjectKind.TABLE && !this.getDbms().isRedshift()) {
                boolean bl = isTable = PsiTreeUtil.getParentOfType((PsiElement)place, SqlResultSetExpression.class) != null;
            }
            if (isTable) {
                SqlReferenceExpression ref2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
                return ref2 == null || ref2.getQualifierExpression() == null;
            }
        }
        return super.isResolveTargetAccepted(symbol, type2, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    private static SqlScopeProcessorBase filterSingleArgumentRoutines(final SqlScopeProcessor sqlProcessor) {
        SqlScopeProcessorBase processor2 = new SqlScopeProcessorBase(sqlProcessor.getReferenceName(), (SqlLanguageDialectEx)sqlProcessor.getDialect(), sqlProcessor.getDataSources(), sqlProcessor.getPlace()){

            public boolean isResultEmpty() {
                return sqlProcessor.isResultEmpty();
            }

            public boolean executeTarget(@NotNull DasSymbol symbol, @Nullable DasType dasType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !SqlFunctionsUtil.isSingleArgumentRoutine(symbol.getDasObject()) || sqlProcessor.executeTarget(symbol, dasType, forcedCaseSens, state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "symbol";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/dialects/postgres/PgDialectBase$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor2.setExpectedKinds(Collections.singleton(ObjectKind.ROUTINE));
        SqlScopeProcessorBase sqlScopeProcessorBase = processor2;
        if (sqlScopeProcessorBase == null) {
            PgDialectBase.$$$reportNull$$$0(16);
        }
        return sqlScopeProcessorBase;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath) {
        Couple<ObjectName> scAndDb = PgDialectBase.getScAndDb(dataSource2);
        TreePatternNode.Group[] schemas2 = SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.first, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
        TreePattern treePattern = this.applyImplicitImports(SqlImportUtil.getRealDsNames(dataSource2), SqlDialectImplUtilCore.forcedContextExpandedToSchemas(dataSource2, this.getDbms(), searchPath, schemas2, SqlImportUtil.optAr(TreePatternUtils.create((ObjectName)scAndDb.second, ObjectKind.DATABASE, schemas2))));
        if (treePattern == null) {
            PgDialectBase.$$$reportNull$$$0(17);
        }
        return treePattern;
    }

    @Override
    public boolean isMultiIdReference(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            PgDialectBase.$$$reportNull$$$0(18);
        }
        return expression.getReferenceElementType() == SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE || super.isMultiIdReference(expression);
    }

    public boolean isValidRawToken(@NotNull IElementType type2, @NotNull CharSequence text2) {
        if (type2 == null) {
            PgDialectBase.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            PgDialectBase.$$$reportNull$$$0(20);
        }
        return SqlLexer.isValidRawCopyToken(text2);
    }

    @Override
    public boolean supportsJoinUsing() {
        return true;
    }

    @Override
    public boolean supportsNaturalJoin() {
        return true;
    }

    @Override
    public boolean requiresAsForAliasAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            PgDialectBase.$$$reportNull$$$0(21);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlInsertStatement.class}) != null;
    }

    @Override
    @NotNull
    public SqlImportBuilder getImportBuilder() {
        PgBaseImportBuilder pgBaseImportBuilder = PgBaseImportBuilder.INSTANCE;
        if (pgBaseImportBuilder == null) {
            PgDialectBase.$$$reportNull$$$0(22);
        }
        return pgBaseImportBuilder;
    }

    @Override
    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return new PgExtractVariableHelper(this);
    }

    private static Couple<ObjectName> getScAndDb(@Nullable DbDataSource dataSource2) {
        ObjectName dbName = PgDialectBase.getDbName(dataSource2);
        ObjectName scName = null;
        DasNamespace namespace = PgDialectBase.getDefaultNamespace(dataSource2, dbName);
        if (namespace != null) {
            DasObject parent2;
            if (namespace.getKind() == ObjectKind.SCHEMA) {
                scName = ObjectName.quoted(namespace.getName());
            }
            if ((parent2 = namespace.getDasParent()) != null && parent2.getKind() == ObjectKind.DATABASE) {
                dbName = ObjectName.quoted(parent2.getName());
            }
        }
        if (scName == null) {
            scName = PgDialect.LazyData.PUBLIC_NAME;
        }
        return Couple.of((Object)scName, (Object)dbName);
    }

    @Nullable
    protected static ObjectName getDbName(@Nullable DbDataSource dataSource2) {
        RawConnectionConfig config = SqlImportUtil.getConnectionConfig(dataSource2);
        return ObjectName.plain((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName(config), (Object)SqlDialectImplUtilCore.getUserName(config)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 16, 17, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/postgres/PgDialectBase";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDateTimeHelper";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSingleArgumentRoutines";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inIndexExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inDomainCheck";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "raiseStatement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 22: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isMultiIdReference";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "requiresAsForAliasAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 16, 17, 22 -> new IllegalStateException(string);
        };
    }

    private class LazyInstanceData {
        private final ReservedEntity myNewTableAlias;
        private final ReservedEntity myOldTableAlias;
        private final Map<String, ReservedEntity> myTriggerStringImplicits;
        private final ReservedEntity myTriggerNArgsColumn;
        private final ReservedEntity myTriggerArgVColumn;
        private final ReservedEntity myFoundColumn;
        private final ReservedEntity mySqlStateColumn;
        private final ReservedEntity mySqlErrmColumn;
        private final ReservedEntity myValueColumn;

        private LazyInstanceData() {
            this.myNewTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "new", ObjectKind.TABLE);
            this.myOldTableAlias = new ReservedEntity(PgDialectBase.this.getDbms(), "old", ObjectKind.TABLE);
            this.myTriggerStringImplicits = SqlDialectImplUtilCore.buildEntities(PgDialectBase.this.getDbms(), ObjectKind.COLUMN, "tg_name", "tg_when", "tg_level", "tg_op", "tg_relid", "tg_relname", "tg_table_name", "tg_table_schema", "tg_tag", "tg_event");
            this.myTriggerNArgsColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_nargs", ObjectKind.COLUMN);
            this.myTriggerArgVColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "tg_argv", ObjectKind.COLUMN);
            this.myFoundColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "FOUND", ObjectKind.COLUMN);
            this.mySqlStateColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "SQLSTATE", ObjectKind.COLUMN);
            this.mySqlErrmColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "SQLERRM", ObjectKind.COLUMN);
            this.myValueColumn = new ReservedEntity(PgDialectBase.this.getDbms(), "VALUE", ObjectKind.COLUMN);
        }
    }
}

