/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.MsTokens;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.dialects.mssql.dataFlow.MsDFABuildingVisitor;
import com.intellij.sql.dialects.mssql.refactoring.MsExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MsDialectBase
extends SqlLanguageDialectBase {
    private final NotNullLazyValue<LazyInstanceData> myInstanceData;

    protected MsDialectBase(@NotNull String id) {
        if (id == null) {
            MsDialectBase.$$$reportNull$$$0(0);
        }
        super(id);
        this.myInstanceData = NotNullLazyValue.atomicLazy(() -> new LazyInstanceData());
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(MsTokens.class);
        if (tokensHelper == null) {
            MsDialectBase.$$$reportNull$$$0(1);
        }
        return tokensHelper;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "hierarchyid", "hierarchyid", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "xml", "xml", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "geometry", "geometry", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "geography", "geography", (SqlLanguageDialectEx)this);
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type2, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MsDialectBase.$$$reportNull$$$0(2);
        }
        if ((type2 == ObjectKind.ALIAS_TYPE || type2 == ObjectKind.TABLE_TYPE) && expectedTypes.contains(ObjectKind.OBJECT_TYPE)) {
            return true;
        }
        if (type2 == ObjectKind.INDEX && expectedTypes.contains(SqlDbElementType.STATISTICS) && place instanceof SqlReferenceExpression && PsiUtilCore.getElementType((PsiElement)place.getParent()) == MsTypes.MSSQL_UPDATE_STATISTICS_STATEMENT) {
            return true;
        }
        if ((type2 == ObjectKind.LOGIN || type2 == ObjectKind.ROLE) && expectedTypes.contains(ObjectKind.USER)) {
            return true;
        }
        if (type2 == ObjectKind.PARTITION_FUNCTION && expectedTypes.contains(ObjectKind.ROUTINE) && place instanceof SqlReferenceExpression && PsiUtilCore.getElementType((PsiElement)((SqlReferenceExpression)place).getQualifierExpression()) == MsTypes.MSSQL_PARTITION_LITERAL) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type2, expectedTypes, place, strict, isCompletion);
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            MsDialectBase.$$$reportNull$$$0(3);
        }
        for (PsiElement parent2 : SqlImplUtil.sqlParents(place)) {
            if (PsiUtilCore.getElementType((PsiElement)parent2) != SqlElementTypes.SQL_COLUMN_GENERATED_CLAUSE) continue;
            return true;
        }
        return super.allowGlobalTableResolve(place);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        if (place == null) {
            MsDialectBase.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            MsDialectBase.$$$reportNull$$$0(5);
        }
        DasTypeSystemBase typeSystem = this.getTypeSystem();
        if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_ACTION.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_ACTION, typeSystem.getStringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_IDENTITY.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_IDENTITY, typeSystem.getStringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_ROWGUID.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_ROWGUID, typeSystem.getStringType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_XML.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_XML, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_ROWVERSION.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_ROWVERSION, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_GEOMETRY.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_GEOMETRY, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_GEOGRAPHY.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_GEOGRAPHY, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else if (SqlImplUtil.equalsInsensitiveOrTrue(name2, LazyData.RE_PARTITION.name, resolve2)) {
            if (!processor2.executeTarget((DasSymbol)LazyData.RE_PARTITION, null, Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        } else {
            String referenceName;
            String string = referenceName = place instanceof SqlReferenceExpression ? ((SqlReferenceExpression)place).getName() : null;
            if (SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.COLUMN, ObjectKind.VARIABLE)) {
                DasType scopingType = SqlImplUtil.getScopingType(place);
                if (scopingType != null) {
                    typeName = scopingType.getDescription();
                    if ((typeName.equalsIgnoreCase("geometry") || typeName.equalsIgnoreCase("geography")) && !processor2.executeTarget((DasSymbol)LazyData.RE_GEO_NULL, scopingType, null, ResolveState.initial())) {
                        return false;
                    }
                } else {
                    Map<String, ReservedEntity.Typed> fieldMap;
                    typeName = SqlImplUtil.getQualifierDasType(place).getDescription();
                    LazyInstanceData instanceData = (LazyInstanceData)this.myInstanceData.getValue();
                    Map<String, ReservedEntity.Typed> map2 = typeName.equalsIgnoreCase("geometry") ? instanceData.GEOMETRY_FIELDS : (fieldMap = typeName.equalsIgnoreCase("geography") ? instanceData.GEOGRAPHY_FIELDS : null);
                    if (fieldMap != null) {
                        ReservedEntity.Typed target2;
                        ReservedEntity.Typed typed = target2 = referenceName == null ? null : instanceData.COMMON_GEO_FIELDS.get(referenceName);
                        if (target2 == null) {
                            ReservedEntity.Typed typed2 = target2 = referenceName == null ? null : fieldMap.get(referenceName);
                        }
                        if (target2 != null && !processor2.executeTarget((DasSymbol)target2, target2.type, null, ResolveState.initial())) {
                            return false;
                        }
                    }
                }
            }
        }
        if (processor2.mayAccept(ObjectKind.FILEGROUP)) {
            for (ReservedEntity entity : LazyData.RE_FILEGROPUS) {
                if (processor2.executeTarget((DasSymbol)entity, null, Boolean.valueOf(false), ResolveState.initial())) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor2);
    }

    @Override
    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor2, @NotNull ResolveState state, @NotNull SqlReference ref2, @NotNull SqlExpression qualifier) {
        if (processor2 == null) {
            MsDialectBase.$$$reportNull$$$0(6);
        }
        if (state == null) {
            MsDialectBase.$$$reportNull$$$0(7);
        }
        if (ref2 == null) {
            MsDialectBase.$$$reportNull$$$0(8);
        }
        if (qualifier == null) {
            MsDialectBase.$$$reportNull$$$0(9);
        }
        if (PsiUtilCore.getElementType((PsiElement)qualifier) == MsTypes.MSSQL_PARTITION_LITERAL && ref2 instanceof SqlReferenceImpl) {
            return ((SqlReferenceImpl)ref2).processUnqualifiedResolveVariants(processor2, state);
        }
        return super.processQualifiedResolve(processor2, state, ref2, qualifier);
    }

    @Override
    @Nullable
    public Condition<DasObject> getAdditionalExpandCondition(@NotNull SqlScopeProcessor processor2, @NotNull PsiElement place) {
        Condition<DasObject> condition2;
        if (processor2 == null) {
            MsDialectBase.$$$reportNull$$$0(10);
        }
        if (place == null) {
            MsDialectBase.$$$reportNull$$$0(11);
        }
        if ((condition2 = super.getAdditionalExpandCondition(processor2, place)) != null) {
            return condition2;
        }
        PsiElement parent2 = place.getParent();
        if (processor2.mayAccept(ObjectKind.ROUTINE) && parent2 instanceof SqlFunctionCallExpression && parent2.getParent() instanceof SqlCallStatement) {
            return o2 -> o2.getKind() == ObjectKind.SCHEMA && o2.getName().equals("sys");
        }
        return null;
    }

    public boolean shouldStubCall(@NotNull String name2) {
        if (name2 == null) {
            MsDialectBase.$$$reportNull$$$0(12);
        }
        if (name2.equalsIgnoreCase("sp_addextendedproperty") || name2.equalsIgnoreCase("sp_updateextendedproperty") || name2.equalsIgnoreCase("sp_dropextendedproperty")) {
            return true;
        }
        return super.shouldStubCall(name2);
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            MsDialectBase.$$$reportNull$$$0(13);
        }
        return 128;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName, @Nullable ObjectKind kind) {
        if (identifier == null) {
            MsDialectBase.$$$reportNull$$$0(14);
        }
        if (newElementName == null) {
            MsDialectBase.$$$reportNull$$$0(15);
        }
        if (kind == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName, kind);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o2, ObjectKind type2) {
        if (type2 == ObjectKind.ARGUMENT && MsDialectBase.isSpExecuteSqlArgName(o2)) {
            return false;
        }
        if (type2 == ObjectKind.COLLATION) {
            return true;
        }
        if (type2 == SqlDbElementType.ANY && MsDialectBase.isExecArg(o2)) {
            return false;
        }
        if (type2 == MsElementTypes.Kinds.FILE) {
            return false;
        }
        if (MsDialectBase.checkPrecedingClauseKeyword((PsiElement)o2)) {
            return false;
        }
        return super.shallResolve(o2, type2);
    }

    private static boolean checkPrecedingClauseKeyword(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        for (PsiElement e2 = element2.getPrevSibling(); e2 != null; e2 = e2.getPrevSibling()) {
            IElementType currentType;
            if (e2 instanceof PsiWhiteSpace || e2 instanceof PsiComment || e2 instanceof PsiErrorElement || (currentType = PsiUtilCore.getElementType((PsiElement)e2)) == SqlCommonTokens.SQL_OP_EQ) continue;
            return currentType == MsTypes.MSSQL_HISTORY_TABLE || currentType == MsTypes.MSSQL_LEDGER_VIEW;
        }
        return false;
    }

    private static boolean isSpExecuteSqlArgName(@Nullable SqlReferenceExpression o2) {
        if (o2 == null) {
            return false;
        }
        PsiElement p2 = o2.getParent();
        if (!(p2 instanceof SqlNamedParameterValueExpression) || ((SqlNamedParameterValueExpression)p2).getLOperand() != o2) {
            return false;
        }
        if (!((p2 = p2.getParent()) instanceof SqlExpressionList)) {
            return false;
        }
        if (!((p2 = p2.getParent()) instanceof SqlFunctionCallExpression)) {
            return false;
        }
        SqlFunctionCallExpression call2 = (SqlFunctionCallExpression)p2;
        SqlReferenceExpression nameElement = call2.getNameElement();
        String name2 = nameElement != null ? nameElement.getName() : "";
        return name2.equalsIgnoreCase("sp_executesql");
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type2) {
        super.getParentDbTypes(result2, type2);
        if (type2 == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        if (type2 == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        if (type2 == ObjectKind.DATABASE) {
            result2.add((ObjectKind)ObjectKind.LINKED_SERVER);
        }
        return result2;
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref2) {
        if (ref2 == null) {
            MsDialectBase.$$$reportNull$$$0(16);
        }
        return !this.getKeywords().contains(ref2);
    }

    @Override
    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection2 = LazyData.MAJOR_CHILD_KINDS;
        if (collection2 == null) {
            MsDialectBase.$$$reportNull$$$0(17);
        }
        return collection2;
    }

    @Override
    protected boolean checkArgumentMatch(@NotNull DasRoutine routine2, @NotNull SqlFunctionCallExpression call2) {
        if (routine2 == null) {
            MsDialectBase.$$$reportNull$$$0(18);
        }
        if (call2 == null) {
            MsDialectBase.$$$reportNull$$$0(19);
        }
        if (routine2.getName().equalsIgnoreCase("sp_executesql")) {
            return true;
        }
        return super.checkArgumentMatch(routine2, call2);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource2, ObjectName @Nullable [] dsNames) {
        List<ObjectName> schemas2 = MsDialectBase.getSchemaNames(dataSource2);
        ObjectName dbname = MsDialectBase.getDatabaseName(dataSource2);
        DasNamespace namespace = MsDialectBase.getDefaultNamespace(dataSource2, dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(schemas2, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                MsDialectBase.$$$reportNull$$$0(20);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource2 == null, dbname, TreePatternUtils.create(schemas2, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath) {
        TreePatternNode.Group[] schemas2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MsDialectBase.getSchemaNames(dataSource2), ObjectKind.SCHEMA, new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases2 = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MsDialectBase.getDatabaseName(dataSource2), ObjectKind.DATABASE, schemas2)});
        TreePattern treePattern = SqlDialectImplUtilCore.forcedContextExpandedToSchemas(dataSource2, this.getDbms(), searchPath, schemas2, databases2);
        if (treePattern == null) {
            MsDialectBase.$$$reportNull$$$0(21);
        }
        return treePattern;
    }

    @Override
    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref2) {
        if (prev == null) {
            MsDialectBase.$$$reportNull$$$0(22);
        }
        if (ref2 == null) {
            MsDialectBase.$$$reportNull$$$0(23);
        }
        return SqlDialectImplUtilCore.refPatternExpandedToSchema(prev, ref2, this);
    }

    @Override
    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource2, @NotNull SearchPath searchPath) {
        if (searchPath == null) {
            MsDialectBase.$$$reportNull$$$0(24);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource2, searchPath);
        if (treePattern == null) {
            MsDialectBase.$$$reportNull$$$0(25);
        }
        return treePattern;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            MsDialectBase.$$$reportNull$$$0(26);
        }
        return super.isTableAliasAllowedAt(element2) || PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlMergeStatement.class}) != null;
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return MsExtractFunctionHelper.INSTANCE;
    }

    @Override
    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new MsDFABuildingVisitor(this);
    }

    @Override
    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_SEMICOLON}).mask(true, false)), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_TRY, MsElementTypes.Misc.MSSQL_TRY_CATCH_STATEMENT}, "", "end try\nbegin catch\nend catch", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(MsTypes.MSSQL_TRY).opt(new IElementType[]{MsElementTypes.Misc.MSSQL_CATCH_CLAUSE, SqlElementTypes.SQL_SEMICOLON}).build()), new SubstitutionDescriptorImpl(new IElementType[]{MsTypes.MSSQL_CATCH, MsElementTypes.Misc.MSSQL_CATCH_CLAUSE}, "", "end catch", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, MsTypes.MSSQL_CATCH, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false)));
    }

    public static boolean isExecArg(@Nullable SqlReferenceExpression o2) {
        if (o2 == null) {
            return false;
        }
        PsiElement top = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o2).skipWhile(x -> x == o2 || x instanceof SqlNamedParameterValueExpression || x instanceof SqlExpressionList || x instanceof SqlFunctionCallExpression).first();
        return top instanceof SqlStatement;
    }

    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource2) {
        return ObjectName.plain((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtilCore.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource2)), (Object)"master"));
    }

    @NotNull
    private static List<ObjectName> getSchemaNames(@Nullable DbDataSource dataSource2) {
        SmartList schemas2 = new SmartList((Object)ObjectName.quoted("dbo"));
        String username = SqlDialectImplUtilCore.getUserName(SqlImportUtil.getConnectionConfig(dataSource2));
        if (username != null) {
            schemas2.add(ObjectName.plain(username));
        }
        SmartList smartList = schemas2;
        if (smartList == null) {
            MsDialectBase.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 17, 20, 21, 25, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mssql/MsDialectBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mssql/MsDialectBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 17: 
            case 20: 
            case 21: 
            case 25: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalExpandCondition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldStubCall";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkArgumentMatch";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 17, 20, 21, 25, 27 -> new IllegalStateException(string);
        };
    }

    static final class LazyData {
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlCommonTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{MsTypes.MSSQL_GO})});
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ);
        static final ReservedEntity RE_ACTION = new ReservedEntity(Dbms.MSSQL, "$action", ObjectKind.COLUMN);
        static final ReservedEntity RE_IDENTITY = new ReservedEntity(Dbms.MSSQL, "$IDENTITY", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWGUID = new ReservedEntity(Dbms.MSSQL, "$ROWGUID", ObjectKind.COLUMN);
        static final ReservedEntity RE_XML = new ReservedEntity(Dbms.MSSQL, "XML", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_ROWVERSION = new ReservedEntity(Dbms.MSSQL, "rowversion", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_GEOMETRY = new ReservedEntity(Dbms.MSSQL, "geometry", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_GEOGRAPHY = new ReservedEntity(Dbms.MSSQL, "geography", ObjectKind.OBJECT_TYPE);
        static final ReservedEntity RE_GEO_NULL = new ReservedEntity(Dbms.MSSQL, "Null", ObjectKind.VARIABLE);
        static final ReservedEntity RE_PARTITION = new ReservedEntity(Dbms.MSSQL, "$PARTITION", ObjectKind.COLUMN);
        static final List<ReservedEntity> RE_FILEGROPUS = Arrays.asList(new ReservedEntity(Dbms.MSSQL, "PRIMARY", ObjectKind.FILEGROUP), new ReservedEntity(Dbms.MSSQL, "default", ObjectKind.FILEGROUP));
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Collections.singletonList(ObjectKind.TRIGGER);

        LazyData() {
        }
    }

    private class LazyInstanceData {
        private final ReservedEntity.Typed RE_GEO_STSRID;
        private final ReservedEntity.Typed RE_GEO_STX;
        private final ReservedEntity.Typed RE_GEO_STY;
        private final ReservedEntity.Typed RE_GEO_HASM;
        private final ReservedEntity.Typed RE_GEO_HASZ;
        private final ReservedEntity.Typed RE_GEO_M;
        private final ReservedEntity.Typed RE_GEO_Z;
        private final ReservedEntity.Typed RE_GEO_LAT;
        private final ReservedEntity.Typed RE_GEO_LONG;
        private final Map<String, ReservedEntity.Typed> COMMON_GEO_FIELDS;
        private final Map<String, ReservedEntity.Typed> GEOMETRY_FIELDS;
        private final Map<String, ReservedEntity.Typed> GEOGRAPHY_FIELDS;

        private LazyInstanceData() {
            this.RE_GEO_STSRID = new ReservedEntity.Typed(Dbms.MSSQL, "STSrid", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getIntType());
            this.RE_GEO_STX = new ReservedEntity.Typed(Dbms.MSSQL, "STX", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getRealType());
            this.RE_GEO_STY = new ReservedEntity.Typed(Dbms.MSSQL, "STY", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getRealType());
            this.RE_GEO_HASM = new ReservedEntity.Typed(Dbms.MSSQL, "HasM", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getBooleanType());
            this.RE_GEO_HASZ = new ReservedEntity.Typed(Dbms.MSSQL, "HasZ", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getBooleanType());
            this.RE_GEO_M = new ReservedEntity.Typed(Dbms.MSSQL, "M", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getRealType());
            this.RE_GEO_Z = new ReservedEntity.Typed(Dbms.MSSQL, "Z", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getRealType());
            this.RE_GEO_LAT = new ReservedEntity.Typed(Dbms.MSSQL, "Lat", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getRealType());
            this.RE_GEO_LONG = new ReservedEntity.Typed(Dbms.MSSQL, "Long", ObjectKind.VARIABLE, MsDialectBase.this.getTypeSystem().getRealType());
            this.COMMON_GEO_FIELDS = Map.of(this.RE_GEO_STSRID.name, this.RE_GEO_STSRID, this.RE_GEO_HASM.name, this.RE_GEO_HASM, this.RE_GEO_HASZ.name, this.RE_GEO_HASZ, this.RE_GEO_M.name, this.RE_GEO_M, this.RE_GEO_Z.name, this.RE_GEO_Z);
            this.GEOMETRY_FIELDS = Map.of(this.RE_GEO_STX.name, this.RE_GEO_STX, this.RE_GEO_STY.name, this.RE_GEO_STY);
            this.GEOGRAPHY_FIELDS = Map.of(this.RE_GEO_LAT.name, this.RE_GEO_LAT, this.RE_GEO_LONG.name, this.RE_GEO_LONG);
        }
    }
}

