/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ES6Parser;
import com.intellij.sql.dialects.mongo.js.FunctionParser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JSParsingContextUtil;
import com.intellij.sql.dialects.mongo.js.JavaScriptParserBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Predicate;

public interface JSModifiersStructure {
    public boolean parseOptimistically(PsiBuilder var1);

    public boolean parse(PsiBuilder var1, Predicate<PsiBuilder> var2);

    public boolean isPossibleLookahead(PsiBuilder var1);

    public void resetContexts(PsiBuilder var1);

    public static class JSOrderedModifiersStructure
    extends JSCompositeModifiersStructure {
        public JSOrderedModifiersStructure(JSModifiersStructure ... elements2) {
            super(elements2);
        }

        @Override
        public boolean parseOptimistically(PsiBuilder builder) {
            boolean result2 = false;
            int i2 = 0;
            while (i2 < this.myElements.length) {
                if (this.myElements[i2].parseOptimistically(builder)) {
                    result2 = true;
                    continue;
                }
                ++i2;
            }
            return result2;
        }

        @Override
        public boolean parse(PsiBuilder builder, Predicate<PsiBuilder> isPossibleLookahead) {
            boolean parsedSomething = false;
            PsiBuilder.Marker currentMarker = builder.mark();
            block0: for (int i2 = 0; i2 < this.myElements.length; ++i2) {
                if (!this.myElements[i2].parse(builder, isPossibleLookahead)) continue;
                for (int j = i2 + 1; j < this.myElements.length; ++j) {
                    if (!this.myElements[j].isPossibleLookahead(builder)) continue;
                    currentMarker.drop();
                    currentMarker = builder.mark();
                    parsedSomething = true;
                    continue block0;
                }
                return this.successOrRollback(builder, isPossibleLookahead, this.myElements[i2], currentMarker, parsedSomething);
            }
            currentMarker.drop();
            return parsedSomething;
        }
    }

    public static class JSOneOfModifiersStructure
    extends JSCompositeModifiersStructure {
        public JSOneOfModifiersStructure(IElementType ... elements2) {
            this(true, elements2);
        }

        public JSOneOfModifiersStructure(boolean allowNewlineAfter, IElementType ... elements2) {
            super((JSModifiersStructure[])ContainerUtil.map2Array((Object[])elements2, JSModifiersStructure.class, t -> new JSModifiersStructureLeaf((IElementType)t, allowNewlineAfter)));
        }

        @Override
        public boolean parseOptimistically(PsiBuilder builder) {
            for (JSModifiersStructure element2 : this.myElements) {
                if (!element2.parseOptimistically(builder)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean parse(PsiBuilder builder, Predicate<PsiBuilder> isPossibleLookahead) {
            PsiBuilder.Marker temp = builder.mark();
            for (JSModifiersStructure element2 : this.myElements) {
                if (!element2.parse(builder, isPossibleLookahead)) continue;
                return this.successOrRollback(builder, isPossibleLookahead, element2, temp, false);
            }
            temp.rollbackTo();
            return false;
        }
    }

    public static final class JSModifiersStructureLeaf
    implements JSModifiersStructure {
        private final IElementType myTokenType;
        private final boolean myAllowNewlineAfter;

        public JSModifiersStructureLeaf(IElementType tokenType) {
            this(tokenType, true);
        }

        public JSModifiersStructureLeaf(IElementType tokenType, boolean allowNewlineAfter) {
            this.myTokenType = tokenType;
            this.myAllowNewlineAfter = allowNewlineAfter;
        }

        @Override
        public boolean parseOptimistically(PsiBuilder builder) {
            if (this.isPossibleLookahead(builder)) {
                builder.advanceLexer();
                this.setContexts(builder, true);
                return true;
            }
            return false;
        }

        @Override
        public boolean parse(PsiBuilder builder, Predicate<PsiBuilder> isPossibleLookahead) {
            if (this.isPossibleLookahead(builder)) {
                PsiBuilder.Marker temp = builder.mark();
                builder.advanceLexer();
                if (isPossibleLookahead.test(builder)) {
                    temp.drop();
                    this.setContexts(builder, true);
                    return true;
                }
                temp.rollbackTo();
            }
            return false;
        }

        private void setContexts(PsiBuilder builder, boolean value2) {
            if (this.myTokenType == JSElementTypes.ASYNC_KEYWORD) {
                builder.putUserData(ES6Parser.ES6FunctionParser.HAD_ASYNC_MODIFIER_KEY, (Object)value2);
            } else if (this.myTokenType == JSElementTypes.MULT) {
                JSParsingContextUtil.setIsGenerator(value2, builder);
            } else if (this.myTokenType == JSElementTypes.GET_KEYWORD || this.myTokenType == JSElementTypes.SET_KEYWORD) {
                builder.putUserData(FunctionParser.HAD_GET_SET, (Object)value2);
            }
        }

        @Override
        public void resetContexts(PsiBuilder builder) {
            this.setContexts(builder, false);
        }

        @Override
        public boolean isPossibleLookahead(PsiBuilder builder) {
            return (this.myAllowNewlineAfter || !JavaScriptParserBase.hasSemanticLinefeedAfter(builder)) && builder.getTokenType() == this.myTokenType;
        }
    }

    public static abstract class JSCompositeModifiersStructure
    implements JSModifiersStructure {
        protected final JSModifiersStructure[] myElements;

        JSCompositeModifiersStructure(JSModifiersStructure ... elements2) {
            this.myElements = elements2;
        }

        @Override
        public boolean isPossibleLookahead(PsiBuilder builder) {
            for (JSModifiersStructure element2 : this.myElements) {
                if (!element2.isPossibleLookahead(builder)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void resetContexts(PsiBuilder builder) {
            for (JSModifiersStructure structure : this.myElements) {
                structure.resetContexts(builder);
            }
        }

        protected boolean successOrRollback(PsiBuilder builder, Predicate<PsiBuilder> isPossibleLookahead, JSModifiersStructure structure, PsiBuilder.Marker currentMarker, boolean parsedSomething) {
            if (isPossibleLookahead.test(builder)) {
                currentMarker.drop();
                return true;
            }
            currentMarker.rollbackTo();
            structure.resetContexts(builder);
            return parsedSomething;
        }
    }
}

