/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLexer;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlStringLeafTokenType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import java.util.Set;

public final class SqlInjectionIdentifyingLexerUtil {
    public static final Set<IElementType> ourStopper = Set.of(SqlTokens.SQL_SEMICOLON, SqlTokens.SQL_RIGHT_PAREN, SqlCommonKeywords.SQL_CREATE, SqlCommonKeywords.SQL_SELECT);

    public static void lookAheadCreateFunction(SqlLexer.LookAheadHelper lah, Set<IElementType> extraBeforeName, Set<IElementType> stopper, String defLang) {
        IElementType type2 = lah.getNextToken();
        if (type2 == SqlCommonKeywords.SQL_OR) {
            type2 = SqlInjectionIdentifyingLexerUtil.skipOrReplace(lah);
        }
        if (type2 != SqlCommonKeywords.SQL_FUNCTION && type2 != SqlCommonKeywords.SQL_PROCEDURE) {
            return;
        }
        while (extraBeforeName != null && extraBeforeName.contains(type2)) {
            type2 = lah.getNextToken();
        }
        if (SqlInjectionIdentifyingLexerUtil.skipQName(lah) != SqlTokens.SQL_LEFT_PAREN) {
            return;
        }
        if (SqlInjectionIdentifyingLexerUtil.skipParens(lah) != SqlTokens.SQL_RIGHT_PAREN) {
            return;
        }
        String lang = null;
        int bodyIdx = -1;
        while (true) {
            IElementType token;
            if ((token = lah.getNextToken()) == SqlTokens.SQL_LEFT_PAREN) {
                if (SqlInjectionIdentifyingLexerUtil.skipParens(lah) == SqlTokens.SQL_RIGHT_PAREN) continue;
                return;
            }
            if (token == null || stopper.contains(token)) break;
            if (token == SqlCommonKeywords.SQL_LANGUAGE) {
                lang = SqlInjectionIdentifyingLexerUtil.getNormalizedLanguage(lah);
                if (lang == null) {
                    return;
                }
                if (bodyIdx == -1) continue;
                break;
            }
            if (token != SqlCommonKeywords.SQL_AS) continue;
            token = lah.getNextToken();
            if (token != SqlTokens.SQL_CUSTOM_LQUOTE || lah.getNextToken() != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
                return;
            }
            bodyIdx = lah.getPos();
            lah.getNextToken();
            if (lang != null) break;
        }
        if (lang == null) {
            lang = defLang;
        }
        if (bodyIdx != -1 && lang != null) {
            lah.replaceToken(bodyIdx, (IElementType)SqlTokenType.SqlInjectionMark.get((String)lang));
        }
    }

    private static IElementType skipParens(SqlLexer.LookAheadHelper lah) {
        IElementType type2;
        do {
            IElementType tmp;
            if ((type2 = lah.getNextToken()) == null) {
                return null;
            }
            if (type2 != SqlTokens.SQL_LEFT_PAREN || (tmp = SqlInjectionIdentifyingLexerUtil.skipParens(lah)) == SqlTokens.SQL_RIGHT_PAREN) continue;
            return tmp;
        } while (type2 != SqlTokens.SQL_RIGHT_PAREN && type2 != SqlTokens.SQL_SEMICOLON);
        return type2;
    }

    private static IElementType skipQName(SqlLexer.LookAheadHelper lah) {
        IElementType type2 = lah.getNextToken();
        while (SqlInjectionIdentifyingLexerUtil.isIdent(type2)) {
            type2 = lah.getNextToken();
            if (type2 != SqlTokens.SQL_PERIOD) {
                return type2;
            }
            type2 = lah.getNextToken();
        }
        return null;
    }

    private static boolean isIdent(IElementType type2) {
        return type2 == SqlTokens.SQL_IDENT || type2 == SqlTokens.SQL_IDENT_DELIMITED || type2 instanceof SqlIdentifierKeywordTokenType || type2 instanceof SqlKeywordTokenType;
    }

    public static IElementType skipOrReplace(SqlLexer.LookAheadHelper lah) {
        IElementType type2 = lah.getNextToken();
        if (type2 == SqlCommonKeywords.SQL_REPLACE) {
            type2 = lah.getNextToken();
        }
        return type2;
    }

    public static String getNormalizedLanguage(SqlLexer.LookAheadHelper lah) {
        String language = SqlInjectionIdentifyingLexerUtil.getLanguage(lah);
        return language == null ? null : StringUtil.trimStart((String)language, (String)"pl");
    }

    private static String getLanguage(SqlLexer.LookAheadHelper lah) {
        IElementType type2 = lah.getNextToken();
        if (type2 == SqlTokens.SQL_CUSTOM_LQUOTE) {
            type2 = lah.getNextToken();
            if (type2 != SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
                return null;
            }
            lah.getNextToken();
            return SqlInjectionIdentifyingLexerUtil.getLanguage(lah, lah.getPos() - 1);
        }
        return SqlInjectionIdentifyingLexerUtil.getLanguage(lah, lah.getPos());
    }

    public static String getLanguage(SqlLexer.LookAheadHelper lah, int pos) {
        IElementType type2 = lah.getToken(pos);
        if (type2 == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            return lah.getTokenText(pos).toString();
        }
        if (type2 instanceof SqlStringLeafTokenType) {
            CharSequence raw = lah.getTokenText(pos);
            if (raw.length() < 2) {
                return null;
            }
            char q2 = raw.charAt(0);
            if (q2 != '\'' && q2 != '\"') {
                return null;
            }
            String qs = Character.toString(q2);
            return raw.subSequence(1, raw.length() - 1).toString().replace(qs + qs, qs);
        }
        if (type2 instanceof SqlKeywordTokenType || type2 instanceof SqlIdentifierKeywordTokenType || type2 == SqlTokens.SQL_IDENT) {
            return StringUtil.toLowerCase((String)lah.getTokenText(pos).toString());
        }
        return null;
    }
}

