/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000b\u001a\u00020\f2\u001c\u0010\r\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\f0\u000eJ.\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u001c\u0010\r\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\f0\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/SqlValuesToColumnMapper;", "", "target", "Lcom/intellij/psi/PsiElement;", "indexRange", "Lkotlin/ranges/IntRange;", "(Lcom/intellij/psi/PsiElement;Lkotlin/ranges/IntRange;)V", "getIndexRange", "()Lkotlin/ranges/IntRange;", "getTarget", "()Lcom/intellij/psi/PsiElement;", "processColumnElements", "", "consumer", "Lkotlin/Function2;", "", "sqlType", "Lcom/intellij/sql/psi/SqlTableType;", "Companion", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlValuesToColumnMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlValuesToColumnMapper.kt\ncom/intellij/sql/SqlValuesToColumnMapper\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,58:1\n66#2,2:59\n66#2,2:61\n66#2,2:63\n66#2,2:65\n*S KotlinDebug\n*F\n+ 1 SqlValuesToColumnMapper.kt\ncom/intellij/sql/SqlValuesToColumnMapper\n*L\n25#1:59,2\n37#1:61,2\n38#1:63,2\n43#1:65,2\n*E\n"})
public final class SqlValuesToColumnMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement target;
    @NotNull
    private final IntRange indexRange;

    private SqlValuesToColumnMapper(PsiElement target2, IntRange indexRange) {
        this.target = target2;
        this.indexRange = indexRange;
    }

    @NotNull
    public final PsiElement getTarget() {
        return this.target;
    }

    @NotNull
    public final IntRange getIndexRange() {
        return this.indexRange;
    }

    public final void processColumnElements(@NotNull Function2<? super PsiElement, ? super String, Unit> consumer2) {
        SqlDmlInstruction instruction2;
        SqlQueryExpression sqlQueryExpression;
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        PsiElement $this$parentOfType_u24default$iv = this.target;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        SqlResultSetExpression query = (SqlResultSetExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlResultSetExpression.class, (boolean)true);
        if (query != null) {
            PsiElement parent2 = query.getParent();
            while (parent2 instanceof SqlParenthesizedExpression) {
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof SqlAsExpression) {
                DasType sqlType;
                PsiElement alias = parent2;
                DasType dasType = sqlType = PsiTreeUtil.getChildOfType((PsiElement)alias, SqlColumnAliasListImpl.class) != null ? ((SqlAsExpression)alias).getDasType() : null;
                if (sqlType instanceof SqlTableType) {
                    this.processColumnElements((SqlTableType)sqlType, consumer2);
                    return;
                }
            }
        }
        SqlResultSetExpression sqlResultSetExpression = query;
        if (sqlResultSetExpression != null) {
            $this$parentOfType_u24default$iv = (PsiElement)sqlResultSetExpression;
            withSelf$iv = false;
            $i$f$parentOfType = false;
            sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlQueryExpression.class, (boolean)true);
        } else {
            sqlQueryExpression = null;
        }
        if (sqlQueryExpression != null) {
            return;
        }
        SqlResultSetExpression sqlResultSetExpression2 = query;
        if (sqlResultSetExpression2 != null) {
            PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)sqlResultSetExpression2;
            boolean withSelf$iv2 = false;
            boolean $i$f$parentOfType2 = false;
            v4 = (SqlDmlInstruction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, SqlDmlInstruction.class, (boolean)true);
        } else {
            v4 = instruction2 = null;
        }
        if (instruction2 != null) {
            SqlTableType sqlTableType = instruction2.getTargetType();
            Intrinsics.checkNotNullExpressionValue((Object)sqlTableType, (String)"getTargetType(...)");
            this.processColumnElements(sqlTableType, consumer2);
            return;
        }
        PsiElement $this$parentOfType_u24default$iv3 = this.target;
        boolean withSelf$iv3 = false;
        boolean $i$f$parentOfType3 = false;
        SqlCreateViewStatement createView = (SqlCreateViewStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv3, SqlCreateViewStatement.class, (boolean)true);
        if (createView != null) {
            int n;
            SqlDefinition[] aliases = createView.getColumnAliases();
            int i2 = this.indexRange.getFirst();
            if (i2 <= (n = Math.min(this.indexRange.getLast(), aliases.length - 1))) {
                while (true) {
                    consumer2.invoke((Object)aliases[i2], (Object)aliases[i2].getName());
                    if (i2 == n) break;
                    ++i2;
                }
            }
        }
    }

    private final void processColumnElements(SqlTableType sqlType, Function2<? super PsiElement, ? super String, Unit> consumer2) {
        int n;
        int id = this.indexRange.getFirst();
        if (id <= (n = Math.min(this.indexRange.getLast(), sqlType.getColumnCount() - 1))) {
            while (true) {
                consumer2.invoke((Object)sqlType.getColumnElement(id), (Object)sqlType.getColumnName(id));
                if (id == n) break;
                ++id;
            }
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element2, boolean strict) {
        return Companion.getInstance(element2, strict);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element2) {
        return Companion.getInstance(element2);
    }

    public /* synthetic */ SqlValuesToColumnMapper(PsiElement target2, IntRange indexRange, DefaultConstructorMarker $constructor_marker) {
        this(target2, indexRange);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/sql/SqlValuesToColumnMapper$Companion;", "", "()V", "getInstance", "Lcom/intellij/sql/SqlValuesToColumnMapper;", "element", "Lcom/intellij/psi/PsiElement;", "strict", "", "intellij.database.sql.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element2, boolean strict) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            IntRange intRange = SqlImplUtil.getImmediateColumnSourceIndices(element2, null, strict);
            if (intRange == null) {
                return null;
            }
            IntRange indexRange = intRange;
            return new SqlValuesToColumnMapper(element2, indexRange, null);
        }

        public static /* synthetic */ SqlValuesToColumnMapper getInstance$default(Companion companion, PsiElement psiElement, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.getInstance(psiElement, bl);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final SqlValuesToColumnMapper getInstance(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            return com.intellij.sql.SqlValuesToColumnMapper$Companion.getInstance$default(this, element2, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

