/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.DynamicBundle;
import com.intellij.database.util.SqlDialects;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlFrameworkSupportProvider
extends FrameworkSupportProvider {
    @NonNls
    private static final String ID = "sql:dialects";

    public SqlFrameworkSupportProvider() {
        super(ID, SqlBundle.message((String)"sql.framework.support.provider.title", (Object[])new Object[0]));
    }

    public Icon getIcon() {
        return DatabaseIcons.Sql;
    }

    @NotNull
    public FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel model2) {
        if (model2 == null) {
            SqlFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        return new SqlSupportConfigurable(model2.getProject());
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            SqlFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/SqlFrameworkSupportProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForModuleType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SqlSupportConfigurable
    extends FrameworkSupportConfigurable {
        private JComboBox<SqlLanguageDialect> myComboBox;
        private JPanel myMainPanel;
        private final Project myProject;

        SqlSupportConfigurable(Project project) {
            Object defaultTitle;
            this.myProject = project;
            Object[] objectArray = new Object[]{};
            this.$$$setupUI$$$();
            String defaultPrefix = SqlBundle.message((String)"sql.framework.support.provider.project.default", (Object[])objectArray);
            if (this.myProject != null) {
                SqlLanguageDialect projectLang = SqlDialectMappings.getInstance(this.myProject).getMapping(null);
                defaultTitle = defaultPrefix + " (" + projectLang.getDisplayName() + ")";
            } else {
                defaultTitle = defaultPrefix;
            }
            this.myComboBox.setEditable(false);
            ArrayList<SqlLanguageDialect> dialects = new ArrayList<SqlLanguageDialect>(SqlDialects.getTopLevelSqlDialects());
            dialects.sort(LanguageUtil.LANGUAGE_COMPARATOR);
            dialects.add(0, null);
            this.myComboBox.setModel((ComboBoxModel<SqlLanguageDialect>)new CollectionComboBoxModel(dialects, null));
            this.myComboBox.setRenderer((ListCellRenderer<SqlLanguageDialect>)SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> SqlSupportConfigurable.lambda$new$0((String)defaultTitle, arg_0, arg_1, arg_2)));
        }

        public JComponent getComponent() {
            return this.myMainPanel;
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel model2, @Nullable Library library) {
            Object o2;
            if (module == null) {
                SqlSupportConfigurable.$$$reportNull$$$0(0);
            }
            if (model2 == null) {
                SqlSupportConfigurable.$$$reportNull$$$0(1);
            }
            if (!((o2 = this.myComboBox.getSelectedItem()) instanceof SqlLanguageDialect)) {
                return;
            }
            SqlLanguageDialect dialect = (SqlLanguageDialect)o2;
            SqlDialectMappings mappings = SqlDialectMappings.getInstance(module.getProject());
            for (VirtualFile root2 : model2.getContentRoots()) {
                mappings.setMapping(root2, dialect);
            }
        }

        private static /* synthetic */ void lambda$new$0(String defaultTitle, JBLabel label2, SqlLanguageDialect value2, int index2) {
            if (value2 != null) {
                label2.setIcon(SqlFileType.INSTANCE.getIcon());
                label2.setText(value2.getDisplayName());
            } else {
                label2.setText(defaultTitle);
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SqlBundle", SqlSupportConfigurable.class).getString("label.text.default.dialect"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JComboBox jComboBox = new JComboBox();
            this.myComboBox = jComboBox;
            jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            jLabel.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c2 = '\u0000';
            int n = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) == '&') {
                    if (++j == string.length()) break;
                    if (!bl && string.charAt(j) != '&') {
                        bl = true;
                        c2 = string.charAt(j);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(j));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c2);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/SqlFrameworkSupportProvider$SqlSupportConfigurable";
            objectArray[2] = "addSupport";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

