/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcEngineUtils;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DdlMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsCollector;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.ui.DataSourcesSideTab;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorConsumer;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DdlMappingSideTab;
import com.intellij.database.view.ui.DriversSideTab;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.DefaultTabPainterAdapter;
import com.intellij.ui.tabs.impl.JBDefaultTabPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.themes.DefaultTabTheme;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DatabaseConfigEditorImpl
extends SettingsEditor<DataSourceSettings>
implements DatabaseConfigEditor,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance(DatabaseConfigEditorImpl.class);
    private final DatabaseCredentials myDatabaseCredentials;
    private final SimpleModificationTracker myModificationTracker;
    private final DataSourceSettings mySettings;
    final JPanel myRootPanel;
    private final JPanel myRightPanel;
    private final JPanel myInfoPanel;
    private SidePanelItem<?, ?> mySelectedItem;
    private final ValidationComponent myValidationComponent;
    private final ValidationComponent myErrorInfoComponent;
    final DataSourceProblemsCollector<SidePanelItem<?, ?>> myErrorsCollector;
    private final UserDataHolderBase myUserDataHolder;
    private boolean myFilling;
    private History myHistory;
    private JBTabs mySidePanels;
    final DataSourcesSideTab myDsSideTab;
    final DriversSideTab myDrSideTab;
    final DdlMappingSideTab myMappingSideTab;
    private List<Progressive> myOnApplyTasks;
    private final CoroutineScope myCoroutineScope;

    public boolean isUsed(DatabaseDriver driver2) {
        return this.myDsSideTab.isUsed(driver2);
    }

    DatabaseConfigEditorImpl(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(0);
        }
        this.myModificationTracker = new SimpleModificationTracker();
        this.myUserDataHolder = new UserDataHolderBase();
        this.myFilling = false;
        this.myHistory = new History((Place.Navigator)this);
        int newDsAmount = settings.newDataSources.size();
        int newDrAmount = settings.newDrivers.size();
        if (newDsAmount > 10 || newDrAmount > 10) {
            LOG.info("Data Sources: " + newDsAmount + ", Drivers: " + newDrAmount);
        }
        this.mySettings = settings;
        this.myDatabaseCredentials = this.mySettings.newCredentials == null ? DatabaseCredentialsUi.newUIInstance() : this.mySettings.newCredentials;
        this.myRootPanel = new MyRootPanel(new BorderLayout());
        UIUtil.putClientProperty((JComponent)this.myRootPanel, (Key)UserActivityWatcher.DO_NOT_WATCH, (Object)true);
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(0, 5));
        this.myValidationComponent = new ValidationComponent(false);
        this.myErrorInfoComponent = new ValidationComponent(true);
        this.myInfoPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.myDsSideTab = new DataSourcesSideTab(this);
        this.myDrSideTab = new DriversSideTab(this);
        this.myMappingSideTab = new DdlMappingSideTab(this);
        this.myErrorsCollector = new DataSourceProblemsCollector(this.myDsSideTab.myErrorsConfigurable);
        Disposer.register((Disposable)this, this.myErrorsCollector);
        OnePixelSplitter mySplitter = new OnePixelSplitter(false, 0.3f);
        mySplitter.setFirstComponent(this.createLeftPanel());
        mySplitter.setSecondComponent((JComponent)this.myRightPanel);
        this.myRootPanel.add((Component)mySplitter, "Center");
        Dimension d2 = this.myRootPanel.getPreferredSize();
        d2.width = Math.max(d2.width, 800);
        d2.height = Math.max(d2.height, 600);
        this.myRootPanel.setPreferredSize(d2);
        this.putUserData(DataSourceConfigurable.DRIVER_VARIANTS_PROVIDER, dataSource2 -> this.myDrSideTab.getDrivers((JBIterable<LocalDataSource>)JBIterable.of((Object)dataSource2)).toList());
        UiNotifyConnector.doWhenFirstShown((JComponent)this.myRootPanel, () -> {
            this.setSelectedEditor(null);
            this.resetTreeModel(this.mySettings);
        });
        DatabaseArtifactManager.getInstance().checkForUpdates();
        this.myCoroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)EmptyCoroutineContext.INSTANCE);
        Disposer.register((Disposable)this, () -> CoroutineScopeKt.cancel((CoroutineScope)this.myCoroutineScope, null));
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DatabaseArtifactManager.TOPIC, v2 -> ContainerUtil.process(this.myDrSideTab.getSidePanelItems(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                List<Object> artifacts;
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)driverItem.getConfigurable();
                DatabaseDriverImpl driver2 = configurable == null ? null : configurable.getTempDriver();
                List<Object> list = artifacts = driver2 == null ? Collections.emptyList() : driver2.getArtifacts();
                if (!artifacts.isEmpty() && (v2 == null || ContainerUtil.exists(artifacts, a -> DatabaseDriverImpl.matches(a, v2)))) {
                    configurable.resetFromTemp();
                    DatabaseConfigEditorImpl.this.updateDriverDependants(driver2);
                    driverItem.resetModifiedCache();
                }
                return true;
            }
        }));
    }

    private boolean processSidePanelItems(@NotNull Processor<SidePanelItem<?, ?>> processor2) {
        if (processor2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(1);
        }
        return ContainerUtil.process(this.getSidePanelItems(), processor2);
    }

    private JBIterable<SidePanelItem<?, ?>> getSidePanelItems() {
        return this.getSideTabs().flatten(DatabaseConfigSideTab::getSidePanelItems);
    }

    private JBIterable<DatabaseConfigSideTab> getSideTabs() {
        return JBIterable.of((Object[])new DatabaseConfigSideTab[]{this.myDsSideTab, this.myDrSideTab, this.myMappingSideTab});
    }

    @Nullable
    private SidePanelItem<?, ?> getSidePanelItem(@Nullable Object key2) {
        return (SidePanelItem)this.getSideTabs().filterMap(t -> t.getSidePanelItem(key2)).first();
    }

    void updateDriverDependants(DatabaseDriver driver2) {
        final DatabaseDriver actualDriver = this.getTempTargetOrTarget(driver2);
        SidePanelItem<?, ?> item = this.getSidePanelItem(driver2);
        final boolean modified = item != null && item.isModified();
        ContainerUtil.process(this.myDsSideTab.getSidePanelItems(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                DatabaseDriver dataSourceDriver;
                LocalDataSource dataSource2 = dataSourceItem.extractActualLocalDataSource();
                DatabaseDriver databaseDriver = dataSourceDriver = dataSource2 == null ? null : dataSource2.getDatabaseDriver();
                if (dataSourceDriver != null && actualDriver == DatabaseConfigEditorImpl.this.getTempTargetOrTarget(dataSourceDriver)) {
                    AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)dataSourceItem.getConfigurable();
                    if (configurable != null) {
                        configurable.onDepActivity();
                    } else if (modified) {
                        DatabaseConfigEditorImpl.createEditorIfNeeded(dataSourceItem);
                    }
                    DatabaseConfigEditorImpl.this.myErrorsCollector.update(dataSourceItem);
                }
                return true;
            }
        });
    }

    private void updateSidePanelImpl() {
        final SidePanelItem<?, ?> item = this.mySelectedItem;
        if (item == null) {
            return;
        }
        this.myErrorsCollector.update(item);
        this.updateValidationProblem(this.mySelectedItem);
        this.getSideTabs().forEach(DatabaseConfigSideTab::revalidate);
        if (item.getObject() instanceof DatabaseDriver) {
            ContainerUtil.process(this.myDsSideTab.getSidePanelItems(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dsItem) {
                    LocalDataSource source = dsItem.extractActualLocalDataSource();
                    if (source == null || source.getDatabaseDriver() != item.getObject()) {
                        return true;
                    }
                    DataSourceConfigurable conf = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(dsItem), DataSourceConfigurable.class);
                    if (conf != null) {
                        conf.actualizeDriver();
                    }
                    return true;
                }
            });
        }
    }

    public void onUiActivity(SidePanelItem<?, ?> item) {
        if (item == this.mySelectedItem) {
            this.stateChangedAsyncInner();
            this.updateSidePanelImpl();
        } else {
            Object configurable = item.getConfigurable();
            if (configurable instanceof AbstractDatabaseConfigurable) {
                ((AbstractDatabaseConfigurable)configurable).onUserActivity();
            }
        }
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                DatabaseConfigEditorImpl.this.myMappingSideTab.getSidePanelItems().forEach(SidePanelItem::onDepActivity);
                return true;
            }

            @Override
            boolean visit(SidePanelItem.MappingItem mappingItem) {
                DatabaseConfigEditorImpl.this.myDsSideTab.getSidePanelItems().forEach(SidePanelItem::onDepActivity);
                return true;
            }
        });
        this.fireEditorStateChanged();
    }

    private void stateChangedAsyncInner() {
        Object configurable;
        if (this.myFilling) {
            return;
        }
        this.clearModifiedCache();
        Object v0 = configurable = this.mySelectedItem == null ? null : this.mySelectedItem.getConfigurable();
        if (configurable instanceof AbstractDatabaseConfigurable) {
            ((AbstractDatabaseConfigurable)configurable).onUserActivity();
        }
        if (configurable instanceof DatabaseDriverConfigurable) {
            this.updateDriverDependants(((DatabaseDriverConfigurable)configurable).getTempDriver());
        }
    }

    @Nullable
    private Place getPlace(@Nullable Object object) {
        SidePanelItem<?, ?> item = this.getSidePanelItem(object);
        return item == null ? null : item.getPlace();
    }

    @Nullable
    private SidePanelItem<?, ?> getItem(@Nullable Place place) {
        SidePanelItem<?, ?> item = SidePanelItem.getItem(place);
        if (item != null) {
            item = this.getSidePanelItem(item.getObject());
        }
        return item;
    }

    @Override
    public void clearModifiedCache() {
        this.myModificationTracker.incModificationCount();
        this.processSidePanelItems(item -> {
            item.resetModifiedCache();
            return true;
        });
    }

    @Override
    public void refresh() {
        this.updateSidePanelImpl();
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.myRootPanel);
        if (modalityState == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(2);
        }
        return modalityState;
    }

    @Override
    @NotNull
    public Collection<DbDataSource> getDataSources() {
        Collection<DbDataSource> collection2 = this.myDsSideTab.getAllDataSources(this.mySettings);
        if (collection2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(3);
        }
        return collection2;
    }

    @Override
    public JBIterable<DdlMapping> getMappings() {
        return JBIterable.from(this.myMappingSideTab.getAllMappings(this.mySettings));
    }

    @Override
    public String getProblem(Object target2) {
        SidePanelItem<?, ?> item = this.getSidePanelItem(target2);
        Set<DataSourceProblem> problems = item == null ? null : this.myErrorsCollector.getProblems(item);
        DataSourceProblem problem = item != null ? (DataSourceProblem)ContainerUtil.getFirstItem(problems) : null;
        return problem == null ? null : problem.getText().getDescription();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(4);
        }
        return (T)this.myUserDataHolder.getUserData(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
        if (key2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(5);
        }
        this.myUserDataHolder.putUserData(key2, value2);
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @NotNull
    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        SidePanelItem<?, ?> item = this.getItem(place);
        if (item != this.mySelectedItem) {
            this.setSelectedEditor(item);
            if (this.mySelectedItem != null) {
                this.myHistory.pushQueryPlace();
                if (requestFocus) {
                    JComponent toFocus;
                    Object configurable = this.mySelectedItem.getConfigurable();
                    JComponent jComponent = toFocus = configurable == null ? null : configurable.getPreferredFocusedComponent();
                    if (toFocus != null) {
                        UiNotifyConnector.doWhenFirstShown((JComponent)toFocus, () -> IdeFocusManager.getInstance((Project)this.mySettings.facade.getProject()).requestFocus((Component)toFocus, false));
                    }
                }
            }
            DatabaseConfigSideTab sideTab = this.getSideTab(place);
            for (DatabaseConfigSideTab other : this.getSideTabs()) {
                if (other == sideTab) continue;
                other.resetSelection();
            }
            this.mySidePanels.select(this.getInfo(sideTab), false);
            sideTab.select(place);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(6);
        }
        return actionCallback;
    }

    private TabInfo getInfo(DatabaseConfigSideTab tab2) {
        return (TabInfo)ContainerUtil.find((Iterable)this.mySidePanels.getTabs(), t -> t.getObject() == tab2);
    }

    @NotNull
    private DatabaseConfigSideTab getSideTab(@Nullable Object object) {
        DatabaseConfigSideTab tab2;
        Place place = this.getPlace(object);
        if (place == null && object != null && (tab2 = (DatabaseConfigSideTab)this.getSideTabs().find(t -> t.isMine(object))) != null) {
            DatabaseConfigSideTab databaseConfigSideTab = tab2;
            if (databaseConfigSideTab == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(7);
            }
            return databaseConfigSideTab;
        }
        return this.getSideTab(place);
    }

    @NotNull
    private DatabaseConfigSideTab getSideTab(@Nullable Place place) {
        DatabaseConfigSideTab res2 = (DatabaseConfigSideTab)this.getSideTabs().find(t -> t.getItem(place) != null);
        if (res2 != null) {
            DatabaseConfigSideTab databaseConfigSideTab = res2;
            if (databaseConfigSideTab == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(8);
            }
            return databaseConfigSideTab;
        }
        TabInfo selected = this.mySidePanels.getSelectedInfo();
        res2 = selected == null ? null : (DatabaseConfigSideTab)ObjectUtils.tryCast((Object)selected.getObject(), DatabaseConfigSideTab.class);
        DatabaseConfigSideTab databaseConfigSideTab = res2 == null ? this.getDefaultSideTab() : res2;
        if (databaseConfigSideTab == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(9);
        }
        return databaseConfigSideTab;
    }

    @NotNull
    private DatabaseConfigSideTab getDefaultSideTab() {
        DatabaseConfigSideTab databaseConfigSideTab = Objects.requireNonNull((DatabaseConfigSideTab)this.getSideTabs().first());
        if (databaseConfigSideTab == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(10);
        }
        return databaseConfigSideTab;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(11);
        }
        SidePanelItem.setItem(place, this.mySelectedItem);
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.mySettings.selection != null && this.mySelectedItem != null && this.mySelectedItem.getObject() == this.mySettings.selection) {
            JComponent toFocus;
            Object configurable = this.mySelectedItem.getConfigurable();
            JComponent jComponent = toFocus = configurable == null ? null : configurable.getPreferredFocusedComponent();
            if (toFocus != null) {
                return toFocus;
            }
        }
        return this.getDefaultSideTab().getList();
    }

    protected void disposeEditor() {
        super.disposeEditor();
        this.getSideTabs().forEach(DatabaseConfigSideTab::disposeUi);
        this.mySettings.newDataSources.removeIf(o2 -> !o2.isValid());
    }

    public String getHelpTopic() {
        Object configurable = this.mySelectedItem == null ? null : this.mySelectedItem.getConfigurable();
        return configurable == null ? null : configurable.getHelpTopic();
    }

    public boolean isAnyEditorModified() {
        return this.getSideTabs().find(DatabaseConfigSideTab::isAnyEditorModified) != null;
    }

    protected void resetEditorFrom(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(12);
        }
        this.resetTreeModel(settings);
        this.processSidePanelItems(item -> {
            if (item.isModified()) {
                ((Configurable)Objects.requireNonNull(item.getConfigurable())).reset();
            }
            return true;
        });
        this.clearModifiedCache();
    }

    protected void applyEditorTo(@NotNull DataSourceSettings settings) throws ConfigurationException {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(13);
        }
        this.myOnApplyTasks = new ArrayList<Progressive>();
        for (DatabaseConfigSideTab tab2 : this.getSideTabs()) {
            tab2.onApply();
        }
        this.clearModifiedCache();
        this.refillSidePanel(this.mySettings, true);
        final List<Progressive> queue = this.myOnApplyTasks;
        this.myOnApplyTasks = null;
        new Task.Backgroundable(this.mySettings.facade.getProject(), DatabaseBundle.message("progress.title.DatabaseConfigEditor.applying.changes.to.data.sources", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                for (int i2 = 0; i2 < queue.size(); ++i2) {
                    Progressive task = (Progressive)queue.get(i2);
                    indicator.setFraction((double)i2 / (double)queue.size());
                    try {
                        task.run(indicator);
                        continue;
                    }
                    catch (RuntimeException e2) {
                        LOG.warn((Throwable)e2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$5", "run"));
            }
        }.queue();
        this.mySettings.facade.clearCaches();
    }

    private void resetTreeModel(DataSourceSettings settings) {
        this.refillSidePanel(settings, false);
        this.navigateTo(this.mySettings.selection, false);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(14);
        }
        return jPanel;
    }

    void ensureErrorProviderExistence(@NotNull SidePanelItem<?, ?> item) {
        DataSourceProblemsProvider provider;
        if (item == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(15);
        }
        if ((provider = (DataSourceProblemsProvider)ObjectUtils.tryCast(item, DataSourceProblemsProvider.class)) == null || this.myErrorsCollector.contains(item)) {
            return;
        }
        this.myErrorsCollector.add(item, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refillSidePanel(@NotNull DataSourceSettings settings, boolean keepSelection) {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(16);
        }
        this.myFilling = true;
        try {
            for (DatabaseConfigSideTab tab2 : this.getSideTabs()) {
                tab2.refillSidePanel(settings, keepSelection);
            }
        }
        finally {
            this.myFilling = false;
        }
    }

    public int getDataSourceGroup(@Nullable Object object) {
        return switch (Kind.kindOf(object)) {
            case Kind.DATABASE -> 2;
            case Kind.DRIVER -> 1;
            default -> 0;
        };
    }

    private JComponent createLeftPanel() {
        this.mySidePanels = new JBTabsImpl(this.getProject()){

            protected TabPainterAdapter createTabPainterAdapter() {
                return new DefaultTabPainterAdapter((JBTabPainter)new JBDefaultTabPainter((TabTheme)new DefaultTabTheme(){

                    public Color getBackground() {
                        return UIUtil.SIDE_PANEL_BACKGROUND;
                    }

                    @NotNull
                    public Color getInactiveColoredTabBackground() {
                        Color color = UIUtil.SIDE_PANEL_BACKGROUND;
                        if (color == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return color;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$6$1", "getInactiveColoredTabBackground"));
                    }
                }));
            }
        };
        this.mySidePanels.getComponent().setOpaque(true);
        if (this.mySidePanels instanceof JBTabbedPane) {
            ((JBTabbedPane)this.mySidePanels).setTabComponentInsets(null);
        }
        this.mySidePanels.getComponent().setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        for (DatabaseConfigSideTab tab2 : this.getSideTabs()) {
            TabInfo info2 = new TabInfo(tab2.getComponent());
            info2.setDefaultStyle(1);
            info2.setText(tab2.getName());
            info2.setObject((Object)tab2);
            this.mySidePanels.addTab(info2);
        }
        return this.mySidePanels.getComponent();
    }

    @NotNull
    public Project getProject() {
        Project project = this.mySettings.facade.getProject();
        if (project == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(17);
        }
        return project;
    }

    @Nullable
    public String getObjectName(@Nullable Object object) {
        SidePanelItem<?, ?> item = this.getSidePanelItem(object);
        return item == null ? null : item.getName();
    }

    static Configurable createEditorIfNeeded(@Nullable SidePanelItem<?, ?> item) {
        if (item != null && item.getConfigurable() == null) {
            item.createConfigurable();
        }
        return item == null ? null : (Configurable)item.getConfigurable();
    }

    private void setSelectedEditor(@Nullable SidePanelItem<?, ?> item) {
        if (item == this.mySelectedItem && this.myRightPanel.getComponentCount() != 0) {
            return;
        }
        this.myRightPanel.removeAll();
        this.myInfoPanel.removeAll();
        this.mySelectedItem = item;
        DatabaseConfigEditorImpl.createEditorIfNeeded(item);
        if (item != null && item.getConfigurable() != null) {
            AbstractDatabaseConfigurable dbConfigurable = (AbstractDatabaseConfigurable)ObjectUtils.tryCast(item.getConfigurable(), AbstractDatabaseConfigurable.class);
            JComponent bottom = null;
            if (dbConfigurable != null) {
                dbConfigurable.beforeShowNotify();
                bottom = dbConfigurable.getCommonBar();
            }
            this.myRightPanel.add((Component)Objects.requireNonNull(item.getComponent()), "Center");
            this.myInfoPanel.add(this.myErrorInfoComponent);
            this.myInfoPanel.add(this.myValidationComponent);
            if (bottom != null) {
                this.myInfoPanel.add(bottom);
            }
            this.myRightPanel.add((Component)this.myInfoPanel, "South");
        } else {
            JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
            panel2.setBorder(JBUI.Borders.empty((int)10));
            String placeholder = "/*placeholder*/";
            String message2 = DatabaseBundle.message("DatabaseConfigEditor.press.the.0.button.to.create.a.new.data.source", placeholder);
            panel2.add(new JLabel(StringUtil.substringBefore((String)message2, (String)placeholder)));
            ActionButton addIcon = new ActionButton(this.myDsSideTab.myAddAction, this.myDsSideTab.myAddAction.getTemplatePresentation().clone(), "MainToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                protected DataContext getDataContext() {
                    return ActionToolbar.getDataContextFor(DatabaseConfigEditorImpl.this.myDsSideTab.getList());
                }
            };
            addIcon.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            panel2.add((Component)addIcon);
            panel2.add(new JLabel(StringUtil.substringAfter((String)message2, (String)placeholder)));
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel2, (boolean)true);
            this.myRightPanel.add((Component)scrollPane, "Center");
        }
        this.updateCurrentValidationProblem();
        UIUtil.setupEnclosingDialogBounds((JComponent)this.myRootPanel);
    }

    @Override
    public boolean isObjectNameUnique(@Nullable Object source, String name2) {
        Kind kind = Kind.kindOf(source);
        if (kind == Kind.OTHER) {
            return true;
        }
        String group2 = DatabaseConfigEditorImpl.getGroup(source);
        return this.processSidePanelItems(item -> {
            Object o2 = item.getObject();
            if (Kind.kindOf(o2) != kind) {
                return true;
            }
            if (o2 == source || o2 instanceof DbElement && ((DbElement)o2).getDelegate() == source) {
                return true;
            }
            return !Objects.equals(item.getName(), name2) || !Objects.equals(DatabaseConfigEditorImpl.getGroup(o2), group2);
        });
    }

    @Nullable
    private static String getGroup(@Nullable Object source) {
        return source instanceof RawDataSource ? ((RawDataSource)source).getGroupName() : null;
    }

    @Override
    @NotNull
    public String generateObjectName(final @Nullable Object source, String baseName) {
        final HashSet<String> existingNames = new HashSet<String>();
        DatabaseConfigSideTab tab2 = this.getSideTab(source);
        ContainerUtil.process(tab2.getSidePanelItems(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                if (((DbDataSourceImpl)dataSourceItem.getObject()).getDelegate() != source) {
                    existingNames.add(dataSourceItem.getName());
                }
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                if (driverItem.getObject() != source) {
                    existingNames.add(driverItem.getName());
                }
                return true;
            }

            @Override
            boolean visit(SidePanelItem.MappingItem mappingItem) {
                if (mappingItem.getObject() != source) {
                    existingNames.add(mappingItem.getName());
                }
                return true;
            }
        });
        String string = DbUtil.generateUniqueName(baseName, existingNames);
        if (string == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public DataSourceSettings getSettings() {
        DataSourceSettings dataSourceSettings = this.mySettings;
        if (dataSourceSettings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(19);
        }
        return dataSourceSettings;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(20);
        }
        return simpleModificationTracker;
    }

    @Override
    @NotNull
    public ActionCallback navigateTo(@Nullable Object object, boolean requestFocus) {
        SidePanelItem<?, ?> item;
        Place place = this.getPlace(object);
        if (place == null && (item = this.findItemByTemp(object)) != null) {
            place = item.getPlace();
        }
        ActionCallback actionCallback = this.navigateTo(place, requestFocus);
        if (actionCallback == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(21);
        }
        return actionCallback;
    }

    @Nullable
    private SidePanelItem<?, ?> findItemByTemp(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return (SidePanelItem)this.getSidePanelItems().find(item -> {
            AbstractDatabaseConfigurable configurable = (AbstractDatabaseConfigurable)ObjectUtils.tryCast(item.getConfigurable(), AbstractDatabaseConfigurable.class);
            return configurable != null && configurable.isTempTarget(object);
        });
    }

    @Override
    @Nullable
    public <T, C> C getConfigurable(@Nullable T target2, boolean createIfNeeded, @NotNull Class<C> clazz) {
        Condition isTarget;
        JBIterable<SidePanelItem<?, ?>> items2;
        SidePanelItem<?, ?> item;
        if (clazz == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(22);
        }
        if ((item = (SidePanelItem<?, ?>)(items2 = this.getSidePanelItems()).find(arg_0 -> DatabaseConfigEditorImpl.lambda$getConfigurable$15(isTarget = o2 -> o2 == target2 || o2 instanceof DbElement && ((DbElement)o2).getDelegate() == target2, arg_0))) == null) {
            item = this.findItemByTemp(target2);
        }
        if (item == null) {
            return null;
        }
        if (item.getConfigurable() == null && createIfNeeded) {
            item.createConfigurable();
        }
        return (C)ObjectUtils.tryCast(item.getConfigurable(), clazz);
    }

    @Override
    @NotNull
    public <T> T getTempTargetOrTarget(@NotNull T target2) {
        AbstractDatabaseConfigurable configurable;
        if (target2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(23);
        }
        T t = (configurable = this.getConfigurable(target2, false, AbstractDatabaseConfigurable.class)) == null ? target2 : configurable.getTempTarget();
        if (t == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(24);
        }
        return t;
    }

    @Override
    public void showErrorNotification(@NotNull AbstractDatabaseConfigurable<?> source, @NotNull Object id, @Nullable Exception e2) {
        if (source == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(25);
        }
        if (id == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(26);
        }
        if (e2 == null) {
            this.showErrorNotification(source, id, null, null, new Object[0]);
            return;
        }
        LocalDataSource dataSource2 = source instanceof DataSourceConfigurable ? (LocalDataSource)((DataSourceConfigurable)source).getDataSource() : null;
        ErrorInfo errorInfo = JdbcEngineUtils.getErrorInfo(e2, dataSource2);
        String message2 = errorInfo.getMessage();
        if (StringUtil.isEmpty((String)message2)) {
            return;
        }
        @NlsSafe StringBuilder longText = new StringBuilder();
        longText.append(message2);
        List fixes = errorInfo.getFixes();
        Object[] actions = new Object[fixes.size()];
        for (int i2 = 0; i2 < fixes.size(); ++i2) {
            ErrorInfo.Fix fix = (ErrorInfo.Fix)fixes.get(i2);
            actions[i2] = () -> DataSourceUiUtil.applyFix(source.getProject(), fix, source.getController());
            longText.append("&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"ACTION").append(i2).append("\">").append(fix.getName()).append("</a>");
        }
        Pair<@NlsContexts.NotificationContent String, Object[]> patched = DatabaseConfigEditorImpl.patchMessages(longText.toString(), actions);
        if (patched == null) {
            this.showErrorNotification(source, id, DatabaseBundle.message("notification.title.DatabaseConfigEditor.error", new Object[0]), longText.toString(), actions);
        } else {
            this.showErrorNotification(source, id, DatabaseBundle.message("notification.title.DatabaseConfigEditor.error", new Object[0]), (String)patched.first, (Object[])patched.second);
        }
    }

    private static @Nullable Pair<@NlsContexts.NotificationContent String, Object[]> patchMessages(@NlsContexts.NotificationContent @Nullable String message2, Object ... linkActions) {
        if (linkActions == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(27);
        }
        if (linkActions.length != 0 || message2 == null) {
            return null;
        }
        Object shortText = message2;
        int div = message2.indexOf(10);
        if (div > 5) {
            shortText = ((String)shortText).substring(0, div);
        }
        for (String exName : Arrays.asList("java.lang.IllegalArgumentException", "com.intellij.execution.ExecutionException", "com.jcraft.jsch.")) {
            int offset;
            if (((String)shortText).length() < exName.length() + 10 || !((String)shortText).startsWith(exName)) continue;
            int len = exName.length();
            int n = exName.endsWith(".") ? len : (offset = ((String)shortText).startsWith(": ", len) ? len + 2 : -1);
            if (offset < 0) continue;
            shortText = ((String)shortText).substring(offset);
        }
        if (!Objects.equals(message2, shortText = StringUtil.escapeXmlEntities((String)StringUtil.trimLog((String)shortText, (int)80)))) {
            shortText = (String)shortText + " (<a href=\"$ACTION0\">view</a>)";
        }
        class ViewAction
        implements Runnable {
            private final @NlsContexts.NotificationContent @Nullable String myMessage;
            final /* synthetic */ String val$message;

            ViewAction(String string) {
                this.val$message = string;
                this.myMessage = this.val$message;
            }

            @Override
            public void run() {
                Messages.showIdeaMessageDialog(null, (String)this.myMessage, (String)DatabaseBundle.message("message.title.connection.error", new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
            }

            public boolean equals(Object o2) {
                if (this == o2) {
                    return true;
                }
                if (o2 == null || this.getClass() != o2.getClass()) {
                    return false;
                }
                ViewAction action = (ViewAction)o2;
                return Objects.equals(this.myMessage, action.myMessage);
            }

            public int hashCode() {
                return this.myMessage != null ? this.myMessage.hashCode() : 0;
            }
        }
        return Pair.create((Object)shortText, (Object)new Object[]{new ViewAction(message2)});
    }

    @Override
    public void showErrorNotification(@NotNull AbstractDatabaseConfigurable<?> source, @NotNull Object id, @NlsContexts.NotificationTitle @Nullable String title, @NlsContexts.NotificationContent @Nullable String message2, Object ... linkActions) {
        Pair<String, Object[]> patched;
        if (source == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(28);
        }
        if (id == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(29);
        }
        if (linkActions == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(30);
        }
        if ((patched = DatabaseConfigEditorImpl.patchMessages(message2, linkActions)) != null) {
            message2 = (String)patched.first;
            linkActions = (Object[])patched.second;
        }
        DataSourceProblem dataSourceProblem = title != null && message2 != null ? new DataSourceProblem(source, id, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(title, message2, message2, linkActions), null) : null;
        this.processSidePanelItems(item -> {
            if (item.getConfigurable() == source) {
                if (dataSourceProblem != null || item.getDataSourceProblem() == null || Comparing.equal((Object)item.getDataSourceProblem().getId(), (Object)id)) {
                    item.setDataSourceProblem(dataSourceProblem);
                }
                return false;
            }
            return true;
        });
        if (this.mySelectedItem != null && this.mySelectedItem.getConfigurable() == source) {
            this.updateValidationProblem(this.mySelectedItem);
        }
    }

    @Override
    @NotNull
    public DatabaseCredentials getSecretService() {
        DatabaseCredentials databaseCredentials = this.myDatabaseCredentials;
        if (databaseCredentials == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(31);
        }
        return databaseCredentials;
    }

    @Override
    @Nullable
    public AnAction createResetAction(final @Nullable Configurable configurable) {
        if (configurable == null) {
            return null;
        }
        Ref itemRef = Ref.create();
        this.processSidePanelItems(sitem -> {
            if (sitem.getConfigurable() == configurable) {
                itemRef.set(sitem);
                return false;
            }
            return true;
        });
        final SidePanelItem item = (SidePanelItem)itemRef.get();
        if (item == null) {
            return null;
        }
        return new DumbAwareAction(DatabaseBundle.messagePointer("database.config.rollback.changes", new Object[0]), AllIcons.Actions.Rollback){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    9.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    9.$$$reportNull$$$0(1);
                }
                e2.getPresentation().setEnabledAndVisible(item.isModified());
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                if (e2 == null) {
                    9.$$$reportNull$$$0(2);
                }
                configurable.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$9";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$9";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Override
    @NotNull
    public List<AnAction> getAddLocalDataSourceActions(@Nullable Consumer<DasDataSource> callback) {
        List<AnAction> list = this.myDsSideTab.getAddActions(callback);
        if (list == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(32);
        }
        return list;
    }

    @Override
    public void onCreated(@NotNull Object target2) {
        if (target2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(33);
        }
        if (target2 instanceof RawDataSource) {
            RawDataSource ds = (RawDataSource)target2;
            DbPsiFacade facade = this.mySettings.facade;
            DataSourceManager<Class<?>> manager = DataSourceManager.byDataSource(facade.getProject(), ds.getClass());
            if (manager == null) {
                LOG.error("Unknown data source type " + target2.getClass().getSimpleName());
                return;
            }
            this.myDsSideTab.onDataSourceCreated(facade, manager, ds);
        } else if (target2 instanceof DatabaseDriver) {
            this.myDrSideTab.addNewDriverAndNavigate((DatabaseDriver)target2);
        } else if (target2 instanceof DdlMapping) {
            this.myMappingSideTab.addNewMappingAndNavigate((DdlMapping)target2);
        }
    }

    @Override
    public void onDriverDownloaded(@NotNull DatabaseDriver driver2) {
        DatabaseDriverConfigurable configurable;
        if (driver2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(34);
        }
        if ((configurable = this.getConfigurable(driver2, true, DatabaseDriverConfigurable.class)) != null) {
            configurable.resetFromTemp();
        }
        this.updateDriverDependants(driver2);
    }

    @Override
    public void onChangesApplied(@NotNull Progressive task) {
        if (task == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(35);
        }
        if (this.myOnApplyTasks == null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            throw new IllegalStateException("Should be called when applying");
        }
        this.myOnApplyTasks.add(task);
    }

    void updateCurrentValidationProblem() {
        this.updateValidationProblem(this.mySelectedItem);
    }

    private void updateValidationProblem(@Nullable SidePanelItem<?, ?> item) {
        DataSourceProblem error2 = item == null ? null : item.getDataSourceProblem();
        this.myErrorInfoComponent.updateWarning(error2);
        DataSourceProblem problem = (DataSourceProblem)ContainerUtil.getFirstItem(this.myErrorsCollector.getProblems(item));
        this.myValidationComponent.updateWarning(problem);
        if (item != null) {
            item.onDepActivity();
        }
    }

    @Override
    public void processAction(final Object action) {
        AbstractDatabaseConfigurable c2;
        Project project = this.mySettings.facade.getProject();
        if (action instanceof Runnable) {
            ((Runnable)action).run();
        } else if (action instanceof Computable) {
            ((Computable)action).compute();
        } else if (action instanceof DatabaseConfigEditorConsumer) {
            ((DatabaseConfigEditorConsumer)action).run(this);
        } else if (action instanceof FixWithProgress) {
            final FixWithProgress fixWithProgress = (FixWithProgress)action;
            final DatabaseConfigEditorImpl configEditor = this;
            new Task.Modal(project, fixWithProgress.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    fixWithProgress.run(indicator, configEditor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$10", "run"));
                }
            }.queue();
        } else if (action instanceof Progressive) {
            NamedProgressive named = (NamedProgressive)ObjectUtils.tryCast((Object)action, NamedProgressive.class);
            new Task.Modal(project, named == null ? "" : named.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    ((Progressive)action).run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$11", "run"));
                }
            }.queue();
        } else if (action instanceof DataSourceProblem.Navigate) {
            this.navigateTo(((DataSourceProblem.Navigate)action).target, false);
        } else if (action instanceof DataSourceProblem.NewUrlTemplate) {
            DataSourceProblem.NewUrlTemplate newUrlTemplate = (DataSourceProblem.NewUrlTemplate)action;
            DatabaseDriverConfigurable configurable = this.getConfigurable(newUrlTemplate.driver, true, DatabaseDriverConfigurable.class);
            this.addTemplate((DatabaseDriver)ObjectUtils.notNull((Object)(configurable == null ? null : configurable.getDriver()), (Object)newUrlTemplate.driver), newUrlTemplate.template);
        } else if (action instanceof DataSourceProblem.FocusDriverClass) {
            DataSourceProblem.FocusDriverClass focusDriverClass = (DataSourceProblem.FocusDriverClass)action;
            this.focusDriverClassSelector(focusDriverClass.driver);
        } else if (action instanceof ErrorInfo.Fix) {
            DataSourceUiUtil.applyFix(project, (ErrorInfo.Fix)action, this);
        }
        this.updateSidePanelImpl();
        AbstractDatabaseConfigurable abstractDatabaseConfigurable = c2 = this.mySelectedItem == null ? null : (AbstractDatabaseConfigurable)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), AbstractDatabaseConfigurable.class);
        if (c2 != null) {
            c2.onUserActivity();
        }
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.myCoroutineScope;
        if (coroutineScope == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(36);
        }
        return coroutineScope;
    }

    private void addTemplate(@NotNull DatabaseDriver driver2, @NotNull String template) {
        if (driver2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(37);
        }
        if (template == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(38);
        }
        this.navigateTo(driver2, false).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class);
            if (configurable == null) {
                return;
            }
            configurable.addNewUrlTemplate(template);
        });
    }

    private void focusDriverClassSelector(@NotNull DatabaseDriver driver2) {
        if (driver2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(39);
        }
        this.navigateTo(driver2, false).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class);
            if (configurable == null) {
                return;
            }
            configurable.focusDriverClassSelector();
        });
    }

    public void resurrectDriver(@Nullable DatabaseDriver driver2) {
        boolean isNew;
        if (driver2 == null) {
            return;
        }
        boolean bl = isNew = !DatabaseDriverManager.getInstance().getDrivers().contains(driver2);
        if (isNew && !this.mySettings.newDrivers.contains(driver2)) {
            this.mySettings.newDrivers.add(driver2);
        }
        this.myDrSideTab.undelete(driver2);
        DbUIUtil.invokeLater(() -> this.refillSidePanel(this.mySettings, true));
    }

    private static /* synthetic */ boolean lambda$getConfigurable$15(Condition isTarget, SidePanelItem o2) {
        return isTarget.value(o2.getObject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 8, 9, 10, 14, 17, 18, 19, 20, 21, 24, 31, 32, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 31: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkActions";
                break;
            }
            case 34: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModalityState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 6: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateTo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSideTab";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSideTab";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateObjectName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTargetOrTarget";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecretService";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddLocalDataSourceActions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processSidePanelItems";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 31: 
            case 32: 
            case 36: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ensureErrorProviderExistence";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "refillSidePanel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurable";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTempTargetOrTarget";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "patchMessages";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "onCreated";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "onDriverDownloaded";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "onChangesApplied";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "focusDriverClassSelector";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 8, 9, 10, 14, 17, 18, 19, 20, 21, 24, 31, 32, 36 -> new IllegalStateException(string);
        };
    }

    static class DataSourceSettings {
        final DbPsiFacade facade;
        @Nullable
        Object selection;
        final List<DbDataSource> newDataSources;
        final List<DatabaseDriver> newDrivers;
        final List<DdlMapping> newMappings;
        @Nullable
        final DatabaseCredentials newCredentials;

        DataSourceSettings(@NotNull DbPsiFacade psiFacade2, @Nullable DatabaseCredentials credentials) {
            if (psiFacade2 == null) {
                DataSourceSettings.$$$reportNull$$$0(0);
            }
            this.newDataSources = new ArrayList<DbDataSource>();
            this.newDrivers = new ArrayList<DatabaseDriver>();
            this.newMappings = new ArrayList<DdlMapping>();
            this.facade = psiFacade2;
            this.newCredentials = credentials;
            assert (this.newCredentials != DatabaseCredentials.getInstance());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFacade", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$DataSourceSettings", "<init>"));
        }
    }

    private class MyRootPanel
    extends NonOpaquePanel
    implements DataProvider {
        MyRootPanel(LayoutManager layout) {
            super(layout);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyRootPanel.$$$reportNull$$$0(0);
            }
            if (History.KEY.is(dataId)) {
                return DatabaseConfigEditorImpl.this.myHistory;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$MyRootPanel", "getData"));
        }
    }

    public class ValidationComponent
    extends JPanel {
        private final JEditorPane myWarningLabel;
        private final List<Object> myActions = new ArrayList<Object>();
        private DataSourceProblem myProblem;

        public ValidationComponent(boolean closeable) {
            ComponentUtil.putClientProperty((JComponent)this, (Key)UserActivityWatcher.DO_NOT_WATCH, (Object)true);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)0, (int)0, (int)0), DsUiDefaults.DEFAULT_PANEL_BORDER));
            this.setVisible(false);
            JLabel iconLabel = new JLabel(UIUtil.getBalloonWarningIcon());
            iconLabel.setHorizontalAlignment(2);
            iconLabel.setVerticalAlignment(1);
            this.myWarningLabel = new JEditorPane();
            this.myWarningLabel.setEditorKit(HTMLEditorKitBuilder.simple());
            this.myWarningLabel.setEditable(false);
            NonOpaquePanel.setTransparent((JComponent)this.myWarningLabel);
            this.myWarningLabel.setBorder(null);
            this.myWarningLabel.addHyperlinkListener(e2 -> {
                if (e2.getEventType() != HyperlinkEvent.EventType.ACTIVATED || this.myProblem == null) {
                    return;
                }
                Object action = DataSourceProblem.extractAction(e2.getDescription(), this.myActions);
                if (action != null) {
                    DatabaseConfigEditorImpl.this.processAction(action);
                }
            });
            this.add((Component)iconLabel, "West");
            JViewport viewport = new JViewport(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    return new Dimension(JBUI.scale((int)100), size.height);
                }
            };
            this.add((Component)viewport, "Center");
            viewport.setView(this.myWarningLabel);
            if (closeable) {
                JPanel comp = new JPanel(new BorderLayout());
                comp.add((Component)new LinkLabel(null, AllIcons.Actions.Close, (aSource, aLinkData) -> {
                    AbstractDatabaseConfigurable configurable;
                    AbstractDatabaseConfigurable abstractDatabaseConfigurable = configurable = this.myProblem.getId() == null ? null : (AbstractDatabaseConfigurable)ObjectUtils.tryCast((Object)this.myProblem.getOwner(), AbstractDatabaseConfigurable.class);
                    if (configurable != null) {
                        DatabaseConfigEditorImpl.this.showErrorNotification(configurable, this.myProblem.getId(), null);
                    }
                }), "North");
                this.add((Component)comp, "East");
            }
        }

        private void updateWarning(@Nullable DataSourceProblem problem) {
            if (Comparing.equal((Object)problem, (Object)this.myProblem)) {
                return;
            }
            if (problem != null) {
                this.setVisible(true);
                this.myProblem = problem;
                this.myActions.clear();
                this.myWarningLabel.setText(this.generateWarningLabelText());
            } else {
                this.setVisible(false);
                this.myActions.clear();
                this.myProblem = null;
            }
        }

        @Nls
        private String generateWarningLabelText() {
            @NlsSafe StringBuilder builder = new StringBuilder("<html><body>");
            String title = this.myProblem.getText().getTitle();
            builder.append("<font face=\"verdana\">");
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                builder.append("<b>");
                DataSourceProblem.formatText(builder, this.myActions, title, this.myProblem.getText().getLinkActions());
                builder.append("</b>: ");
            }
            DataSourceProblem.formatText(builder, this.myActions, this.myProblem.getText().getShortDescription(), this.myProblem.getText().getLinkActions());
            builder.append("</font></body></html>");
            return builder.toString();
        }
    }

    static enum Kind {
        DATABASE,
        DRIVER,
        OTHER;


        static Kind kindOf(Object o2) {
            if (o2 instanceof DasDataSource) {
                return DATABASE;
            }
            if (o2 instanceof DatabaseDriver) {
                return DRIVER;
            }
            return OTHER;
        }
    }
}

