/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigEditorImpl;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourcesSideTab
extends DatabaseConfigSideTab {
    DataSourceErrorsConfigurable myErrorsConfigurable;
    AnAction myAddAction;

    public DataSourcesSideTab(@NotNull DatabaseConfigEditorImpl editor2) {
        if (editor2 == null) {
            DataSourcesSideTab.$$$reportNull$$$0(0);
        }
        super(DatabaseBundle.message("tab.title.data.sources", new Object[0]), editor2);
        this.myErrorsConfigurable = new DataSourceErrorsConfigurable(this.myEditor, () -> {
            Place place = this.getPlace(this.myErrorsConfigurable);
            this.mySidePanel.getList().revalidate();
            this.mySidePanel.getList().repaint();
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(place));
            editor2.updateCurrentValidationProblem();
        });
    }

    Collection<DbDataSource> getAllDataSources(DatabaseConfigEditorImpl.DataSourceSettings settings) {
        LinkedHashSet<DbDataSource> result2 = new LinkedHashSet<DbDataSource>(settings.facade.getDataSources());
        result2.addAll(settings.newDataSources);
        result2.removeAll(this.myRemovedObjects);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refillSidePanel(@NotNull DatabaseConfigEditorImpl.DataSourceSettings settings, boolean keepSelection) {
        if (settings == null) {
            DataSourcesSideTab.$$$reportNull$$$0(1);
        }
        try {
            HashSet addedItems = new HashSet();
            Set selection2 = keepSelection ? this.getSelectedItems().toSet() : null;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            List<@NlsContexts.Separator String> sections = Arrays.asList(DatabaseBundle.message("separator.global.data.sources", new Object[0]), DatabaseBundle.message("separator.project.data.sources", new Object[0]), DatabaseBundle.message("separator.ddl.data.sources", new Object[0]), DatabaseBundle.message("separator.imported.data.sources", new Object[0]));
            List items2 = this.sectionize(this.getAllDataSources(settings), this::createItem, o2 -> o2.isGlobal() ? 0 : (o2.isImported() ? 3 : (((DbDataSourceImpl)o2.getObject()).getDelegate() instanceof SqlDataSource ? 2 : 1)));
            for (int i2 = 0; i2 < items2.size(); ++i2) {
                this.mySidePanel.addSeparator(sections.get(i2));
                List list = items2.get(i2);
                list.sort(Comparator.comparing(SidePanelItem.DataSourceItem::getName, DbPresentation.NAMES_COMPARATOR));
                for (SidePanelItem item : list) {
                    addedItems.add(this.addToSidePanel(item));
                }
            }
            this.mySidePanel.addSeparator("---");
            SidePanelItem.ErrorsItem errorsItem = this.createItem(this.myErrorsConfigurable);
            addedItems.add(this.addToSidePanel(errorsItem));
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(this.getPlace(this.myErrorsConfigurable)));
            if (keepSelection) {
                this.restoreSelection(selection2);
            }
            for (SidePanelItem item : new ArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
        }
        finally {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    @Override
    public boolean isMine(Object object) {
        return object instanceof DasDataSource;
    }

    @NotNull
    public SidePanelItem.DataSourceItem createItem(@NotNull DbDataSource obj2) {
        SidePanelItem.DataSourceItem item;
        if (obj2 == null) {
            DataSourcesSideTab.$$$reportNull$$$0(2);
        }
        if ((item = (SidePanelItem.DataSourceItem)this.getSidePanelItem(obj2)) == null) {
            item = new SidePanelItem.DataSourceItem(this.myEditor, (DbDataSourceImpl)obj2);
        }
        SidePanelItem.DataSourceItem dataSourceItem = this.createItem(item);
        if (dataSourceItem == null) {
            DataSourcesSideTab.$$$reportNull$$$0(3);
        }
        return dataSourceItem;
    }

    @NotNull
    public SidePanelItem.ErrorsItem createItem(@NotNull DataSourceErrorsConfigurable obj2) {
        SidePanelItem.ErrorsItem item;
        if (obj2 == null) {
            DataSourcesSideTab.$$$reportNull$$$0(4);
        }
        if ((item = (SidePanelItem.ErrorsItem)this.getSidePanelItem(obj2)) == null) {
            item = new SidePanelItem.ErrorsItem(this.myEditor, obj2);
        }
        SidePanelItem.ErrorsItem errorsItem = this.createItem(item);
        if (errorsItem == null) {
            DataSourcesSideTab.$$$reportNull$$$0(5);
        }
        return errorsItem;
    }

    @Override
    public void disposeUi() {
        super.disposeUi();
        this.myErrorsConfigurable.disposeUIResources();
    }

    @Override
    public void copy(@NotNull SidePanelItem<?, ?> item) {
        SidePanelItem.DataSourceItem dataSourceItem;
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(6);
        }
        if ((dataSourceItem = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(item, SidePanelItem.DataSourceItem.class)) == null) {
            return;
        }
        DbDataSource dataSource2 = (DbDataSource)dataSourceItem.getObject();
        AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)dataSourceItem.getConfigurable();
        this.copy(dataSource2, configurable);
    }

    DasDataSource copy(DbDataSource dataSource2, AbstractDataSourceConfigurable<?, ?> configurable) {
        DatabaseCredentials credentials;
        RawDataSource delegate;
        if (configurable instanceof DataSourceConfigurable) {
            delegate = ((DataSourceConfigurable)configurable).getTempDataSourceForConnection();
            credentials = this.myEditor.getSecretService();
        } else if (configurable != null) {
            delegate = configurable.getTempDataSource();
            credentials = this.myEditor.getSecretService();
        } else {
            delegate = dataSource2.getDelegate();
            credentials = DatabaseCredentials.getInstance();
        }
        String newName = this.myEditor.generateObjectName(null, delegate.getName());
        DataSourceManager<RawDataSource> dbManager = this.myEditor.getSettings().facade.getDataSourceManager(dataSource2);
        RawDataSource databaseSystem = dbManager.copyDataSource(newName, delegate);
        if (delegate instanceof LocalDataSource) {
            DatabaseAuthProvider.copyAllCredentials((LocalDataSource)delegate, credentials, (LocalDataSource)databaseSystem, this.myEditor.getSecretService());
        }
        this.onDataSourceCreated(this.myEditor.getSettings().facade, dbManager, databaseSystem);
        return databaseSystem;
    }

    @Override
    public boolean canCopy(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(7);
        }
        return item instanceof SidePanelItem.DataSourceItem;
    }

    @NotNull
    public JBIterable<SidePanelItem.DataSourceItem> getSelectedDataSources() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DataSourceItem.class);
        if (jBIterable == null) {
            DataSourcesSideTab.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<SidePanelItem.DataSourceItem> getSelectedLocalDataSources() {
        JBIterable jBIterable = this.getSelectedDataSources().filter(item -> item.extractActualLocalDataSource() != null);
        if (jBIterable == null) {
            DataSourcesSideTab.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    void configureActionGroups(DefaultActionGroup left, DefaultActionGroup right, DefaultActionGroup context, JList<?> target2) {
        ActionManager actionManager = ActionManager.getInstance();
        this.myAddAction = new AddAction();
        this.myAddAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target2);
        DatabaseConfigSideTab.RemoveAction removeAction = new DatabaseConfigSideTab.RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target2);
        DatabaseConfigSideTab.CopyAction copyAction = new DatabaseConfigSideTab.CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target2);
        GoToDriverAction editDefaultsAction = new GoToDriverAction();
        editDefaultsAction.registerCustomShortcutSet(actionManager.getAction("GotoDeclaration").getShortcutSet(), target2);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        BackAction backAction = new BackAction((JComponent)this.myEditor.myRootPanel, (Disposable)this.myEditor);
        DataSourceScopeAction scopeAction = new DataSourceScopeAction();
        DatabaseConfigSideTab.ResetAction revertAction = new DatabaseConfigSideTab.ResetAction();
        revertAction.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target2);
        SetIntrospectionLevelAction setIntrospectionLevelAction = new SetIntrospectionLevelAction();
        SourceLoadingAction sourceLoading = new SourceLoadingAction();
        left.addAll(new AnAction[]{this.myAddAction, removeAction, copyAction, editDefaultsAction, scopeAction});
        right.addAll(new AnAction[]{backAction, forwardAction});
        context.add(this.myAddAction);
        context.add((AnAction)removeAction);
        context.add((AnAction)copyAction);
        context.add((AnAction)scopeAction);
        context.addSeparator();
        context.add((AnAction)editDefaultsAction);
        context.add((AnAction)new ChooseDriverGroup());
        context.addSeparator();
        context.add((AnAction)revertAction);
        context.add((AnAction)setIntrospectionLevelAction);
        context.add((AnAction)sourceLoading);
    }

    @Override
    boolean canRemove(@NotNull SidePanelItem<?, ?> item) {
        if (item == null) {
            DataSourcesSideTab.$$$reportNull$$$0(10);
        }
        return item instanceof SidePanelItem.DataSourceItem;
    }

    public boolean isUsed(@NotNull DatabaseDriver driver2) {
        if (driver2 == null) {
            DataSourcesSideTab.$$$reportNull$$$0(11);
        }
        for (DbDataSource ds : this.getAllDataSources(this.myEditor.getSettings())) {
            SidePanelItem.DataSourceItem item;
            LocalDataSource dataSource2;
            DatabaseDriver dsDriver;
            if (this.myRemovedObjects.contains(ds) || (dsDriver = (dataSource2 = (item = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(this.getSidePanelItem(ds), SidePanelItem.DataSourceItem.class)) == null ? null : item.extractActualLocalDataSource()) == null ? null : dataSource2.getDatabaseDriver()) != driver2) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onApply() throws ConfigurationException {
        DbDeleteProvider.closeAllFilesBeforeDataSourceRemoval(this.myEditor.getSettings().facade.getProject(), (Set)JBIterable.from((Iterable)this.myRemovedObjects).filter(DbDataSourceImpl.class).addAllTo(new LinkedHashSet()));
        super.onApply();
    }

    @Override
    protected void ensureNewObjectDropped(Object object) {
        if (object instanceof DbDataSource) {
            this.myEditor.getSettings().newDataSources.remove(object);
        }
    }

    @Override
    protected void removeObject(Object object) {
        if (object instanceof DbDataSource) {
            DbDataSource element2 = (DbDataSource)object;
            for (DbDataSource existingDS : this.myEditor.getSettings().facade.getDataSources()) {
                if (existingDS.getDelegate() != element2.getDelegate()) continue;
                this.myEditor.getSettings().facade.getDataSourceManager(element2).removeDataSource(element2.getDelegate());
                break;
            }
        }
    }

    @Override
    @Nullable
    public SidePanelItem<?, ?> getSidePanelItem(@Nullable Object key2) {
        if (key2 instanceof DasDataSource && !(key2 instanceof DbDataSource)) {
            return (SidePanelItem)ContainerUtil.find(this.mySidePanelItems.values(), item -> item instanceof SidePanelItem.DataSourceItem && ((DbDataSource)item.getObject()).getDelegate() == key2);
        }
        return super.getSidePanelItem(key2);
    }

    void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager<?> manager, @NotNull RawDataSource dataSource2) {
        if (facade == null) {
            DataSourcesSideTab.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            DataSourcesSideTab.$$$reportNull$$$0(13);
        }
        if (dataSource2 == null) {
            DataSourcesSideTab.$$$reportNull$$$0(14);
        }
        DbDataSource element2 = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource2, manager);
        this.myEditor.getSettings().newDataSources.add(element2);
        this.myEditor.putUserData(DatabaseConfigEditor.SELECTED_TAB_KEY, null);
        DatabaseConfigEditorImpl.createEditorIfNeeded(this.createItem(element2));
        this.refillSidePanel(this.myEditor.getSettings(), false);
        this.myEditor.navigateTo(element2, true);
    }

    public List<AnAction> getAddActions(@Nullable java.util.function.Consumer<DasDataSource> callback) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        DatabaseConfigEditorImpl.DataSourceSettings settings = this.myEditor.getSettings();
        DbPsiFacade facade = settings.facade;
        LocalDataSourceManager defaultManager = LocalDataSourceManager.getInstance(facade.getProject());
        Function toTemp = o2 -> this.isRemoved(o2) ? null : this.myEditor.getTempTargetOrTarget(o2);
        java.util.function.Consumer<LocalDataSource> consumer2 = ds -> this.handleCreated(facade, defaultManager, (RawDataSource)ds, (java.util.function.Consumer)callback);
        JBIterable newDrivers = JBIterable.from(settings.newDrivers).filterMap(toTemp);
        JBIterable existingDrivers = JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filterMap(toTemp);
        actions.addAll(defaultManager.getCreateDataSourceActions(newDrivers.toList(), (Consumer<? super LocalDataSource>)((Consumer)consumer2::accept)));
        actions.add((AnAction)Separator.getInstance());
        actions.addAll(defaultManager.getCreateDataSourceActions(existingDrivers.toList(), (Consumer<? super LocalDataSource>)((Consumer)consumer2::accept)));
        actions.add((AnAction)Separator.getInstance());
        for (DataSourceManager<?> manager : DataSourceManager.getManagers(facade.getProject())) {
            if (manager == defaultManager) continue;
            ContainerUtil.addIfNotNull(actions, (Object)this.getCreateActions(callback, facade, manager));
        }
        DatabaseViewActions.DataSourceFactory factory = (f, m, ds) -> this.handleCreated(f, m, ds, callback);
        actions.add((AnAction)new AddDataSourceFromUrl(factory));
        actions.add((AnAction)new AddDataSourceFromPath.FromDialog(factory));
        return actions;
    }

    @Nullable
    private <T extends RawDataSource> AnAction getCreateActions(@Nullable java.util.function.Consumer<? super T> callback, DbPsiFacade facade, DataSourceManager<T> manager) {
        return manager.getCreateDataSourceAction(ds -> this.handleCreated(facade, manager, (RawDataSource)ds, callback));
    }

    private <T extends RawDataSource> void handleCreated(DbPsiFacade f, DataSourceManager<T> m, T ds, @Nullable java.util.function.Consumer<? super T> callback) {
        this.onDataSourceCreated(f, m, ds);
        if (callback != null) {
            callback.accept(ds);
        }
    }

    @Nullable
    public static DataSourcesSideTab getDataSourcesTab(@Nullable AnActionEvent e2) {
        return e2 == null ? null : (DataSourcesSideTab)ObjectUtils.tryCast((Object)e2.getData(SIDE_PANEL), DataSourcesSideTab.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDataSources";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocalDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refillSidePanel";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canRemove";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUsed";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onDataSourceCreated";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static final class AddAction
    extends ActionGroup
    implements DumbAware,
    AlwaysVisibleActionGroup {
        private AddAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.add.text", new Object[0]), null, IconUtil.getAddIcon());
            this.setPopup(true);
            this.getTemplatePresentation().setPerformGroup(true);
            this.getTemplatePresentation().putClientProperty(ActionMenu.SUPPRESS_SUBMENU, (Object)true);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)this, e2.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20, null, ActionPlaces.getPopupPlace((String)"database"));
            DbUIUtil.showPopup((JBPopup)popup2, null, e2);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2);
            if (dataSourcesTab == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    AddAction.$$$reportNull$$$0(1);
                }
                return AnAction.EMPTY_ARRAY;
            }
            List<AnAction> actions = dataSourcesTab.getAddActions(null);
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                AddAction.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$AddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$AddAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class GoToDriverAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        GoToDriverAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.go.to.driver.text", new Object[0]), null, AllIcons.General.Settings);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                GoToDriverAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                GoToDriverAction.$$$reportNull$$$0(1);
            }
            boolean enabled = this.isEnabled(e2);
            e2.getPresentation().setEnabled(enabled);
            e2.getPresentation().setVisible(DataSourcesSideTab.getDataSourcesTab(e2) != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            LocalDataSource localDataSource;
            DataSourcesSideTab dataSourcesTab;
            if (e2 == null) {
                GoToDriverAction.$$$reportNull$$$0(2);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) == null) {
                return;
            }
            JBIterable<SidePanelItem.DataSourceItem> selection2 = dataSourcesTab.getSelectedDataSources();
            SidePanelItem.DataSourceItem dataSource2 = (SidePanelItem.DataSourceItem)selection2.first();
            LocalDataSource localDataSource2 = localDataSource = dataSource2 == null ? null : dataSource2.extractActualLocalDataSource();
            if (localDataSource == null) {
                return;
            }
            dataSourcesTab.myEditor.navigateTo(localDataSource.getDatabaseDriver(), false);
        }

        public boolean isEnabled(@NotNull AnActionEvent e2) {
            DataSourcesSideTab dataSourcesTab;
            if (e2 == null) {
                GoToDriverAction.$$$reportNull$$$0(3);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) == null) {
                return false;
            }
            JBIterable<SidePanelItem.DataSourceItem> selection2 = dataSourcesTab.getSelectedDataSources();
            if (selection2.size() != 1) {
                return false;
            }
            LocalDataSource localDataSource = Objects.requireNonNull((SidePanelItem.DataSourceItem)selection2.first()).extractActualLocalDataSource();
            return localDataSource != null && localDataSource.getDatabaseDriver() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$GoToDriverAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$GoToDriverAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class DataSourceScopeAction
    extends DumbAwareAction {
        DataSourceScopeAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.data.source.scope.text", new Object[0]), null, AllIcons.ToolbarDecorator.Import);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                DataSourceScopeAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        boolean isIDEScopeSelected(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DataSourceScopeAction.$$$reportNull$$$0(1);
            }
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2);
            boolean isIDEScope = true;
            if (dataSourcesTab != null) {
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    isIDEScope &= item.isGlobal();
                }
            }
            return isIDEScope;
        }

        public void update(@NotNull AnActionEvent e2) {
            DataSourcesSideTab dataSourcesTab;
            if (e2 == null) {
                DataSourceScopeAction.$$$reportNull$$$0(2);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) == null) {
                e2.getPresentation().setEnabledAndVisible(false);
            } else {
                e2.getPresentation().setEnabled(!dataSourcesTab.getSelectedLocalDataSources().filter(ds -> DataSourceScopeAction.canMoveToScope(e2.getProject(), ds, null)).isEmpty());
            }
            boolean ideScope = this.isIDEScopeSelected(e2);
            e2.getPresentation().setText(DatabaseBundle.message(ideScope ? "action.DatabaseConfigEditor.move.to.project.text" : "action.DatabaseConfigEditor.make.global.text", new Object[0]));
            e2.getPresentation().setIcon(ideScope ? AllIcons.ToolbarDecorator.Import : AllIcons.ToolbarDecorator.Export);
        }

        public void actionPerformed(@NotNull AnActionEvent e2) {
            if (e2 == null) {
                DataSourceScopeAction.$$$reportNull$$$0(3);
            }
            boolean isIDEScope = this.isIDEScopeSelected(e2);
            DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2);
            if (dataSourcesTab == null) {
                return;
            }
            for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                DataSourceConfigurable configurable;
                if (!DataSourceScopeAction.canMoveToScope(e2.getProject(), item, !isIDEScope) || (configurable = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class)) == null) continue;
                configurable.setGlobal(!isIDEScope);
            }
        }

        private static boolean canMoveToScope(Project project, SidePanelItem.DataSourceItem item, Boolean global) {
            LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast(((DbDataSourceImpl)item.getObject()).getDelegate(), LocalDataSource.class);
            if (ds == null) {
                return false;
            }
            String id = ds.getUniqueId();
            if (global == null) {
                global = !ds.isGlobal();
            }
            DataSourceStorage storage = DbSrcUtils.getDataSourceStorage(global != false ? null : project);
            for (LocalDataSource source : storage.getDataSources()) {
                if (source.isGlobal() != global.booleanValue() || !id.equals(source.getUniqueId()) || source == ds) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$DataSourceScopeAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$DataSourceScopeAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isIDEScopeSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class SetIntrospectionLevelAction
    extends ActionGroup {
        private final AnAction[] mySetActions = new AnAction[]{new SetValueAction(Level.L1, DatabaseBundle.message("database.introspection.level.1.name", new Object[0]), DatabaseIcons.Level1), new SetValueAction(Level.L2, DatabaseBundle.message("database.introspection.level.2.name", new Object[0]), DatabaseIcons.Level2), new SetValueAction(Level.L3, DatabaseBundle.message("database.introspection.level.3.name", new Object[0]), DatabaseIcons.Level3)};

        SetIntrospectionLevelAction() {
            super(DatabaseBundle.message("dataSourceSideTab.introspectionLevel.action.group.setDefaultLevel.text", new Object[0]), DatabaseBundle.message("dataSourceSideTab.introspectionLevel.action.group.setDefaultLevel.description", new Object[0]), null);
            this.setPopup(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SetIntrospectionLevelAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            if (this.mySetActions == null) {
                SetIntrospectionLevelAction.$$$reportNull$$$0(1);
            }
            return this.mySetActions;
        }

        public void update(@NotNull AnActionEvent e2) {
            boolean enabled;
            DataSourcesSideTab dataSourcesTab;
            if (e2 == null) {
                SetIntrospectionLevelAction.$$$reportNull$$$0(2);
            }
            JBIterable<SidePanelItem.DataSourceItem> dsItems = (dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) != null ? dataSourcesTab.getSelectedLocalDataSources() : null;
            boolean bl = enabled = dsItems != null && !dsItems.isEmpty();
            if (enabled) {
                for (SidePanelItem.DataSourceItem item : dsItems) {
                    Dbms dbms = ((DbDataSourceImpl)item.getObject()).getDbms();
                    if (DBIntrospectorFeatures.supportsMultilevelIntrospection(dbms)) continue;
                    enabled = false;
                    break;
                }
            }
            e2.getPresentation().setEnabledAndVisible(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$SetIntrospectionLevelAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SetIntrospectionLevelAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }

        private static class SetValueAction
        extends DumbAwareAction {
            private final Level myLevel;

            SetValueAction(@NotNull Level level, @NotNull @NlsActions.ActionText String caption, @Nullable Icon icon) {
                if (level == null) {
                    SetValueAction.$$$reportNull$$$0(0);
                }
                if (caption == null) {
                    SetValueAction.$$$reportNull$$$0(1);
                }
                super(caption, null, icon);
                this.myLevel = level;
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                DataSourcesSideTab dataSourcesTab;
                if (e2 == null) {
                    SetValueAction.$$$reportNull$$$0(2);
                }
                if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) == null) {
                    return;
                }
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast(item.createConfigurable(), DataSourceConfigurable.class);
                    if (configurable == null) continue;
                    configurable.setIntrospectionLevel(this.myLevel);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "level";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caption";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SetIntrospectionLevelAction$SetValueAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class SourceLoadingAction
    extends ActionGroup {
        private final AnAction[] mySetActions = new AnAction[]{new SetValueAction(DatabaseBundle.message("action.DatabaseConfigEditor.none.text", new Object[0]), DBIntrospectionOptions.SourceLoading.NO_SOURCES), new SetValueAction(DatabaseBundle.message("action.DatabaseConfigEditor.except.system.schemas.text", new Object[0]), DBIntrospectionOptions.SourceLoading.USER_SOURCES), new SetValueAction(DatabaseBundle.message("action.DatabaseConfigEditor.all.schemas.text", new Object[0]), DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES)};

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SourceLoadingAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        SourceLoadingAction() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.load.sources.text", new Object[0]), DatabaseBundle.message("action.DatabaseConfigEditor.which.sources.to.load.description", new Object[0]), AllIcons.Actions.Download);
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            if (this.mySetActions == null) {
                SourceLoadingAction.$$$reportNull$$$0(1);
            }
            return this.mySetActions;
        }

        public void update(@NotNull AnActionEvent e2) {
            boolean enabled;
            DataSourcesSideTab dataSourcesTab;
            if (e2 == null) {
                SourceLoadingAction.$$$reportNull$$$0(2);
            }
            JBIterable<SidePanelItem.DataSourceItem> dsItems = (dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) != null ? dataSourcesTab.getSelectedLocalDataSources() : null;
            boolean bl = enabled = dsItems != null && !dsItems.isEmpty();
            if (enabled) {
                for (SidePanelItem.DataSourceItem item : dsItems) {
                    Dbms dbms;
                    Dbms dbms2 = dbms = item.getConfigurable() != null ? ((AbstractDataSourceConfigurable)item.getConfigurable()).getDataSource().getDbms() : null;
                    if (dbms != null && !DBIntrospectorFeatures.supportsMultilevelIntrospection(dbms)) continue;
                    enabled = false;
                    break;
                }
            }
            e2.getPresentation().setEnabledAndVisible(enabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2 -> new IllegalArgumentException(string);
            };
        }

        private static class SetValueAction
        extends DumbAwareAction {
            private final DBIntrospectionOptions.SourceLoading myMode;

            SetValueAction(@NotNull @NlsActions.ActionText String caption, @NotNull DBIntrospectionOptions.SourceLoading mode) {
                if (caption == null) {
                    SetValueAction.$$$reportNull$$$0(0);
                }
                if (mode == null) {
                    SetValueAction.$$$reportNull$$$0(1);
                }
                super(caption);
                this.myMode = mode;
            }

            public void actionPerformed(@NotNull AnActionEvent e2) {
                DataSourcesSideTab dataSourcesTab;
                if (e2 == null) {
                    SetValueAction.$$$reportNull$$$0(2);
                }
                if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) == null) {
                    return;
                }
                for (SidePanelItem.DataSourceItem item : dataSourcesTab.getSelectedLocalDataSources()) {
                    DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast(item.createConfigurable(), DataSourceConfigurable.class);
                    if (configurable == null) continue;
                    configurable.setSourceLoading(this.myMode);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caption";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mode";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$SourceLoadingAction$SetValueAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class ChooseDriverGroup
    extends ActionGroup
    implements DumbAware {
        ChooseDriverGroup() {
            super(DatabaseBundle.message("action.DatabaseConfigEditor.change.driver.text", new Object[0]), DatabaseBundle.message("action.DatabaseConfigEditor.change.data.source.driver.description", new Object[0]), null);
            this.getTemplatePresentation().setPopupGroup(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ChooseDriverGroup.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e2) {
            DataSourcesSideTab dataSourcesTab;
            if (e2 == null) {
                ChooseDriverGroup.$$$reportNull$$$0(1);
            }
            if ((dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2)) == null) {
                e2.getPresentation().setEnabledAndVisible(false);
                return;
            }
            JBIterable<SidePanelItem.DataSourceItem> dataSources2 = dataSourcesTab.getSelectedLocalDataSources();
            JBIterable<DatabaseDriver> drivers = dataSourcesTab.myEditor.myDrSideTab.getDrivers((JBIterable<LocalDataSource>)dataSources2.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource));
            e2.getPresentation().setVisible(!dataSources2.isEmpty());
            e2.getPresentation().setEnabled(drivers.take(2).size() > 1);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e2) {
            final DataSourcesSideTab dataSourcesTab = DataSourcesSideTab.getDataSourcesTab(e2);
            if (dataSourcesTab == null) {
                if (EMPTY_ARRAY == null) {
                    ChooseDriverGroup.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }
            final JBIterable<SidePanelItem.DataSourceItem> dataSources2 = dataSourcesTab.getSelectedLocalDataSources();
            List drivers = dataSourcesTab.myEditor.myDrSideTab.getDrivers((JBIterable<LocalDataSource>)dataSources2.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource)).filterMap(o2 -> dataSourcesTab.myEditor.getTempTargetOrTarget(o2)).toList();
            if (drivers.size() < 2) {
                if (EMPTY_ARRAY == null) {
                    ChooseDriverGroup.$$$reportNull$$$0(3);
                }
                return EMPTY_ARRAY;
            }
            final Set selection2 = dataSourcesTab.getSelectedItems().toSet();
            ArrayList<1> res2 = new ArrayList<1>();
            for (final DatabaseDriver driver2 : drivers) {
                res2.add(new DumbAwareAction(driver2.getName(), null, driver2.getIcon(0)){

                    public void actionPerformed(@NotNull AnActionEvent e1) {
                        if (e1 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (SidePanelItem.DataSourceItem item : dataSources2) {
                            DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class);
                            if (configurable == null) continue;
                            configurable.setDriver(driver2);
                        }
                        dataSourcesTab.restoreSelection(selection2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup$1", "actionPerformed"));
                    }
                });
            }
            AnAction[] anActionArray = res2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChooseDriverGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DataSourcesSideTab$ChooseDriverGroup";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

