/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvExtraNode;
import com.intellij.database.view.structure.DvFamilyDivision;
import com.intellij.database.view.structure.DvNodeComparator;
import com.intellij.database.view.structure.DvOrderedExtraNode;
import com.intellij.database.view.structure.DvUnnestFamily;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/view/structure/DvDisplayNodesComparator;", "Lcom/intellij/database/view/structure/DvNodeComparator;", "()V", "compare", "", "o1", "Lcom/intellij/database/model/basic/BasicNode;", "o2", "getKindOf", "Lcom/intellij/database/model/ObjectKind;", "node", "intellij.database.core.impl"})
public final class DvDisplayNodesComparator
extends DvNodeComparator {
    @NotNull
    public static final DvDisplayNodesComparator INSTANCE = new DvDisplayNodesComparator();

    private DvDisplayNodesComparator() {
        super(null);
    }

    @Override
    public int compare(@Nullable BasicNode o1, @Nullable BasicNode o2) {
        int orderB;
        ObjectKind kindB;
        ObjectKind kindA = this.getKindOf(o1);
        if (kindA != (kindB = this.getKindOf(o2))) {
            int weightB;
            int weightA = DbPresentationCore.getWeight(kindA, 0);
            if (weightA < (weightB = DbPresentationCore.getWeight(kindB, 0))) {
                return -1;
            }
            if (weightA > weightB) {
                return 1;
            }
        }
        int orderA = o1 instanceof DvOrderedExtraNode ? ((DvOrderedExtraNode)o1).getOrderNum() : Integer.MAX_VALUE;
        int n = orderB = o2 instanceof DvOrderedExtraNode ? ((DvOrderedExtraNode)o2).getOrderNum() : Integer.MAX_VALUE;
        if (orderA < orderB) {
            return -1;
        }
        if (orderA > orderB) {
            return 1;
        }
        return 0;
    }

    private final ObjectKind getKindOf(BasicNode node2) {
        ObjectKind objectKind;
        BasicNode basicNode = node2;
        if (basicNode instanceof BasicElement) {
            ObjectKind objectKind2 = ((BasicElement)node2).getKind();
            objectKind = objectKind2;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"getKind(...)");
        } else if (basicNode instanceof HostFamily) {
            ObjectKind objectKind3 = ((HostFamily)node2).getChildrenKind();
            objectKind = objectKind3;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"getChildrenKind(...)");
        } else if (basicNode instanceof DvFamilyDivision) {
            objectKind = ((DvFamilyDivision)node2).getChildrenKind();
        } else if (basicNode instanceof DvUnnestFamily) {
            objectKind = ((DvUnnestFamily)node2).getChildrenKind();
        } else if (basicNode instanceof FamilyWithId) {
            objectKind = ((FamilyWithId)node2).getFamilyId().getFakeKind();
        } else if (basicNode instanceof DvExtraNode) {
            ObjectKind objectKind4 = ((DvExtraNode)node2).getHostKind();
            if (objectKind4 == null) {
                objectKind4 = ObjectKind.UNKNOWN_OBJECT;
            }
            ObjectKind objectKind5 = objectKind4;
            Intrinsics.checkNotNull((Object)objectKind5);
            objectKind = objectKind5;
        } else if (basicNode instanceof DataSourceNode) {
            ObjectKind objectKind6 = ObjectKind.ROOT;
            objectKind = objectKind6;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind6, (String)"ROOT");
        } else {
            ObjectKind objectKind7 = ObjectKind.UNKNOWN_OBJECT;
            objectKind = objectKind7;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind7, (String)"UNKNOWN_OBJECT");
        }
        return objectKind;
    }
}

