/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.database.view.DatabaseCopyPasteProvider;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseTreeContext;
import com.intellij.database.view.DatabaseViewTreeComponent;
import com.intellij.database.view.DatabaseViewTreeComponentKt;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvTreeLayoutLayer;
import com.intellij.database.view.structure.DvTreeStructure;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u000223B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020/H\u0014J\u000e\u00100\u001a\u00020*2\u0006\u00101\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00064"}, d2={"Lcom/intellij/database/view/DatabaseViewTreeComponent;", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "context", "Lcom/intellij/database/view/DatabaseTreeContext;", "myViewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "(Lcom/intellij/database/view/DatabaseTreeContext;Lcom/intellij/database/view/structure/DvViewOptions;)V", "myCellRenderer", "Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "myCopyPasteProvider", "Lcom/intellij/database/view/DatabaseCopyPasteProvider;", "myTreeStructure", "Lcom/intellij/database/view/structure/DvTreeStructure;", "getMyTreeStructure", "()Lcom/intellij/database/view/structure/DvTreeStructure;", "myTreeStructure$delegate", "Lkotlin/Lazy;", "myWrappingService", "Lcom/intellij/database/view/DatabaseNodeWrappingService;", "getMyWrappingService", "()Lcom/intellij/database/view/DatabaseNodeWrappingService;", "myWrappingService$delegate", "viewport", "Lcom/intellij/ui/components/GradientViewport;", "getViewport", "()Lcom/intellij/ui/components/GradientViewport;", "getCellPresentation", "Lcom/intellij/navigation/ItemPresentation;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "getFileColorFor", "Ljava/awt/Color;", "object", "", "getFileColorForPath", "path", "Ljavax/swing/tree/TreePath;", "getToggleClickCount", "", "isFileColorsEnabled", "", "onSelectionChange", "", "event", "Ljavax/swing/event/TreeSelectionEvent;", "processKeyEvent", "e", "Ljava/awt/event/KeyEvent;", "setCopyPasteProvider", "copyPasteProvider", "CellRenderer", "MyGradientViewport", "intellij.database.impl"})
public final class DatabaseViewTreeComponent
extends DnDAwareTree {
    @NotNull
    private final DatabaseTreeContext context;
    @NotNull
    private final DvViewOptions myViewOptions;
    @NotNull
    private final Lazy myTreeStructure$delegate;
    @NotNull
    private final Lazy myWrappingService$delegate;
    @Nullable
    private DatabaseCopyPasteProvider myCopyPasteProvider;
    @NotNull
    private final GradientViewport viewport;
    @NotNull
    private final CellRenderer myCellRenderer;

    public DatabaseViewTreeComponent(@NotNull DatabaseTreeContext context, @NotNull DvViewOptions myViewOptions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)myViewOptions, (String)"myViewOptions");
        this.context = context;
        this.myViewOptions = myViewOptions;
        this.myTreeStructure$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DvTreeStructureService>(this){
            final /* synthetic */ DatabaseViewTreeComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DvTreeStructureService invoke() {
                ComponentManager $this$service$iv = (ComponentManager)DatabaseViewTreeComponent.access$getContext$p(this.this$0).getProject();
                boolean $i$f$service = false;
                Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (DvTreeStructureService)object;
            }
        }));
        this.myWrappingService$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DatabaseNodeWrappingService>(this){
            final /* synthetic */ DatabaseViewTreeComponent this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DatabaseNodeWrappingService invoke() {
                ComponentManager $this$service$iv = (ComponentManager)DatabaseViewTreeComponent.access$getContext$p(this.this$0).getProject();
                boolean $i$f$service = false;
                Class<DatabaseNodeWrappingService> serviceClass$iv = DatabaseNodeWrappingService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                return (DatabaseNodeWrappingService)object;
            }
        }));
        ClientProperty.put((JComponent)((JComponent)((Object)this)), (Key)JBViewport.ATTACH_STATUS_TEXT, (Object)true);
        this.viewport = new MyGradientViewport();
        this.putClientProperty(DefaultTreeUI.AUTO_EXPAND_ALLOWED, false);
        this.putClientProperty(BookmarksManager.ALLOWED, true);
        this.myCellRenderer = new CellRenderer();
        this.setCellRenderer(this.myCellRenderer);
        this.addMouseMotionListener(this.myCellRenderer);
        this.addMouseListener(this.myCellRenderer);
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((JComponent)((Object)this)));
        this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
        this.getSelectionModel().addTreeSelectionListener(arg_0 -> DatabaseViewTreeComponent._init_$lambda$0(this, arg_0));
    }

    private final DvTreeStructure getMyTreeStructure() {
        Lazy lazy = this.myTreeStructure$delegate;
        return (DvTreeStructure)lazy.getValue();
    }

    private final DatabaseNodeWrappingService getMyWrappingService() {
        Lazy lazy = this.myWrappingService$delegate;
        return (DatabaseNodeWrappingService)lazy.getValue();
    }

    @NotNull
    public final GradientViewport getViewport() {
        return this.viewport;
    }

    public final void setCopyPasteProvider(@NotNull DatabaseCopyPasteProvider copyPasteProvider) {
        Intrinsics.checkNotNullParameter((Object)copyPasteProvider, (String)"copyPasteProvider");
        this.myCopyPasteProvider = copyPasteProvider;
    }

    public int getToggleClickCount() {
        TreePath path;
        TreePath treePath = path = this.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        return object instanceof DasSchemaChild ? -1 : super.getToggleClickCount();
    }

    @Nullable
    public Color getFileColorFor(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path) {
        DasObject o2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = DatabaseColorManager.getLocalColorManager(this.context.getProject()).getState();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getState(...)");
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)object;
        if (!state.useColors || !state.inDatabaseView) {
            return null;
        }
        DbDataSource dataSource2 = DatabaseViewTreeComponentKt.access$findDbDataSourceInPath(path);
        DasObject dasObject = o2 = (DasObject)TreeUtil.findObjectInPath((TreePath)path, DasObject.class);
        DbElement e2 = dasObject == null ? (DbElement)dataSource2 : DbImplUtilCore.findElement(dataSource2, dasObject);
        return DatabaseColorManager.getColor(e2);
    }

    public boolean isFileColorsEnabled() {
        if (this.context.getProject().isDisposed()) {
            return false;
        }
        Object object = DatabaseColorManager.getLocalColorManager(this.context.getProject()).getState();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getState(...)");
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)object;
        boolean enabled = state.useColors && state.inDatabaseView;
        boolean opaque = this.isOpaque();
        if (enabled && opaque) {
            this.setOpaque(false);
        } else if (!enabled && !opaque) {
            this.setOpaque(true);
        }
        return enabled;
    }

    protected void processKeyEvent(@NotNull KeyEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        if (e2.getKeyCode() == 27 && this.context.isSomethingCut()) {
            DatabaseCopyPasteProvider databaseCopyPasteProvider = this.myCopyPasteProvider;
            Intrinsics.checkNotNull((Object)databaseCopyPasteProvider);
            databaseCopyPasteProvider.undoCut();
            e2.consume();
            return;
        }
        super.processKeyEvent(e2);
    }

    private final void onSelectionChange(TreeSelectionEvent event) {
        String string;
        int count = this.getSelectionModel().getSelectionCount();
        if (count > 1) {
            Object[] objectArray = new Object[]{count};
            string = DatabaseBundle.message("database.view.statusBar.selection.count", objectArray);
        } else {
            string = null;
        }
        String description = string;
        ActionMenu.Companion.showDescriptionInStatusBar(true, (Component)((Object)this), description);
    }

    @Nullable
    public final ItemPresentation getCellPresentation(@NotNull BasicNode node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return this.myCellRenderer.getPresentationInner(node2, false);
    }

    private static final void _init_$lambda$0(DatabaseViewTreeComponent this$0, TreeSelectionEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.onSelectionChange(event);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0090\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0013J@\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0013H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010-\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010.\u001a\u00020,2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "Ljava/awt/event/MouseAdapter;", "Ljavax/swing/tree/TreeCellRenderer;", "(Lcom/intellij/database/view/DatabaseViewTreeComponent;)V", "nodeRenderer", "Lcom/intellij/ide/util/treeView/NodeRenderer;", "getNodeRenderer", "()Lcom/intellij/ide/util/treeView/NodeRenderer;", "setNodeRenderer", "(Lcom/intellij/ide/util/treeView/NodeRenderer;)V", "pathUnderMouse", "Ljavax/swing/tree/TreePath;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "getPresentation", "()Lcom/intellij/ide/projectView/PresentationData;", "setPresentation", "(Lcom/intellij/ide/projectView/PresentationData;)V", "checkMouseOnTheLink", "", "e", "Ljava/awt/event/MouseEvent;", "createRenderer", "getCopyPresentationInner", "Lcom/intellij/navigation/ItemPresentation;", "o", "", "getPresentationInner", "node", "Lcom/intellij/database/model/basic/BasicNode;", "active", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "selected", "expanded", "leaf", "row", "", "hasFocus", "isNodeCut", "mouseClicked", "", "mouseExited", "mouseMoved", "intellij.database.impl"})
    public class CellRenderer
    extends MouseAdapter
    implements TreeCellRenderer {
        @NotNull
        private PresentationData presentation = new PresentationData();
        @Nullable
        private TreePath pathUnderMouse;
        @NotNull
        private NodeRenderer nodeRenderer = this.createRenderer();

        @NotNull
        public final PresentationData getPresentation() {
            return this.presentation;
        }

        public final void setPresentation(@NotNull PresentationData presentationData) {
            Intrinsics.checkNotNullParameter((Object)presentationData, (String)"<set-?>");
            this.presentation = presentationData;
        }

        @NotNull
        public final NodeRenderer getNodeRenderer() {
            return this.nodeRenderer;
        }

        public final void setNodeRenderer(@NotNull NodeRenderer nodeRenderer) {
            Intrinsics.checkNotNullParameter((Object)nodeRenderer, (String)"<set-?>");
            this.nodeRenderer = nodeRenderer;
        }

        @NotNull
        protected NodeRenderer createRenderer() {
            return new NodeRenderer(this){
                final /* synthetic */ CellRenderer this$0;
                {
                    this.this$0 = $receiver;
                }

                @Nullable
                protected ItemPresentation getPresentation(@Nullable Object node2) {
                    return node2 instanceof BasicNode ? (ItemPresentation)ReadAction.compute(() -> createRenderer.1.getPresentation$lambda$0(this.this$0, node2)) : null;
                }

                private static final ItemPresentation getPresentation$lambda$0(CellRenderer this$0, Object $node) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    return this$0.getPresentationInner((BasicNode)$node, true);
                }
            };
        }

        @Nullable
        public final ItemPresentation getCopyPresentationInner(@Nullable Object o2) {
            BasicNode node2;
            Object object = o2;
            BasicNode basicNode = node2 = object instanceof BasicNode ? (BasicNode)o2 : (object instanceof PsiElement ? DatabaseViewTreeComponent.this.getMyWrappingService().unwrap((PsiElement)o2) : null);
            return basicNode != null ? this.getPresentationInner(basicNode, false) : null;
        }

        @Nullable
        public final ItemPresentation getPresentationInner(@NotNull BasicNode node2, boolean active) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            DbNodeDescriptor.updatePresentation(this.presentation, node2, DatabaseViewTreeComponent.this.context.getProject(), DatabaseViewTreeComponent.this.myViewOptions, DatabaseViewTreeComponent.this.getMyTreeStructure(), this.pathUnderMouse, active, active);
            if (this.isNodeCut(node2)) {
                this.presentation.setForcedTextForeground((Color)JBColor.LIGHT_GRAY);
            }
            return (ItemPresentation)this.presentation;
        }

        private final boolean isNodeCut(Object node2) {
            DatabaseCopyPasteProvider provider = DatabaseViewTreeComponent.this.myCopyPasteProvider;
            return provider != null && provider.isNodeCut(node2);
        }

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree2, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Component component2 = this.nodeRenderer.getTreeCellRendererComponent(tree2, value2, selected, expanded, leaf, row, hasFocus);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.ui.SimpleColoredComponent");
            SimpleColoredComponent component3 = (SimpleColoredComponent)component2;
            component3.setOpaque(false);
            component3.setIconOpaque(false);
            component3.setTransparentIconBackground(true);
            component3.setIconTextGap(JBUIScale.scale((int)5));
            return (Component)component3;
        }

        private final boolean checkMouseOnTheLink(MouseEvent e2) {
            SimpleColoredComponent.ColoredIterator it2;
            Object o2;
            TreePath path;
            this.pathUnderMouse = null;
            TreePath treePath = path = DatabaseViewTreeComponent.this.getPathForLocation(e2.getX(), e2.getY());
            Object object = o2 = treePath != null ? treePath.getLastPathComponent() : null;
            if (!(o2 instanceof DataSourceNode || o2 instanceof BasicNamespaceOwner || o2 instanceof DvTreeLayoutLayer.EmptyScopeLeaf)) {
                return false;
            }
            LocalDataSource dataSource2 = DatabaseViewTreeComponentKt.access$findLocalDataSourceInPath(path);
            if (dataSource2 == null) {
                return false;
            }
            Rectangle bounds = DatabaseViewTreeComponent.this.getPathBounds(path);
            if (bounds == null) {
                return false;
            }
            int row = DatabaseViewTreeComponent.this.getRowForPath(path);
            Component component2 = this.getTreeCellRendererComponent((JTree)((Object)DatabaseViewTreeComponent.this), o2, false, false, false, row, false);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.ui.SimpleColoredComponent");
            SimpleColoredComponent component3 = (SimpleColoredComponent)component2;
            int index2 = component3.findFragmentAt(e2.getX() - bounds.x);
            SimpleColoredComponent.ColoredIterator coloredIterator = it2 = index2 < 0 ? null : component3.iterator(index2);
            if (it2 != null && it2.hasNext()) {
                it2.next();
                if (it2.getTextAttributes().isClickable()) {
                    this.pathUnderMouse = path;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e2) {
            Object o2;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            if (!UIUtil.isActionClick((MouseEvent)e2, (int)500)) {
                return;
            }
            if (!this.checkMouseOnTheLink(e2)) {
                return;
            }
            LocalDataSource dataSource2 = DatabaseViewTreeComponentKt.access$findLocalDataSourceInPath(this.pathUnderMouse);
            TreePath treePath = this.pathUnderMouse;
            Intrinsics.checkNotNull((Object)treePath);
            Object object = o2 = treePath.getLastPathComponent();
            BasicElement selection2 = object instanceof BasicElement ? (BasicElement)o2 : (object instanceof DvTreeLayoutLayer.EmptyScopeLeaf ? ((DvTreeLayoutLayer.EmptyScopeLeaf)o2).host : null);
            Project project = DatabaseViewTreeComponent.this.context.getProject();
            LocalDataSource localDataSource = dataSource2;
            Intrinsics.checkNotNull((Object)localDataSource);
            JBPopup jBPopup = DataSourceUiUtil.buildHiddenNamespacesPopup(project, localDataSource, selection2);
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"buildHiddenNamespacesPopup(...)");
            JBPopup popup2 = jBPopup;
            Rectangle rectangle = DatabaseViewTreeComponent.this.getPathBounds(this.pathUnderMouse);
            Intrinsics.checkNotNull((Object)rectangle);
            Rectangle bounds = rectangle;
            popup2.show(new RelativePoint((Component)((Object)DatabaseViewTreeComponent.this), new Point(e2.getX(), bounds.y + bounds.height)));
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e2) {
            Rectangle rectangle;
            Rectangle r1;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            TreePath p0 = this.pathUnderMouse;
            this.checkMouseOnTheLink(e2);
            TreePath p1 = this.pathUnderMouse;
            if (p0 == null && p1 == null) {
                return;
            }
            Rectangle r0 = p0 == null ? null : DatabaseViewTreeComponent.this.getPathBounds(p0);
            Rectangle rectangle2 = r1 = p1 == null ? null : DatabaseViewTreeComponent.this.getPathBounds(p1);
            if (r0 == null && r1 == null) {
                return;
            }
            DatabaseViewTreeComponent.this.setCursor(Cursor.getPredefinedCursor(p1 != null ? 12 : 0));
            if (r0 == null) {
                rectangle = r1;
            } else {
                Rectangle rectangle3 = r1;
                rectangle = rectangle3 == null ? r0 : r0.union(rectangle3);
            }
            Rectangle clip = rectangle;
            DatabaseViewTreeComponent.this.repaint(clip);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e2) {
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            if (this.pathUnderMouse == null) {
                return;
            }
            DatabaseViewTreeComponent.this.setCursor(Cursor.getPredefinedCursor(0));
            Rectangle clip = DatabaseViewTreeComponent.this.getPathBounds(this.pathUnderMouse);
            if (clip != null) {
                DatabaseViewTreeComponent.this.repaint(clip);
            }
            this.pathUnderMouse = null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002R\u001e\u0010\u0003\u001a\u00060\u0004R\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/view/DatabaseViewTreeComponent$MyGradientViewport;", "Lcom/intellij/ui/components/GradientViewport;", "(Lcom/intellij/database/view/DatabaseViewTreeComponent;)V", "myHeaderRenderer", "Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "Lcom/intellij/database/view/DatabaseViewTreeComponent;", "getMyHeaderRenderer", "()Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;", "setMyHeaderRenderer", "(Lcom/intellij/database/view/DatabaseViewTreeComponent$CellRenderer;)V", "findDataSourceOrGroupAt", "Ljavax/swing/tree/TreePath;", "x", "", "y", "getHeader", "Ljava/awt/Component;", "getHeaderPath", "intellij.database.impl"})
    private final class MyGradientViewport
    extends GradientViewport {
        @NotNull
        private CellRenderer myHeaderRenderer;

        public MyGradientViewport() {
            super((Component)((Object)DatabaseViewTreeComponent.this), (Insets)JBUI.insetsTop((int)5), true);
            this.myHeaderRenderer = new CellRenderer(DatabaseViewTreeComponent.this, this){
                final /* synthetic */ MyGradientViewport this$0;
                {
                    this.this$0 = $receiver2;
                }

                @NotNull
                protected NodeRenderer createRenderer() {
                    return new NodeRenderer(this, this.this$0){
                        final /* synthetic */ myHeaderRenderer.1 this$0;
                        final /* synthetic */ MyGradientViewport this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            ClientProperty.put((JComponent)((JComponent)((Object)this)), (Key)AnimatedIcon.REFRESH_DELEGATE, () -> myHeaderRenderer.createRenderer.1._init_$lambda$0(this));
                        }

                        @Nullable
                        protected ItemPresentation getPresentation(@Nullable Object node2) {
                            return (ItemPresentation)ReadAction.compute(() -> myHeaderRenderer.createRenderer.1.getPresentation$lambda$1(this.this$0, node2));
                        }

                        public boolean isShowing() {
                            return this.this$1.isShowing() && MyGradientViewport.access$getHeaderPath(this.this$1) != null;
                        }

                        private static final void _init_$lambda$0(myHeaderRenderer.createRenderer.1 this$0) {
                            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                            this$0.repaint(this$0.getBounds());
                        }

                        private static final ItemPresentation getPresentation$lambda$1(myHeaderRenderer.1 this$0, Object $node) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            return this$0.getCopyPresentationInner($node);
                        }
                    };
                }
            };
        }

        @NotNull
        public final CellRenderer getMyHeaderRenderer() {
            return this.myHeaderRenderer;
        }

        public final void setMyHeaderRenderer(@NotNull CellRenderer cellRenderer) {
            Intrinsics.checkNotNullParameter((Object)cellRenderer, (String)"<set-?>");
            this.myHeaderRenderer = cellRenderer;
        }

        private final TreePath getHeaderPath() {
            int x = DatabaseViewTreeComponent.this.getX();
            int y = DatabaseViewTreeComponent.this.getY();
            if (y == 0) {
                return null;
            }
            NodeRenderer headerComponent = this.myHeaderRenderer.getNodeRenderer();
            int height = headerComponent.getPreferredSize().height;
            TreePath path = this.findDataSourceOrGroupAt(-x, height + 3 - y);
            if (path == null) {
                return null;
            }
            TreePath pathAlt = this.findDataSourceOrGroupAt(-x, -y);
            return pathAlt != null && pathAlt.getLastPathComponent() != path.getLastPathComponent() ? null : path;
        }

        @Nullable
        protected Component getHeader() {
            TreePath path = this.getHeaderPath();
            if (path == null) {
                return null;
            }
            NodeRenderer headerComponent = this.myHeaderRenderer.getNodeRenderer();
            JTree jTree = (JTree)((Object)DatabaseViewTreeComponent.this);
            Object object = path.getLastPathComponent();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLastPathComponent(...)");
            this.myHeaderRenderer.getTreeCellRendererComponent(jTree, object, false, false, true, 0, false);
            Color color = DatabaseViewTreeComponent.this.getFileColorForPath(path);
            headerComponent.setBackground(color);
            headerComponent.setOpaque(color != null);
            headerComponent.setTransparentIconBackground(color == null);
            return (Component)headerComponent;
        }

        private final TreePath findDataSourceOrGroupAt(int x, int y) {
            TreePath path;
            TreePath treePath = path = DatabaseViewTreeComponent.this.getClosestPathForLocation(x, y);
            TreePath treePath2 = path = treePath != null ? treePath.getParentPath() : null;
            while (path != null) {
                Object o2 = path.getLastPathComponent();
                TreePath parentPath = path.getParentPath();
                if (o2 instanceof DataSourceNode || o2 instanceof DvDsGroup || o2 instanceof DasDataSource) {
                    return parentPath == null ? null : path;
                }
                path = parentPath;
            }
            return null;
        }

        public static final /* synthetic */ TreePath access$getHeaderPath(MyGradientViewport $this) {
            return $this.getHeaderPath();
        }
    }
}

