/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SearchPath {
    public final List<ObjectPath> elements;

    private SearchPath(@NotNull List<ObjectPath> elements2) {
        if (elements2 == null) {
            SearchPath.$$$reportNull$$$0(0);
        }
        this.elements = elements2;
    }

    @NotNull
    public ObjectPath getCurrent() {
        ObjectPath objectPath = this.elements.get(0);
        if (objectPath == null) {
            SearchPath.$$$reportNull$$$0(1);
        }
        return objectPath;
    }

    @Contract(value="!null->!null")
    public static SearchPath of(@Nullable ObjectPath p2) {
        return p2 == null ? null : new SearchPath(Collections.singletonList(p2));
    }

    @Nullable
    public static SearchPath of(@Nullable List<ObjectPath> p2) {
        return p2 == null || p2.isEmpty() ? null : new SearchPath(p2);
    }

    @Contract(value="!null->!null")
    public static ObjectPath getCurrent(@Nullable SearchPath p2) {
        return p2 == null ? null : p2.getCurrent();
    }

    @NotNull
    public static List<ObjectPath> getElements(@Nullable SearchPath p2) {
        List<Object> list = p2 == null ? Collections.emptyList() : p2.elements;
        if (list == null) {
            SearchPath.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SearchPath multi = (SearchPath)o2;
        return this.elements.equals(multi.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        return StringUtil.join(this.elements, (Function)Functions.TO_STRING(), (String)",");
    }

    @NlsSafe
    public String getDisplayName() {
        return "[" + StringUtil.join(this.elements, ObjectPath::getDisplayName, (String)", ") + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/SearchPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/SearchPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

