/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.util.Ref;
import com.intellij.util.containers.JBIterable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntrospectionScopeUpdater {
    private final Set<ObjectPath> mySchemasToRemove = new LinkedHashSet<ObjectPath>();
    private final Set<ObjectPath> mySchemasToAdd = new LinkedHashSet<ObjectPath>();

    public IntrospectionScopeUpdater addAll(IntrospectionScopeUpdater other) {
        this.mySchemasToRemove.addAll(other.mySchemasToRemove);
        this.mySchemasToAdd.addAll(other.mySchemasToAdd);
        return this;
    }

    public IntrospectionScopeUpdater toRemove(@Nullable ObjectPath path) {
        if (path != null) {
            this.mySchemasToAdd.remove(path);
            this.mySchemasToRemove.add(path);
        }
        return this;
    }

    public IntrospectionScopeUpdater toAdd(@Nullable ObjectPath path) {
        if (path != null) {
            this.mySchemasToRemove.remove(path);
            this.mySchemasToAdd.add(path);
        }
        return this;
    }

    @NotNull
    public Iterable<ObjectPath> getSchemasToAdd() {
        Set<ObjectPath> set = this.mySchemasToAdd;
        if (set == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    private Set<ObjectPath> getPathsToAdd() {
        LinkedHashSet<ObjectPath> pathsToAdd = new LinkedHashSet<ObjectPath>(this.mySchemasToAdd);
        JBIterable.from(this.mySchemasToRemove).filterMap(p2 -> p2.parent).filter(p2 -> !this.mySchemasToRemove.contains(p2)).addAllTo(pathsToAdd);
        LinkedHashSet<ObjectPath> linkedHashSet = pathsToAdd;
        if (linkedHashSet == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @NotNull
    public TreePattern updateVisibleNamespaces(@NotNull TreePattern introspectionScope, @NotNull BasicModel model2) {
        if (introspectionScope == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(2);
        }
        if (model2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(3);
        }
        if (this.mySchemasToRemove.isEmpty() && this.mySchemasToAdd.isEmpty()) {
            TreePattern treePattern = introspectionScope;
            if (treePattern == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(4);
            }
            return treePattern;
        }
        TreePattern toAdd = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(this.getPathsToAdd()).filterMap(p2 -> ObjectPaths.of((DasObject)QNameUtil.findByPath(model2, p2).first())).map(n -> TreePatternUtils.create(n)));
        TreePattern toRemove = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(this.mySchemasToRemove).filter(p2 -> QNameUtil.findByPath(model2, p2).isEmpty()).map(n -> TreePatternUtils.create(IntrospectionScopeUpdater.adjust(n, introspectionScope, model2))));
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            TreePattern treePattern = introspectionScope;
            if (treePattern == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(5);
            }
            return treePattern;
        }
        TreePattern treePattern = TreePatternUtils.union(TreePatternUtils.minus(introspectionScope, toRemove), toAdd);
        if (treePattern == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(6);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern updateVisibleNamespacesPlain(@NotNull TreePattern introspectionScope, @NotNull CasingProvider casingProvider) {
        if (introspectionScope == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(7);
        }
        if (casingProvider == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(8);
        }
        if (this.mySchemasToRemove.isEmpty() && this.mySchemasToAdd.isEmpty()) {
            TreePattern treePattern = introspectionScope;
            if (treePattern == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        TreePattern toAdd = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(this.getPathsToAdd()).map(n -> TreePatternUtils.create(n)));
        TreePattern toRemove = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from(this.mySchemasToRemove).map(n -> TreePatternUtils.create(IntrospectionScopeUpdater.adjust(n, introspectionScope, casingProvider))));
        if (toAdd.isEmpty() && toRemove.isEmpty()) {
            TreePattern treePattern = introspectionScope;
            if (treePattern == null) {
                IntrospectionScopeUpdater.$$$reportNull$$$0(10);
            }
            return treePattern;
        }
        TreePattern treePattern = TreePatternUtils.union(TreePatternUtils.minus(introspectionScope, toRemove), toAdd);
        if (treePattern == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(11);
        }
        return treePattern;
    }

    public boolean isNotEmpty() {
        return !this.mySchemasToRemove.isEmpty() || !this.mySchemasToAdd.isEmpty();
    }

    @NotNull
    private static ObjectPath adjust(@NotNull ObjectPath path, @NotNull TreePattern pattern2, @NotNull CasingProvider casingProvider) {
        if (path == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(12);
        }
        if (pattern2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(13);
        }
        if (casingProvider == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(14);
        }
        Ref res2 = Ref.create();
        IntrospectionScopeUpdater.adjust(path, pattern2.root, casingProvider, (Ref<ObjectPath>)res2);
        ObjectPath objectPath = (ObjectPath)res2.get();
        if (objectPath == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(15);
        }
        return objectPath;
    }

    @Nullable
    private static TreePatternNode adjust(@NotNull ObjectPath path, @NotNull TreePatternNode root2, @NotNull CasingProvider casingProvider, @NotNull Ref<ObjectPath> res2) {
        if (path == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(16);
        }
        if (root2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(17);
        }
        if (casingProvider == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(18);
        }
        if (res2 == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(19);
        }
        TreePatternNode parent2 = path.parent == null ? root2 : IntrospectionScopeUpdater.adjust(path.parent, root2, casingProvider, res2);
        TreePatternNode.Group group2 = parent2 == null ? null : parent2.getGroup(path.kind);
        TreePatternNode negativeChild = null;
        if (group2 != null) {
            ObjectName name2 = TreePatternUtils.nameOf(path);
            if (group2.children != null) {
                for (TreePatternNode child : group2.children) {
                    ObjectName correction;
                    boolean negative = child.naming instanceof TreePatternNode.NegativeNaming;
                    if (negativeChild == null && negative) {
                        negativeChild = child;
                    }
                    if ((correction = child.naming.find(name2, casingProvider.getCasing(path.kind, null))) == null) continue;
                    res2.set((Object)ObjectPath.create(correction.name, path.kind, correction.quoted, null, (ObjectPath)res2.get()));
                    return negative ? null : child;
                }
            }
        }
        res2.set((Object)ObjectPath.create(path.name, path.kind, path.isQuoted(), null, (ObjectPath)res2.get()));
        return negativeChild;
    }

    public void merge(@NotNull IntrospectionScopeUpdater updater) {
        if (updater == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(20);
        }
        this.mySchemasToAdd.addAll(updater.mySchemasToAdd);
        this.mySchemasToRemove.addAll(updater.mySchemasToRemove);
    }

    public boolean isRemoved(BasicNamespace nsp) {
        Casing casing = nsp.getCasing(nsp.getKind(), nsp);
        ObjectPath path = BasicPaths.of(nsp);
        for (ObjectPath removed : this.mySchemasToRemove) {
            if (!IntrospectionScopeUpdater.matches(path, removed, casing)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(@Nullable ObjectPath p1, @Nullable ObjectPath p2, @NotNull Casing casing) {
        if (casing == null) {
            IntrospectionScopeUpdater.$$$reportNull$$$0(21);
        }
        if (p1 == null || p2 == null) {
            return p1 == p2;
        }
        if (!IntrospectionScopeUpdater.matches(p1.parent, p2.parent, casing)) {
            return false;
        }
        return ObjectPath.namesEqual(p1, p2, casing);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        IntrospectionScopeUpdater updater = (IntrospectionScopeUpdater)o2;
        if (!this.mySchemasToRemove.equals(updater.mySchemasToRemove)) {
            return false;
        }
        return this.mySchemasToAdd.equals(updater.mySchemasToAdd);
    }

    public int hashCode() {
        int result2 = this.mySchemasToRemove.hashCode();
        result2 = 31 * result2 + this.mySchemasToAdd.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 7, 8, 12, 13, 14, 16, 17, 18, 19, 20, 21 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/IntrospectionScopeUpdater";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introspectionScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemasToAdd";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToAdd";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/IntrospectionScopeUpdater";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "updateVisibleNamespaces";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "updateVisibleNamespacesPlain";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "adjust";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateVisibleNamespaces";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateVisibleNamespacesPlain";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "adjust";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 7, 8, 12, 13, 14, 16, 17, 18, 19, 20, 21 -> new IllegalArgumentException(string);
        };
    }
}

