/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.LevelAnalyzer;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.properties.Level;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseUiService;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailsSyncHelper {
    @Nullable
    private final ScriptCategory myScriptCategory;
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final List<BasicElement> myElements = new ArrayList<BasicElement>();
    private boolean myAllSources;

    @Contract(value="null,!null,_->fail")
    public DetailsSyncHelper(@Nullable Project project, @Nullable LocalDataSource dataSource2, @Nullable ScriptCategory scriptCategory) {
        assert (project != null || dataSource2 == null);
        this.myScriptCategory = scriptCategory;
        this.myProject = project;
        this.myDataSource = dataSource2;
    }

    public static DetailsSyncHelper of(@Nullable DbElement element2) {
        return DetailsSyncHelper.of(element2, null);
    }

    public static DetailsSyncHelper of(@Nullable DbElement element2, @Nullable ScriptCategory scriptCategory) {
        if (element2 == null) {
            return new DetailsSyncHelper(null, null, scriptCategory);
        }
        DetailsSyncHelper res2 = DetailsSyncHelper.of(element2.getProject(), element2.getDataSource(), scriptCategory);
        return res2.check(element2);
    }

    public static DetailsSyncHelper of(@NotNull Project project, @Nullable DasDataSource dataSource2, @Nullable ScriptCategory scriptCategory) {
        if (project == null) {
            DetailsSyncHelper.$$$reportNull$$$0(0);
        }
        if (dataSource2 instanceof DbDataSource) {
            dataSource2 = ((DbDataSource)dataSource2).getDelegate();
        }
        return new DetailsSyncHelper(project, (LocalDataSource)ObjectUtils.tryCast((Object)dataSource2, LocalDataSource.class), scriptCategory);
    }

    public DetailsSyncHelper check(@Nullable DbElement e2) {
        return this.check(e2 instanceof DbDataSource ? null : DbImplUtilCore.getMaybeBasicElement(e2));
    }

    public DetailsSyncHelper check(@Nullable BasicElement e2) {
        ContainerUtil.addIfNotNull(this.myElements, (Object)e2);
        return this;
    }

    public DetailsSyncHelper check(@NotNull Iterable<BasicElement> elements2) {
        if (elements2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(1);
        }
        ContainerUtil.addAll(this.myElements, elements2);
        return this;
    }

    public DetailsSyncHelper withAllSources() {
        this.myAllSources = true;
        return this;
    }

    @Nullable
    public LoaderContext prepareContextIfIntrospectionIsNeeded() {
        if (this.myProject == null || this.myDataSource == null || this.myElements.isEmpty() && !this.myAllSources || !DBIntrospectorFeatures.supportsMultilevelIntrospection(this.myDataSource)) {
            return null;
        }
        if (this.myAllSources) {
            boolean needsIntrospection;
            JBTreeTraverser objects2 = DbImplUtilCore.traverseVisibleObjects((JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.myElements.isEmpty() ? this.myDataSource.getModel().getModelRoots() : this.myElements), this.myDataSource.getIntrospectionScope());
            boolean bl = needsIntrospection = objects2.traverse().filter(BasicMultiLevelObject.class).find(it2 -> it2.getDetailsLevel() != Level.L3) != null;
            if (!needsIntrospection) {
                return null;
            }
            return LoaderContext.selectGeneralTask(this.myProject, this.myDataSource);
        }
        LevelAnalyzer analyzer = DetailsSyncHelper.createAnalyzer(this.myDataSource);
        DetailsSyncHelper.giveElementsToAnalyse(analyzer, this.myElements);
        LevelAnalyzer.Recommendation recommendation = this.myScriptCategory == null ? analyzer.analyzeForAllDetailsAccessing() : analyzer.analyzeForScripting(this.myScriptCategory);
        return DetailsSyncHelper.prepareContext(this.myProject, this.myDataSource, recommendation);
    }

    private static void giveElementsToAnalyse(@NotNull LevelAnalyzer analyzer, @NotNull List<BasicElement> elements2) {
        if (analyzer == null) {
            DetailsSyncHelper.$$$reportNull$$$0(2);
        }
        if (elements2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(3);
        }
        ArrayList<String> errors = null;
        for (BasicElement e2 : elements2) {
            try {
                analyzer.addElementToAnalysis(e2);
            }
            catch (IllegalArgumentException iae) {
                if (errors == null) {
                    errors = new ArrayList<String>();
                }
                errors.add(iae.getMessage());
            }
        }
        if (errors != null) {
            int n = errors.size();
            String message2 = "The following " + n + StringUtil.pluralize((String)"elements", (int)n) + (n == 1 ? " was" : " were") + " not accepted by elements level analyzer:\n\t" + StringUtil.join(errors, (String)"\n\t");
            Logger logger2 = Logger.getInstance(DetailsSyncHelper.class);
            logger2.warn(message2);
        }
    }

    public static boolean askUserForSyncOrAbort(@NotNull DbDataSource dbDataSource, @NotNull BasicElement element2, @Nls String actionName) {
        if (dbDataSource == null) {
            DetailsSyncHelper.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(5);
        }
        Project project = dbDataSource.getProject();
        RawDataSource dataSourceDelegate = dbDataSource.getDelegate();
        if (!(dataSourceDelegate instanceof LocalDataSource)) {
            return false;
        }
        LocalDataSource dataSource2 = (LocalDataSource)dataSourceDelegate;
        return DetailsSyncHelper.askUserForSyncOrAbort(project, dataSource2, element2, actionName);
    }

    public static boolean askUserForSyncOrAbort(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull BasicElement element2, @Nls String actionName) {
        LevelAnalyzer.Recommendation recommendation;
        if (project == null) {
            DetailsSyncHelper.$$$reportNull$$$0(6);
        }
        if (dataSource2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(8);
        }
        boolean abort = false;
        if (element2.isOutdated()) {
            DatabaseUiService databaseUiService = DatabaseUiService.getInstance();
            abort = databaseUiService.askIfAbort(actionName, project, dataSource2, element2);
        } else if (DBIntrospectorFeatures.supportsMultilevelIntrospection(dataSource2) && (recommendation = DetailsSyncHelper.analyzeWhatToIntrospect(dataSource2.getDbms(), element2)).hasContent()) {
            DatabaseUiService databaseUiService = DatabaseUiService.getInstance();
            abort = databaseUiService.confirmAndRunSync(project, dataSource2, actionName, recommendation);
        }
        return abort;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public boolean askAbortIfSyncRequired(@Nls String string) {
        void actionName;
        ThreadingAssertions.assertEventDispatchThread();
        LoaderContext context = this.prepareContextIfIntrospectionIsNeeded();
        if (context == null) {
            return false;
        }
        return DatabaseUiService.getInstance().askIfAbort((String)actionName, context);
    }

    public boolean askAbortIfSyncRequiredAnyThread(@Nls String actionName) {
        if (EDT.isCurrentThreadEdt()) {
            return this.askAbortIfSyncRequired(actionName);
        }
        Ref res2 = Ref.create((Object)false);
        ApplicationManager.getApplication().invokeAndWait(() -> res2.set((Object)this.askAbortIfSyncRequired(actionName)));
        return (Boolean)res2.get();
    }

    public void notifyIfSyncRequired(@Nls String actionName) {
        LoaderContext context = this.prepareContextIfIntrospectionIsNeeded();
        if (context == null) {
            return;
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message("notification.title.low.introspection.level", StringUtil.trimEnd((String)actionName, (String)"\u2026")), DatabaseBundle.message("notification.content.results.might.be.wrong.due.to.low.level", new Object[0]) + HtmlChunk.link((String)"sync", (String)DatabaseBundle.message("notification.content.increase.introspection.level", new Object[0])), NotificationType.WARNING).setListener((notification, event) -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                DataSourceUtil.performManualSyncTask(context);
            }
        }).setDisplayId("DetailsSyncHelper.sync.required").notify(context.getProject());
    }

    @NotNull
    public static LevelAnalyzer.Recommendation analyzeWhatToIntrospect(@NotNull DbElement dbElement) {
        LocalDataSource dataSource2;
        if (dbElement == null) {
            DetailsSyncHelper.$$$reportNull$$$0(9);
        }
        if ((dataSource2 = (LocalDataSource)ObjectUtils.tryCast((Object)dbElement.getDataSource().getDelegateDataSource(), LocalDataSource.class)) == null) {
            LevelAnalyzer.Recommendation recommendation = LevelAnalyzer.Recommendation.nothing;
            if (recommendation == null) {
                DetailsSyncHelper.$$$reportNull$$$0(10);
            }
            return recommendation;
        }
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dataSource2)) {
            LevelAnalyzer.Recommendation recommendation = LevelAnalyzer.Recommendation.nothing;
            if (recommendation == null) {
                DetailsSyncHelper.$$$reportNull$$$0(11);
            }
            return recommendation;
        }
        BasicElement element2 = (BasicElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicElement.class);
        if (element2 == null) {
            LevelAnalyzer.Recommendation recommendation = LevelAnalyzer.Recommendation.nothing;
            if (recommendation == null) {
                DetailsSyncHelper.$$$reportNull$$$0(12);
            }
            return recommendation;
        }
        Dbms dbms = dbElement.getDbms();
        return DetailsSyncHelper.analyzeWhatToIntrospect(dbms, element2);
    }

    @NotNull
    private static LevelAnalyzer.Recommendation analyzeWhatToIntrospect(@NotNull Dbms dbms, @NotNull BasicElement element2) {
        if (dbms == null) {
            DetailsSyncHelper.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(14);
        }
        LevelAnalyzer analyzer = DetailsSyncHelper.createAnalyzer(dbms);
        analyzer.addElementToAnalysis(element2);
        LevelAnalyzer.Recommendation recommendation = analyzer.analyzeForAllDetailsAccessing();
        if (recommendation == null) {
            DetailsSyncHelper.$$$reportNull$$$0(15);
        }
        return recommendation;
    }

    @NotNull
    private static LevelAnalyzer createAnalyzer(@NotNull LocalDataSource dataSource2) {
        if (dataSource2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(16);
        }
        Dbms dbms = dataSource2.getDbms();
        return DetailsSyncHelper.createAnalyzer(dbms);
    }

    @NotNull
    public static LevelAnalyzer createAnalyzer(@NotNull Dbms dbms) {
        if (dbms == null) {
            DetailsSyncHelper.$$$reportNull$$$0(17);
        }
        LevelAnalyzer levelAnalyzer = ModelFacade.forDbms(dbms).createLevelAnalyzer();
        if (levelAnalyzer == null) {
            DetailsSyncHelper.$$$reportNull$$$0(18);
        }
        return levelAnalyzer;
    }

    @Nullable
    public static LoaderContext prepareContext(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull LevelAnalyzer.Recommendation recommendation) {
        if (project == null) {
            DetailsSyncHelper.$$$reportNull$$$0(19);
        }
        if (dataSource2 == null) {
            DetailsSyncHelper.$$$reportNull$$$0(20);
        }
        if (recommendation == null) {
            DetailsSyncHelper.$$$reportNull$$$0(21);
        }
        if (recommendation.hasContent()) {
            return LoaderContext.selectTasks(project, dataSource2, recommendation.tasks);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analyzer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbDataSource";
                break;
            }
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DetailsSyncHelper";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recommendation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DetailsSyncHelper";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeWhatToIntrospect";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnalyzer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "giveElementsToAnalyse";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "askUserForSyncOrAbort";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "analyzeWhatToIntrospect";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAnalyzer";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 15, 18 -> new IllegalStateException(string);
        };
    }
}

