/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.CodeMarker;
import com.intellij.database.util.CodeTextWithMarkers;
import com.intellij.database.util.CodeWithMarkers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001f\u001a\u00020\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010 \u001a\u0004\u0018\u00010!J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u0006H\u0002J\b\u0010(\u001a\u00020&H\u0002J\u0019\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0*H\u0016\u00a2\u0006\u0002\u0010+J\f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003J\b\u0010-\u001a\u00020\u000fH\u0016J\u0006\u0010.\u001a\u00020&J\u000e\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u00020\u000fJ\u0014\u00100\u001a\u00020&2\f\u00101\u001a\b\u0012\u0004\u0012\u00020&02J%\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020$2\u0006\u00106\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00107J\u0006\u00108\u001a\u00020&J9\u00109\u001a\u00020&2\u0016\u0010:\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0*\"\u0004\u0018\u00010!2\n\b\u0002\u00106\u001a\u0004\u0018\u00018\u00002\b\b\u0002\u00108\u001a\u00020\u0006\u00a2\u0006\u0002\u0010;J2\u0010<\u001a\u00020&2\u0016\u0010:\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010!0*\"\u0004\u0018\u00010!2\n\b\u0002\u00106\u001a\u0004\u0018\u00018\u0000H\u0086\b\u00a2\u0006\u0002\u0010=J\u0006\u0010>\u001a\u00020&J\u0006\u0010?\u001a\u00020&J\b\u0010@\u001a\u00020$H\u0016J\b\u0010A\u001a\u00020\u000fH\u0016J\b\u0010B\u001a\u00020&H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/intellij/database/util/CodeBuilder;", "A", "", "Lcom/intellij/database/util/CodeWithMarkers;", "()V", "atLineBegin", "", "getAtLineBegin", "()Z", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getBuf", "()Ljava/lang/StringBuilder;", "currIndentation", "", "defaultIndentation", "getDefaultIndentation", "()Ljava/lang/String;", "setDefaultIndentation", "(Ljava/lang/String;)V", "lastChar", "", "getLastChar", "()C", "markers", "Ljava/util/ArrayList;", "Lcom/intellij/database/util/CodeMarker;", "stack", "Ljava/util/Stack;", "append", "c", "text", "", "charAt", "index", "", "ensurePrefix", "", "space", "ensureSpace", "getMarkers", "", "()[Lcom/intellij/database/util/CodeMarker;", "getResult", "getText", "indent", "indentation", "indenting", "block", "Lkotlin/Function0;", "mark", "begin", "end", "annotation", "(IILjava/lang/Object;)V", "nl", "phrase", "words", "([Ljava/lang/CharSequence;Ljava/lang/Object;Z)V", "phraseLn", "([Ljava/lang/CharSequence;Ljava/lang/Object;)V", "removeLastChar", "tab", "textLength", "toString", "unindent", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nCodeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeBuilder.kt\ncom/intellij/database/util/CodeBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,195:1\n37#2,2:196\n37#2,2:198\n*S KotlinDebug\n*F\n+ 1 CodeBuilder.kt\ncom/intellij/database/util/CodeBuilder\n*L\n161#1:196,2\n165#1:198,2\n*E\n"})
public final class CodeBuilder<A>
implements CodeWithMarkers<A> {
    @NotNull
    private String defaultIndentation = "\t";
    @NotNull
    private final StringBuilder buf = new StringBuilder();
    @NotNull
    private final ArrayList<CodeMarker<A>> markers = new ArrayList();
    @NotNull
    private final Stack<String> stack = new Stack();
    @NotNull
    private String currIndentation = "";

    @NotNull
    public final String getDefaultIndentation() {
        return this.defaultIndentation;
    }

    public final void setDefaultIndentation(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultIndentation = string;
    }

    @NotNull
    public final StringBuilder getBuf() {
        return this.buf;
    }

    public final void indent() {
        this.indent(this.defaultIndentation);
    }

    public final void indent(@NotNull String indentation) {
        Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
        this.stack.push(this.currIndentation);
        this.currIndentation = this.currIndentation + indentation;
    }

    private final void unindent() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("The called 'unindent()' doesn't correspond to previous 'indent()'");
        }
        this.nl();
        String string = this.stack.pop();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pop(...)");
        this.currIndentation = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void indenting(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.indent();
        try {
            block.invoke();
        }
        finally {
            this.unindent();
        }
    }

    public final void phraseLn(@NotNull CharSequence[] words, @Nullable A annotation) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        boolean $i$f$phraseLn = false;
        this.phrase(Arrays.copyOf(words, words.length), annotation, true);
    }

    public static /* synthetic */ void phraseLn$default(CodeBuilder $this, CharSequence[] words, Object annotation, int n, Object object) {
        if ((n & 2) != 0) {
            annotation = null;
        }
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        boolean $i$f$phraseLn = false;
        $this.phrase(Arrays.copyOf(words, words.length), annotation, true);
    }

    public final void phrase(@NotNull CharSequence[] words, @Nullable A annotation, boolean nl) {
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        int begin = -1;
        boolean was = false;
        for (CharSequence word : words) {
            CharSequence charSequence = word;
            if (charSequence == null || charSequence.length() == 0) continue;
            if (was) {
                this.ensureSpace();
            } else {
                this.ensurePrefix(true);
                begin = this.buf.length();
                was = true;
            }
            this.append(word);
        }
        int end = this.buf.length();
        if (nl) {
            this.buf.append('\n');
        }
        if (was && begin >= 0 && annotation != null) {
            this.mark(begin, end, annotation);
        }
    }

    public static /* synthetic */ void phrase$default(CodeBuilder codeBuilder, CharSequence[] charSequenceArray, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        codeBuilder.phrase(charSequenceArray, object, bl);
    }

    @NotNull
    public final CodeBuilder<A> append(@Nullable CharSequence text2) {
        if (text2 == null) {
            return this;
        }
        List lines = StringsKt.lines((CharSequence)text2);
        int n = lines.size();
        if (n == 0) {
            return this;
        }
        CodeBuilder.ensurePrefix$default(this, false, 1, null);
        this.buf.append((String)lines.get(0));
        for (int i2 = 1; i2 < n; ++i2) {
            this.buf.append('\n').append((String)lines.get(i2));
        }
        return this;
    }

    @NotNull
    public final CodeBuilder<A> append(char c2) {
        CodeBuilder.ensurePrefix$default(this, false, 1, null);
        if (c2 == '\r' || c2 == '\n') {
            this.buf.append('\n');
        } else {
            this.buf.append(c2);
        }
        return this;
    }

    private final void mark(int begin, int end, A annotation) {
        CodeMarker<A> marker = new CodeMarker<A>(begin, end, annotation);
        this.markers.add(marker);
    }

    private final void ensurePrefix(boolean space) {
        char c2 = this.getLastChar();
        if (c2 == '\u0000' || c2 == '\n') {
            if (((CharSequence)this.currIndentation).length() > 0) {
                this.buf.append(this.currIndentation);
            }
        } else if (!CharsKt.isWhitespace((char)c2) && space) {
            this.buf.append(' ');
        }
    }

    static /* synthetic */ void ensurePrefix$default(CodeBuilder codeBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        codeBuilder.ensurePrefix(bl);
    }

    private final void ensureSpace() {
        char c2 = this.getLastChar();
        if (c2 == '\u0000' || CharsKt.isWhitespace((char)c2)) {
            return;
        }
        this.buf.append(' ');
    }

    public final void nl() {
        char lc = this.getLastChar();
        if (lc == '\u0000' || lc == '\n') {
            return;
        }
        this.buf.append('\n');
    }

    public final void tab() {
        this.buf.append('\t');
    }

    public final void removeLastChar() {
        int n = this.buf.length();
        if (n == 0) {
            throw new IllegalStateException("Cannot remove the last character: the buffer is empty");
        }
        this.buf.setLength(n - 1);
    }

    @NotNull
    public final CodeWithMarkers<A> getResult() {
        String string = this.buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Collection $this$toTypedArray$iv = this.markers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new CodeTextWithMarkers(string, thisCollection$iv.toArray(new CodeMarker[0]));
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public CodeMarker<A>[] getMarkers() {
        Collection $this$toTypedArray$iv = this.markers;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CodeMarker[0]);
    }

    @Override
    public int textLength() {
        return this.buf.length();
    }

    @Override
    public char charAt(int index2) {
        return index2 < this.buf.length() ? this.buf.charAt(index2) : (char)'\u0000';
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    private final char getLastChar() {
        int n = this.buf.length();
        if (n == 0) {
            return '\u0000';
        }
        return this.buf.charAt(n - 1);
    }

    public final boolean getAtLineBegin() {
        char c2 = this.getLastChar();
        return c2 == '\u0000' ? true : c2 == '\n';
    }
}

