/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.csv.GridCsvBundle;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.settings.CsvSettings;
import com.intellij.database.settings.DataGridAppearanceSettings;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.database.settings.ExtraParametersProvider;
import com.intellij.database.settings.UserPatterns;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.database.util.common.TimeFunKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlFileResolveMode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="DatabaseSettings", storages={@Storage(value="databaseSettings.xml")}, category=SettingsCategory.TOOLS)
public final class DatabaseSettings
implements PersistentStateComponent<DatabaseSettings>,
ModificationTracker,
DataGridSettings,
CsvFormatsSettings,
DataGridAppearanceSettings {
    private static final int CURRENT_VERSION = 10;
    static final String STATE_NAME = "databaseSettings";
    static final int EXEC_COUNT = 3;
    public static final int EXECUTE_INSIDE_SHOW_CHOOSER = 1;
    public static final int EXECUTE_INSIDE_SUBQUERY = 2;
    public static final int EXECUTE_INSIDE_SMALLEST = 3;
    public static final int EXECUTE_INSIDE_LARGEST = 4;
    public static final int EXECUTE_INSIDE_BATCH = 5;
    public static final int EXECUTE_INSIDE_WHOLE_SCRIPT = 6;
    public static final int EXECUTE_INSIDE_SCRIPT_TAIL = 7;
    public static final int EXECUTE_OUTSIDE_NOTHING = 1;
    public static final int EXECUTE_OUTSIDE_WHOLE_SCRIPT = 2;
    public static final int EXECUTE_OUTSIDE_SCRIPT_TAIL = 3;
    public static final int EXECUTE_SELECTION_EXACTLY_ONE = 1;
    public static final int EXECUTE_SELECTION_EXACTLY_SCRIPT = 2;
    public static final int EXECUTE_SELECTION_SMART_EXPAND = 3;
    private final AtomicLong myModificationCount = new AtomicLong();
    public static final Topic<Runnable> TOPIC = Topic.create((String)"Database settings", Runnable.class);
    @Attribute(value="version")
    @Property(alwaysWrite=true)
    private int version = 0;
    @OptionTag(value="results-title-prefix")
    public String resultsTitlePrefix = null;
    @OptionTag(value="results-title-prefix-enabled")
    public boolean resultsTitlePrefixEnabled = true;
    @OptionTag(value="submit-immediately")
    public boolean submitImmediately = false;
    @OptionTag(value="page-size")
    public int pageSize = 500;
    @OptionTag(value="page-size-updated-timestamp")
    public long pageSizeUpdatedTimestamp = 0L;
    @OptionTag(value="limit-page-size")
    public boolean limitPageSize = true;
    @Deprecated(forRemoval=true)
    @OptionTag(value="auto-transpose")
    public boolean autoTranspose = false;
    @OptionTag(value="auto-transpose-mode")
    public DataGridSettings.AutoTransposeMode autoTransposeMode = DataGridSettings.AutoTransposeMode.NEVER;
    @OptionTag(value="enable-local-filter-by-default")
    public boolean enableLocalFilterByDefault = true;
    @OptionTag(value="enable-paging-in-in-editor-result-by-default")
    public boolean enablePagingInInEditorResultsByDefault = false;
    @OptionTag(value="disable-grid-floating-toolbar")
    public boolean disableGridFloatingToolbar = false;
    @OptionTag(value="enable-immediate-completion-in-grid-cells")
    public boolean enableImmediateCompletionInGridCells = true;
    @OptionTag(value="enable-grid-floating-toolbar-customization")
    public boolean enableGridFloatingToolbarCustomization = true;
    @OptionTag(value="boolean-mode")
    public DataGridAppearanceSettings.BooleanMode booleanMode = DataGridAppearanceSettings.BooleanMode.TEXT;
    @OptionTag(value="detect-text-in-binary-columns")
    public boolean detectTextInBinaryColumns = true;
    @OptionTag(value="detect-uuid-in-binary-columns")
    public boolean detectUUIDInBinaryColumns = true;
    @OptionTag(value="striped-table")
    public boolean stripedTable = false;
    @Deprecated
    @OptionTag(value="default-ordering")
    public RowSortOrder.Type defaultTableOrdering = RowSortOrder.Type.UNSORTED;
    @OptionTag(value="sort-tables")
    public boolean sortTables = false;
    @OptionTag(value="table-ordering-asc")
    public boolean tableOrderingAsc = true;
    @OptionTag(value="sort-via-order-by")
    public boolean sortViaOrderBy = true;
    @OptionTag(value="always-review-parameters")
    public boolean alwaysReviewParameters = true;
    @OptionTag(value="split-statements-mode")
    public SplitScriptMode splitScriptMode = SplitScriptMode.COMBINED;
    @OptionTag(value="load-slow-documentation")
    public boolean loadSlowDocumentation = true;
    @OptionTag(value="preview-rows")
    public int previewRows = 10;
    @OptionTag(value="filters-history-size")
    public int filtersHistorySize = 10;
    @OptionTag(value="prefetch-size")
    public int prefetchSize = 100;
    @OptionTag(value="lob-length")
    public int bytesLimitPerValue = 204800;
    @OptionTag(value="warn-unsafe-query")
    public boolean warnAboutUnsafeQuery = true;
    @OptionTag(value="show-query-output-timestamp")
    public boolean showQueryOutputTimestamp = false;
    @OptionTag(value="ddl-editor-confirm-loss")
    public boolean ddlConfirmLoss = true;
    @OptionTag(value="skip-refactoring-preview")
    public boolean skipRefactoringPreview = false;
    @OptionTag(value="notebook-mode")
    public boolean notebookMode = false;
    @OptionTag(value="focus-on-services-in-window-mode")
    public boolean focusOnServicesInWindowMode = false;
    @OptionTag(value="show-output-in-tab")
    public boolean showOutputInTab = false;
    @OptionTag(value="ignore-hidden-clients-output")
    public boolean showOnlySelectedClientOutput = false;
    @OptionTag(value="context-tempate-target")
    public ContextTemplateTarget contextTemplateTarget = ContextTemplateTarget.APPEND_TO_EXISTING_CONSOLE;
    @OptionTag(value="show-services-mode")
    public ShowServicesMode showServicesMode = ShowServicesMode.ALL;
    @OptionTag(value="add-to-sort-via-alt-click")
    public boolean addToSortViaAltClick = true;
    @OptionTag(value="use-custom-font")
    public boolean useGridCustomFont = false;
    @OptionTag(value="grid-font-family")
    public String gridFontFamily = null;
    @OptionTag(value="grid-font-size")
    public int gridFontSize = -1;
    @OptionTag(value="grid-line-spacing")
    public float gridLineSpacing = -1.0f;
    @OptionTag(value="sampling-size")
    public String samplingSize = "1";
    @OptionTag(value="disabled-aggregators")
    public List<String> disabledAggregators = new ArrayList<String>();
    @OptionTag(value="widget-aggregator")
    public String widgetAggregator = null;
    @OptionTag(value="suggest-mapping-dumping")
    public boolean suggestMappingDumping = true;
    @OptionTag(value="tree-filter-is-sticky")
    public boolean treeFilterIsSticky = true;
    @OptionTag(value="default-console-resolve-mode")
    public SqlFileResolveMode defaultConsoleResolveMode = SqlFileResolveMode.PLAYGROUND;
    @OptionTag(value="statement-delimiter")
    public String statementDelimiter = "";
    @XCollection(propertyElementName="exec-options", elementName="exec-option", elementTypes={ExecOption.class})
    public List<ExecOption> execOptions = ContainerUtil.newArrayList((Iterable)JBIterable.of((Object)"").repeat(3).map(o2 -> new ExecOption()));
    @Property(surroundWithTag=false)
    public UserPatterns userPatterns = new UserPatterns();
    @XCollection(propertyElementName="csv-formats", elementName="format", elementTypes={PersistentCsvFormat.class})
    public List<PersistentCsvFormat> csvFormats = new ArrayList<PersistentCsvFormat>();
    @OptionTag(value="number-grouping-enabled")
    public boolean numberGroupingEnabled = false;
    @OptionTag(value="number-grouping-separator")
    public String numberGroupingSeparator = " ";
    @OptionTag(value="decimal-separator")
    public String decimalSeparator = ".";
    @OptionTag(value="infinity")
    public String infinity = "Infinity";
    @OptionTag(value="nan")
    public String nan = "NaN";
    @OptionTag(value="number-pattern-enabled")
    public boolean numberPatternEnabled = false;
    @OptionTag(value="numberPattern")
    public String numberPattern = "";
    @OptionTag(value="date-time-pattern-enabled")
    public boolean dateTimePatternEnabled = false;
    @OptionTag(value="date-time-pattern")
    public String dateTimePattern = "yyyy-MM-dd HH:mm:ss";
    @OptionTag(value="zoned-date-time-pattern-enabled")
    public boolean zonedDateTimePatternEnabled = false;
    @OptionTag(value="zoned-date-time-pattern")
    public String zonedDateTimePattern = "yyyy-MM-dd HH:mm:ss Z";
    @OptionTag(value="time-pattern-enabled")
    public boolean timePatternEnabled = false;
    @OptionTag(value="time-pattern")
    public String timePattern = "HH:mm:ss";
    @OptionTag(value="zoned-time-pattern-enabled")
    public boolean zonedTimePatternEnabled = false;
    @OptionTag(value="zoned-time-pattern")
    public String zonedTimePattern = "HH:mm:ss Z";
    @OptionTag(value="date-pattern-enabled")
    public boolean datePatternEnabled = false;
    @OptionTag(value="date-pattern")
    public String datePattern = "yyyy-MM-dd";
    @OptionTag(value="formatting-time-zone")
    public String formattingTimeZone = "";
    @OptionTag(value="open-https-enabled")
    public boolean isOpeningOfHttpsLinkAllowed = false;
    @OptionTag(value="open-http-enabled")
    public boolean isOpeningOfHttpLinkAllowed = false;
    @OptionTag(value="open-local-file-enabled")
    public boolean isOpeningOfLocalFileUrlAllowed = false;
    @OptionTag(value="open-as-http")
    public boolean isWebUrlWithoutProtocolIsHttp = false;
    @Transient
    public final TokenPatternCache patternCache = new TokenPatternCache(this);

    public long getModificationCount() {
        return this.myModificationCount.get();
    }

    @Deprecated
    public boolean getUseGridCustomFont() {
        return this.useGridCustomFont;
    }

    @Deprecated
    public void setUseGridCustomFont(boolean value2) {
        this.useGridCustomFont = value2;
    }

    @Deprecated
    @Nullable
    public String getGridFontFamily() {
        return this.gridFontFamily;
    }

    @Deprecated
    public void setGridFontFamily(@Nullable String value2) {
        this.gridFontFamily = value2;
    }

    @Deprecated
    public int getGridFontSize() {
        return this.gridFontSize;
    }

    @Deprecated
    public void setGridFontSize(int value2) {
        this.gridFontSize = value2;
    }

    @Deprecated
    public float getGridLineSpacing() {
        return this.gridLineSpacing;
    }

    @Deprecated
    public void setGridLineSpacing(float value2) {
        this.gridLineSpacing = value2;
    }

    public String getTableSamplingSize() {
        return this.samplingSize;
    }

    public void setTableSamplingSize(String size) {
        this.samplingSize = size;
    }

    @NotNull
    public List<String> getDisabledAggregators() {
        List<String> list = this.disabledAggregators;
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setDisabledAggregators(@NotNull List<String> aggregators) {
        if (aggregators == null) {
            DatabaseSettings.$$$reportNull$$$0(1);
        }
        this.disabledAggregators = aggregators;
    }

    public String getWidgetAggregator() {
        return this.widgetAggregator;
    }

    public void setWidgetAggregator(String aggregator) {
        this.widgetAggregator = aggregator;
    }

    public boolean isNumberGroupingEnabled() {
        return this.numberGroupingEnabled;
    }

    public char getNumberGroupingSeparator() {
        return this.numberGroupingSeparator.isEmpty() ? (char)' ' : this.numberGroupingSeparator.charAt(0);
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator.isEmpty() ? (char)'.' : this.decimalSeparator.charAt(0);
    }

    @NotNull
    public String getInfinity() {
        String string = StringUtil.notNullize((String)this.infinity);
        if (string == null) {
            DatabaseSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getNan() {
        String string = StringUtil.notNullize((String)this.nan);
        if (string == null) {
            DatabaseSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getEffectiveNumberPattern() {
        return this.numberPatternEnabled ? this.numberPattern : null;
    }

    @Nullable
    public String getEffectiveDateTimePattern() {
        return this.dateTimePatternEnabled ? this.dateTimePattern : null;
    }

    @Nullable
    public String getEffectiveZonedDateTimePattern() {
        return this.zonedDateTimePatternEnabled ? this.zonedDateTimePattern : null;
    }

    @Nullable
    public String getEffectiveTimePattern() {
        return this.timePatternEnabled ? this.timePattern : null;
    }

    @Nullable
    public String getEffectiveZonedTimePattern() {
        return this.zonedTimePatternEnabled ? this.zonedTimePattern : null;
    }

    @Nullable
    public String getEffectiveDatePattern() {
        return this.datePatternEnabled ? this.datePattern : null;
    }

    @Nullable
    public ZoneId getEffectiveZoneId() {
        return TimeFunKt.zoneIdOrNull(this.formattingTimeZone);
    }

    @NotNull
    public static ExecOption getDefaultExecOption() {
        ExecOption execOption = DatabaseSettings.getSettings().execOptions.get(0);
        if (execOption == null) {
            DatabaseSettings.$$$reportNull$$$0(4);
        }
        return execOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseSettings getSettings() {
        DatabaseSettings settings = (DatabaseSettings)ApplicationManager.getApplication().getService(DatabaseSettings.class);
        if (settings != null && settings.version == 0) {
            DatabaseSettings databaseSettings = settings;
            synchronized (databaseSettings) {
                settings.ensureDefaultsSet();
            }
        }
        return settings;
    }

    public void fireChanged() {
        DatabaseSettings.fireSettingsChanged();
    }

    public static void fireSettingsChanged() {
        DatabaseSettings instance = DatabaseSettings.getSettings();
        instance.myModificationCount.incrementAndGet();
        instance.patternCache.clear();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        ((Runnable)messageBus.syncPublisher(TOPIC)).run();
        ((DataGridSettings.Listener)messageBus.syncPublisher(DataGridSettings.TOPIC)).settingsChanged();
        ((CsvFormatsSettings.Listener)messageBus.syncPublisher(CsvFormatsSettings.TOPIC)).settingsChanged();
    }

    @TestOnly
    public static DatabaseSettings create() {
        DatabaseSettings settings = new DatabaseSettings();
        settings.ensureDefaultsSet();
        return settings;
    }

    private DatabaseSettings() {
    }

    @TestOnly
    public void initTestDefaults() {
        LinkedHashSet<UserPatterns.ParameterPattern> predef = new LinkedHashSet<UserPatterns.ParameterPattern>(UserPatterns.getPredefined());
        ContainerUtil.addAll(predef, (Object[])new ExtraParametersProvider().getPatterns());
        this.getUserPatterns().patterns = new ArrayList<UserPatterns.ParameterPattern>(predef);
        this.getUserPatterns().processStrings = false;
        this.patternCache.clear();
        this.splitScriptMode = SplitScriptMode.ON_STATEMENTS;
        this.contextTemplateTarget = ContextTemplateTarget.APPEND_TO_EXISTING_CONSOLE;
    }

    @NotNull
    public DatabaseSettings getState() {
        DatabaseSettings databaseSettings = this;
        if (databaseSettings == null) {
            DatabaseSettings.$$$reportNull$$$0(5);
        }
        return databaseSettings;
    }

    @TestOnly
    public DatabaseSettings copy() {
        return (DatabaseSettings)XmlSerializer.deserialize((Element)XmlSerializer.serialize((Object)this), DatabaseSettings.class);
    }

    public void loadState(@NotNull DatabaseSettings state) {
        if (state == null) {
            DatabaseSettings.$$$reportNull$$$0(6);
        }
        List<ExecOption> execOptionsPrev = this.execOptions;
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (this.execOptions.size() != 3) {
            JBIterable required = JBIterable.from(this.execOptions).append(execOptionsPrev).take(3);
            this.execOptions = ContainerUtil.newArrayList((Iterable)required);
        }
        this.ensureDefaultsSet();
    }

    public boolean isSubmitImmediately() {
        return this.submitImmediately;
    }

    public boolean isAddToSortViaAltClick() {
        return this.addToSortViaAltClick;
    }

    public void setAddToSortViaAltClick(boolean value2) {
        this.addToSortViaAltClick = value2;
    }

    public void setSubmitImmediately(boolean submitImmediately) {
        this.submitImmediately = submitImmediately;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getPageSizeUpdatedTimestamp() {
        return this.pageSizeUpdatedTimestamp;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
        this.updatePageSizeTimestamp();
    }

    public boolean isLimitPageSize() {
        return this.limitPageSize;
    }

    public boolean isOpeningOfHttpsLinksAllowed() {
        return this.isOpeningOfHttpsLinkAllowed;
    }

    public void setIsOpeningOfHttpsLinksAllowed(boolean value2) {
        this.isOpeningOfHttpsLinkAllowed = value2;
    }

    public void setIsOpeningOfHttpLinksAllowed(boolean value2) {
        this.isOpeningOfHttpLinkAllowed = value2;
    }

    public boolean isOpeningOfHttpLinksAllowed() {
        return this.isOpeningOfHttpLinkAllowed;
    }

    public boolean isOpeningOfLocalFileUrlsAllowed() {
        return this.isOpeningOfLocalFileUrlAllowed;
    }

    public void setIsOpeningOfLocalFileUrlsAllowed(boolean value2) {
        this.isOpeningOfLocalFileUrlAllowed = value2;
    }

    public boolean isWebUrlWithoutProtocolAssumedHttp() {
        return this.isWebUrlWithoutProtocolIsHttp;
    }

    public void setIsWebUrlWithoutProtocolAssumedHttp(boolean value2) {
        this.isWebUrlWithoutProtocolIsHttp = value2;
    }

    public void setLimitPageSize(boolean limitPageSize) {
        this.limitPageSize = limitPageSize;
        this.updatePageSizeTimestamp();
    }

    public void updatePageSizeTimestamp() {
        this.pageSizeUpdatedTimestamp = System.currentTimeMillis();
    }

    public void setAutoTransposeMode(@NotNull DataGridSettings.AutoTransposeMode autoTransposeMode) {
        if (autoTransposeMode == null) {
            DatabaseSettings.$$$reportNull$$$0(7);
        }
        this.autoTransposeMode = autoTransposeMode;
    }

    @NotNull
    public DataGridSettings.AutoTransposeMode getAutoTransposeMode() {
        DataGridSettings.AutoTransposeMode autoTransposeMode = this.autoTransposeMode;
        if (autoTransposeMode == null) {
            DatabaseSettings.$$$reportNull$$$0(8);
        }
        return autoTransposeMode;
    }

    public void setEnableLocalFilterByDefault(boolean enableLocalFilterByDefault) {
        this.enableLocalFilterByDefault = enableLocalFilterByDefault;
    }

    public boolean isEnableLocalFilterByDefault() {
        return this.enableLocalFilterByDefault;
    }

    public void setEnablePagingInInEditorResultsByDefault(boolean enablePagingInInEditorResultsByDefault) {
        this.enablePagingInInEditorResultsByDefault = enablePagingInInEditorResultsByDefault;
    }

    public boolean isDisableGridFloatingToolbar() {
        return this.disableGridFloatingToolbar;
    }

    public void setDisableGridFloatingToolbar(boolean disableGridFloatingToolbar) {
        this.disableGridFloatingToolbar = disableGridFloatingToolbar;
    }

    public boolean isEnableImmediateCompletionInGridCells() {
        return this.enableImmediateCompletionInGridCells;
    }

    public void setEnableImmediateCompletionInGridCells(boolean enableImmediateCompletionInGridCells) {
        this.enableImmediateCompletionInGridCells = enableImmediateCompletionInGridCells;
    }

    public boolean isFloatingToolbarCustomizable() {
        return this.enableGridFloatingToolbarCustomization;
    }

    public void setFloatingToolbarCustomizable(boolean value2) {
        this.enableGridFloatingToolbarCustomization = value2;
    }

    public boolean isEnablePagingInInEditorResultsByDefault() {
        return this.enablePagingInInEditorResultsByDefault;
    }

    @Deprecated
    public DataGridAppearanceSettings.BooleanMode getBooleanMode() {
        return this.booleanMode;
    }

    @Deprecated
    public void setBooleanMode(@NotNull DataGridAppearanceSettings.BooleanMode mode) {
        if (mode == null) {
            DatabaseSettings.$$$reportNull$$$0(9);
        }
        this.booleanMode = mode;
    }

    public boolean isDetectTextInBinaryColumns() {
        return this.detectTextInBinaryColumns;
    }

    public void setDetectTextInBinaryColumns(boolean v2) {
        this.detectTextInBinaryColumns = v2;
    }

    public boolean isDetectUUIDInBinaryColumns() {
        return this.detectUUIDInBinaryColumns;
    }

    public void setDetectUUIDInBinaryColumns(boolean v2) {
        this.detectUUIDInBinaryColumns = v2;
    }

    @Deprecated
    public boolean isStripedTable() {
        return this.stripedTable;
    }

    @Deprecated
    public void setStripedTable(boolean striped) {
        this.stripedTable = striped;
    }

    public boolean isSortViaOrderBy() {
        return this.sortViaOrderBy;
    }

    public void setSortViaOrderBy(boolean value2) {
        this.sortViaOrderBy = value2;
    }

    public boolean isSortTables() {
        return this.sortTables;
    }

    public void setSortTables(boolean value2) {
        this.sortTables = value2;
    }

    public boolean isTableOrderingAsc() {
        return this.tableOrderingAsc;
    }

    public void setTableOrderingAsc(boolean value2) {
        this.tableOrderingAsc = value2;
    }

    @NotNull
    public RowSortOrder.Type getDefaultTableOrdering() {
        RowSortOrder.Type type2 = this.sortTables ? (this.tableOrderingAsc ? RowSortOrder.Type.ASC : RowSortOrder.Type.DESC) : RowSortOrder.Type.UNSORTED;
        if (type2 == null) {
            DatabaseSettings.$$$reportNull$$$0(10);
        }
        return type2;
    }

    public void setDefaultTableOrdering(@NotNull RowSortOrder.Type ordering) {
        if (ordering == null) {
            DatabaseSettings.$$$reportNull$$$0(11);
        }
        if (ordering == RowSortOrder.Type.UNSORTED) {
            this.sortTables = false;
            return;
        }
        this.sortTables = true;
        this.tableOrderingAsc = ordering == RowSortOrder.Type.ASC;
    }

    public int getPreviewRows() {
        return this.previewRows;
    }

    public void setPreviewRows(int rows) {
        this.previewRows = rows;
    }

    public boolean isLoadSlowDocumentation() {
        return this.loadSlowDocumentation;
    }

    public void setLoadSlowDocumentation(boolean loadSlowDocumentation) {
        this.loadSlowDocumentation = loadSlowDocumentation;
    }

    public int getFiltersHistorySize() {
        return this.filtersHistorySize;
    }

    public void setFiltersHistorySize(int filtersHistorySize) {
        this.filtersHistorySize = filtersHistorySize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getBytesLimitPerValue() {
        return this.bytesLimitPerValue;
    }

    public void setBytesLimitPerValue(int lobLength) {
        this.bytesLimitPerValue = lobLength;
    }

    public UserPatterns getUserPatterns() {
        return this.userPatterns;
    }

    @Deprecated
    @NotNull
    public List<CsvFormat> getCsvFormats() {
        List<CsvFormat> formats = DatabaseSettings.getImmutableFormats(this.csvFormats);
        List<CsvFormat> list = formats.isEmpty() ? DatabaseSettings.getDefaultFormats() : formats;
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public static List<CsvFormat> getDefaultFormats() {
        List list = CsvSettings.getDefaultFormats();
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Deprecated
    public void setCsvFormats(@NotNull List<CsvFormat> formats) {
        if (formats == null) {
            DatabaseSettings.$$$reportNull$$$0(14);
        }
        this.csvFormats = ContainerUtil.map(formats, PersistentCsvFormat::new);
    }

    private void ensureDefaultsSet() {
        this.userPatterns.migrate(this.version);
        if (DatabaseSettings.getImmutableFormats(this.csvFormats).isEmpty()) {
            this.setCsvFormats(DatabaseSettings.getDefaultFormats());
        } else {
            if (this.version < 2) {
                int idx = 0;
                for (PersistentCsvFormat format2 : this.csvFormats) {
                    if (ContainerUtil.exists(DatabaseSettings.getDefaultFormats(), f -> StringUtil.equals((CharSequence)format2.id, (CharSequence)f.id))) continue;
                    CsvFormat similar = (CsvFormat)ContainerUtil.find(DatabaseSettings.getDefaultFormats(), f -> CsvSettings.formatsSimilar((CsvFormat)f, (PersistentCsvFormat)format2));
                    if (similar == null || ContainerUtil.exists(this.csvFormats, f -> StringUtil.equals((CharSequence)f.id, (CharSequence)similar.id))) {
                        format2.id = String.valueOf(idx++);
                        continue;
                    }
                    format2.id = similar.id;
                }
            }
            if (this.version < 5) {
                CsvSettings.addNewFormat(this.csvFormats, (CsvFormat)((CsvFormat)CsvFormats.PIPE_SEPARATED_FORMAT.getValue()), (CsvFormat)((CsvFormat)CsvFormats.TSV_FORMAT.getValue()));
            }
            if (this.version < 6) {
                this.renameFormat(DataGridBundle.message((String)"csv.format.csv.default.old.name", (Object[])new Object[0]), GridCsvBundle.message((String)"csv.format.csv.default.name", (Object[])new Object[0]));
                this.renameFormat(DataGridBundle.message((String)"csv.format.tsv.default.old.name", (Object[])new Object[0]), GridCsvBundle.message((String)"csv.format.tsv.default.name", (Object[])new Object[0]));
            }
        }
        if (this.version < 4) {
            boolean bl = this.limitPageSize = this.pageSize > 0;
            if (!this.limitPageSize) {
                this.pageSize = 500;
            }
        }
        if (this.version < 7) {
            this.autoTransposeMode = this.autoTranspose ? DataGridSettings.AutoTransposeMode.ALWAYS : DataGridSettings.AutoTransposeMode.NEVER;
            this.autoTranspose = false;
        }
        if (this.version < 8) {
            this.setDefaultTableOrdering(this.defaultTableOrdering);
            this.defaultTableOrdering = RowSortOrder.Type.UNSORTED;
        }
        if (this.version < 9) {
            this.execOptions.forEach(o2 -> {
                o2.execInside = o2.execInside == 1 ? o2.execInside : o2.execInside + 1;
            });
        }
        if (this.version < 10) {
            CsvSettings.addNewFormat(this.csvFormats, (CsvFormat)((CsvFormat)CsvFormats.SEMICOLON_SEPARATED_FORMAT.get()), (CsvFormat)((CsvFormat)CsvFormats.PIPE_SEPARATED_FORMAT.getValue()));
        }
        this.version = 10;
    }

    private void renameFormat(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            DatabaseSettings.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            DatabaseSettings.$$$reportNull$$$0(16);
        }
        for (PersistentCsvFormat format2 : this.csvFormats) {
            if (!oldName.equals(format2.name)) continue;
            format2.name = newName;
        }
    }

    @NotNull
    private static List<CsvFormat> getImmutableFormats(@NotNull List<PersistentCsvFormat> persistentFormats) {
        if (persistentFormats == null) {
            DatabaseSettings.$$$reportNull$$$0(17);
        }
        List list = ContainerUtil.mapNotNull(persistentFormats, format2 -> format2 == null ? null : format2.immutable());
        if (list == null) {
            DatabaseSettings.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        DatabaseSettings databaseSettings = this;
        if (databaseSettings == null) {
            DatabaseSettings.$$$reportNull$$$0(19);
        }
        return databaseSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 6, 7, 9, 11, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/DatabaseSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aggregators";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoTransposeMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentFormats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledAggregators";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/DatabaseSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfinity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNan";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExecOption";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoTransposeMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTableOrdering";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormats";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormats";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableFormats";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledAggregators";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAutoTransposeMode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setBooleanMode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultTableOrdering";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setCsvFormats";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renameFormat";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImmutableFormats";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 6, 7, 9, 11, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    @Tag(value="exec-option")
    public static class ExecOption {
        @Attribute(value="new-tab")
        public boolean newTab;
        @Attribute(value="exec-inside")
        public int execInside = 1;
        @Attribute(value="exec-outside")
        public int execOutside = 1;
        @Attribute(value="exec-selection")
        public int execSelection = 2;

        @NotNull
        public ExecOption copyFrom(@NotNull ExecOption o2) {
            if (o2 == null) {
                ExecOption.$$$reportNull$$$0(0);
            }
            this.newTab = o2.newTab;
            this.execInside = o2.execInside;
            this.execOutside = o2.execOutside;
            this.execSelection = o2.execSelection;
            ExecOption execOption = this;
            if (execOption == null) {
                ExecOption.$$$reportNull$$$0(1);
            }
            return execOption;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ExecOption option = (ExecOption)o2;
            if (this.newTab != option.newTab) {
                return false;
            }
            if (this.execInside != option.execInside) {
                return false;
            }
            if (this.execOutside != option.execOutside) {
                return false;
            }
            return this.execSelection == option.execSelection;
        }

        public int hashCode() {
            int result2 = this.newTab ? 1 : 0;
            result2 = 31 * result2 + this.execInside;
            result2 = 31 * result2 + this.execOutside;
            result2 = 31 * result2 + this.execSelection;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/settings/DatabaseSettings$ExecOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/settings/DatabaseSettings$ExecOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyFrom";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copyFrom";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static enum SplitScriptMode {
        COMBINED,
        ON_STATEMENTS,
        BY_SEPARATOR;

    }

    public static enum ContextTemplateTarget {
        OPEN_IN_NEW_CONSOLE,
        APPEND_TO_EXISTING_CONSOLE;

    }

    public static enum ShowServicesMode {
        ALL,
        QUERYOUTPUT_ERRORS_RESULTSETS,
        ERRORS_RESULTSETS,
        RESULTSETS,
        NEVER;

    }
}

