/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.basic.BasicDataObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.schemaEditor.DbDelegatingElementOwner;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTrackingElementOwner
extends DbDelegatingElementOwner
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DbTrackingElementOwner.class);
    private final Set<ElementIdentity<?>> myModified;
    private final Map<ElementIdentity<?>, BasicElement> myPossiblyModified;
    private final Set<BasicModModel> myListened;
    private final BasicModelListener myListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ElementIdentity<?>> tracking(@NotNull ElementOwner owner, @NotNull Consumer<ElementOwner> consumer2) {
        if (owner == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(1);
        }
        DbTrackingElementOwner tracker = new DbTrackingElementOwner(owner);
        try {
            consumer2.accept(tracker);
            Set<ElementIdentity<?>> set = tracker.getModified();
            return set;
        }
        finally {
            Disposer.dispose((Disposable)tracker);
        }
    }

    private DbTrackingElementOwner(@NotNull ElementOwner delegate) {
        if (delegate == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(2);
        }
        super(delegate);
        this.myModified = new LinkedHashSet();
        this.myPossiblyModified = new LinkedHashMap();
        this.myListened = new HashSet<BasicModModel>();
        this.myListener = this::modelChanged;
        this.addListener(this::onAddedToOwner, this);
    }

    public Set<ElementIdentity<?>> getModified() {
        LinkedHashSet modified = new LinkedHashSet(this.myModified);
        for (Map.Entry<ElementIdentity<?>, BasicElement> entry : this.myPossiblyModified.entrySet()) {
            Object current = super.findElement(entry.getKey());
            if (current != null && ModelLightCopier.equals(current, entry.getValue())) continue;
            modified.add(entry.getKey());
        }
        return modified;
    }

    public void dispose() {
        boolean missingModify = false;
        for (BasicModModel model2 : this.myListened) {
            missingModify |= BaseModel.hasUnfiredNotifications(model2);
            BaseModel.forceNotifications(model2, false);
            model2.removeListener(this.myListener);
        }
        if (missingModify) {
            LOG.error("Missing modify on model");
        }
    }

    private void modelChanged(Set<BasicElement> created2, Set<BasicElement> modified, Set<BasicElement> removed) {
        ElementIdentity<BasicElement> identity;
        for (BasicElement element2 : removed) {
            identity = this.myDelegate.findIdentity(element2);
            if (identity == null) continue;
            this.myDelegate.drop(identity);
            this.myModified.add(identity);
        }
        for (BasicElement element2 : created2) {
            this.onCreated(element2);
        }
        for (BasicElement element2 : modified) {
            identity = this.myDelegate.findIdentity(element2);
            if (identity == null) continue;
            this.myModified.add(identity);
        }
    }

    private void onAddedToOwner(@NotNull BasicElement e2, @NotNull ElementIdentity<?> id) {
        if (e2 == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(3);
        }
        if (id == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(4);
        }
        this.addModelListener(e2);
        this.myModified.add(id);
    }

    private ElementIdentity<BasicElement> onCreated(BasicElement element2) {
        ElementIdentity<BasicElement> identity = this.myDelegate.findIdentity(element2);
        if (identity != null) {
            return identity;
        }
        BasicElement parent2 = element2.getParent();
        if (parent2 == null) {
            return null;
        }
        ElementIdentity<BasicElement> parentId = this.onCreated(parent2);
        identity = this.myDelegate.register(parentId, element2);
        this.myModified.add(identity);
        return identity;
    }

    private <E extends BasicElement> E track(@Nullable E e2, @Nullable ElementIdentity<E> id) {
        this.track(id, e2);
        return e2;
    }

    private <E extends BasicElement> ElementIdentity<E> track(@Nullable ElementIdentity<E> id, @Nullable E e2) {
        if (id != null && e2 != null) {
            if (e2 instanceof BasicDataObject) {
                this.myPossiblyModified.computeIfAbsent(id, o2 -> ModelLightCopier.copyData(e2, false));
            } else {
                this.addModelListener(e2);
            }
        }
        return id;
    }

    private void addModelListener(@Nullable BasicElement e2) {
        BasicModModel model2;
        BasicModModel basicModModel = model2 = e2 == null || e2 instanceof BasicDataObject ? null : (BasicModModel)e2.getModel();
        if (model2 != null && this.myListened.add(model2)) {
            model2.addListener(this.myListener);
            BaseModel.forceNotifications(model2, true);
        }
    }

    @Override
    @NotNull
    public <E extends BasicElement> ElementIdentity<E> identify(@NotNull E e2) {
        if (e2 == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(5);
        }
        ElementIdentity<E> elementIdentity = this.track(super.identify(e2), e2);
        if (elementIdentity == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(6);
        }
        return elementIdentity;
    }

    @Override
    @Nullable
    public <E extends BasicElement> ElementIdentity<E> findIdentity(@NotNull E e2) {
        if (e2 == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(7);
        }
        return this.track(super.findIdentity(e2), e2);
    }

    @Override
    @Nullable
    public <E extends BasicElement> E findElement(@Nullable ElementIdentity<E> e2) {
        return this.track(super.findElement(e2), e2);
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> ElementIdentity<T> identifyInlineRef(@NotNull S owner, @NotNull BasicMetaReference<S, T> ref2, @NotNull T e2) {
        if (owner == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(8);
        }
        if (ref2 == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(9);
        }
        if (e2 == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(10);
        }
        ElementIdentity<T> elementIdentity = this.track(super.identifyInlineRef(owner, ref2, e2), e2);
        if (elementIdentity == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(11);
        }
        return elementIdentity;
    }

    @Override
    @Nullable
    public <E extends BasicElement> E findOrCreate(@NotNull ElementIdentity<E> identity) {
        if (identity == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(12);
        }
        return this.track(super.findOrCreate(identity), identity);
    }

    @Override
    public <E extends BasicElement> void drop(@NotNull ElementIdentity<E> identity) {
        if (identity == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(13);
        }
        this.find(identity);
        super.drop(identity);
    }

    @Override
    @NotNull
    public <E extends BasicElement> ElementIdentity<E> register(@Nullable ElementIdentity<?> parent2, @NotNull E object) {
        if (object == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(14);
        }
        ElementIdentity<E> elementIdentity = this.track(super.register(parent2, object), object);
        if (elementIdentity == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(15);
        }
        return elementIdentity;
    }

    @Override
    public <E extends BasicElement> void addMatch(@NotNull ElementIdentity<E> identity, @NotNull E element2) {
        if (identity == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(16);
        }
        if (element2 == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(17);
        }
        super.addMatch(identity, this.track(element2, identity));
    }

    @Override
    @Nullable
    public <E extends BasicElement> E find(@NotNull ElementIdentity<E> identity) {
        if (identity == null) {
            DbTrackingElementOwner.$$$reportNull$$$0(18);
        }
        return this.track(super.find(identity), identity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbTrackingElementOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbTrackingElementOwner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "identify";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyInlineRef";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "register";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tracking";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onAddedToOwner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "identify";
                break;
            }
            case 6: 
            case 11: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIdentity";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "identifyInlineRef";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addMatch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 15 -> new IllegalStateException(string);
        };
    }
}

