/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicGrantee;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeCheck;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.VmColumn;
import com.intellij.database.model.basic.VmView;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbEmbeddedObjectModelMultiApplier;
import com.intellij.database.schemaEditor.model.applier.DbEmbeddedRefObjectModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbForeignKeyColumnsModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbIndexColumnsModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbIndirectReferenceModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbKeyColumnsModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbNameModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbNameModelMultiApplier;
import com.intellij.database.schemaEditor.model.applier.DbObjectGrantsModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbPropertyModelApplierBase;
import com.intellij.database.schemaEditor.model.applier.DbSeqIdModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbSinglePropModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbSingleValueModelMultiApplier;
import com.intellij.database.schemaEditor.model.applier.DbSourceTextModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureFamilyModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbUserGrantsModelApplier;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.model.state.DbCollectionTextModelState;
import com.intellij.database.schemaEditor.model.state.DbCompoundModelState;
import com.intellij.database.schemaEditor.model.state.DbEmbeddedObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbGenNameModelState;
import com.intellij.database.schemaEditor.model.state.DbIndirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectGrantsModelState;
import com.intellij.database.schemaEditor.model.state.DbSeqIdPropModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueModelState;
import com.intellij.database.schemaEditor.model.state.DbSingleValueTextModelState;
import com.intellij.database.schemaEditor.model.state.DbSourceTextModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.model.state.DbUserGrantsModelState;
import com.intellij.database.schemaEditor.ui.DbAdvancedTextEditor;
import com.intellij.database.schemaEditor.ui.DbBoolEditor;
import com.intellij.database.schemaEditor.ui.DbCollectionEditor;
import com.intellij.database.schemaEditor.ui.DbDataTypeEditor;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEmbeddedObjectEditor;
import com.intellij.database.schemaEditor.ui.DbEnumEditor;
import com.intellij.database.schemaEditor.ui.DbForeignKeyColumnsEditor;
import com.intellij.database.schemaEditor.ui.DbFormCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbGenNameEditor;
import com.intellij.database.schemaEditor.ui.DbIndexColumnsEditor;
import com.intellij.database.schemaEditor.ui.DbKeyColumnsEditor;
import com.intellij.database.schemaEditor.ui.DbObjectGrantsEditor;
import com.intellij.database.schemaEditor.ui.DbReferenceEditor;
import com.intellij.database.schemaEditor.ui.DbSqlBigEditor;
import com.intellij.database.schemaEditor.ui.DbSqlExpressionEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureNodeEditor;
import com.intellij.database.schemaEditor.ui.DbTextEditor;
import com.intellij.database.schemaEditor.ui.DbTextEditorBase;
import com.intellij.database.schemaEditor.ui.DbToggleableFormCompoundEditor;
import com.intellij.database.schemaEditor.ui.DbUserGrantsEditor;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.util.NameTemplate;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectEditorFactory {
    public static final DbmsExtension<DbObjectEditorFactory> EP = new DbmsExtension("com.intellij.database.objectEditorFactory");
    protected final ModelHelper myModelHelper;
    private final Dbms myDbms;
    private static final Map<Class<?>, Converter<String, ?>> ourConverters;
    private static final Map<Class<? extends Collection>, Factory<? extends Collection<?>>> ourCollections;

    public DbObjectEditorFactory(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(0);
        }
        this.myModelHelper = DbImplUtilCore.getModelHelper(dbms);
        this.myDbms = dbms;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.myDbms;
        if (dbms == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @NotNull
    public static DbObjectEditorFactory forDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(2);
        }
        DbObjectEditorFactory dbObjectEditorFactory = EP.forDbms(dbms);
        if (dbObjectEditorFactory == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(3);
        }
        return dbObjectEditorFactory;
    }

    protected static <E extends BasicElement, E2 extends BasicElement> DbEditorModel<E, ?> castModel(DbEditorModel<E2, ?> model2) {
        return model2;
    }

    @Nullable
    public final <E extends BasicElement, S extends DbModelState> DbEditor<E, S> createObjectEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(4);
        }
        if (modelRef == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(5);
        }
        return this.createObjectEditorImpl(controller, modelRef);
    }

    public static <E extends DbEditor<?, ?>> E init(E editor2) {
        if (editor2 == null) {
            return null;
        }
        editor2.register();
        editor2.reset();
        return editor2;
    }

    @Nullable
    protected DbEditor<?, ?> createObjectEditorImpl(@NotNull DbEditorController controller, @NotNull DbModelRef<?, ?> model2) {
        DbCollectionEditor<?, ?> editor2;
        Object pa;
        DbModelState s2;
        Object obj2;
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(6);
        }
        if (model2 == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(7);
        }
        if ((obj2 = model2.getState()) instanceof DbStructureModelState) {
            DbStructureModelState s3 = (DbStructureModelState)obj2;
            return new DbStructureEditor(controller, model2.castState(s3));
        }
        obj2 = model2.getState();
        if (obj2 instanceof DbStructureNodeState) {
            DbStructureNodeState s4 = (DbStructureNodeState)obj2;
            return new DbStructureNodeEditor(controller, model2.castState(s4));
        }
        obj2 = model2.getState();
        if (obj2 instanceof DbEmbeddedObjectModelState) {
            DbEmbeddedObjectModelState s5 = (DbEmbeddedObjectModelState)obj2;
            return new DbEmbeddedObjectEditor(controller, model2.castState(s5));
        }
        obj2 = model2.getState();
        if (obj2 instanceof DbSeqIdPropModelState) {
            s2 = (DbSeqIdPropModelState)obj2;
            pa = (DbPropertyModelApplierBase)ObjectUtils.tryCast(model2.getApplier(), DbPropertyModelApplierBase.class);
            if (pa != null && ((DbPropertyModelApplierBase)pa).getDefault() == null) {
                return new DbToggleableSeqIdEditor(controller, model2.castState(s2));
            }
        }
        if ((pa = model2.getState()) instanceof DbCompoundModelState) {
            s2 = (DbCompoundModelState)pa;
            return new DbFormCompoundEditor(controller, model2.castState(s2), controller::shouldHaveEditor);
        }
        pa = model2.getState();
        if (pa instanceof DbObjectGrantsModelState) {
            s2 = (DbObjectGrantsModelState)pa;
            return new DbObjectGrantsEditor(controller, model2.castState(s2));
        }
        pa = model2.getState();
        if (pa instanceof DbUserGrantsModelState) {
            s2 = (DbUserGrantsModelState)pa;
            return new DbUserGrantsEditor(controller, model2.castState(s2));
        }
        pa = model2.getState();
        if (pa instanceof DbCollectionModelState && (editor2 = this.createCollectionEditor(controller, model2.castState(s2 = (DbCollectionModelState)pa))) != null) {
            return editor2;
        }
        obj2 = model2.getState();
        if (obj2 instanceof DbIndirectReferenceModelState) {
            s2 = (DbIndirectReferenceModelState)obj2;
            return new DbReferenceEditor(controller, model2.castState(s2));
        }
        obj2 = model2.getState();
        if (obj2 instanceof DbGenNameModelState) {
            s2 = (DbGenNameModelState)obj2;
            return new DbGenNameEditor(controller, model2.castState(s2));
        }
        obj2 = model2.getState();
        if (obj2 instanceof DbTextModelState) {
            s2 = (DbTextModelState)obj2;
            return this.createTextEditor(controller, model2.castState(s2));
        }
        s2 = DbObjectEditorFactory.tryCastTo(model2, Boolean.class);
        if (s2 != null) {
            return new DbBoolEditor(controller, model2.castState(s2));
        }
        s2 = DbObjectEditorFactory.tryCastTo(model2, Enum.class);
        if (s2 != null) {
            return new DbEnumEditor(controller, model2.castState(s2));
        }
        throw new AssertionError((Object)("Unsupported model: " + model2.getState().getClass().getSimpleName()));
    }

    @NotNull
    private DbTextEditorBase<?, ? extends DbTextModelState> createTextEditor(@NotNull DbEditorController controller, DbModelRef<?, DbTextModelState> model2) {
        BasicMetaType<Object> type2;
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(8);
        }
        if ((type2 = model2.getApplier().getValueType()) != null && (type2.isKindOf(DataType.class) || type2.isKindOf(DasType.class))) {
            return new DbDataTypeEditor(controller, model2);
        }
        if (controller.getBuilder().isBigSqlEditor(model2, this)) {
            return new DbSqlBigEditor(controller, model2);
        }
        if (this.isSqlExpression(model2)) {
            return new DbSqlExpressionEditor(controller, model2);
        }
        if (model2.getModelInternalKey() == BasicModNamedElement.NAME || model2.getState().isMultiline()) {
            return new DbAdvancedTextEditor(controller, model2);
        }
        return new DbTextEditor(controller, model2);
    }

    protected boolean isSqlExpression(DbModelRef<?, DbTextModelState> model2) {
        BasicMetaId key2 = model2.getModelInternalKey();
        return key2 == BasicModTypedElement.DEFAULT_EXPRESSION || key2 == BasicModLikeCheck.PREDICATE || key2 == BasicModTrigger.CONDITION || key2 == VmColumn.EXPRESSION || key2 == VmView.QUERY;
    }

    protected boolean isBigSqlEditor(DbModelRef<?, DbTextModelState> model2) {
        BasicMetaId key2 = model2.getModelInternalKey();
        return key2 == VmView.QUERY || key2 == BasicModSourceAware.SOURCE_TEXT;
    }

    @Nullable
    protected DbCollectionEditor<?, ?> createCollectionEditor(@NotNull DbEditorController controller, DbModelRef<?, DbCollectionModelState<?>> model2) {
        DbModelRef<?, DbCollectionModelState<DbKeyColumnsModelApplier.KeyColumn>> typedModel;
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(9);
        }
        if ((typedModel = model2.castState(model2.getState().tryCastItem(DbIndexColumnsModelApplier.IndexColumn.class))) != null) {
            return new DbIndexColumnsEditor(controller, (DbModelRef<?, DbCollectionModelState<DbIndexColumnsModelApplier.IndexColumn>>)typedModel);
        }
        typedModel = model2.castState(model2.getState().tryCastItem(DbForeignKeyColumnsModelApplier.FkColumn.class));
        if (typedModel != null) {
            return new DbForeignKeyColumnsEditor(controller, (DbModelRef<?, DbCollectionModelState<DbIndexColumnsModelApplier.IndexColumn>>)typedModel);
        }
        typedModel = model2.castState(model2.getState().tryCastItem(DbKeyColumnsModelApplier.KeyColumn.class));
        if (typedModel != null) {
            return new DbKeyColumnsEditor(controller, (DbModelRef<?, DbCollectionModelState<DbIndexColumnsModelApplier.IndexColumn>>)typedModel);
        }
        return null;
    }

    @Nullable
    private static <T> DbSingleValueModelState<T> tryCastTo(@NotNull DbModelRef<?, ?> model2, Class<T> clazz) {
        DbSingleValueModelState s2;
        if (model2 == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(10);
        }
        BasicMetaType<T> type2 = (s2 = (DbSingleValueModelState)ObjectUtils.tryCast(model2.getState(), DbSingleValueModelState.class)) == null ? null : model2.getApplier().getValueType();
        return type2 != null && type2.isKindOf(clazz) ? s2 : null;
    }

    @NotNull
    public <E extends BasicElement, C extends BasicElement> DbEditorModel<E, DbStructureFamilyModelState<C>> createStructureFamilyEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaObject<C> child) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(11);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(12);
        }
        if (child == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(13);
        }
        DbStructureFamilyModelState<C> state = new DbStructureFamilyModelState<C>(child);
        DbStructureFamilyModelApplier applier = new DbStructureFamilyModelApplier(child);
        return new DbEditorModelBase<E, DbStructureFamilyModelState<C>>(controller, id, StringUtil.capitalizeWords((String)child.kind.getPluralPresentableName(), (boolean)true), state, applier, null);
    }

    @Nullable
    public static <E extends BasicElement> DbEditorModel<E, ?> createAnyGrantsEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(14);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(15);
        }
        BasicMetaObject<E> meta = id.getMetaObject();
        Dbms dbms = controller.getDbms(id);
        Grants.Controller<?, ?> grantCtl = ModelFacade.forDbms(dbms).getModelHelper().getGrantController();
        if (grantCtl == null) {
            return null;
        }
        if (grantCtl.asGrantee((BasicElement)meta.newDataObject()) != null) {
            return DbObjectEditorFactory.castModel(DbObjectEditorFactory.createUserGrantsEditorModel(controller, id, grantCtl));
        }
        return DbObjectEditorFactory.createGrantsEditorModel(controller, id, grantCtl);
    }

    @NotNull
    private static <G extends Grants.Grant, U extends BasicGrantee> DbEditorModel<U, ?> createUserGrantsEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id, Grants.Controller<G, U> grantCtl) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(16);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(17);
        }
        DbUserGrantsModelState state = new DbUserGrantsModelState();
        return new DbEditorModelBase(controller, id, DatabaseBundle.message("DbObjectGrantsEditor.label.grants", new Object[0]), state, new DbUserGrantsModelApplier<G, U>(grantCtl), null);
    }

    @Nullable
    public static <G extends Grants.Grant, U extends BasicGrantee, E extends BasicElement> DbEditorModel<E, ?> createGrantsEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, Grants.Controller<G, U> grantCtl) {
        Iterable<String> p2;
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(18);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(19);
        }
        BasicMetaObject<E> meta = id.getMetaObject();
        if (meta.kind == ObjectKind.COLUMN) {
            return null;
        }
        Iterable<String> iterable = p2 = grantCtl == null ? null : grantCtl.possiblePrivileges(meta);
        if (grantCtl == null || !p2.iterator().hasNext()) {
            return null;
        }
        DbObjectGrantsModelState state = new DbObjectGrantsModelState();
        return new DbEditorModelBase(controller, id, DatabaseBundle.message("DbObjectGrantsEditor.label.grants", new Object[0]), state, new DbObjectGrantsModelApplier(grantCtl), null);
    }

    @NlsSafe
    @NotNull
    public final String getTitle(@NotNull ElementIdentity<?> id, @NotNull BasicMetaId prop) {
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(20);
        }
        if (prop == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(21);
        }
        String string = this.myModelHelper.getTitle(id.getMetaObject(), prop);
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(22);
        }
        return string;
    }

    public final <E extends BasicElement> void prepareProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(23);
        }
        if (fields == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(24);
        }
        this.hackProperties(meta, fields);
        this.myModelHelper.prepareProperties(meta, fields);
    }

    protected <E extends BasicElement> void hackProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        BasicMetaProperty<E, CompositeText> src2;
        BasicMetaReference<E, BasicIndex> idx;
        BasicMetaProperty<E, List<String>> cols2;
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(25);
        }
        if (fields == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(26);
        }
        if (meta.kindOf(BasicModKey.class) && (cols2 = meta.getObjectProperty(BasicModColumniation.COL_NAMES)) != null && cols2.isAbstract() && (idx = meta.getReference(BasicModKey.UNDERLYING_INDEX_REF)) != null && !idx.isAbstract()) {
            fields.add(cols2);
        }
        if (meta.kindOf(BasicModSourceAware.class) && (src2 = meta.getObjectProperty(BasicModSourceAware.SOURCE_TEXT)) != null) {
            fields.add(src2);
        }
    }

    private static NameValueType parseNvt(String s2) {
        int valSep = s2.indexOf(61);
        int valSepSafe = valSep == -1 ? s2.length() : valSep;
        int typeSep = StringUtil.indexOf((CharSequence)s2, (char)':', (int)0, (int)valSepSafe);
        return new NameValueType(s2.substring(0, typeSep == -1 ? valSepSafe : typeSep), valSep == -1 ? "" : s2.substring(valSep + 1), typeSep == -1 ? "" : s2.substring(typeSep + 1, valSepSafe));
    }

    @NotNull
    private static String serializeNvt(NameValueType nvt) {
        String string = nvt.getName() + (String)(StringUtil.isEmpty((String)nvt.getType()) ? "" : ":" + nvt.getType()) + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static NameValue parseNv(String s2) {
        int valSep = s2.indexOf(61);
        int valSepSafe = valSep == -1 ? s2.length() : valSep;
        return new NameValue(s2.substring(0, valSepSafe), valSep == -1 ? "" : s2.substring(valSep + 1));
    }

    @NotNull
    private static String serializeNv(NameValue nvt) {
        String string = nvt.getName() + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static <T> Map.Entry<Class<?>, Converter<String, ?>> put(Class<T> clazz, Function<T, String> from, Function<String, T> to) {
        return Map.entry(clazz, new Converter<String, T>(from, to));
    }

    private static <T> Map.Entry<Class<?>, Converter<String, ?>> putNullable(Class<T> clazz, Function<? super T, String> from, Function<? super String, ? extends T> to) {
        return DbObjectEditorFactory.put(clazz, v2 -> v2 == null ? "" : (String)from.fun(v2), t -> StringUtil.isEmpty((String)t) ? null : to.fun(t));
    }

    @Nullable
    protected <E extends BasicElement, T extends BasicElement> DbEditorModel<E, ?> createReferenceEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaReference<E, T> reference, @NotNull List<BasicMetaField<E>> fields) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(29);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(30);
        }
        if (reference == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(31);
        }
        if (fields == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(32);
        }
        DbIndirectReferenceModelApplier applier = new DbIndirectReferenceModelApplier(reference, DbIndirectReferenceModelApplier.TEXT_PARSER);
        DbIndirectReferenceModelState state = new DbIndirectReferenceModelState(null, v2 -> applier.toReference(controller.getDbms(id), (String)v2));
        return new DbEditorModelBase(controller, id, this.getTitle(id, reference.id), state, applier, new DbSingleValueModelMultiApplier());
    }

    @Nullable
    public <E extends BasicElement> DbEditorModel<E, ?> createPropertyEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaField<E>> fields) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(33);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(34);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(35);
        }
        if (fields == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(36);
        }
        if (property.id == BasicModNamedElement.NAME) {
            ModelHelper.remove(fields, BasicModNamedElement.NAME);
            boolean small = this.isSmall(id.getMetaObject(), property.id);
            boolean multiline = this.isMultiline(id.getMetaObject(), property.id);
            NameTemplate template = DbObjectEditorFactory.getNameTemplate(controller, id);
            DbSingleValueTextModelState state = template == null ? DbSingleValueTextModelState.createTextValue(small, multiline) : new DbGenNameModelState(template, small, multiline);
            return new DbEditorModelBase<E, DbGenNameModelState>(controller, id, DatabaseBundle.message("DbObjectEditor.label.name", new Object[0]), (DbGenNameModelState)state, new DbNameModelApplier(), new DbNameModelMultiApplier());
        }
        if (property.id == BasicModColumniation.COL_NAMES && id.getMetaObject().kindOf(BasicModColumniation.class)) {
            BasicMetaField<E> revCols;
            BasicMetaField<E> basicMetaField = revCols = id.getMetaObject().kindOf(BasicModIndex.class) ? id.getMetaObject().getField(BasicModIndex.REVERSE_COL_NAMES) : null;
            if (revCols != null && !revCols.isAbstract()) {
                ModelHelper.remove(fields, BasicModIndex.REVERSE_COL_NAMES);
                DbIndexColumnsModelApplier applier = new DbIndexColumnsModelApplier();
                DbCollectionModelState state = new DbCollectionModelState(applier);
                return DbObjectEditorFactory.castModel(new DbEditorModelBase(controller, id, DatabaseBundle.message("label.columns", new Object[0]), state, applier, null));
            }
            if (id.getMetaObject().kindOf(BasicModForeignKey.class)) {
                ModelHelper.remove(fields, BasicModForeignKey.REF_COL_NAMES);
                DbForeignKeyColumnsModelApplier applier = new DbForeignKeyColumnsModelApplier();
                DbCollectionModelState state = new DbCollectionModelState(applier);
                return DbObjectEditorFactory.castModel(new DbEditorModelBase(controller, id, DatabaseBundle.message("label.columns", new Object[0]), state, applier, null));
            }
            DbKeyColumnsModelApplier applier = new DbKeyColumnsModelApplier();
            DbCollectionModelState state = new DbCollectionModelState(applier);
            return DbObjectEditorFactory.castModel(new DbEditorModelBase(controller, id, DatabaseBundle.message("label.columns", new Object[0]), state, applier, null));
        }
        if (id.getMetaObject().kindOf(BasicModSourceAware.class) && property.id == BasicModSourceAware.SOURCE_TEXT) {
            DbSourceTextModelState state = new DbSourceTextModelState();
            return DbObjectEditorFactory.castModel(new DbEditorModelBase<E, DbSourceTextModelState>(controller, id, this.getTitle(id, property.id), state, new DbSourceTextModelApplier<E>(property), null));
        }
        DbEditorModel<E, ?> model2 = this.getTextEditorModel(controller, id, property);
        if (model2 != null) {
            return model2;
        }
        BasicMetaProperty<E, SequenceIdentity> prop = property.tryCast(SequenceIdentity.class);
        if (prop != null) {
            return this.createSeqIdEditorModel(controller, id, prop);
        }
        if (property.id.type instanceof BasicMetaType.CollectionMetaType) {
            return this.createPropertyEditorModel(controller, id, property);
        }
        return this.createSimplePropertyEditorModel(controller, id, property);
    }

    @Nullable
    private static NameTemplate getNameTemplate(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(37);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(38);
        }
        ObjectKind kind = id.getMetaObject().kind;
        SqlCodeStyleSettings codeStyle = DbObjectEditorFactory.getCodeStyle(controller, id);
        return DbObjectEditorFactory.getNameTemplate(kind, codeStyle);
    }

    public static boolean hasNameTemplate(ObjectKind kind) {
        return DbObjectEditorFactory.getNameTemplate(kind, null) != null;
    }

    @Nullable
    private static NameTemplate getNameTemplate(@NotNull ObjectKind kind, @Nullable SqlCodeStyleSettings codeStyle) {
        if (kind == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(39);
        }
        if (kind == ObjectKind.INDEX) {
            return new NameTemplate.IndexNameTemplate(codeStyle);
        }
        if (kind == ObjectKind.KEY) {
            return new NameTemplate.PrimaryKeyNameTemplate(codeStyle);
        }
        if (kind == ObjectKind.FOREIGN_KEY) {
            return new NameTemplate.ForeignKeyNameTemplate(codeStyle);
        }
        return null;
    }

    @NotNull
    private static SqlCodeStyleSettings getCodeStyle(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        DbDataSource dataSource2;
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(40);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(41);
        }
        if ((dataSource2 = controller.getDataSource(id)) != null) {
            SqlCodeStyleSettings sqlCodeStyleSettings = ScriptingTaskBuilderKt.getSqlCodeStyle(dataSource2);
            if (sqlCodeStyleSettings == null) {
                DbObjectEditorFactory.$$$reportNull$$$0(42);
            }
            return sqlCodeStyleSettings;
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)controller.getProject(), (Language)DbSqlUtilCore.getSqlDialect(controller.getDbms(id)));
        if (sqlCodeStyleSettings == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(43);
        }
        return sqlCodeStyleSettings;
    }

    protected <E extends BasicElement> boolean isMultiline(BasicMetaObject<E> meta, BasicMetaPropertyId<?> id) {
        return id == BasicModNamedElement.COMMENT || id == BasicModLikeCheck.PREDICATE;
    }

    protected <E extends BasicElement> boolean isSmall(BasicMetaObject<E> meta, BasicMetaPropertyId<?> id) {
        return Number.class.isAssignableFrom(id.getValueClass());
    }

    private static <E extends BasicElement> DbEditorModel<E, DbSingleValueModelState<BigInteger>> createSeqIdFragmentModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull @Nls String title, BasicMetaId parentKey, BasicMetaId modelKey) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(44);
        }
        if (identity == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(45);
        }
        if (title == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(46);
        }
        DbSingleValueTextModelState<BigInteger> state = Objects.requireNonNull(DbObjectEditorFactory.createTextEditorModelState(BigInteger.class, true, false));
        return new DbEditorModelBase<E, DbSingleValueTextModelState<BigInteger>>(controller, identity, title, state, new DbSeqIdModelApplier.FragmentApplier(parentKey, modelKey), new DbSingleValueModelMultiApplier());
    }

    private <E extends BasicElement> DbEditorModel<E, ?> createSeqIdEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaProperty<E, SequenceIdentity> property) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(47);
        }
        if (identity == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(48);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(49);
        }
        @NotNull BasicMetaPropertyId<T> id = property.id;
        DbEditorModel<E, DbSingleValueModelState<BigInteger>> min = DbObjectEditorFactory.createSeqIdFragmentModel(controller, identity, DatabaseBundle.message("label.min", new Object[0]), id, BasicMetaId.create(id.name + ".min"));
        DbEditorModel<E, DbSingleValueModelState<BigInteger>> max = DbObjectEditorFactory.createSeqIdFragmentModel(controller, identity, DatabaseBundle.message("label.max", new Object[0]), id, BasicMetaId.create(id.name + ".max"));
        DbEditorModel<E, DbSingleValueModelState<BigInteger>> inc = DbObjectEditorFactory.createSeqIdFragmentModel(controller, identity, DatabaseBundle.message("label.step", new Object[0]), id, BasicMetaId.create(id.name + ".inc"));
        DbSeqIdPropModelState state = new DbSeqIdPropModelState(new DbModelRef<E, DbSingleValueModelState<BigInteger>>(min), new DbModelRef<E, DbSingleValueModelState<BigInteger>>(max), new DbModelRef<E, DbSingleValueModelState<BigInteger>>(inc));
        return new DbEditorModelBase<E, DbSeqIdPropModelState>(controller, identity, property.getDefaultValue() == null ? this.getTitle(identity, id) : null, state, new DbSeqIdModelApplier<E>(property), null);
    }

    @NotNull
    private <E extends BasicElement, T> DbEditorModel<E, ?> createSimplePropertyEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaProperty<E, T> property) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(50);
        }
        if (id == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(51);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(52);
        }
        DbSingleValueModelState<T> state = new DbSingleValueModelState<T>(property.getDefaultValue());
        return new DbEditorModelBase<E, DbSingleValueModelState<T>>(controller, id, this.getTitle(id, property.id), state, new DbSinglePropModelApplier<E, T>(property), new DbSingleValueModelMultiApplier());
    }

    @Nullable
    private <E extends BasicElement, T> DbEditorModel<E, ?> getTextEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaProperty<E, T> property) {
        DbSingleValueTextModelState state;
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(53);
        }
        if (identity == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(54);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(55);
        }
        if ((state = DbObjectEditorFactory.createTextEditorModelState(property.id.getValueClass(), this.isSmall(identity.getMetaObject(), property.id), this.isMultiline(identity.getMetaObject(), property.id))) != null) {
            return new DbEditorModelBase(controller, identity, this.getTitle(identity, property.id), state, new DbSinglePropModelApplier<E, T>(property), new DbSingleValueModelMultiApplier());
        }
        return null;
    }

    @Nullable
    public static <T> DbSingleValueTextModelState<T> createTextEditorModelState(@NotNull Class<T> valueClass, boolean small, boolean multiline) {
        Converter<String, T> converter;
        if (valueClass == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(56);
        }
        if ((converter = DbObjectEditorFactory.getConverter(valueClass)) != null) {
            return new DbSingleValueTextModelState(converter.from, converter.to, small, multiline);
        }
        return null;
    }

    private static <E extends BasicElement, T> Converter<String, T> getConverter(@NotNull Class<T> valueClass) {
        if (valueClass == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(57);
        }
        return ourConverters.get(valueClass);
    }

    @Nullable
    public <E extends BasicElement, C extends Collection<?>> DbEditorModel<E, ?> createPropertyEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaProperty<E, C> property) {
        Factory<? extends Collection<?>> fac;
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(58);
        }
        if (identity == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(59);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(60);
        }
        if ((fac = ourCollections.get(property.id.getValueClass())) == null) {
            return null;
        }
        BasicMetaType.CollectionMetaType type2 = (BasicMetaType.CollectionMetaType)property.id.type;
        Converter<String, ?> converter = ourConverters.get(type2.getElementClass());
        if (converter != null) {
            return this.createTextCollectionEditor(controller, identity, property, fac, converter.from, converter.to);
        }
        if (Enum.class.isAssignableFrom(type2.getElementClass())) {
            Function from = Enum::name;
            Function to = n -> Enum.valueOf(type2.getElementClass(), n);
            return this.createTextCollectionEditor(controller, identity, property, fac, from, to);
        }
        return null;
    }

    @NotNull
    private <E extends BasicElement, C extends Collection<?>> DbEditorModel<E, ?> createTextCollectionEditor(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaProperty<E, C> property, Factory<? extends Collection<?>> fac, Function<?, String> from, Function<String, ?> to) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(61);
        }
        if (identity == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(62);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(63);
        }
        DbCollectionTextModelState state = new DbCollectionTextModelState(from, to, fac);
        return new DbEditorModelBase(controller, identity, this.getTitle(identity, property.id), state, new DbSinglePropModelApplier<E, C>(property), new DbSingleValueModelMultiApplier());
    }

    public static <E extends BasicElement, T extends BasicElement> DbEditorModel<E, ?> createEmbeddedRefModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> identity, @NotNull BasicMetaReference<E, T> reference, boolean inline, @NotNull Condition<DbModelRef<?, ?>> filter2, @NlsContexts.Label @Nullable String title) {
        if (controller == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(64);
        }
        if (identity == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(65);
        }
        if (reference == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(66);
        }
        if (filter2 == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(67);
        }
        ElementIdentity<T> fallbackId = DbEmbeddedObjectModelState.createFallbackId(controller, identity, reference, inline);
        DbEmbeddedObjectModelState<T> state = new DbEmbeddedObjectModelState<T>(fallbackId, controller);
        return new DbEditorModelBase<E, DbEmbeddedObjectModelState<T>>(controller, identity, title, state, new DbEmbeddedRefObjectModelApplier<E, T>(reference, filter2), new DbEmbeddedObjectModelMultiApplier());
    }

    static {
        ourCollections = Map.of(List.class, ArrayList::new, Set.class, LinkedHashSet::new);
        ourConverters = Map.ofEntries(DbObjectEditorFactory.put(String.class, Functions.id(), Functions.id()), DbObjectEditorFactory.putNullable(OneTimeString.class, s2 -> s2.toString(false), s2 -> new OneTimeString(s2)), DbObjectEditorFactory.putNullable(Byte.class, Object::toString, Byte::parseByte), DbObjectEditorFactory.putNullable(Short.class, Object::toString, Short::parseShort), DbObjectEditorFactory.putNullable(Integer.class, Object::toString, Integer::parseInt), DbObjectEditorFactory.putNullable(Long.class, Object::toString, Long::parseLong), DbObjectEditorFactory.putNullable(Float.class, Object::toString, Float::parseFloat), DbObjectEditorFactory.putNullable(Double.class, Object::toString, Double::parseDouble), DbObjectEditorFactory.putNullable(BigInteger.class, Object::toString, BigInteger::new), DbObjectEditorFactory.put(DasType.class, dt -> dt.toDataType().equals(DataType.UNKNOWN) ? "" : dt.getSpecification(), s2 -> StringUtil.isEmpty((String)s2) ? DasTypeSystemBase.UNKNOWN : DasUnresolvedTypeReference.of(DataTypeFactory.of(s2))), DbObjectEditorFactory.put(NameValue.class, DbObjectEditorFactory::serializeNv, DbObjectEditorFactory::parseNv), DbObjectEditorFactory.put(NameValueType.class, DbObjectEditorFactory::serializeNvt, DbObjectEditorFactory::parseNvt));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 22, 27, 28, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 3: 
            case 22: 
            case 27: 
            case 28: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 29: 
            case 33: 
            case 37: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 53: 
            case 58: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 30: 
            case 34: 
            case 38: 
            case 41: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 24: 
            case 26: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 31: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 35: 
            case 49: 
            case 52: 
            case 55: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 45: 
            case 48: 
            case 54: 
            case 59: 
            case 62: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "forDbms";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNvt";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNv";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 22: 
            case 27: 
            case 28: 
            case 42: 
            case 43: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forDbms";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditorImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTextEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryCastTo";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createStructureFamilyEditorModel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAnyGrantsEditorModel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createUserGrantsEditorModel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createGrantsEditorModel";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "prepareProperties";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hackProperties";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceEditorModel";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyEditorModel";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getNameTemplate";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCodeStyle";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createSeqIdFragmentModel";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createSeqIdEditorModel";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createSimplePropertyEditorModel";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getTextEditorModel";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createTextEditorModelState";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createTextCollectionEditor";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createEmbeddedRefModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 22, 27, 28, 42, 43 -> new IllegalStateException(string);
        };
    }

    private static class DbToggleableSeqIdEditor<E extends BasicElement>
    extends DbToggleableFormCompoundEditor<E, DbSeqIdPropModelState> {
        public DbToggleableSeqIdEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbSeqIdPropModelState> model2) {
            if (controller == null) {
                DbToggleableSeqIdEditor.$$$reportNull$$$0(0);
            }
            if (model2 == null) {
                DbToggleableSeqIdEditor.$$$reportNull$$$0(1);
            }
            super(controller, model2, controller::shouldHaveEditor);
        }

        @Override
        protected void setToggleState(boolean selected) {
            ((DbSeqIdPropModelState)this.getState()).setPresent(selected);
        }

        @Override
        protected boolean getToggleState() {
            return ((DbSeqIdPropModelState)this.getState()).isPresent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "controller";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory$DbToggleableSeqIdEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Converter<A, B> {
        public final Function<B, A> from;
        public final Function<A, B> to;

        private Converter(Function<B, A> from, Function<A, B> to) {
            this.from = from;
            this.to = to;
        }
    }
}

