/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DbModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ddl.CreateObjectActionHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.VmModelContextFactory;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementMatcherImpl;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.DbModelResetHelper;
import com.intellij.database.schemaEditor.model.applier.DbObjectModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureFamilyModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbTextModelState;
import com.intellij.database.schemaEditor.ui.DbDuplicateObjectAction;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbStructureEditorActions;
import com.intellij.database.schemaEditor.ui.DbVisualEditor;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectEditorBuilder {
    private DbStructureEditorActions.MoreAction myObjectMoreActions;

    @NotNull
    public DbObjectEditorFactory getFactory(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(0);
        }
        DbObjectEditorFactory dbObjectEditorFactory = DbObjectEditorFactory.forDbms(dbms);
        if (dbObjectEditorFactory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(1);
        }
        return dbObjectEditorFactory;
    }

    @NotNull
    public DbEditorModelController createModelControllerWithScope(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull Disposable parent2) {
        if (project == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(2);
        }
        if (modalityState == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(3);
        }
        if (parent2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(4);
        }
        CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob(null));
        DbEditorModelController modelController = this.createModelController(project, scope, modalityState, parent2);
        Disposer.register((Disposable)modelController, () -> CoroutineScopeKt.cancel((CoroutineScope)scope, null));
        DbEditorModelController dbEditorModelController = modelController;
        if (dbEditorModelController == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(5);
        }
        return dbEditorModelController;
    }

    @NotNull
    public DbEditorModelController createModelController(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull ModalityState modalityState, @NotNull Disposable parent2) {
        if (project == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(6);
        }
        if (coroutineScope == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(7);
        }
        if (modalityState == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(8);
        }
        if (parent2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(9);
        }
        DbEditorModelController controller = new DbEditorModelController(project, coroutineScope, modalityState, this);
        Disposer.register((Disposable)parent2, (Disposable)controller);
        DbEditorModelController dbEditorModelController = controller;
        if (dbEditorModelController == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(10);
        }
        return dbEditorModelController;
    }

    @NotNull
    public DbEditorController createEditorController(@NotNull DbEditorModelController modelController, @NotNull Disposable parent2) {
        if (modelController == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(11);
        }
        if (parent2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(12);
        }
        DbEditorController controller = new DbEditorController(modelController);
        Disposer.register((Disposable)parent2, (Disposable)controller);
        DbEditorController dbEditorController = controller;
        if (dbEditorController == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(13);
        }
        return dbEditorController;
    }

    @NotNull
    public <E extends BasicElement> DbEditorModel<E, ?> createAppropriateObjectEditorModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        BasicMetaObject<E> meta;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(14);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(15);
        }
        if (!this.hasStructuredEditor(meta = id.getMetaObject())) {
            DbEditorModel<E, DbObjectModelState<E>> dbEditorModel = controller.createObjectEditorModel(id);
            if (dbEditorModel == null) {
                DbObjectEditorBuilder.$$$reportNull$$$0(16);
            }
            return dbEditorModel;
        }
        DbEditorModel<E, DbStructureModelState> model2 = this.createStructureModel(controller, id);
        controller.createStructureNodeModel(id);
        DbEditorModel<E, DbStructureModelState> dbEditorModel = model2;
        if (dbEditorModel == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(17);
        }
        return dbEditorModel;
    }

    @NotNull
    public <E extends BasicElement> DbEditorModel<E, DbStructureModelState> createStructureModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(18);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(19);
        }
        DbStructureModelState state = new DbStructureModelState();
        return new DbEditorModelBase<E, DbStructureModelState>(controller, id, null, state, new DbStructureModelApplier(new DbStructureModelApplier.RootsChecker(){

            @Override
            @Nullable
            public String getRootGroup(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> rootId2, @NotNull DbModelRef<?, ? extends DbStructureNodeState<?, ?>> checkRef) {
                if (controller == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rootId2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (checkRef == null) {
                    1.$$$reportNull$$$0(2);
                }
                return DbObjectEditorBuilder.this.getStructureRootGroup(controller, rootId2, checkRef);
            }

            @Override
            @Nullable
            public DbModelRef<?, ? extends DbStructureNodeState<?, ?>> getAffectedNodeByChange(@NotNull DbEditorModel<?, ?> m) {
                if (m == null) {
                    1.$$$reportNull$$$0(3);
                }
                return DbObjectEditorBuilder.this.getAffectedStructureNodeByChange(m);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "controller";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "checkRef";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "m";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getRootGroup";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getAffectedNodeByChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }), null);
    }

    @Nullable
    protected String getStructureRootGroup(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> rootId2, @NotNull DbModelRef<?, ? extends DbStructureNodeState<?, ?>> checkRef) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(20);
        }
        if (rootId2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(21);
        }
        if (checkRef == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(22);
        }
        return checkRef.getIdentity() == rootId2 && checkRef.getState() instanceof DbStructureObjectModelState ? "" : null;
    }

    @Nullable
    protected DbModelRef<?, ? extends DbStructureNodeState<?, ?>> getAffectedStructureNodeByChange(@NotNull DbEditorModel<?, ?> m) {
        if (m == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(23);
        }
        return null;
    }

    @NotNull
    public <E extends BasicElement> DbEditorModel<E, DbStructureObjectModelState<E>> createStructureNodeModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(24);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(25);
        }
        BasicMetaObject<E> meta = id.getMetaObject();
        ArrayList<DbEditorModel> models2 = new ArrayList<DbEditorModel>();
        for (BasicMetaObject child : this.getChildren(meta)) {
            if (!this.isIncludedInStructured(child)) continue;
            DbObjectEditorFactory factory = this.getFactory(controller.getDbms(id));
            DbEditorModel model2 = factory.createStructureFamilyEditorModel(controller, id, child);
            models2.add(model2);
        }
        models2.sort(Comparator.comparing(m -> ((DbStructureFamilyModelApplier)m.getApplier()).getWeight()));
        DbEditorModel<E, DbObjectModelState<E>> objectModel = controller.createObjectEditorModel(id);
        DbStructureObjectModelState<E> state = new DbStructureObjectModelState<E>(new DbModelRef<E, DbObjectModelState<E>>(objectModel), ContainerUtil.map(models2, DbModelRef::new));
        return new DbEditorModelBase<E, DbStructureObjectModelState<E>>(controller, id, null, state, new DbStructureObjectModelApplier(), null);
    }

    @NotNull
    public JBIterable<BasicMetaObject<?>> getChildren(@Nullable BasicMetaObject<?> meta) {
        JBIterable<BasicMetaObject<?>> jBIterable = meta == null ? JBIterable.empty() : VmModelContextFactory.getChildren(meta);
        if (jBIterable == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @Nullable
    public BasicMetaObject<?> getParent(@Nullable BasicMetaObject<?> meta) {
        return meta == null ? null : meta.getParent();
    }

    protected boolean isIncludedInStructured(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(27);
        }
        return true;
    }

    protected boolean hasStructuredEditor(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(28);
        }
        return meta.kindOf(BasicTable.class);
    }

    public boolean shouldHaveEditor(@NotNull DbModelRef<?, ?> model2) {
        if (model2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(29);
        }
        return model2.getModelInternalKey() != BasicModArrangedElement.POSITION;
    }

    @NotNull
    public <E extends BasicElement> DbObjectModelState<E> createObjectModelState(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(30);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(31);
        }
        DbObjectModelState<E> dbObjectModelState = this.createObjectModel(controller, id, null).getState();
        if (dbObjectModelState == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(32);
        }
        return dbObjectModelState;
    }

    @NotNull
    public <E extends BasicElement> DbEditorModel<E, DbObjectModelState<E>> createObjectModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(33);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(34);
        }
        DbEditorModel<E, DbObjectModelState<E>> dbEditorModel = this.createObjectModel(controller, id, null);
        if (dbEditorModel == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(35);
        }
        return dbEditorModel;
    }

    @NotNull
    public <E extends BasicElement> DbEditorModel<E, DbObjectModelState<E>> createObjectModel(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @Nullable List<BasicMetaId> invalid) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(36);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(37);
        }
        List<DbEditorModel<E, ?>> models2 = this.createObjectPropertiesModels(controller, id, invalid);
        List states2 = ContainerUtil.map(models2, DbModelRef::new);
        DbObjectModelState<E> state = new DbObjectModelState<E>(id.getMetaObject(), states2);
        return new DbEditorModelBase<E, DbObjectModelState<E>>(controller, id, DatabaseBundle.message("label.properties", new Object[0]), state, new DbObjectModelApplier(), null);
    }

    @NotNull
    public <E extends BasicElement> List<DbEditorModel<E, ?>> createObjectPropertiesModels(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @Nullable List<BasicMetaId> invalid) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(38);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(39);
        }
        Dbms dbms = controller.getDbms(id);
        DbObjectEditorFactory factory = this.getFactory(dbms);
        BasicMetaObject<E> meta = id.getMetaObject();
        ArrayList<BasicMetaField<BasicMetaField>> fields = new ArrayList<BasicMetaField<BasicMetaField>>();
        ContainerUtil.addAll(fields, meta.getAllProperties());
        fields.removeIf(o2 -> o2.isAbstract());
        this.prepareProperties(factory, meta, fields);
        List<DbEditorModel<E, ?>> list = this.createModels(factory, controller, id, fields, invalid);
        if (list == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(40);
        }
        return list;
    }

    protected <E extends BasicElement> void prepareProperties(DbObjectEditorFactory factory, BasicMetaObject<E> meta, List<BasicMetaField<E>> fields) {
        factory.prepareProperties(meta, fields);
    }

    @NotNull
    protected <E extends BasicElement> List<DbEditorModel<E, ?>> createModels(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull List<BasicMetaField<E>> fields, @Nullable List<BasicMetaId> invalid) {
        if (factory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(41);
        }
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(42);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(43);
        }
        if (fields == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(44);
        }
        ArrayList models2 = new ArrayList(fields.size());
        while (!fields.isEmpty()) {
            BasicMetaField<E> field = fields.get(0);
            boolean created2 = false;
            if (field instanceof BasicMetaReference) {
                BasicMetaReference reference = (BasicMetaReference)field;
                created2 = this.createReferenceEditorModel(factory, controller, id, reference, fields, models2);
            } else if (field instanceof BasicMetaProperty) {
                BasicMetaProperty property = (BasicMetaProperty)field;
                created2 = this.createPropertyEditorModel(factory, controller, id, property, fields, models2);
            }
            if (!created2 && invalid != null) {
                invalid.add(field.getId());
            }
            fields.remove(field);
        }
        ContainerUtil.addIfNotNull(models2, DbObjectEditorFactory.createAnyGrantsEditorModel(controller, id));
        ArrayList arrayList = models2;
        if (arrayList == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    protected <E extends BasicElement> boolean createPropertyEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaField<E>> fields, @NotNull List<DbEditorModel<E, ?>> models2) {
        if (factory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(46);
        }
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(47);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(48);
        }
        if (property == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(49);
        }
        if (fields == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(50);
        }
        if (models2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(51);
        }
        if (property.isInternal() && property.id != BasicModArrangedElement.POSITION) {
            return true;
        }
        DbEditorModel<E, ?> model2 = this.createPropertyEditorModel(factory, controller, id, property, fields);
        if (model2 == null) {
            return false;
        }
        models2.add(model2);
        return true;
    }

    @Nullable
    protected <E extends BasicElement> DbEditorModel<E, ?> createPropertyEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaField<E>> fields) {
        if (factory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(52);
        }
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(53);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(54);
        }
        if (property == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(55);
        }
        if (fields == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(56);
        }
        return factory.createPropertyEditorModel(controller, id, property, fields);
    }

    protected <E extends BasicElement> boolean createReferenceEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaReference<E, ?> reference, @NotNull List<BasicMetaField<E>> fields, @NotNull List<DbEditorModel<E, ?>> models2) {
        if (factory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(57);
        }
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(58);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(59);
        }
        if (reference == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(60);
        }
        if (fields == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(61);
        }
        if (models2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(62);
        }
        if (reference.isInternal()) {
            return true;
        }
        DbEditorModel<E, ?> model2 = this.createReferenceEditorModel(factory, controller, id, reference, fields);
        if (model2 == null) {
            return false;
        }
        models2.add(model2);
        return true;
    }

    @Nullable
    protected <E extends BasicElement, T extends BasicElement> DbEditorModel<E, ?> createReferenceEditorModel(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @NotNull BasicMetaReference<E, T> reference, @NotNull List<BasicMetaField<E>> fields) {
        if (factory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(63);
        }
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(64);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(65);
        }
        if (reference == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(66);
        }
        if (fields == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(67);
        }
        return factory.createReferenceEditorModel(controller, id, reference, fields);
    }

    @NotNull
    public DbStructureEditor.StructureRenderer createStructureRenderer(@NotNull DbEditorController controller) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(68);
        }
        return new DbStructureEditor.StructureRenderer(controller);
    }

    @Nullable
    public final <E extends BasicElement, S extends DbModelState> DbEditor<E, S> createObjectEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(69);
        }
        if (modelRef == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(70);
        }
        if (!modelRef.isBoundTo(controller.getModelController())) {
            throw new AssertionError((Object)"Model refs are bound to controller for now");
        }
        Dbms dbms = controller.getModelController().getDbms(modelRef.getIdentity());
        DbObjectEditorFactory factory = DbObjectEditorFactory.forDbms(dbms);
        return DbObjectEditorFactory.init(this.createObjectEditorImpl(factory, controller, modelRef));
    }

    @Nullable
    protected <E extends BasicElement, S extends DbModelState> DbEditor<E, S> createObjectEditorImpl(@NotNull DbObjectEditorFactory factory, @NotNull DbEditorController controller, @NotNull DbModelRef<E, S> modelRef) {
        if (factory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(71);
        }
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(72);
        }
        if (modelRef == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(73);
        }
        return factory.createObjectEditor(controller, modelRef);
    }

    @NotNull
    protected DefaultActionGroup createObjectActionsGroup() {
        return new DefaultActionGroup(new AnAction[]{new DbStructureEditorActions.ColumnKeyAction(ModelHelper.PRIMARY_KEY), new DbStructureEditorActions.ColumnKeyAction(ModelHelper.UNIQUE_KEY), new DbStructureEditorActions.RevertAction()});
    }

    @NotNull
    private DbStructureEditorActions.MoreAction getObjectMoreAction() {
        if (this.myObjectMoreActions == null) {
            this.myObjectMoreActions = new DbStructureEditorActions.MoreAction((ActionGroup)this.createObjectActionsGroup());
        }
        DbStructureEditorActions.MoreAction moreAction = this.myObjectMoreActions;
        if (moreAction == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(74);
        }
        return moreAction;
    }

    @NotNull
    public JComponent decorateEditor(@NotNull DbVisualEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(75);
        }
        BasicMetaId key2 = editor2.getModelInternalKey();
        JComponent component2 = editor2.getComponent();
        if (key2 == BasicModNamedElement.NAME) {
            return DbObjectEditorBuilder.addMoreAction(component2, this.getObjectMoreAction());
        }
        JComponent jComponent = component2;
        if (jComponent == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(76);
        }
        return jComponent;
    }

    @Nullable
    public Icon getIcon(BasicElement properties2) {
        return DbPresentationCore.getIcon(properties2);
    }

    public boolean isUnaligned(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(77);
        }
        return false;
    }

    public boolean startsNewLine(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(78);
        }
        return false;
    }

    public boolean isBigSqlEditor(@NotNull DbModelRef<?, DbTextModelState> model2, @NotNull DbObjectEditorFactory factory) {
        if (model2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(79);
        }
        if (factory == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(80);
        }
        return factory.isBigSqlEditor(model2);
    }

    public boolean isHideFromStructure(@NotNull DbModelRef<?, ?> ref2) {
        if (ref2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(81);
        }
        return false;
    }

    @Nls
    @Nullable
    public String getLocationText(@NotNull DbEditorController controller, @NotNull ElementIdentity<?> identity) {
        DbEditorModelController modelController;
        DbEditorModel<?, DbStructureObjectModelState<?>> sn;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(82);
        }
        if (identity == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(83);
        }
        if ((sn = (modelController = controller.getModelController()).getStructureNodeModel(identity)) == null) {
            return null;
        }
        DbModelRef<?, DbStructureNodeState<?, ?>> p2 = DbStructureModelState.getParentModel(modelController, DbModelRef.create(sn));
        if (p2 == null) {
            return this.computeLocationString(controller, identity);
        }
        return null;
    }

    @NlsSafe
    @Nullable
    protected String computeLocationString(@NotNull DbEditorController controller, @Nullable ElementIdentity<?> identity) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(84);
        }
        if (identity == null) {
            return null;
        }
        DbEditorModelController modelController = controller.getModelController();
        ElementMatcher matcher = modelController.getMatcher();
        return this.computePathString(controller, matcher.getParent(identity));
    }

    @NlsSafe
    @Nullable
    protected String computePathString(@NotNull DbEditorController controller, @Nullable ElementIdentity<?> identity) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(85);
        }
        if (identity == null) {
            return null;
        }
        DbEditorModelController modelController = controller.getModelController();
        ElementMatcher matcher = modelController.getMatcher();
        ElementIdentity<BasicRoot> rootId2 = DbEditorUtilsKt.skipTo(matcher, identity, BasicRoot.class);
        if (rootId2 == null || rootId2 == identity) {
            return null;
        }
        ArrayList<String> path = new ArrayList<String>();
        ElementIdentity<?> p2 = identity;
        while (p2 != null && p2 != rootId2) {
            path.add(this.computeLocationStringPart(controller, p2));
            p2 = matcher.getParent(p2);
        }
        Collections.reverse(path);
        StringBuilder res2 = new StringBuilder();
        StringUtil.join(path, (String)".", (StringBuilder)res2);
        DbDataSource dataSource2 = this.getDataSource(modelController, identity);
        if (dataSource2 != null) {
            res2.append(" [").append(dataSource2.getName()).append("]");
        }
        return res2.toString();
    }

    @NotNull
    protected <E extends BasicElement> String computeLocationStringPart(@NotNull DbEditorController controller, @NotNull ElementIdentity<E> identity) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(86);
        }
        if (identity == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(87);
        }
        E obj2 = DbStructureEditor.StructureRenderer.getObjectToRender(controller, identity);
        String string = this.getDisplayName((ElementIdentity)identity, (BasicElement)obj2);
        if (string == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(88);
        }
        return string;
    }

    @Nullable
    public String getHelpId(@NotNull DbEditorController controller, @NotNull ElementIdentity<?> rootId2) {
        DbStructureEditor<?> structureEditor;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(89);
        }
        if (rootId2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(90);
        }
        DbEditor<?, ?> selectedStructureEditor = (structureEditor = controller.findStructureEditor()) != null ? structureEditor.getSelectedEditor() : null;
        return this.getObjectHelpId(selectedStructureEditor == null ? rootId2 : selectedStructureEditor.getIdentity());
    }

    @Nullable
    protected String getObjectHelpId(@NotNull ElementIdentity<?> id) {
        ObjectKind kind;
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(91);
        }
        if ((kind = id.getMetaObject().kind) == ObjectKind.SCHEMA) {
            return "database.object.modify.dialog.schemas";
        }
        if (kind == ObjectKind.TABLE) {
            return "database.object.modify.dialog.tables";
        }
        if (kind == ObjectKind.COLUMN) {
            return "database.object.modify.dialog.columns";
        }
        if (kind == ObjectKind.KEY) {
            return "database.object.modify.dialog.keys";
        }
        if (kind == ObjectKind.FOREIGN_KEY) {
            return "database.object.modify.dialog.foreign.keys";
        }
        if (kind == ObjectKind.INDEX) {
            return "database.object.modify.dialog.indexes";
        }
        if (kind == ObjectKind.CHECK) {
            return "database.object.modify.dialog.checks";
        }
        if (kind == ObjectKind.VIEW) {
            return "database.object.modify.dialog.views";
        }
        if (kind == ObjectKind.USER || kind == ObjectKind.ROLE || kind == ObjectKind.GROUP) {
            return "database.object.modify.dialog.users.roles";
        }
        if (kind == DvFamilyId.VIRTUAL_COLUMN.getFakeKind()) {
            return "database.object.modify.dialog.virtual.columns";
        }
        if (kind == DvFamilyId.VIRTUAL_FOREIGN_KEY.getFakeKind()) {
            return "database.object.modify.dialog.virtual.foreign.keys";
        }
        if (kind == DvFamilyId.VIRTUAL_VIEW.getFakeKind()) {
            return "database.object.modify.dialog.virtual.views";
        }
        return null;
    }

    @NotNull
    private static BorderLayoutPanel addMoreAction(@NotNull JComponent component2, DbStructureEditorActions.MoreAction moreAction) {
        if (component2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(92);
        }
        moreAction.registerCustomShortcutSet(component2, null);
        ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("EditorPopup", (ActionGroup)new DefaultActionGroup(new AnAction[]{moreAction}), true);
        toolbar2.setTargetComponent(toolbar2.getComponent());
        toolbar2.setReservePlaceAutoPopupIcon(false);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)component2).addToRight((Component)toolbar2.getComponent());
        if (borderLayoutPanel == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(93);
        }
        return borderLayoutPanel;
    }

    @NotNull
    public ElementMatcher createMatcher(boolean withOriginal, final @NotNull DbEditorModelController controller) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(94);
        }
        return new ElementMatcherImpl(withOriginal, new ElementMatcherImpl.ChildProvider(){

            @Override
            @NotNull
            public <P extends BasicElement, E extends BasicElement> Iterable<E> getChildren(@NotNull P e2, @NotNull ElementIdentity<P> id, @NotNull BasicMetaObject<E> meta) {
                if (e2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (id == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (meta == null) {
                    2.$$$reportNull$$$0(2);
                }
                Iterable<E> iterable = DbObjectEditorBuilder.this.getChildren(controller, e2, id, meta);
                if (iterable == null) {
                    2.$$$reportNull$$$0(3);
                }
                return iterable;
            }

            @Override
            @NotNull
            public Iterable<BasicMetaObject<?>> getChildren(@Nullable BasicMetaObject<?> meta) {
                JBIterable<BasicMetaObject<?>> jBIterable = DbObjectEditorBuilder.this.getChildren(meta);
                if (jBIterable == null) {
                    2.$$$reportNull$$$0(4);
                }
                return jBIterable;
            }

            @Override
            @Nullable
            public BasicMetaObject<?> getParent(@Nullable BasicMetaObject<?> meta) {
                return DbObjectEditorBuilder.this.getParent(meta);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "id";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "meta";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorBuilder$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorBuilder$2";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildren";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3, 4 -> new IllegalStateException(string);
                };
            }
        });
    }

    @NotNull
    protected <P extends BasicElement, E extends BasicElement> Iterable<E> getChildren(@NotNull DbEditorModelController controller, @NotNull P e2, @NotNull ElementIdentity<P> id, @NotNull BasicMetaObject<E> meta) {
        Object family;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(95);
        }
        if (e2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(96);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(97);
        }
        if (meta == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(98);
        }
        if ((family = BasicMetaUtils.getFamily(e2, meta)) != null) {
            Object f = family;
            if (f == null) {
                DbObjectEditorBuilder.$$$reportNull$$$0(99);
            }
            return f;
        }
        LocalDataSource dataSource2 = DbImplUtilCore.getMaybeLocalDataSource(controller.getDataSource(id));
        if (dataSource2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DbObjectEditorBuilder.$$$reportNull$$$0(100);
            }
            return jBIterable;
        }
        JBIterable<E> jBIterable = VmModelContextFactory.createVirtualObjects(dataSource2, e2, meta);
        if (jBIterable == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(101);
        }
        return jBIterable;
    }

    public <T extends BasicElement> void initNewObject(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child, @NotNull ModelHelper.ObjectKindVariant variant, int position, @NotNull Set<DbModelRef<?, ? extends DbStructureNodeState<?, ?>>> selection2) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(102);
        }
        if (child == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(103);
        }
        if (variant == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(104);
        }
        if (selection2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(105);
        }
        DbObjectEditorBuilder.fillWithExamples(controller, child, variant, position, selection2);
    }

    private static <T extends BasicElement> void fillWithExamples(@NotNull DbEditorModelController controller, @NotNull DbModelRef<T, DbStructureObjectModelState<T>> child, @NotNull ModelHelper.ObjectKindVariant variant, int position, @NotNull Set<DbModelRef<?, ? extends DbStructureNodeState<?, ?>>> selection2) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(106);
        }
        if (child == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(107);
        }
        if (variant == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(108);
        }
        if (selection2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(109);
        }
        ElementIdentity<T> id = child.getIdentity();
        Set selection22 = ContainerUtil.map2SetNotNull(selection2, m -> m.getState() instanceof DbStructureObjectModelState ? new StructureModelCursor<Object>(controller, m.getIdentity(), null) : null);
        T o2 = id.getMetaObject().newDataObject();
        StructureModelCursor<T> target2 = new StructureModelCursor<T>(controller, id, o2);
        Dbms dbms = controller.getDbms(child.getIdentity());
        CreateObjectActionHelper.prepareNewObject(dbms, target2, variant, (short)position, selection22);
        DbObjectEditorBuilder.applyPropertiesToModel(controller, id, o2);
    }

    public static <T extends BasicElement> void applyPropertiesToModel(DbEditorModelController controller, ElementIdentity<T> id, T o2) {
        DbModelResetHelper.resetOne(controller, o2, id);
    }

    @NotNull
    public static <E extends BasicElement> CreateObjectActionHelper.ObjectCursor<E> cursor(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(110);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(111);
        }
        return new StructureModelCursor<Object>(controller, id, null);
    }

    @NotNull
    public DefaultActionGroup createStructureContextMenu() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new DbStructureEditorActions.CreateObjectGroup());
        group2.add((AnAction)new DbDuplicateObjectAction());
        group2.add((AnAction)new DbStructureEditorActions.EditAction());
        group2.add((AnAction)new DbStructureEditorActions.DeleteAction());
        group2.add((AnAction)new DbStructureEditorActions.RevertAction());
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(112);
        }
        return defaultActionGroup;
    }

    public final boolean isEnabled(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id, @NotNull BasicMetaId prop) {
        Object o2;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(113);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(114);
        }
        if (prop == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(115);
        }
        if (DbObjectEditorBuilder.isDropped(controller, id)) {
            return false;
        }
        DbObjectModelState<?> state = controller.getObjectModelState(id);
        Object v0 = o2 = state == null ? null : state.getProperties();
        if (o2 == null) {
            ElementOwner original = controller.getMatcher().getOriginalOwner();
            Object v1 = o2 = original == null ? null : original.find(id);
        }
        if (o2 == null) {
            o2 = id.getMetaObject().newDataObject();
        }
        return this.isEnabled(controller, id, o2, prop);
    }

    public boolean isEnabled(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id, @Nullable BasicElement e2, @NotNull BasicMetaId prop) {
        boolean enabled;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(116);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(117);
        }
        if (prop == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(118);
        }
        if (e2 == null || DbObjectEditorBuilder.isDropped(controller, id)) {
            return false;
        }
        ScriptingCapabilities capabilities = DbObjectEditorBuilder.getCapabilities(controller.getDbms(id), e2);
        if (capabilities == null) {
            return true;
        }
        if (controller.isReadonly(id)) {
            return false;
        }
        ElementMatcher matcher = controller.getMatcher();
        BasicMetaReference<?, ?> inlined2 = matcher.getInlineMetaRef(id);
        ElementIdentity<?> parentId = matcher.getParent(id);
        ElementOwner original = controller.getMatcher().getOriginalOwner();
        Object orig = original == null ? null : original.find(id);
        Version targetVersion = this.getServerVersion(controller, id);
        boolean bl = (inlined2 == null || parentId == null || this.isEnabled(controller, parentId, inlined2.id)) && (orig == null ? capabilities.canCreateWith(prop) : capabilities.canAlter(prop)).get(targetVersion) != false ? true : (enabled = false);
        if (enabled) {
            return true;
        }
        if (orig == null) {
            return parentId != null && (original == null || original.find(parentId) == null);
        }
        if (!controller.getScriptingOptions().get(ScriptingOptionStatic.ALLOW_RECREATE).booleanValue()) {
            return false;
        }
        return DbObjectEditorBuilder.canRecreateWith(capabilities, prop, targetVersion);
    }

    @Nullable
    private static ScriptingCapabilities getCapabilities(@NotNull Dbms dbms, @NotNull BasicElement e2) {
        if (dbms == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(119);
        }
        if (e2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(120);
        }
        if (!DbObjectEditorBuilder.isInMetaModel(e2.getMetaObject())) {
            return null;
        }
        return ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e2);
    }

    private static boolean isInMetaModel(@NotNull BasicMetaObject<?> object) {
        BasicMetaObject<?> parent2;
        if (object == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(121);
        }
        if ((parent2 = object.getParent()) == null) {
            BasicMetaModel<?> model2 = object.getModelOpt();
            return model2 != null && model2.root == object;
        }
        return ArrayUtil.indexOf((Object[])parent2.children, object) != -1 && DbObjectEditorBuilder.isInMetaModel(parent2);
    }

    private static boolean isDropped(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        DbObjectModelState<?> state;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(122);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(123);
        }
        return (state = controller.getObjectModelState(id)) != null && state.isDropped();
    }

    private static boolean canRecreateWith(@NotNull ScriptingCapabilities capabilities, @NotNull BasicMetaId prop, Version targetVersion) {
        if (capabilities == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(124);
        }
        if (prop == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(125);
        }
        if (!capabilities.getCreate().get(targetVersion).booleanValue()) {
            return false;
        }
        return capabilities.canCreateWith(prop).get(targetVersion) != false;
    }

    public boolean canDrop(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> element2) {
        DbObjectModelState<?> state;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(126);
        }
        if (element2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(127);
        }
        Object example = (state = controller.getObjectModelState(element2)) == null ? element2.getMetaObject().newDataObject() : state.getProperties();
        ScriptingCapabilities capabilities = DbObjectEditorBuilder.getCapabilities(controller.getDbms(element2), example);
        if (capabilities == null) {
            return true;
        }
        if (controller.isReadonly(element2)) {
            return false;
        }
        ElementOwner original = controller.getMatcher().getOriginalOwner();
        ElementIdentity<?> parent2 = original != null ? original.getParent(element2) : null;
        boolean parentExists = parent2 != null && original.find(parent2) != null;
        Version targetVersion = this.getServerVersion(controller, element2);
        boolean canDrop = capabilities.getDrop().get(targetVersion);
        if (canDrop || !parentExists) {
            return true;
        }
        return controller.getScriptingOptions().get(ScriptingOptionStatic.ALLOW_RECREATE) != false;
    }

    public boolean canCreate(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> parent2, @NotNull BasicMetaObject<?> child) {
        Version targetVersion;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(128);
        }
        if (parent2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(129);
        }
        if (child == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(130);
        }
        Object example = child.newDataObject();
        ScriptingCapabilities capabilities = DbObjectEditorBuilder.getCapabilities(controller.getDbms(parent2), example);
        if (capabilities == null) {
            return true;
        }
        if (controller.isReadonly(parent2)) {
            return false;
        }
        ElementOwner original = controller.getMatcher().getOriginalOwner();
        boolean parentExists = original != null && original.find(parent2) != null;
        boolean canCreate = (parentExists ? capabilities.getCreateAlone() : capabilities.getCreate()).get(targetVersion = this.getServerVersion(controller, parent2));
        if (canCreate || !parentExists) {
            return true;
        }
        if (!controller.getScriptingOptions().get(ScriptingOptionStatic.ALLOW_RECREATE).booleanValue()) {
            return false;
        }
        return capabilities.getCreate().get(targetVersion);
    }

    @Nullable
    public DbDataSource getDataSource(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        BasicElement root2;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(131);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(132);
        }
        ElementMatcher matcher = controller.getMatcher();
        ElementIdentity<?> rootId2 = DbObjectEditorBuilder.skipToRootIfPossible(matcher, id);
        ElementOwner owner = matcher.getOriginalOwner();
        BasicElement basicElement = root2 = owner == null ? null : (BasicElement)owner.find(rootId2);
        if (root2 == null) {
            return null;
        }
        DbModelRegistry mr = (DbModelRegistry)controller.getProject().getService(DbModelRegistry.class);
        return mr.findDbDataSource(root2);
    }

    @NotNull
    public Dbms getDbms(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        Dbms v2;
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(133);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(134);
        }
        Dbms dbms = (v2 = this.getProperty(controller.getMatcher(), id, BasicModRoot.DBMS)) == null ? id.getMetaObject().getDbms() : v2;
        if (dbms == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(135);
        }
        return dbms;
    }

    @Nullable
    public Version getServerVersion(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(136);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(137);
        }
        return this.getProperty(controller.getMatcher(), id, BasicModRoot.SERVER_VERSION);
    }

    @Nullable
    public <T> T getProperty(@NotNull ElementMatcher matcher, @NotNull ElementIdentity<?> id, @NotNull BasicMetaPropertyId<T> propId) {
        ElementIdentity<?> startId;
        if (matcher == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(138);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(139);
        }
        if (propId == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(140);
        }
        ElementIdentity<?> tmpId = startId = propId == BasicModRoot.DBMS || propId == BasicModRoot.SERVER_VERSION ? DbObjectEditorBuilder.skipToRootIfPossible(matcher, id) : id;
        while (tmpId != null) {
            T v2 = DbObjectEditorBuilder.getPropIfHasProp(matcher, tmpId, propId);
            if (v2 != null) {
                return v2;
            }
            tmpId = matcher.getParent(tmpId);
        }
        return null;
    }

    private static ElementIdentity<?> skipToRootIfPossible(@NotNull ElementMatcher matcher, @NotNull ElementIdentity<?> id) {
        ElementIdentity<BasicRoot> rootId2;
        if (matcher == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(141);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(142);
        }
        return (rootId2 = DbEditorUtilsKt.skipTo(matcher, id, BasicRoot.class)) != null ? rootId2 : id;
    }

    @Nullable
    private static <E extends BasicElement, T> T getPropIfHasProp(@NotNull ElementMatcher matcher, @NotNull ElementIdentity<E> id, @NotNull BasicMetaPropertyId<T> propId) {
        BasicMetaProperty<E, T> prop;
        if (matcher == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(143);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(144);
        }
        if (propId == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(145);
        }
        if ((prop = id.getMetaObject().getObjectProperty(propId)) == null) {
            return null;
        }
        E element2 = ((ElementMatcherImpl)matcher).findElement(id);
        if (element2 != null) {
            return prop.get(element2);
        }
        return null;
    }

    @Nullable
    @Nls
    public String getDisplayNamePrefix(@NotNull ElementIdentity<?> id) {
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(146);
        }
        return null;
    }

    @Nls
    public <T extends BasicElement> String getDisplayName(@NotNull ElementIdentity<T> id, @NotNull T properties2) {
        List<ElementIdentity<T>> identities;
        Object name2;
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(147);
        }
        if (properties2 == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(148);
        }
        if (StringUtil.isEmpty((String)(name2 = properties2.getName())) && (identities = MultiElementIdentity.getIdentities(id)) != null) {
            name2 = identities.size() + " " + id.getMetaObject().kind.getPluralPresentableName();
        }
        return name2;
    }

    @NlsSafe
    @NotNull
    public final String getTitle(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> id, @NotNull BasicMetaId prop) {
        if (controller == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(149);
        }
        if (id == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(150);
        }
        if (prop == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(151);
        }
        Dbms dbms = this.getDbms(controller, id);
        String string = this.getFactory(dbms).getTitle(id, prop);
        if (string == null) {
            DbObjectEditorBuilder.$$$reportNull$$$0(152);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 10, 13, 16, 17, 26, 32, 35, 40, 45, 74, 76, 88, 93, 99, 100, 101, 112, 135, 152 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 26: 
            case 32: 
            case 35: 
            case 40: 
            case 45: 
            case 74: 
            case 76: 
            case 88: 
            case 93: 
            case 99: 
            case 100: 
            case 101: 
            case 112: 
            case 135: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorBuilder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelController";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 30: 
            case 33: 
            case 36: 
            case 38: 
            case 42: 
            case 47: 
            case 53: 
            case 58: 
            case 64: 
            case 68: 
            case 69: 
            case 72: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 94: 
            case 95: 
            case 102: 
            case 106: 
            case 110: 
            case 113: 
            case 116: 
            case 122: 
            case 126: 
            case 128: 
            case 131: 
            case 133: 
            case 136: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 15: 
            case 19: 
            case 25: 
            case 31: 
            case 34: 
            case 37: 
            case 39: 
            case 43: 
            case 48: 
            case 54: 
            case 59: 
            case 65: 
            case 91: 
            case 97: 
            case 111: 
            case 114: 
            case 117: 
            case 123: 
            case 132: 
            case 134: 
            case 137: 
            case 139: 
            case 142: 
            case 144: 
            case 146: 
            case 147: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 21: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkRef";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 27: 
            case 28: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 29: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 41: 
            case 46: 
            case 52: 
            case 57: 
            case 63: 
            case 71: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 44: 
            case 50: 
            case 56: 
            case 61: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 51: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 75: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 83: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 96: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 103: 
            case 107: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 104: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 105: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 115: 
            case 118: 
            case 125: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capabilities";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 138: 
            case 141: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 140: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propId";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelControllerWithScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelController";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorController";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppropriateObjectEditorModel";
                break;
            }
            case 26: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectModelState";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectModel";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectPropertiesModels";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createModels";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectMoreAction";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "decorateEditor";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLocationStringPart";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "addMoreAction";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureContextMenu";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFactory";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 26: 
            case 32: 
            case 35: 
            case 40: 
            case 45: 
            case 74: 
            case 76: 
            case 88: 
            case 93: 
            case 99: 
            case 100: 
            case 101: 
            case 112: 
            case 135: 
            case 152: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModelControllerWithScope";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createModelController";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEditorController";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAppropriateObjectEditorModel";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createStructureModel";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStructureRootGroup";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedStructureNodeByChange";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createStructureNodeModel";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedInStructured";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasStructuredEditor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldHaveEditor";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createObjectModelState";
                break;
            }
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createObjectModel";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createObjectPropertiesModels";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createModels";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyEditorModel";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceEditorModel";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createStructureRenderer";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditor";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditorImpl";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "decorateEditor";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isUnaligned";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "startsNewLine";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isBigSqlEditor";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isHideFromStructure";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getLocationText";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "computeLocationString";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "computePathString";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "computeLocationStringPart";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getObjectHelpId";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "addMoreAction";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "createMatcher";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "initNewObject";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "fillWithExamples";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "cursor";
                break;
            }
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getCapabilities";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isInMetaModel";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isDropped";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "canRecreateWith";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "canDrop";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "getDbms";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getServerVersion";
                break;
            }
            case 138: 
            case 139: 
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "skipToRootIfPossible";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getPropIfHasProp";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayNamePrefix";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 10, 13, 16, 17, 26, 32, 35, 40, 45, 74, 76, 88, 93, 99, 100, 101, 112, 135, 152 -> new IllegalStateException(string);
        };
    }

    public static class StructureModelCursor<E extends BasicElement>
    implements CreateObjectActionHelper.ObjectCursor<E> {
        private final DbEditorModelController myController;
        private final ElementIdentity<E> myId;
        private E myProperties;

        public StructureModelCursor(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<E> id, @Nullable E properties2) {
            if (controller == null) {
                StructureModelCursor.$$$reportNull$$$0(0);
            }
            if (id == null) {
                StructureModelCursor.$$$reportNull$$$0(1);
            }
            this.myController = controller;
            this.myId = id;
            this.myProperties = properties2;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = this.myController.getDbms(this.myId);
            if (dbms == null) {
                StructureModelCursor.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @Override
        @NotNull
        public E getProperties() {
            if (this.myProperties == null) {
                DbObjectModelState<E> state = this.myController.getObjectModelState(this.myId);
                if (state != null) {
                    this.myProperties = state.getProperties();
                } else {
                    ElementOwner oOwner = this.myController.getMatcher().getOriginalOwner();
                    Object original = oOwner == null ? null : oOwner.find(this.myId);
                    this.myProperties = original == null ? this.myId.getMetaObject().newDataObject() : original;
                }
            }
            E e2 = this.myProperties;
            if (e2 == null) {
                StructureModelCursor.$$$reportNull$$$0(3);
            }
            return e2;
        }

        @Override
        @NotNull
        public BasicMetaObject<E> getMetaObject() {
            BasicMetaObject<E> basicMetaObject = this.myId.getMetaObject();
            if (basicMetaObject == null) {
                StructureModelCursor.$$$reportNull$$$0(4);
            }
            return basicMetaObject;
        }

        @Override
        @NotNull
        public JBIterable<BasicMetaObject<?>> getMetaChildren() {
            JBIterable<BasicMetaObject<?>> jBIterable = this.myController.getBuilder().getChildren(this.getMetaObject());
            if (jBIterable == null) {
                StructureModelCursor.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Override
        @Nullable
        public CreateObjectActionHelper.ObjectCursor<?> getParent() {
            return this.wrap(this.myController.getMatcher().getParent(this.myId));
        }

        @Override
        public boolean isExisting() {
            ElementOwner oOwner = this.myController.getMatcher().getOriginalOwner();
            return oOwner != null && oOwner.find(this.myId) != null;
        }

        private <T extends BasicElement> StructureModelCursor<T> wrap(@Nullable ElementIdentity<T> id) {
            return id == null ? null : new StructureModelCursor<Object>(this.myController, id, null);
        }

        @Override
        @NotNull
        public JBIterable<CreateObjectActionHelper.ObjectCursor<?>> getChildren(@Nullable ObjectKind kind) {
            DbStructureObjectModelState<E> state = this.myController.getStructureNodeModelState(this.myId);
            if (state == null) {
                ElementOwner owner = this.myController.getMatcher().getOriginalOwner();
                BasicMixinElement original = owner == null ? null : (BasicMixinElement)owner.find(this.myId);
                JBIterable jBIterable = original == null ? JBIterable.empty() : original.getDasChildren(kind).map(o2 -> this.wrap(owner.identify(o2)));
                if (jBIterable == null) {
                    StructureModelCursor.$$$reportNull$$$0(6);
                }
                return jBIterable;
            }
            JBIterable families = kind != null ? JBIterable.of(state.getFamily(kind)) : JBIterable.from(state.getFamilies());
            JBIterable jBIterable = families.flatten(f -> ((DbStructureFamilyModelState)f.getState()).getStructureChildren()).map(s2 -> this.wrap(s2.getIdentity()));
            if (jBIterable == null) {
                StructureModelCursor.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof StructureModelCursor && ((StructureModelCursor)obj2).myId == this.myId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controller";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorBuilder$StructureModelCursor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorBuilder$StructureModelCursor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProperties";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaObject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetaChildren";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

