/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.schemaEditor.DbObjectGrantsEditorCore;
import com.intellij.database.schemaEditor.GrantForUser;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.StateKey;
import com.intellij.database.schemaEditor.model.DeArgument;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeConstraint;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeGrant;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.schemaEditor.model.DeTrigger;
import com.intellij.database.schemaEditor.model.DeView;
import com.intellij.database.schemaEditor.model.DeWrapper;
import com.intellij.database.schemaEditor.model.DeWrapperImpl;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DasSchemaExporters {
    protected static boolean isMixedCase(String name2) {
        Case c2 = Case.forString(name2);
        return c2 == Case.MIXED || c2 == Case.TITLE;
    }

    public static boolean treatAsPlainIdentifier(String name2, boolean quoted, BasicNamedElement edited, boolean mixedIsQuoted) {
        if (edited != null && (edited.getName().equals(name2) || edited.isNameScripted())) {
            return edited.isNameScripted();
        }
        return !quoted && (!mixedIsQuoted || !DasSchemaExporters.isMixedCase(name2));
    }

    private static <T extends Grants.Grant> void applyGrants(@NotNull DeTable from, @NotNull BasicModTableOrView to, Grants.Controller<T, ?> grantCtl) {
        if (from == null) {
            DasSchemaExporters.$$$reportNull$$$0(0);
        }
        if (to == null) {
            DasSchemaExporters.$$$reportNull$$$0(1);
        }
        BasicElement fromE = from.unwrap();
        if (to instanceof BasicModIdentifiedElement && ((BasicModIdentifiedElement)((Object)to)).getObjectId() == Long.MIN_VALUE && fromE == null) {
            ((BasicModIdentifiedElement)((Object)to)).setObjectId(new Random().nextLong());
        }
        Collection grants = DasSchemaExporters.convertGrants(from, grantCtl);
        List<T> newGrants = DbObjectGrantsEditorCore.convertGrants(grantCtl, to, grants);
        DbObjectGrantsEditorCore.applyGrants(grantCtl, fromE, to, newGrants);
    }

    @NotNull
    private static <G extends Grants.Grant> Collection<DeGrant<G>> extractGrants(@NotNull BasicElement from, @NotNull Grants.Controller<G, ?> grantCtl) {
        if (from == null) {
            DasSchemaExporters.$$$reportNull$$$0(2);
        }
        if (grantCtl == null) {
            DasSchemaExporters.$$$reportNull$$$0(3);
        }
        BasicElement parent2 = from.getParent();
        List<GrantForUser<G>> list = DbObjectGrantsEditorCore.extractGrants(null, grantCtl, from instanceof BasicLikeColumn && parent2 != null ? parent2 : from);
        MultiMap<Integer, DeGrant<G>> map2 = DasSchemaExporters.convertGrants(list);
        Collection collection2 = map2.get(from instanceof BasicArrangedElement ? Integer.valueOf(((BasicArrangedElement)from).getPosition()) : null);
        if (collection2 == null) {
            DasSchemaExporters.$$$reportNull$$$0(4);
        }
        return collection2;
    }

    public static SchemaExporters createDefaultExporters() {
        SchemaExporters dasSchemaExporter = new SchemaExporters();
        dasSchemaExporter.add(new DeTableExporter());
        dasSchemaExporter.add(new DeColumnExporter());
        dasSchemaExporter.add(new DeIndexExporter());
        dasSchemaExporter.add(new DeForeignKeyExporter());
        dasSchemaExporter.add(new DeTableKeyExporter());
        dasSchemaExporter.add(new DeNamespaceExporter());
        dasSchemaExporter.add(new DeRoutineExporter());
        dasSchemaExporter.add(new DeArgumentExporter());
        dasSchemaExporter.add(new DeViewExporter());
        dasSchemaExporter.add(new DeMatViewExporter());
        dasSchemaExporter.add(new DeObjectTypeExporter());
        dasSchemaExporter.add(new DePackageExporter());
        dasSchemaExporter.add(new DeBodyExporter());
        dasSchemaExporter.add(new DeTriggerExporter());
        dasSchemaExporter.add(new DeSequenceExporter());
        return dasSchemaExporter;
    }

    @NotNull
    public static <G extends Grants.Grant> Collection<GrantForUser<G>> convertGrants(DeTable table, Grants.Controller<G, ?> ctl) {
        Map grouped = FactoryMap.createMap(grant -> new GrantForUser(grant.userText, grant.userKind, grant.userKey, null), () -> DasSchemaExporters.createUserMap(ctl));
        for (DeGrant grant2 : table.grants) {
            GrantForUser res2 = (GrantForUser)grouped.get(grant2);
            for (Map.Entry<String, Grants.State> e2 : grant2.permissions.entrySet()) {
                res2.getGrants().put(new StateKey(e2.getKey(), null), e2.getValue());
            }
        }
        for (DeColumn column2 : table.columns) {
            short position = column2.getPosition();
            for (DeGrant grant3 : column2.grants) {
                GrantForUser res3 = (GrantForUser)grouped.get(grant3);
                for (Map.Entry<String, Grants.State> e3 : grant3.permissions.entrySet()) {
                    res3.getGrants().put(new StateKey(e3.getKey(), Integer.valueOf(position)), e3.getValue());
                }
            }
        }
        Collection<GrantForUser<G>> collection2 = grouped.values();
        if (collection2 == null) {
            DasSchemaExporters.$$$reportNull$$$0(5);
        }
        return collection2;
    }

    @NotNull
    private static <G extends Grants.Grant> Map<DeGrant<G>, GrantForUser<G>> createUserMap(final Grants.Controller<G, ?> ctl) {
        return new Object2ObjectOpenCustomHashMap(new Hash.Strategy<DeGrant<G>>(){

            public int hashCode(DeGrant<G> object) {
                return object == null ? 0 : Objects.hash(object.userText, ctl.getGranteeStrategy().hashCode(object.userKey), object.userKind);
            }

            public boolean equals(DeGrant<G> o1, DeGrant<G> o2) {
                return o1 == null || o2 == null ? o1 == null : Objects.equals(o1.userText, o2.userText) && ctl.getGranteeStrategy().equals(o1.userKey, o2.userKey) && Objects.equals(o1.userKind, o2.userKind);
            }
        });
    }

    @NotNull
    public static <G extends Grants.Grant> MultiMap<Integer, DeGrant<G>> convertGrants(List<GrantForUser<G>> grants) {
        MultiMap res2 = MultiMap.create();
        for (GrantForUser<G> grant : grants) {
            Map tmp = FactoryMap.create(idx -> new LinkedHashMap());
            if (grant.getGrants().isEmpty()) {
                tmp.get(null);
            }
            for (Map.Entry<StateKey, Grants.State> entry : grant.getGrants().entrySet()) {
                ((Map)tmp.get(entry.getKey().getPos())).put(entry.getKey().getPerm(), entry.getValue());
            }
            for (Map.Entry<StateKey, Grants.State> entry : tmp.entrySet()) {
                DeGrant<G> deGrant = new DeGrant<G>(StringUtil.notNullize((String)grant.getUserText()), grant.getUserKey(), (ObjectKind)ObjectUtils.notNull((Object)grant.getUserKind(), (Object)ObjectKind.USER), (Map)((Object)entry.getValue()));
                res2.putValue((Object)((Integer)((Object)entry.getKey())), deGrant);
            }
        }
        MultiMap multiMap = res2;
        if (multiMap == null) {
            DasSchemaExporters.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grantCtl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractGrants";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertGrants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyGrants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractGrants";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    protected static class DeTableExporter
    extends DeObjectExporter<DeTable, BasicTable, BasicModTableOrView> {
        public DeTableExporter() {
            super(DeTable.class, BasicTable.class, ObjectKind.TABLE);
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeTable to, @NotNull BasicTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getParent(), false);
            to.temporary = from.isTemporary();
            to.grants.clear();
            Grants.Controller<?, ?> grantCtl = helper.getContext().myGrantController;
            if (grantCtl != null) {
                to.grants.addAll(DasSchemaExporters.extractGrants(from, grantCtl));
            }
        }

        private static <T extends Grants.Grant> void pullGrantees(@NotNull BasicElement from, @NotNull BasicModElement to, Grants.Controller<T, ?> grantCtl) {
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(3);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(4);
            }
            Iterator it1 = grantCtl.granteeFamiliesFor(from).iterator();
            Iterator it2 = grantCtl.granteeFamiliesFor(to).iterator();
            while (it1.hasNext() && it2.hasNext()) {
                ModelLightCopier.copyFamily((Family)it1.next(), (ModFamily)it2.next(), true);
            }
        }

        @Override
        protected void applyImpl(@NotNull SchemaApplyHelper helper, @NotNull DeTable from, @NotNull BasicModTableOrView to) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(5);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(6);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(7);
            }
            super.applyImpl(helper, from, to);
            to.setTemporary(from.temporary);
            Grants.Controller<?, ?> grantCtl = helper.getContext().myGrantController;
            if (grantCtl != null) {
                DasSchemaExporters.applyGrants(from, to, grantCtl);
                BasicElement fromE = from.unwrap();
                if (fromE == null && from.parent != null) {
                    fromE = from.parent.unwrap();
                }
                if (fromE != null) {
                    DeTableExporter.pullGrantees(fromE, to, grantCtl);
                }
            }
        }

        @Override
        @NotNull
        public DeTable create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(8);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(9);
            }
            return new DeTable(DeTableExporter.getName(helper, from), null, helper.getModel());
        }

        @Override
        public void exportChildren(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeTable to, @NotNull BasicTable from) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(10);
            }
            if (to == null) {
                DeTableExporter.$$$reportNull$$$0(11);
            }
            if (from == null) {
                DeTableExporter.$$$reportNull$$$0(12);
            }
            for (BasicElement child : from.getDasChildren(null)) {
                this.processTableChild(helper, to, child);
            }
            if (to.keys.getPrimaryKey() == null) {
                this.processTableInlinePk(helper, to, from);
            }
        }

        protected void processTableChild(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeTable table, @NotNull BasicElement child) {
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(13);
            }
            if (table == null) {
                DeTableExporter.$$$reportNull$$$0(14);
            }
            if (child == null) {
                DeTableExporter.$$$reportNull$$$0(15);
            }
            if (!helper.canExport(child)) {
                return;
            }
            Object exported = helper.export(child, true);
            if (exported instanceof DeColumn) {
                table.columns.add((DeColumn)exported);
            } else if (exported instanceof DeIndex) {
                table.indices.add((Object)((DeIndex)exported));
            } else if (exported instanceof DeForeignKey) {
                table.foreignKeys.add((Object)((DeForeignKey)exported));
            } else if (exported instanceof DeTableKey) {
                table.keys.add((DeTableKey)exported);
            } else if (exported instanceof DeConstraint) {
                table.constraints.add((Object)((DeConstraint)exported));
            }
        }

        protected void processTableInlinePk(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeTable table, @NotNull BasicTable object) {
            JBIterable key2;
            if (helper == null) {
                DeTableExporter.$$$reportNull$$$0(16);
            }
            if (table == null) {
                DeTableExporter.$$$reportNull$$$0(17);
            }
            if (object == null) {
                DeTableExporter.$$$reportNull$$$0(18);
            }
            if (!(key2 = object.getColumns().jbi().filter(child -> object.getColumnAttrs((DasColumn)child).contains((Object)DasColumn.Attribute.PRIMARY_KEY)).collect()).isEmpty()) {
                DeTableKey primaryKey = new DeTableKey(table.name + "_autogenerated_pk", table, helper.getModel());
                for (BasicTableOrViewColumn column2 : key2) {
                    primaryKey.columns.add((DeColumn)helper.export(column2, true));
                }
                if (table.keys.getPrimaryKey() != null) {
                    this.myLogger.warn("Already have primary key");
                }
                table.keys.setPrimaryKey(primaryKey);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 14: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pullGrantees";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyImpl";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportChildren";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTableChild";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTableInlinePk";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeColumnExporter
    extends DeTableChildExporter<DeColumn, BasicTableColumn, BasicModTableColumn> {
        public DeColumnExporter() {
            super(DeColumn.class, BasicTableColumn.class, ObjectKind.COLUMN);
        }

        @Override
        protected void applyImpl(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
            if (helper == null) {
                DeColumnExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeColumnExporter.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DeColumnExporter.$$$reportNull$$$0(2);
            }
            super.applyImpl(helper, from, to);
            to.setStoredType(DasUnresolvedTypeReference.of(DataTypeFactory.of(from.dataType)));
            to.setNotNull(from.isNotNull());
            to.setPosition((short)(from.table.columns.indexOf(from) + 1));
            DbImplUtilCore.getModelHelper(to).exportApplyColumn(helper, from, to);
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeColumn to, @NotNull BasicTableColumn from) {
            if (helper == null) {
                DeColumnExporter.$$$reportNull$$$0(3);
            }
            if (to == null) {
                DeColumnExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeColumnExporter.$$$reportNull$$$0(5);
            }
            super.lightExport(helper, to, from);
            to.dataType = from.getDasType().getSpecification();
            to.defaultValue = from.getDefault();
            to.grants.clear();
            if (helper.getContext().myGrantController != null) {
                to.grants.addAll(DasSchemaExporters.extractGrants(from, helper.getContext().myGrantController));
            }
            if (from.isNotNull()) {
                to.flags.add(DeColumn.Flag.NOT_NULL);
            }
            DbImplUtilCore.getModelHelper(from).exportLightExport(helper, to, from);
        }

        @Override
        @NotNull
        public DeColumn create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicTableColumn from) {
            if (helper == null) {
                DeColumnExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeColumnExporter.$$$reportNull$$$0(7);
            }
            return new DeColumn(DeColumnExporter.getName(helper, from), DeTable.STUB, helper.getModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeColumnExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyImpl";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeIndexExporter
    extends DeTableChildExporter<DeIndex, BasicIndex, BasicModIndex> {
        public DeIndexExporter() {
            super(DeIndex.class, BasicIndex.class, ObjectKind.INDEX);
        }

        @Override
        protected void applyImpl(@NotNull SchemaApplyHelper helper, @NotNull DeIndex from, @NotNull BasicModIndex to) {
            if (helper == null) {
                DeIndexExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeIndexExporter.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DeIndexExporter.$$$reportNull$$$0(2);
            }
            super.applyImpl(helper, from, to);
            ArrayList<String> cols2 = new ArrayList<String>();
            LinkedHashSet<String> revCols = new LinkedHashSet<String>();
            BasicMetaProperty<?, List<String>> colNamesProp = to.getMetaObject().getObjectProperty(BasicModColumniation.COL_NAMES);
            boolean canBeFunctional = colNamesProp != null && !colNamesProp.isAbstract();
            for (DeIndex.Item item : from.items) {
                BasicModElement col = helper.apply(item.column);
                Object name2 = this.getName(col, item.column);
                if (canBeFunctional && StringUtil.isNotEmpty((String)name2) && item.column != null && !item.column.isInTable() && item.column.getEditedBasic() == null) {
                    name2 = "\u001b" + (String)name2;
                }
                cols2.add((String)name2);
                if (item.sorting != DasIndex.Sorting.DESCENDING) continue;
                revCols.add((String)name2);
            }
            to.setColNames(cols2);
            to.setReverseColNames(revCols);
            to.setUnique(from.unique);
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeIndex to, @NotNull BasicIndex from) {
            if (helper == null) {
                DeIndexExporter.$$$reportNull$$$0(3);
            }
            if (to == null) {
                DeIndexExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeIndexExporter.$$$reportNull$$$0(5);
            }
            super.lightExport(helper, to, from);
            List<String> names2 = from.sanitizedColNames();
            for (DeColumn column2 : DeIndexExporter.getColumnsOrStubs(helper, to.table, from.getLikeTable(), names2)) {
                BasicTypedElement editedColumn = column2.getEditedBasic();
                to.items.add(new DeIndex.Item(column2, from.getColumnSorting(column2.name)));
            }
            to.unique = from.isUnique();
        }

        @Override
        @NotNull
        public DeIndex create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicIndex from) {
            if (helper == null) {
                DeIndexExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeIndexExporter.$$$reportNull$$$0(7);
            }
            return new DeIndex(DeIndexExporter.getName(helper, from), DeTable.STUB, helper.getModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeIndexExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyImpl";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeForeignKeyExporter
    extends DeTableChildExporter<DeForeignKey, BasicForeignKey, BasicModForeignKey> {
        public DeForeignKeyExporter() {
            super(DeForeignKey.class, BasicForeignKey.class, ObjectKind.FOREIGN_KEY);
        }

        @Override
        protected void applyImpl(@NotNull SchemaApplyHelper helper, @NotNull DeForeignKey from, @NotNull BasicModForeignKey to) {
            if (helper == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(2);
            }
            super.applyImpl(helper, from, to);
            BasicModElement target2 = helper.apply(from.target);
            BasicForeignKey origFk = (BasicForeignKey)from.unwrap();
            if (target2 != null || origFk == null || !this.getName(from.target).isEmpty() && !this.getName(from.target).equals(origFk.getRefTableName())) {
                BasicSchema schema2;
                BasicSchema basicSchema = schema2 = target2 == null ? null : target2.getSchema();
                String targetSchemaName = schema2 == to.getSchema() ? null : this.getName(schema2, from.target == null ? null : from.target.parent);
                String targetName = this.getName(target2, from.target);
                to.setRefTableRef(BasicParentReference.create(targetSchemaName, BasicNameReference.create(targetName, !targetName.isEmpty(), false, ObjectKind.NONE, target2 == null ? null : BasicPaths.getIdentity(target2))));
            } else {
                to.setRefTableRef(origFk.getRefTableRef());
                BasicMetaUtils.makeReferencePortable(to, BasicModForeignKey.REF_TABLE_REF);
            }
            ArrayList<String> cols2 = new ArrayList<String>();
            ArrayList<String> targets2 = new ArrayList<String>();
            for (DeForeignKey.Ref ref2 : from.refs) {
                BasicModElement col = helper.apply(ref2.ref);
                cols2.add(this.getName(col, ref2.ref));
                BasicModElement tCol = helper.apply(ref2.target);
                targets2.add(this.getName(tCol, ref2.target));
            }
            to.setColNames(cols2);
            to.setRefColNames(targets2);
            DbImplUtilCore.resolveKey(to, targets2);
            to.setDeferrable(from.deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
            to.setInitiallyDeferred(from.deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
            to.setOnUpdate(DbImplUtilCore.asCascadeRule(from.updateRule));
            to.setOnDelete(DbImplUtilCore.asCascadeRule(from.deleteRule));
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeForeignKey to, @NotNull BasicForeignKey from) {
            if (helper == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(3);
            }
            if (to == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(5);
            }
            super.lightExport(helper, to, from);
            BasicTable refTable = from.getRefTable();
            to.target = refTable == null || refTable.getKind() != ObjectKind.TABLE ? null : DeForeignKeyExporter.getTable(helper, refTable, true);
            to.deferrability = (DasForeignKey.Deferrability)((Object)ObjectUtils.chooseNotNull((Object)((Object)from.getDeferrability()), (Object)((Object)DasForeignKey.Deferrability.NOT_DEFERRABLE)));
            to.updateRule = (DasForeignKey.RuleAction)((Object)ObjectUtils.chooseNotNull((Object)((Object)from.getUpdateRule()), (Object)((Object)DasForeignKey.RuleAction.NO_ACTION)));
            to.deleteRule = (DasForeignKey.RuleAction)((Object)ObjectUtils.chooseNotNull((Object)((Object)from.getDeleteRule()), (Object)((Object)DasForeignKey.RuleAction.NO_ACTION)));
            List<DeColumn> refs = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, from.getLikeTable(), from.getColNames());
            List<DeColumn> targets2 = DeForeignKeyExporter.getColumnsOrStubs(helper, to.table, refTable, from.getRefColNames());
            int cnt = Math.max(refs.size(), targets2.size());
            for (int i2 = 0; i2 < cnt; ++i2) {
                DeColumn ref2 = i2 < refs.size() ? refs.get(i2) : null;
                DeColumn target2 = i2 < targets2.size() ? targets2.get(i2) : null;
                to.refs.add(new DeForeignKey.Ref(ref2, target2));
            }
        }

        @Override
        @NotNull
        public DeForeignKey create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicForeignKey from) {
            if (helper == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeForeignKeyExporter.$$$reportNull$$$0(7);
            }
            return new DeForeignKey(DeForeignKeyExporter.getName(helper, from), DeTable.STUB, helper.getModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeForeignKeyExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyImpl";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeTableKeyExporter
    extends DeTableChildExporter<DeTableKey, BasicKey, BasicModKey> {
        public DeTableKeyExporter() {
            super(DeTableKey.class, BasicKey.class, ObjectKind.KEY);
        }

        @Override
        public void applyImpl(@NotNull SchemaApplyHelper helper, @NotNull DeTableKey from, @NotNull BasicModKey to) {
            if (helper == null) {
                DeTableKeyExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DeTableKeyExporter.$$$reportNull$$$0(2);
            }
            super.applyImpl(helper, from, to);
            ArrayList<String> cols2 = new ArrayList<String>();
            for (DeColumn column2 : from.columns) {
                BasicModElement col = helper.apply(column2);
                cols2.add(this.getName(col, column2));
            }
            to.setColNames(cols2);
            to.setPrimary(from.isPrimary());
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeTableKey to, @NotNull BasicKey from) {
            if (helper == null) {
                DeTableKeyExporter.$$$reportNull$$$0(3);
            }
            if (to == null) {
                DeTableKeyExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(5);
            }
            super.lightExport(helper, to, from);
            if (from.isPrimary()) {
                DeTable table = to.table;
                if (table.keys.getPrimaryKey() != to) {
                    if (table.keys.getPrimaryKey() != null) {
                        this.myLogger.warn("Already have primary key");
                    }
                    table.keys.setPrimaryKey(to);
                }
            }
            to.columns.addAll(DeTableKeyExporter.getColumnsOrStubs(helper, to.table, from.getLikeTable(), from.getColNames()));
        }

        @Override
        @NotNull
        public DeTableKey create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicKey from) {
            if (helper == null) {
                DeTableKeyExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeTableKeyExporter.$$$reportNull$$$0(7);
            }
            return new DeTableKey(DeTableKeyExporter.getName(helper, from), DeTable.STUB, helper.getModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableKeyExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyImpl";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeNamespaceExporter
    extends DeObjectExporter<DeNamespace, BasicNamespace, BasicModNamespace> {
        public DeNamespaceExporter() {
            super(DeNamespace.class, BasicNamespace.class, null);
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeNamespace to, @NotNull BasicNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            BasicNamespace parent2 = (BasicNamespace)ObjectUtils.tryCast((Object)from.getParent(), BasicNamespace.class);
            if (parent2 instanceof BasicRoot) {
                parent2 = null;
            }
            to.parent = (DeNamespace)helper.export(parent2, false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        public boolean canExport(@NotNull BasicNamespace object) {
            if (object == null) {
                DeNamespaceExporter.$$$reportNull$$$0(3);
            }
            return super.canExport(object) && !(object instanceof BasicRoot);
        }

        @Override
        @NotNull
        public DeNamespace create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(5);
            }
            return new DeNamespace(DeNamespaceExporter.getName(helper, from), from.getKind(), helper.getModel());
        }

        @Override
        public void exportChildren(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeNamespace to, @NotNull BasicNamespace from) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(6);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(7);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(8);
            }
            for (BasicElement object : from.getDasChildren(null)) {
                if (!helper.canExport(object)) continue;
                to.children.add((DeObject)helper.export(object, true));
            }
        }

        @Override
        protected void applyImpl(@NotNull SchemaApplyHelper helper, @NotNull DeNamespace from, @NotNull BasicModNamespace to) {
            if (helper == null) {
                DeNamespaceExporter.$$$reportNull$$$0(9);
            }
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(10);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(11);
            }
            super.applyImpl(helper, from, to);
            BasicElement fromE = from.unwrap();
            if (fromE == null && from.parent != null) {
                fromE = from.parent.unwrap();
            }
            if (fromE != null) {
                DeNamespaceExporter.pullTypes(fromE, to);
            }
        }

        private static void pullTypes(@NotNull BasicElement from, @NotNull BasicModNamespace to) {
            if (from == null) {
                DeNamespaceExporter.$$$reportNull$$$0(12);
            }
            if (to == null) {
                DeNamespaceExporter.$$$reportNull$$$0(13);
            }
            Family<? extends BasicElement> fromFamily = from.familyOf(ObjectKind.OBJECT_TYPE);
            Family toFamily = to.familyOf(ObjectKind.OBJECT_TYPE);
            if (fromFamily == null || toFamily == null) {
                return;
            }
            ModelLightCopier.copyFamily(fromFamily, toFamily, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: 
                case 7: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeNamespaceExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canExport";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportChildren";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyImpl";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pullTypes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeRoutineExporter
    extends DeDumbExporter<DeRoutine, BasicRoutine, BasicModRoutine> {
        public DeRoutineExporter() {
            super(DeRoutine.class, BasicRoutine.class, ObjectKind.ROUTINE);
        }

        @Override
        @NotNull
        public DeRoutine create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicRoutine from) {
            if (helper == null) {
                DeRoutineExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeRoutineExporter.$$$reportNull$$$0(1);
            }
            return new DeRoutine(DeRoutineExporter.getName(helper, from), helper.getModel(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeRoutineExporter";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeArgumentExporter
    extends DeObjectExporter<DeArgument, BasicArgument, BasicModArgument> {
        public DeArgumentExporter() {
            super(DeArgument.class, BasicArgument.class, ObjectKind.ARGUMENT);
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeArgument to, @NotNull BasicArgument from) {
            if (helper == null) {
                DeArgumentExporter.$$$reportNull$$$0(0);
            }
            if (to == null) {
                DeArgumentExporter.$$$reportNull$$$0(1);
            }
            if (from == null) {
                DeArgumentExporter.$$$reportNull$$$0(2);
            }
            super.lightExport(helper, to, from);
            to.routine = (DeRoutine)helper.export(from.getParent(), false);
        }

        @Override
        @NotNull
        public DeArgument create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicArgument from) {
            if (helper == null) {
                DeArgumentExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeArgumentExporter.$$$reportNull$$$0(4);
            }
            return new DeArgument(DeArgumentExporter.getName(helper, from), helper.getModel(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeArgumentExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeViewExporter
    extends DeDumbExporter<DeView, BasicView, BasicModView> {
        public DeViewExporter() {
            super(DeView.class, BasicView.class, ObjectKind.VIEW);
        }

        @Override
        @NotNull
        public DeView create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicView from) {
            if (helper == null) {
                DeViewExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeViewExporter.$$$reportNull$$$0(1);
            }
            return new DeView(DeViewExporter.getName(helper, from), helper.getModel(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeViewExporter";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeMatViewExporter
    extends DeGenericExporter {
        public DeMatViewExporter() {
            super(ObjectKind.MAT_VIEW);
        }
    }

    protected static class DeObjectTypeExporter
    extends DeGenericExporter {
        public DeObjectTypeExporter() {
            super(ObjectKind.OBJECT_TYPE);
        }
    }

    protected static class DePackageExporter
    extends DeGenericExporter {
        public DePackageExporter() {
            super(ObjectKind.PACKAGE);
        }
    }

    protected static class DeBodyExporter
    extends DeGenericExporter {
        public DeBodyExporter() {
            super(ObjectKind.BODY);
        }
    }

    protected static class DeTriggerExporter
    extends DeDumbExporter<DeTrigger, BasicTrigger, BasicModTrigger> {
        public DeTriggerExporter() {
            super(DeTrigger.class, BasicTrigger.class, ObjectKind.TRIGGER);
        }

        @Override
        @NotNull
        public DeTrigger create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicTrigger from) {
            if (helper == null) {
                DeTriggerExporter.$$$reportNull$$$0(0);
            }
            if (from == null) {
                DeTriggerExporter.$$$reportNull$$$0(1);
            }
            return new DeTrigger(DeTriggerExporter.getName(helper, from), helper.getModel(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTriggerExporter";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class DeSequenceExporter
    extends DeGenericExporter {
        public DeSequenceExporter() {
            super(ObjectKind.SEQUENCE);
        }
    }

    protected static class DeGenericExporter
    extends DeObjectExporter<DeWrapperImpl<BasicElement>, BasicElement, BasicModElement> {
        public DeGenericExporter(@NotNull ObjectKind kindFilter) {
            if (kindFilter == null) {
                DeGenericExporter.$$$reportNull$$$0(0);
            }
            super(DeWrapperImpl.class, BasicElement.class, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeWrapperImpl<BasicElement> to, @NotNull BasicElement from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(1);
            }
            if (to == null) {
                DeGenericExporter.$$$reportNull$$$0(2);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(3);
            }
            super.lightExport(helper, to, from);
            to.parent = helper.export(from.getParent(), false);
            if (to.parent == null) {
                to.model.addRoot(to);
            }
        }

        @Override
        @NotNull
        public DeWrapperImpl<BasicElement> create(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicElement from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(4);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(5);
            }
            return new DeWrapperImpl<BasicElement>(DeGenericExporter.getName(helper, from), helper.getModel(), null);
        }

        @Override
        public void exportChildren(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeWrapperImpl<BasicElement> to, @NotNull BasicElement from) {
            if (helper == null) {
                DeGenericExporter.$$$reportNull$$$0(6);
            }
            if (to == null) {
                DeGenericExporter.$$$reportNull$$$0(7);
            }
            if (from == null) {
                DeGenericExporter.$$$reportNull$$$0(8);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindFilter";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeGenericExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class DeDumbExporter<De extends DeWrapper, Das extends BasicElement, MDas extends BasicModElement>
    extends DeObjectExporter<De, Das, MDas> {
        public DeDumbExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeDumbExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeDumbExporter.$$$reportNull$$$0(1);
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeDumbExporter.$$$reportNull$$$0(2);
            }
            if (to == null) {
                DeDumbExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeDumbExporter.$$$reportNull$$$0(4);
            }
            super.lightExport(helper, to, from);
            ((DeWrapper)to).parent = helper.export(from.getParent(), false);
            if (((DeWrapper)to).parent == null) {
                ((DeWrapper)to).model.addRoot((DeObject)to);
            }
        }

        @Override
        public void exportChildren(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeDumbExporter.$$$reportNull$$$0(5);
            }
            if (to == null) {
                DeDumbExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeDumbExporter.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeDumbExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lightExport";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exportChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class DeTableChildExporter<De extends DeTableChild, Das extends BasicElement, MDas extends BasicModElement>
    extends DeObjectExporter<De, Das, MDas> {
        public DeTableChildExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeTableChildExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeTableChildExporter.$$$reportNull$$$0(1);
            }
            super(exportedClass, exportableClass, kindFilter);
        }

        @NotNull
        public static DeTable getTable(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicTableOrView table, boolean withChildren) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(2);
            }
            if (table == null) {
                DeTableChildExporter.$$$reportNull$$$0(3);
            }
            DeTable deTable = (DeTable)helper.export(table, withChildren);
            if (deTable == null) {
                DeTableChildExporter.$$$reportNull$$$0(4);
            }
            return deTable;
        }

        @NotNull
        public DeTable getTable(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull Das object) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(5);
            }
            if (object == null) {
                DeTableChildExporter.$$$reportNull$$$0(6);
            }
            return DeTableChildExporter.getTable(helper, (BasicTableOrView)object.getParent(), true);
        }

        @NotNull
        public static List<DeColumn> getColumnsOrStubs(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeTable table, @Nullable BasicLikeTable owner, @NotNull List<String> names2) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(7);
            }
            if (table == null) {
                DeTableChildExporter.$$$reportNull$$$0(8);
            }
            if (names2 == null) {
                DeTableChildExporter.$$$reportNull$$$0(9);
            }
            ArrayList<DeColumn> res2 = new ArrayList<DeColumn>(names2.size());
            PositioningNamingFamily<? extends BasicLikeColumn> cols2 = owner == null ? null : owner.getColumns();
            for (String name2 : names2) {
                DeColumn column2 = cols2 == null ? null : (DeColumn)helper.export(cols2.get(name2), true);
                res2.add(EditorModelUtil.stubbize(column2, name2, table, table.model));
            }
            ArrayList<DeColumn> arrayList = res2;
            if (arrayList == null) {
                DeTableChildExporter.$$$reportNull$$$0(10);
            }
            return arrayList;
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                DeTableChildExporter.$$$reportNull$$$0(11);
            }
            return super.canExport(object) && object.getMetaObject().getParentKind(1) == ObjectKind.TABLE;
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeTableChildExporter.$$$reportNull$$$0(12);
            }
            if (to == null) {
                DeTableChildExporter.$$$reportNull$$$0(13);
            }
            if (from == null) {
                DeTableChildExporter.$$$reportNull$$$0(14);
            }
            super.lightExport(helper, to, from);
            ((DeTableChild)to).table = this.getTable(helper, from);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter";
                    break;
                }
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeTableChildExporter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTable";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsOrStubs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTable";
                    break;
                }
                case 4: 
                case 10: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnsOrStubs";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "canExport";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 10 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class DeObjectExporter<De extends DeObject, Das extends BasicElement, MDas extends BasicModElement>
    implements SchemaExporters.Exporter<De, Das> {
        protected final Logger myLogger;
        private final Class<De> myExportedClass;
        private final Class<Das> myExportableClass;
        private final ObjectKind myKindFilter;

        public DeObjectExporter(@NotNull Class<De> exportedClass, @NotNull Class<Das> exportableClass, @Nullable ObjectKind kindFilter) {
            if (exportedClass == null) {
                DeObjectExporter.$$$reportNull$$$0(0);
            }
            if (exportableClass == null) {
                DeObjectExporter.$$$reportNull$$$0(1);
            }
            this.myLogger = Logger.getInstance(this.getClass());
            this.myExportedClass = exportedClass;
            this.myExportableClass = exportableClass;
            this.myKindFilter = kindFilter;
        }

        protected ObjectKind getKind(@NotNull Das object) {
            if (object == null) {
                DeObjectExporter.$$$reportNull$$$0(2);
            }
            return object.getKind();
        }

        @Override
        public void apply(@NotNull SchemaApplyHelper helper, @NotNull De from, @NotNull Das to) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(3);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(4);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(5);
            }
            this.applyImpl(helper, from, (BasicModElement)to);
        }

        protected void applyImpl(@NotNull SchemaApplyHelper helper, @NotNull De from, @NotNull MDas to) {
            BasicModNamedElement named;
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(6);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(7);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(8);
            }
            if ((named = (BasicModNamedElement)ObjectUtils.tryCast(to, BasicModNamedElement.class)) != null) {
                BasicNamedElement edited = (BasicNamedElement)ObjectUtils.tryCast((Object)((DeObject)from).unwrap(), BasicNamedElement.class);
                NamingService namingService2 = helper.getContext().getNamingService();
                DeObjectExporter.setNameFromText(namingService2, named, edited, ((DeObject)from).name, true);
                named.setComment(((DeObject)from).comment);
            }
        }

        public static void setNameFromText(NamingService namingService2, BasicModNamedElement named, BasicNamedElement edited, String text2, boolean mixedIsQuoted) {
            boolean quoted = namingService2.isQuoted(text2);
            String name2 = namingService2.unquoteIdentifier(text2);
            boolean isSql = DasSchemaExporters.treatAsPlainIdentifier(name2, quoted, edited, mixedIsQuoted);
            named.setName(name2);
            named.setNameScripted(isSql);
            named.setNameSurrogate(DeObjectExporter.isNameSurrogate(named, quoted, edited));
            named.setNameQuoted(isSql && quoted);
        }

        public static boolean isNameSurrogate(@NotNull BasicModNamedElement named, boolean quoted, @Nullable BasicNamedElement edited) {
            if (named == null) {
                DeObjectExporter.$$$reportNull$$$0(9);
            }
            if (edited != null && named.getName().equals(edited.getName())) {
                return edited.isNameSurrogate();
            }
            return !quoted && StringUtil.isEmpty((String)named.getName());
        }

        @Override
        @NotNull
        public Class<De> getExportedClass() {
            Class<De> clazz = this.myExportedClass;
            if (clazz == null) {
                DeObjectExporter.$$$reportNull$$$0(10);
            }
            return clazz;
        }

        @Override
        @NotNull
        public Class<Das> getExportableClass() {
            Class<Das> clazz = this.myExportableClass;
            if (clazz == null) {
                DeObjectExporter.$$$reportNull$$$0(11);
            }
            return clazz;
        }

        @Override
        public int compareTo(SchemaExporters.Exporter<?, ?> o2) {
            return Integer.compare(System.identityHashCode(this), System.identityHashCode(o2));
        }

        @Override
        public boolean canExport(@NotNull Das object) {
            if (object == null) {
                DeObjectExporter.$$$reportNull$$$0(12);
            }
            return this.myKindFilter == null || this.myKindFilter == this.getKind(object);
        }

        @NotNull
        protected static String getName(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull BasicElement object) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(13);
            }
            if (object == null) {
                DeObjectExporter.$$$reportNull$$$0(14);
            }
            NamingService namingService2 = helper.getContext().getNamingService();
            return DeObjectExporter.getIdentifier(namingService2, object);
        }

        @NotNull
        public static String getIdentifier(NamingService namingService2, @NotNull BasicElement object) {
            if (object == null) {
                DeObjectExporter.$$$reportNull$$$0(15);
            }
            String name2 = object.getName();
            if (!DbSqlUtilCore.isSqlObject(object) || !DbSqlUtilCore.isQuoted(object)) {
                String string = name2;
                if (string == null) {
                    DeObjectExporter.$$$reportNull$$$0(16);
                }
                return string;
            }
            String string = namingService2.enquote(name2, object.getKind());
            if (string == null) {
                DeObjectExporter.$$$reportNull$$$0(17);
            }
            return string;
        }

        @NotNull
        protected String getName(@Nullable DeObject from) {
            if (from == null) {
                String string = DasUtil.NO_NAME;
                if (string == null) {
                    DeObjectExporter.$$$reportNull$$$0(18);
                }
                return string;
            }
            String string = from.model.getExportHelper().getContext().getNamingService().unquoteIdentifier(from.name);
            if (string == null) {
                DeObjectExporter.$$$reportNull$$$0(19);
            }
            return string;
        }

        @NotNull
        protected String getName(@Nullable BasicElement e2, @Nullable DeObject obj2) {
            if (e2 != null) {
                String string = DasUtil.getName(e2);
                if (string == null) {
                    DeObjectExporter.$$$reportNull$$$0(20);
                }
                return string;
            }
            String string = this.getName(obj2);
            if (string == null) {
                DeObjectExporter.$$$reportNull$$$0(21);
            }
            return string;
        }

        @Override
        public void lightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(22);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(23);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(24);
            }
            ((DeObject)to).comment = StringUtil.nullize((String)from.getComment());
            ((DeObject)to).setEditedObject((BasicElement)from);
        }

        @Override
        public void exportChildren(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull De to, @NotNull Das from) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(25);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(26);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(27);
            }
        }

        @Override
        public void applyChildren(@NotNull SchemaApplyHelper helper, @NotNull De from, @NotNull Das to) {
            if (helper == null) {
                DeObjectExporter.$$$reportNull$$$0(28);
            }
            if (from == null) {
                DeObjectExporter.$$$reportNull$$$0(29);
            }
            if (to == null) {
                DeObjectExporter.$$$reportNull$$$0(30);
            }
            if (DasUtil.getSchemaObject(to) != null) {
                for (DeObject child : ((DeObject)from).getDasChildren(null)) {
                    helper.apply(child);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 10, 11, 16, 17, 18, 19, 20, 21 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportedClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportableClass";
                    break;
                }
                case 2: 
                case 12: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: 
                case 6: 
                case 13: 
                case 22: 
                case 25: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "helper";
                    break;
                }
                case 4: 
                case 7: 
                case 24: 
                case 27: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
                case 5: 
                case 8: 
                case 23: 
                case 26: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "to";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "named";
                    break;
                }
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/schemaEditor/DasSchemaExporters$DeObjectExporter";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExportedClass";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExportableClass";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdentifier";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getKind";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "applyImpl";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isNameSurrogate";
                    break;
                }
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "canExport";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getIdentifier";
                    break;
                }
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "lightExport";
                    break;
                }
                case 25: 
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "exportChildren";
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "applyChildren";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 10, 11, 16, 17, 18, 19, 20, 21 -> new IllegalStateException(string);
            };
        }
    }
}

