/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.util.AsyncUtil;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/run/audit/CancelProgressAuditor;", "Lcom/intellij/database/datagrid/DataAuditor;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "(Lcom/intellij/database/console/session/DatabaseSession;)V", "requestCancelStarted", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "cancelRequest", "Lcom/intellij/database/datagrid/DataRequest$Cancel;", "Companion", "intellij.database.connectivity"})
public final class CancelProgressAuditor
implements DataAuditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseSession session;
    @JvmField
    @NotNull
    public static final Key<Boolean> SHOW_CANCEL_PROGRESS;

    public CancelProgressAuditor(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    @Override
    public void requestCancelStarted(@NotNull DataRequest.Context context, @Nullable DataRequest.Cancel cancelRequest) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        DataRequest.Cancel cancel2 = cancelRequest;
        if (!(cancel2 != null ? Intrinsics.areEqual((Object)cancel2.getUserData(SHOW_CANCEL_PROGRESS), (Object)true) : false)) {
            return;
        }
        AsyncPromise requestCancelFinishedPromise = CancelProgressAuditor.Companion.getRequestCancelFinishedPromise(context, cancelRequest);
        if (!requestCancelFinishedPromise.isDone()) {
            ScheduledFuture<?> cancelNotificationFeature = AppExecutorUtil.getAppScheduledExecutorService().schedule(CancelProgressAuditor.Companion.showTerminationNotification(this.session), 10L, TimeUnit.SECONDS);
            requestCancelFinishedPromise.onProcessed(arg_0 -> CancelProgressAuditor.requestCancelStarted$lambda$0((Function1)new Function1<Void, Unit>(cancelNotificationFeature){
                final /* synthetic */ ScheduledFuture<?> $cancelNotificationFeature;
                {
                    this.$cancelNotificationFeature = $cancelNotificationFeature;
                    super(1);
                }

                public final void invoke(@Nullable Void it2) {
                    this.$cancelNotificationFeature.cancel(true);
                }
            }, arg_0));
            ApplicationManager.getApplication().invokeLater(() -> CancelProgressAuditor.requestCancelStarted$lambda$2(requestCancelFinishedPromise, this));
        }
    }

    private static final void requestCancelStarted$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void requestCancelStarted$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void requestCancelStarted$lambda$2(AsyncPromise $requestCancelFinishedPromise, CancelProgressAuditor this$0) {
        Intrinsics.checkNotNullParameter((Object)$requestCancelFinishedPromise, (String)"$requestCancelFinishedPromise");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!$requestCancelFinishedPromise.isDone()) {
            LocalDataSource localDataSource = this$0.session.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource2 = localDataSource;
            Object[] objectArray = new Object[]{this$0.session.getDisplayName(), dataSource2.getName()};
            String string = DatabaseBundle.message("cancel.running.statements.progress.indicator.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            ProgressIndicatorEx indicator = AsyncUtil.createBackgroundIndicator(this$0.session.getProject(), title, false);
            $requestCancelFinishedPromise.onProcessed(arg_0 -> CancelProgressAuditor.requestCancelStarted$lambda$2$lambda$1((Function1)new Function1<Void, Unit>(indicator){
                final /* synthetic */ ProgressIndicatorEx $indicator;
                {
                    this.$indicator = $indicator;
                    super(1);
                }

                public final void invoke(@Nullable Void it2) {
                    this.$indicator.processFinish();
                }
            }, arg_0));
        }
    }

    static {
        Key key2 = Key.create((String)"SHOW_CANCEL_PROGRESS");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        SHOW_CANCEL_PROGRESS = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/run/audit/CancelProgressAuditor$Companion;", "", "()V", "SHOW_CANCEL_PROGRESS", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRequestCancelFinishedPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Ljava/lang/Void;", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "cancelRequest", "Lcom/intellij/database/datagrid/DataRequest$Cancel;", "showTerminationNotification", "Ljava/lang/Runnable;", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.connectivity"})
    public static final class Companion {
        private Companion() {
        }

        private final AsyncPromise<Void> getRequestCancelFinishedPromise(DataRequest.Context context, DataRequest.Cancel cancelRequest) {
            AsyncPromise res2 = new AsyncPromise();
            context.request.getPromise().onProcessed(arg_0 -> Companion.getRequestCancelFinishedPromise$lambda$0((Function1)new Function1<Void, Unit>((AsyncPromise<Void>)res2){
                final /* synthetic */ AsyncPromise<Void> $res;
                {
                    this.$res = $res;
                    super(1);
                }

                public final void invoke(@Nullable Void it2) {
                    this.$res.setResult((Object)it2);
                }
            }, arg_0));
            cancelRequest.getPromise().onError(arg_0 -> Companion.getRequestCancelFinishedPromise$lambda$1((Function1)new Function1<Throwable, Unit>((AsyncPromise<Void>)res2){
                final /* synthetic */ AsyncPromise<Void> $res;
                {
                    this.$res = $res;
                    super(1);
                }

                public final void invoke(@NotNull Throwable it2) {
                    Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                    this.$res.setError(it2);
                }
            }, arg_0));
            return res2;
        }

        private final Runnable showTerminationNotification(DatabaseSession session2) {
            Object[] objectArray = new Object[]{session2.getDisplayName(), session2.getConnectionPoint().getDataSource().getName()};
            String string = DatabaseBundle.message("deactivate.data.source.notification.title", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String string2 = DatabaseBundle.message("deactivate.data.source.notification.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String content = string2;
            return () -> Companion.showTerminationNotification$lambda$2(title, content, session2);
        }

        private static final void getRequestCancelFinishedPromise$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void getRequestCancelFinishedPromise$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void showTerminationNotification$lambda$2(String $title, String $content, DatabaseSession $session) {
            Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
            Intrinsics.checkNotNullParameter((Object)$content, (String)"$content");
            Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
            DatabaseNotifications.DATABASE_CANCEL_GROUP.createNotification($title, $content, NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter($session){
                final /* synthetic */ DatabaseSession $session;
                {
                    this.$session = $session;
                }

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e2) {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                    SessionsUtil.deactivateDataSourceAsync(this.$session);
                }
            }).setDisplayId("CancelProgressAuditor.too.long").notify($session.getProject());
            IdeUiService.getInstance().systemNotify($title, $content);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

