/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TxIsolation {
    DEFAULT("transaction.mode.database.default", "transaction.mode.database.default.description", -1),
    READ_UNCOMMITTED("transaction.mode.read.uncommitted", "transaction.mode.read.uncommitted.description", 1){

        @Override
        public boolean isSupported(@NotNull Dbms id, @Nullable DasObject table) {
            if (id == null) {
                1.$$$reportNull$$$0(0);
            }
            return !id.isOracle() && !id.isPostgres() && !id.isHsqldb() && !id.isVertica() && 1.availableIfSybase(id, table);
        }

        private static boolean availableIfSybase(@NotNull Dbms id, @Nullable DasObject table) {
            if (id == null) {
                1.$$$reportNull$$$0(1);
            }
            return !id.isSybase() || table == null || table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class).filter(i2 -> i2.isUnique()).first() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "id";
            objectArray2[1] = "com/intellij/database/run/actions/TxIsolation$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "availableIfSybase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
    ,
    READ_COMMITTED("transaction.mode.read.committed", "transaction.mode.read.committed.description", 2),
    REPEATABLE_READ("transaction.mode.repeatable.read", "transaction.mode.repeatable.read.description", 4){

        @Override
        public boolean isSupported(@NotNull Dbms id, @Nullable DasObject table) {
            if (id == null) {
                2.$$$reportNull$$$0(0);
            }
            return !id.isH2() && !id.isOracle() && !id.isHsqldb() && !id.isVertica();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/run/actions/TxIsolation$2", "isSupported"));
        }
    }
    ,
    SERIALIZABLE("transaction.mode.serializable", "transaction.mode.serializable.description", 8);

    private final int myIsolation;
    @PropertyKey(resourceBundle="messages.DatabaseBundle")
    private final @PropertyKey(resourceBundle="messages.DatabaseBundle") String myNameKey;
    @PropertyKey(resourceBundle="messages.DatabaseBundle")
    private final @PropertyKey(resourceBundle="messages.DatabaseBundle") String myDescriptionKey;

    private TxIsolation(String nameKey, String descriptionKey, int isolation) {
        if (nameKey == null) {
            TxIsolation.$$$reportNull$$$0(0);
        }
        if (descriptionKey == null) {
            TxIsolation.$$$reportNull$$$0(1);
        }
        this.myNameKey = nameKey;
        this.myDescriptionKey = descriptionKey;
        this.myIsolation = isolation;
    }

    @NotNull
    @NlsActions.ActionText
    public String getName() {
        String string = DatabaseBundle.message(this.myNameKey, new Object[0]);
        if (string == null) {
            TxIsolation.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsActions.ActionDescription
    public String getDescription() {
        String string = DatabaseBundle.message(this.myDescriptionKey, new Object[0]);
        if (string == null) {
            TxIsolation.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getIsolation() {
        return this.myIsolation;
    }

    public boolean isSupported(@NotNull Dbms id, @Nullable DasObject table) {
        if (id == null) {
            TxIsolation.$$$reportNull$$$0(4);
        }
        return true;
    }

    @NotNull
    public static TxIsolation of(int value2) {
        for (TxIsolation isolation : TxIsolation.values()) {
            if (isolation.myIsolation != value2) continue;
            TxIsolation txIsolation = isolation;
            if (txIsolation == null) {
                TxIsolation.$$$reportNull$$$0(5);
            }
            return txIsolation;
        }
        TxIsolation txIsolation = DEFAULT;
        if (txIsolation == null) {
            TxIsolation.$$$reportNull$$$0(6);
        }
        return txIsolation;
    }

    public static boolean levelsSupported(@NotNull Dbms id) {
        if (id == null) {
            TxIsolation.$$$reportNull$$$0(7);
        }
        return ArrayUtil.contains((Object)id, (Object[])new Dbms[]{Dbms.ORACLE, Dbms.MYSQL, Dbms.MYSQL_AURORA, Dbms.MARIA, Dbms.MEMSQL, Dbms.POSTGRES, Dbms.MSSQL, Dbms.MSSQL_LOCALDB, Dbms.AZURE, Dbms.SYBASE, Dbms.DB2_LUW, Dbms.DB2_IS, Dbms.DB2_ZOS, Dbms.DB2, Dbms.HSQL, Dbms.H2, Dbms.DERBY, Dbms.VERTICA});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionKey";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/TxIsolation";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/TxIsolation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "levelsSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

