/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.PerformActionBase;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.run.actions.RoutineExecutionHelper;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DetailsSyncHelper;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.ui.PerformRoutineScriptDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerformRoutineActionBase
extends PerformActionBase {
    private final Supplier<@NlsActions.ActionText String> myProcedureText;
    private final Supplier<@NlsActions.ActionText String> myFunctionText;

    protected PerformRoutineActionBase(@NotNull Supplier<@NlsActions.ActionText String> procedureText, @NotNull Supplier<@NlsActions.ActionText String> functionText) {
        if (procedureText == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(0);
        }
        if (functionText == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(1);
        }
        this.myProcedureText = procedureText;
        this.myFunctionText = functionText;
    }

    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(2);
        }
        Presentation presentation = e2.getPresentation();
        ActionData actionData = this.getActionData(e2);
        boolean available = actionData != null && this.isAvailable(actionData);
        presentation.setEnabledAndVisible(available);
        if (available) {
            BasicRoutine routine2 = actionData.routine;
            presentation.setText(this.getText(routine2));
            Icon icon = this.getIcon(e2, routine2);
            if (icon != null) {
                presentation.setIcon(icon);
            }
        }
    }

    @Nullable
    protected Icon getIcon(@NotNull AnActionEvent e2, @Nullable BasicRoutine routine2) {
        if (e2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NlsActions.ActionText
    protected String getText(@Nullable BasicRoutine routine2) {
        DasRoutine.Kind kind;
        DasRoutine.Kind kind2 = kind = routine2 != null ? routine2.getRoutineKind() : null;
        if (kind == DasRoutine.Kind.PROCEDURE) {
            return this.myProcedureText.get();
        }
        if (kind == DasRoutine.Kind.FUNCTION) {
            return this.myFunctionText.get();
        }
        return this.getTemplatePresentation().getText();
    }

    @Nullable
    protected static DbRoutine getDbRoutine(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(4);
        }
        return (DbRoutine)DatabaseContextFun.getSelectedDbElements(e2.getDataContext(), DbRoutine.class).single();
    }

    protected boolean isAvailable(@NotNull ActionData data) {
        if (data == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(5);
        }
        return RoutineExecutionHelper.EP.forDbms(data.dataSource.getDbms()) != null;
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        ActionData data;
        if (e2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(6);
        }
        if ((data = this.getActionData(e2)) == null) {
            return;
        }
        if (DetailsSyncHelper.of(data.dataSource, ScriptCategory.EXECUTE).check(data.routine).askAbortIfSyncRequired(e2.getPresentation().getText())) {
            return;
        }
        DbDataSource dataSource2 = data.dataSource;
        RoutineExecutionHelper provider = RoutineExecutionHelper.EP.forDbms(dataSource2.getDbms());
        if (provider == null) {
            return;
        }
        PerformRoutineActionBase.perform(data, this.getRunner(data), true);
    }

    @Nullable
    protected abstract ActionData getActionData(@NotNull AnActionEvent var1);

    @NotNull
    protected RequestRunner getRunner(@NotNull ActionData actionData) {
        if (actionData == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(7);
        }
        return new ExecuteRequestRunner();
    }

    public static void perform(@NotNull ActionData data, @NotNull RequestRunner runner, boolean showPreviewDialog) {
        if (data == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(8);
        }
        if (runner == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(9);
        }
        DbDataSource dataSource2 = data.dataSource;
        BasicRoutine routine2 = data.routine;
        RoutineExecutionHelper provider = RoutineExecutionHelper.EP.forDbms(dataSource2.getDbms());
        if (provider == null) {
            return;
        }
        LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource(dataSource2);
        DasNamespace searchPathObject = DbImplUtilCore.getSearchPathObjectForSwitch(dataSource2, (DasObject)routine2);
        SearchPath path = ObjectPaths.searchPathOf(searchPathObject);
        Project project = dataSource2.getProject();
        BasicModel model2 = Objects.requireNonNull(routine2.getModel());
        ScriptingSingleModelTask task = PerformRoutineActionBase.makeTask(routine2, model2, path, localDataSource, dataSource2);
        String script2 = StringUtil.join((String[])ScriptGenerators.INSTANCE.makeScript(project, task).getScriptStatementsTexts(), (String)";\n");
        JdbcConsole forcedOwner = null;
        if (showPreviewDialog) {
            List<JdbcConsole> owners = PerformRoutineActionBase.getRelevantOwners(project, localDataSource);
            ScriptInfo scriptInfo = PerformRoutineActionBase.showExecuteRoutineScriptDialog(dataSource2, script2, DatabaseBundle.message("dialog.title.execute.routine", new Object[0]), path, owners);
            if (scriptInfo == null) {
                return;
            }
            script2 = scriptInfo.statement;
            forcedOwner = scriptInfo.forcedOwner;
        }
        if (StringUtil.isEmptyOrSpaces((String)script2)) {
            return;
        }
        String finalScript = script2;
        PerformRoutineActionBase.withOwner(data, forcedOwner, (Consumer<OwnerInfo>)((Consumer)ownerInfo -> {
            GridDataRequest request2 = provider.makeRequest(project, localDataSource, ownerInfo.owner, finalScript, routine2, path);
            if (request2 == null) {
                ownerInfo.disposeIfNeeded();
                return;
            }
            request2.getPromise().onProcessed(__ -> ownerInfo.disposeIfNeeded());
            runner.runRequest(ownerInfo.owner, request2);
        }));
    }

    @NotNull
    private static List<JdbcConsole> getRelevantOwners(@NotNull Project project, @NotNull LocalDataSource localDataSource) {
        if (project == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(10);
        }
        if (localDataSource == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(11);
        }
        ArrayList<JdbcConsole> result2 = new ArrayList<JdbcConsole>();
        List<DatabaseSession> sessions2 = DatabaseSessionManager.getSessions(project, localDataSource);
        for (DatabaseSession session2 : sessions2) {
            for (DatabaseSessionClientWithFile client : session2.getClientsWithFile()) {
                if (!(client instanceof JdbcConsole) || DbSrcUtilsCore.isDbSrcFile(client.getVirtualFile())) continue;
                result2.add((JdbcConsole)client);
            }
        }
        ArrayList<JdbcConsole> arrayList = result2;
        if (arrayList == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void withOwner(@NotNull ActionData data, @Nullable JdbcConsole forcedOwner, @NotNull Consumer<OwnerInfo> runWithOwner) {
        DataRequest.OwnerEx owner;
        if (data == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(13);
        }
        if (runWithOwner == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(14);
        }
        DataRequest.OwnerEx ownerEx = owner = forcedOwner != null ? forcedOwner : data.owner();
        if (owner != null) {
            runWithOwner.consume((Object)new OwnerInfo(owner, false));
            return;
        }
        DbDataSource dataSource2 = data.dataSource;
        @Nls String title = data.routine.getName();
        Consumer<? super DatabaseSession> runInSession = data.runInSession(runWithOwner);
        DatabaseRunners.runInDataSource(dataSource2, title, runInSession);
    }

    @NotNull
    private static ScriptingSingleModelTask makeTask(@NotNull BasicRoutine routine2, @NotNull BasicModel model2, @Nullable SearchPath searchPath, @NotNull LocalDataSource localDataSource, @NotNull DbDataSource dataSource2) {
        if (routine2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(15);
        }
        if (model2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(16);
        }
        if (localDataSource == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(17);
        }
        if (dataSource2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(18);
        }
        ScriptingSingleModelTaskBuilder taskBuilder = new ScriptingSingleModelTaskBuilder(model2, ScriptCategory.EXECUTE);
        ObjectPath path = searchPath == null ? null : searchPath.getCurrent();
        ObjectPath databasePath = path == null ? null : path.findParent(ObjectKind.DATABASE, false);
        ObjectPath schemaPath = path == null ? null : path.findParent(ObjectKind.SCHEMA, false);
        BasicDatabase database = databasePath == null ? null : (BasicDatabase)DbSqlUtilCore.findObjects(dataSource2, databasePath).filter(BasicDatabase.class).first();
        BasicSchema schema2 = schemaPath == null ? null : (BasicSchema)DbSqlUtilCore.findObjects(dataSource2, schemaPath).filter(BasicSchema.class).first();
        taskBuilder.setCurrentSchema(schema2);
        taskBuilder.setCurrentDatabase(database);
        taskBuilder.setVersion(localDataSource.getVersion());
        taskBuilder.setElements(Collections.singletonList(routine2));
        taskBuilder.setOptions(new CustomScriptingOptions(ContainerUtil.map2Map(Collections.singletonList(Pair.create(ScriptingOptionStatic.CALL, (Object)true)))));
        ScriptingSingleModelTask scriptingSingleModelTask = taskBuilder.build();
        if (scriptingSingleModelTask == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(19);
        }
        return scriptingSingleModelTask;
    }

    @Nullable
    protected static ScriptInfo showExecuteRoutineScriptDialog(@NotNull DbDataSource dataSource2, @NotNull String script2, @NlsContexts.DialogTitle @NotNull String title, @Nullable SearchPath path, @NotNull List<JdbcConsole> owners) {
        PerformRoutineScriptDialog scriptDialog;
        if (dataSource2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(20);
        }
        if (script2 == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(21);
        }
        if (title == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(22);
        }
        if (owners == null) {
            PerformRoutineActionBase.$$$reportNull$$$0(23);
        }
        return (scriptDialog = new PerformRoutineScriptDialog(dataSource2.getProject(), dataSource2, path, title, "", script2, ContainerUtil.emptyList(), owners)).showAndGet() ? new ScriptInfo(scriptDialog.getStatement(), scriptDialog.getForcedOwner()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedureText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/PerformRoutineActionBase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runWithOwner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/PerformRoutineActionBase";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantOwners";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "makeTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDbRoutine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRelevantOwners";
                break;
            }
            case 12: 
            case 19: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withOwner";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "makeTask";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showExecuteRoutineScriptDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 19 -> new IllegalStateException(string);
        };
    }

    public static abstract class ActionData {
        public final DbDataSource dataSource;
        public final BasicRoutine routine;

        protected ActionData(@NotNull DbDataSource dataSource2, @NotNull BasicRoutine routine2) {
            if (dataSource2 == null) {
                ActionData.$$$reportNull$$$0(0);
            }
            if (routine2 == null) {
                ActionData.$$$reportNull$$$0(1);
            }
            this.dataSource = dataSource2;
            this.routine = routine2;
        }

        @Nullable
        public abstract DataRequest.OwnerEx owner();

        @NotNull
        public abstract Consumer<? super DatabaseSession> runInSession(@NotNull Consumer<OwnerInfo> var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "routine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/PerformRoutineActionBase$ActionData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RequestRunner {
        public void runRequest(@NotNull DataRequest.OwnerEx var1, @NotNull GridDataRequest var2);
    }

    private static class ExecuteRequestRunner
    implements RequestRunner {
        private ExecuteRequestRunner() {
        }

        @Override
        public void runRequest(@NotNull DataRequest.OwnerEx owner, @NotNull GridDataRequest request2) {
            if (owner == null) {
                ExecuteRequestRunner.$$$reportNull$$$0(0);
            }
            if (request2 == null) {
                ExecuteRequestRunner.$$$reportNull$$$0(1);
            }
            owner.getMessageBus().getDataProducer().processRequest(request2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "request";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/PerformRoutineActionBase$ExecuteRequestRunner";
            objectArray[2] = "runRequest";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ScriptInfo {
        public final String statement;
        public final JdbcConsole forcedOwner;

        ScriptInfo(@NotNull String statement2, @Nullable JdbcConsole forcedOwner) {
            if (statement2 == null) {
                ScriptInfo.$$$reportNull$$$0(0);
            }
            this.statement = statement2;
            this.forcedOwner = forcedOwner;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/run/actions/PerformRoutineActionBase$ScriptInfo", "<init>"));
        }
    }

    public static class OwnerInfo {
        public final DataRequest.OwnerEx owner;
        public final boolean temporary;

        public OwnerInfo(@NotNull DataRequest.OwnerEx owner, boolean temporary) {
            if (owner == null) {
                OwnerInfo.$$$reportNull$$$0(0);
            }
            this.owner = owner;
            this.temporary = temporary;
        }

        public void disposeIfNeeded() {
            if (this.temporary) {
                Disposer.dispose((Disposable)this.owner);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/run/actions/PerformRoutineActionBase$OwnerInfo", "<init>"));
        }
    }

    protected static class PerformActionData
    extends ActionData {
        PerformActionData(@NotNull DbDataSource dataSource2, @NotNull BasicRoutine routine2) {
            if (dataSource2 == null) {
                PerformActionData.$$$reportNull$$$0(0);
            }
            if (routine2 == null) {
                PerformActionData.$$$reportNull$$$0(1);
            }
            super(dataSource2, routine2);
        }

        @Override
        @Nullable
        public DataRequest.OwnerEx owner() {
            return null;
        }

        @Override
        @NotNull
        public Consumer<? super DatabaseSession> runInSession(@NotNull Consumer<OwnerInfo> runWithOwner) {
            if (runWithOwner == null) {
                PerformActionData.$$$reportNull$$$0(2);
            }
            Consumer consumer2 = session2 -> {
                BasicRoutine routine2 = Objects.requireNonNull(this.routine);
                DbDataSource dataSource2 = Objects.requireNonNull(this.dataSource);
                LocalDataSource localDataSource = DbImplUtilCore.getLocalDataSource(dataSource2);
                Project project = dataSource2.getProject();
                SearchPath searchPath = SearchPath.of(ObjectPaths.of(routine2));
                DGDepartment.RoutineRunner dep = new DGDepartment.RoutineRunner(routine2);
                DatabaseSessionManager.Facade facade = DatabaseSessionManager.getFacade(project, localDataSource, null, searchPath, false, null, dep);
                VisibleDatabaseSessionClient client = facade.client((DatabaseSession)session2);
                ScriptingClientDataConsumer.install(project, client);
                runWithOwner.consume((Object)new OwnerInfo(client, true));
            };
            if (consumer2 == null) {
                PerformActionData.$$$reportNull$$$0(3);
            }
            return consumer2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "routine";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runWithOwner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/PerformRoutineActionBase$PerformActionData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/PerformRoutineActionBase$PerformActionData";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runInSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runInSession";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

