/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasObjectFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.DasSchemaExporters;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.database.view.RenameQueryGenerator;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.SqlPreviewComponent;
import com.intellij.database.view.ui.SqlPreviewPanel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.sql.psi.SqlElement;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageView;
import com.intellij.util.Function;
import com.intellij.util.MergeQuery;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbRenamePsiElementProcessor
extends RenamePsiElementProcessor {
    private static final String SEARCH_FOR_STORAGE_OCCURRENCES = "sql.rename.search.for.storage.occurrences";
    private static Function<? super String, AsyncTask<Void>> ourRunStatementsHook = null;

    @TestOnly
    public static void setRunStatementsHook(Function<? super String, AsyncTask<Void>> runStatementsHook) {
        ourRunStatementsHook = runStatementsHook;
    }

    public boolean canProcessElement(@NotNull PsiElement element2) {
        DbElement dbElement;
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        if ((dbElement = DbRenamePsiElementProcessor.getDbElement(element2)) == null) {
            return false;
        }
        if (DbSqlUtil.isSqlElement(dbElement)) {
            return true;
        }
        LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource(dbElement.getDataSource());
        BaseModel model2 = dataSource2 == null ? null : (BaseModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BaseModel.class);
        BasicNamedElement e2 = (BasicNamedElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicNamedElement.class);
        return e2 != null && model2 != null && RenameQueryGenerator.canRename(model2, e2);
    }

    @Nullable
    public static DbElement getDbElement(@Nullable PsiElement element2) {
        DbElement dbElement = (DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class);
        if (dbElement == null) {
            dbElement = (DbElement)JBIterable.from(DbNavigationUtils.unwrapElements(element2)).filter(DbElement.class).first();
        }
        return dbElement;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element2, PsiElement nameSuggestionContext, Editor editor2) {
        DbElement dbElement;
        if (project == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        if ((dbElement = DbRenamePsiElementProcessor.getDbElement(element2)) == null) {
            RenameDialog renameDialog = super.createRenameDialog(project, element2, nameSuggestionContext, editor2);
            if (renameDialog == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(3);
            }
            return renameDialog;
        }
        LocalDataSource dataSource2 = DbImplUtil.getMaybeLocalDataSource(dbElement.getDataSource());
        BasicNamedElement target2 = (BasicNamedElement)ObjectUtils.tryCast((Object)dbElement.getDelegate(), BasicNamedElement.class);
        if (dataSource2 == null || target2 == null) {
            RenameDialog renameDialog = super.createRenameDialog(project, element2, nameSuggestionContext, editor2);
            if (renameDialog == null) {
                DbRenamePsiElementProcessor.$$$reportNull$$$0(4);
            }
            return renameDialog;
        }
        return new DbRenameDialog(project, dataSource2, dbElement, nameSuggestionContext, editor2);
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor2) {
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        return DbRenamePsiElementProcessor.getDbElement(element2);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        final boolean checkStorage = DbRenamePsiElementProcessor.getSearchReferencesInStorage(element2.getProject());
        final String prefix = DbRenamePsiElementProcessor.getDbFsPrefix(element2);
        DbElement dbElement = (DbElement)element2;
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource(dbElement.getDataSource());
        final String objectSrc = ds == null ? null : DbSrcUtils.getPath(dbElement.getProject(), ds, dbElement, ds.getModel(), DbSrcFileSystemCore.ItemType.SRC);
        Object scope = searchScope instanceof GlobalSearchScope ? new DelegatingGlobalSearchScope((GlobalSearchScope)searchScope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DbSrcUtilsCore.isDbSrcFile(file)) {
                    if (!checkStorage) {
                        return false;
                    }
                    if (DbSrcUtils.isOriginal(file)) {
                        return false;
                    }
                    String path = file.getPath();
                    if (!path.startsWith(prefix) || path.equals(objectSrc)) {
                        return false;
                    }
                }
                return super.contains(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/psi/DbRenamePsiElementProcessor$1", "contains"));
            }
        } : searchScope;
        Query query = ReferencesSearch.search((PsiElement)element2, (SearchScope)scope);
        PsiElement sqlElement = (PsiElement)ObjectUtils.tryCast((Object)DbSqlUtil.getSqlSourceElement(dbElement), PsiElement.class);
        if (sqlElement != null) {
            query = new MergeQuery(query, ReferencesSearch.search((PsiElement)sqlElement));
        }
        Collection collection2 = query.findAll();
        if (collection2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        return collection2;
    }

    private static String getDbFsPrefix(PsiElement element2) {
        DbElement e2 = (DbElement)ObjectUtils.tryCast((Object)element2, DbElement.class);
        String id = e2 == null ? null : e2.getDataSource().getUniqueId();
        return DbSrcFileSystem.getDataSourcePath(element2.getProject(), id) + "/";
    }

    @NotNull
    public static JBIterable<Pair<PsiElement, String>> collectRenameElements(@NotNull DeModel model2, @Nullable DbDataSource dataSource2) {
        if (model2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        JBIterable jBIterable = DbRenamePsiElementProcessor.collectRenames(model2).filterMap(de -> {
            BasicElement object = de.unwrap();
            SqlElement sqlElement = GenericEditingResultProcessor.getSqlElement(object, model2.getExportHelper().getContext());
            if (sqlElement != null) {
                return Pair.create((Object)sqlElement, (Object)de.name);
            }
            DbElement dbElement = DbImplUtilCore.findElement(dataSource2, object);
            return dbElement == null ? null : Pair.create((Object)dbElement, (Object)de.name);
        });
        if (jBIterable == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    public static boolean getSearchReferencesInStorage(Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(SEARCH_FOR_STORAGE_OCCURRENCES, false);
    }

    public static void setSearchReferencesInStorage(Project project, boolean val) {
        PropertiesComponent.getInstance((Project)project).setValue(SEARCH_FOR_STORAGE_OCCURRENCES, val, false);
    }

    @NotNull
    public static NonFocusableCheckBox createDbSrcSearchBox(Project project) {
        NonFocusableCheckBox box = new NonFocusableCheckBox(DatabaseBundle.message("search.in.loaded.sources", new Object[0]));
        box.setSelected(DbRenamePsiElementProcessor.getSearchReferencesInStorage(project));
        NonFocusableCheckBox nonFocusableCheckBox = box;
        if (nonFocusableCheckBox == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(11);
        }
        return nonFocusableCheckBox;
    }

    @NotNull
    public static JBIterable<DeObject> collectRenames(@NotNull DeModel model2) {
        if (model2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = model2.traverser().traverse().filter(object -> object.hasEdited() && !DbRenamePsiElementProcessor.nameEqual(object, object.getPrevName(), model2));
        if (jBIterable == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    public static <C extends DeObject> Condition<C> byName(@Nullable String name2) {
        return DbRenamePsiElementProcessor.byName(name2, DasUtil.NO_CASING_PROVIDER);
    }

    @NotNull
    public static <C extends DeObject> Condition<C> byName(@Nullable String name2, @NotNull CasingProvider casing) {
        if (casing == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(14);
        }
        Condition condition2 = name2 == null ? Conditions.alwaysFalse() : object -> DbRenamePsiElementProcessor.nameEqual(object, name2, casing);
        if (condition2 == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(15);
        }
        return condition2;
    }

    public static boolean nameEqual(@Nullable DeObject obj2, @Nullable String name2, @NotNull CasingProvider casing) {
        if (casing == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(16);
        }
        return DbRenamePsiElementProcessor.nameEqual(obj2, name2, casing.getCasing(obj2 == null ? ObjectKind.NONE : obj2.getKind(), obj2 == null ? null : obj2.unwrap()));
    }

    public static boolean nameEqual(@Nullable DeObject obj2, @Nullable String name2, @NotNull Casing casing) {
        if (casing == null) {
            DbRenamePsiElementProcessor.$$$reportNull$$$0(17);
        }
        return obj2 != null && DasUtil.equal(obj2.getName(), name2, casing);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 10, 11, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenameElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDbSrcSearchBox";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRenames";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "byName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectRenameElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectRenames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "byName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "nameEqual";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 10, 11, 13, 15 -> new IllegalStateException(string);
        };
    }

    public static class DbRenameDialog
    extends RenameDialog {
        private final LocalDataSource myDataSource;
        private RenameQueryGenerator myRenameGenerator;
        private SqlPreviewPanel myDdlPreview;
        private JCheckBox myRenameInStorage;

        public DbRenameDialog(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull DbElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor2) {
            if (project == null) {
                DbRenameDialog.$$$reportNull$$$0(0);
            }
            if (dataSource2 == null) {
                DbRenameDialog.$$$reportNull$$$0(1);
            }
            if (psiElement == null) {
                DbRenameDialog.$$$reportNull$$$0(2);
            }
            super(project, (PsiElement)psiElement, nameSuggestionContext, editor2);
            this.myDataSource = dataSource2;
        }

        @Nullable
        private BasicNamespace getCurrentNamespace() {
            return (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObjectForSwitch(this.getPsiElement().getDataSource(), (DasObject)this.getBasicElement().getParent()), BasicNamespace.class);
        }

        @NotNull
        private BasicNamedElement getBasicElement() {
            BasicNamedElement basicNamedElement = (BasicNamedElement)this.getPsiElement().getDelegate();
            if (basicNamedElement == null) {
                DbRenameDialog.$$$reportNull$$$0(3);
            }
            return basicNamedElement;
        }

        @NotNull
        public DbElement getPsiElement() {
            DbElement dbElement = (DbElement)super.getPsiElement();
            if (dbElement == null) {
                DbRenameDialog.$$$reportNull$$$0(4);
            }
            return dbElement;
        }

        protected boolean areButtonsValid() {
            return true;
        }

        protected void createCheckboxes(JPanel panel2, GridBagConstraints gbConstraints) {
            gbConstraints.insets = JBUI.insetsBottom((int)4);
            gbConstraints.gridwidth = 1;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            this.myRenameInStorage = DbRenamePsiElementProcessor.createDbSrcSearchBox(this.getProject());
            panel2.add((Component)this.myRenameInStorage, gbConstraints);
            super.createCheckboxes(panel2, gbConstraints);
        }

        protected void doAction() {
            DbRenamePsiElementProcessor.setSearchReferencesInStorage(this.getProject(), this.myRenameInStorage.isSelected());
            super.doAction();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            BasicNamedElement element2 = this.getBasicElement();
            this.myRenameGenerator = new RenameQueryGenerator(this.getProject(), Objects.requireNonNull(element2.getModel()), element2);
            this.myRenameGenerator.setCurrentNamespace(this.getCurrentNamespace());
            this.myDdlPreview = new SqlPreviewPanel("DbRenameDialog", new SqlPreviewComponent(this.getProject(), this.getPsiElement().getDataSource(), this.getSearchPath(), this.generateQuery(this.getNewName()), false, () -> this.close(1)){

                @Override
                @NotNull
                public List<AnAction> createActions(@NotNull DasDataSource delegate) {
                    if (delegate == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    List<AnAction> res2 = super.createActions(delegate);
                    res2.add(0, DatabaseScriptDialog.createSettingsPopupAction(() -> myRenameGenerator.createTask(null), o2 -> {
                        myRenameGenerator.setOptions((ScriptingOptions)o2);
                        this.regenerateQuery(myRenameGenerator.getTargetElement().getName());
                    }));
                    List<AnAction> list = res2;
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "delegate";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createActions";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            return this.myDdlPreview;
        }

        @Nullable
        private SearchPath getSearchPath() {
            return ObjectPaths.searchPathOf(this.getCurrentNamespace());
        }

        @NotNull
        private String generateQuery(@NotNull String name2) {
            BasicDatabase database;
            BasicElement element2;
            BasicModel model2;
            Dbms dbms;
            NamingService service;
            boolean quoted;
            if (name2 == null) {
                DbRenameDialog.$$$reportNull$$$0(5);
            }
            if (quoted = (service = NamingServices.getNamingService(dbms = DbImplUtilCore.getDbms(this.getPsiElement()), model2 = (element2 = DbImplUtilCore.getMaybeBasicElement(this.getPsiElement())) == null ? null : element2.getModel(), database = element2 == null ? null : element2.getDatabase())).isQuoted(name2)) {
                name2 = service.unquoteIdentifier(name2);
            }
            this.myRenameGenerator.setQuoted(quoted);
            this.myRenameGenerator.setScripted(DasSchemaExporters.treatAsPlainIdentifier(name2, quoted, (BasicNamedElement)ObjectUtils.tryCast((Object)element2, BasicModNamedElement.class), true));
            String string = this.myRenameGenerator.generate(name2).getScriptText();
            if (string == null) {
                DbRenameDialog.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getCanonicalName();
        }

        protected void processNewNameChanged() {
            this.updateName(this.getNewName());
            super.processNewNameChanged();
        }

        private void updateName(String name2) {
            if (this.myDdlPreview != null && this.myRenameGenerator != null && !Objects.equals(this.myRenameGenerator.getTargetElement().getName(), name2)) {
                this.regenerateQuery(name2);
            }
        }

        private void regenerateQuery(String name2) {
            String query = this.generateQuery(name2);
            boolean undo = UndoManager.getInstance((Project)this.getProject()).isUndoInProgress();
            if (!undo) {
                this.myDdlPreview.getPreviewComponent().setQuery(query);
            } else {
                ApplicationManager.getApplication().invokeLater(() -> this.myDdlPreview.getPreviewComponent().setQuery(query));
            }
        }

        protected void canRun() throws ConfigurationException {
            if (this.myRenameGenerator == null || !this.myRenameGenerator.isRenamed()) {
                throw new ConfigurationException(DatabaseBundle.message("dialog.message.nothing.to.rename", new Object[0]));
            }
            super.canRun();
        }

        protected RenameProcessor createRenameProcessor(@NotNull String newName) {
            if (newName == null) {
                DbRenameDialog.$$$reportNull$$$0(7);
            }
            this.updateName(newName);
            DatabaseRefactoringHandler handler2 = this.createHandler();
            return new MyRenameProcessor(this.getProject(), this.getPsiElement(), handler2, newName, null, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles());
        }

        private DatabaseRefactoringHandler createHandler() {
            DbElement element2 = this.getPsiElement();
            DatabaseRefactoringHandler handler2 = new DatabaseRefactoringHandler(element2.getProject(), this.myDataSource, this.getSearchPath()).setStatement(this.myDdlPreview.getPreviewComponent().getQuery());
            handler2.include(DasObjectFun.getBasicElement(element2));
            return handler2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$DbRenameDialog";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBasicElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generateQuery";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createRenameProcessor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class MyRenameProcessor
    extends RenameProcessor {
        private final DatabaseRefactoringHandler myHandler;
        private boolean myExecuteSql;
        private VirtualFile myExcludedFile;
        private AsyncTask<?> myAsyncStarted;

        public MyRenameProcessor(@NotNull Project project, @NotNull PsiElement element2, @NotNull DatabaseRefactoringHandler handler2, @NotNull String newName, @Nullable Iterable<Pair<PsiElement, String>> secondaryRenames, @NotNull SearchScope refactoringScope, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            DasObject parent2;
            if (project == null) {
                MyRenameProcessor.$$$reportNull$$$0(0);
            }
            if (element2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(1);
            }
            if (handler2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(2);
            }
            if (newName == null) {
                MyRenameProcessor.$$$reportNull$$$0(3);
            }
            if (refactoringScope == null) {
                MyRenameProcessor.$$$reportNull$$$0(4);
            }
            super(project, element2, newName, refactoringScope, isSearchInComments, isSearchTextOccurrences);
            this.myExecuteSql = true;
            this.myHandler = handler2;
            if (secondaryRenames != null) {
                for (Pair<PsiElement, String> rename : secondaryRenames) {
                    this.addElement((PsiElement)rename.first, (String)rename.second);
                    this.trackNamespaceRename((PsiElement)rename.first, (String)rename.second);
                }
            }
            this.trackNamespaceRename(element2, newName);
            DasObject object = (DasObject)ObjectUtils.tryCast((Object)element2, DasObject.class);
            if (object != null && (parent2 = object.getDasParent()) != null) {
                BasicElement e2 = DasObjectFun.getBasicElement(parent2);
                this.myHandler.include(e2);
            }
        }

        private void trackNamespaceRename(@NotNull PsiElement element2, @NotNull String name2) {
            if (element2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(5);
            }
            if (name2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(6);
            }
            if (!(element2 instanceof DasObject) || !this.myHandler.getDataSource().shouldTrackNamespaces()) {
                return;
            }
            this.scheduleIntrospectionScopeUpdate((DasObject)element2, name2);
        }

        private void scheduleIntrospectionScopeUpdate(@NotNull DasObject object, @NotNull String newName) {
            if (object == null) {
                MyRenameProcessor.$$$reportNull$$$0(7);
            }
            if (newName == null) {
                MyRenameProcessor.$$$reportNull$$$0(8);
            }
            if (object.getKind() == ObjectKind.SCHEMA || object.getKind() == ObjectKind.DATABASE) {
                ObjectPath old2 = ObjectPaths.of(object);
                Dbms dbms = this.myHandler.getDataSource().getDbms();
                BasicModel model2 = (BasicModel)ObjectUtils.tryCast((Object)this.myHandler.getDataSource().getModel(), BasicModel.class);
                NamingService service = NamingServices.getNamingService(dbms, model2);
                this.myHandler.getScopeUpdater().toRemove(old2);
                ObjectPath newPath = ObjectPath.create(service.unquoteIdentifier(newName), old2.kind, service.isQuoted(newName), null, old2.parent);
                this.myHandler.getScopeUpdater().toAdd(newPath);
            }
        }

        protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
            if (viewDescriptor == null) {
                MyRenameProcessor.$$$reportNull$$$0(9);
            }
            if (usageView == null) {
                MyRenameProcessor.$$$reportNull$$$0(10);
            }
            super.customizeUsagesView(viewDescriptor, usageView);
            JPanel scriptPanel = new JPanel(new BorderLayout());
            scriptPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
            final JBCheckBox box = new JBCheckBox(DatabaseBundle.message("execute.sql.script", new Object[0]), this.myExecuteSql);
            box.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e2) {
                    myExecuteSql = box.isSelected();
                }
            });
            JButton manually = new JButton(new AbstractAction(DatabaseBundle.message("open.in.console", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (myExcludedFile == null) {
                        myExcludedFile = DbUIUtil.openInConsole(myHandler.getProject(), myHandler.getDataSource(), null, myHandler.getStatement(), false);
                    } else {
                        DbUIUtil.openInConsole(myHandler.getProject(), (DasDataSource)myHandler.getDataSource(), myExcludedFile, myHandler.getStatement(), null);
                    }
                    box.setSelected(false);
                }
            });
            scriptPanel.add((Component)box, "West");
            scriptPanel.add((Component)manually, "East");
            usageView.setAdditionalComponent((JComponent)scriptPanel);
        }

        protected void execute(UsageInfo @NotNull [] usages2) {
            if (usages2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(11);
            }
            if (this.myExecuteSql) {
                this.runStatements(usages2);
            } else {
                this.executeSqlRename(usages2);
            }
        }

        private void executeSqlRename(UsageInfo @NotNull [] usages2) {
            if (usages2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(12);
            }
            super.execute(usages2);
        }

        @NotNull
        protected AsyncTask<?> runStatements(UsageInfo @NotNull [] usages2) {
            if (usages2 == null) {
                MyRenameProcessor.$$$reportNull$$$0(13);
            }
            AsyncTask<Boolean> execResult = null;
            if (ourRunStatementsHook != null) {
                execResult = (AsyncTask<Boolean>)ourRunStatementsHook.fun((Object)this.myHandler.getStatement());
            }
            if (execResult == null) {
                execResult = this.myHandler.runStatements(true);
            }
            AsyncTask<?> asyncTask = this.myAsyncStarted = execResult.apply(AsyncUtil.transactionExecutor((Disposable)this.myProject.getMessageBus()), res2 -> {
                CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                    AbstractDatabaseModifier.notifyImpossibilityOnUndo(this.myProject);
                    this.executeSqlRename(usages2);
                });
                return res2;
            });
            if (asyncTask == null) {
                MyRenameProcessor.$$$reportNull$$$0(14);
            }
            return asyncTask;
        }

        @Nullable
        public AsyncTask<?> getAsyncStarted() {
            return this.myAsyncStarted;
        }

        public UsageInfo @NotNull [] findUsages() {
            JBIterable usages2 = JBIterable.of((Object[])super.findUsages());
            if (this.myExcludedFile != null) {
                usages2 = usages2.filter(info2 -> !Comparing.equal((Object)info2.getVirtualFile(), (Object)this.myExcludedFile));
            }
            List res2 = usages2.toList();
            UsageInfo[] usageInfoArray = res2.toArray(UsageInfo.EMPTY_ARRAY);
            if (usageInfoArray == null) {
                MyRenameProcessor.$$$reportNull$$$0(15);
            }
            return usageInfoArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refactoringScope";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageView";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/DbRenamePsiElementProcessor$MyRenameProcessor";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runStatements";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "trackNamespaceRename";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "scheduleIntrospectionScopeUpdate";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeUsagesView";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "executeSqlRename";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "runStatements";
                    break;
                }
                case 14: 
                case 15: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 14, 15 -> new IllegalStateException(string);
            };
        }
    }
}

