/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanModel {
    private final GenericNode myRoot;
    private final boolean myActual;
    private final EnumSet<Feature> myUnsupported;
    private String myDataSourceId;

    public PlanModel(@NotNull GenericNode root2, boolean actual, @NotNull EnumSet<Feature> unsupported) {
        if (root2 == null) {
            PlanModel.$$$reportNull$$$0(0);
        }
        if (unsupported == null) {
            PlanModel.$$$reportNull$$$0(1);
        }
        this.myRoot = root2;
        this.myRoot.myParent = this;
        this.myUnsupported = unsupported;
        this.myActual = actual;
    }

    public boolean isActual() {
        return this.myActual;
    }

    public void setDataSourceId(@Nullable String dataSourceId) {
        this.myDataSourceId = dataSourceId;
    }

    @Nullable
    public String getDataSourceId() {
        return this.myDataSourceId;
    }

    @NotNull
    public EnumSet<Feature> getUnsupported() {
        EnumSet<Feature> enumSet = this.myUnsupported;
        if (enumSet == null) {
            PlanModel.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    @NotNull
    public GenericNode getRoot() {
        GenericNode genericNode = this.myRoot;
        if (genericNode == null) {
            PlanModel.$$$reportNull$$$0(3);
        }
        return genericNode;
    }

    public String dump() {
        return this.dump(false);
    }

    private static <E> String valueOf(E v2) {
        if (v2 instanceof Double) {
            Double d2 = (Double)v2;
            return PlanModel.toStableString(d2);
        }
        return v2 == null ? null : v2.toString();
    }

    @NotNull
    private static String toStableString(double d2) {
        String string = new BigDecimal(d2).toString();
        if (string == null) {
            PlanModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String dump(final boolean skeleton) {
        return new PlanVisitor(){
            int depth = 0;
            final StringBuilder sb = new StringBuilder();
            {
                this.dump(PlanModel.this.getRoot());
            }

            private void appendProp(@NotNull String name2, @Nullable String val) {
                if (name2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.indent(this.depth + 1);
                this.sb.append(name2).append(" = ").append(skeleton ? (val == null ? "N" : "*") : String.valueOf(val)).append("\n");
            }

            @Override
            public void visit(@NotNull GenericNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.indent(this.depth);
                this.sb.append(node2.getType().toString()).append("(").append(node2.getTitle()).append(")\n");
                this.appendProp("row_num", PlanModel.valueOf(node2.getPlanNumRows()));
                if (PlanModel.this.myActual) {
                    this.appendProp("actual_row_num", PlanModel.valueOf(node2.getActualNumRows()));
                }
                this.appendProp("cost", PlanModel.valueOf(node2.getTotalCost()));
                if (PlanModel.this.myActual) {
                    this.appendProp("actual_time", PlanModel.valueOf(node2.getActualTotalTime()));
                }
                this.appendProp("startup_cost", PlanModel.valueOf(node2.getStartupCost()));
                if (PlanModel.this.myActual) {
                    this.appendProp("actual_startup_time", PlanModel.valueOf(node2.getActualStartupTime()));
                }
                for (Hint hint : node2.getHints()) {
                    this.appendProp("***hint***", hint.getText().replace("\n", "\\n"));
                }
            }

            @Override
            public void visit(@NotNull GenericAccessNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.visit((GenericNode)node2);
                this.appendProp("relation", node2.getRelation());
            }

            @Override
            public void visit(@NotNull IndexScanNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.visit((GenericAccessNode)node2);
                this.appendProp("index", node2.getIndex());
            }

            @Override
            public void visit(@NotNull SubQueryNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.visit((GenericNode)node2);
                this.appendProp("scalar", PlanModel.valueOf(node2.isScalar()));
                this.appendProp("correlated", PlanModel.valueOf(node2.isCorrelated()));
            }

            @Override
            public void visit(@NotNull RefNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.visit((GenericNode)node2);
                this.appendProp("ref", node2.getRef().getFullTitle());
            }

            public void dump(@NotNull GenericNode node2) {
                if (node2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                node2.accept(this);
                if (!skeleton) {
                    String[] split = Pattern.compile("\\r?\\n").split(node2.getRawDescription());
                    int pre = this.sb.length();
                    for (int i2 = 0; i2 < split.length; ++i2) {
                        if (split[i2].isEmpty()) continue;
                        if (i2 == 0) {
                            this.indent(this.depth + 1);
                            this.sb.append("[");
                        } else {
                            this.sb.append("\n");
                            this.indent(this.depth + 2);
                        }
                        this.sb.append(split[i2]);
                    }
                    if (pre != this.sb.length()) {
                        this.sb.append("]").append("\n");
                    }
                }
                ++this.depth;
                for (GenericNode c2 : node2.getChildren()) {
                    this.dump(c2);
                }
                --this.depth;
            }

            private void indent(int depth) {
                this.sb.append("\t".repeat(depth));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/plan/PlanModel$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendProp";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "dump";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.sb.toString();
    }

    @NotNull
    public static GenericNode createNode(@NotNull NodeType type2, @Nullable String title) {
        if (type2 == null) {
            PlanModel.$$$reportNull$$$0(5);
        }
        if (type2.isKindOf(NodeType.SUBQUERY)) {
            return new SubQueryNode(type2, title);
        }
        if (type2.isKindOf(NodeType.INDEX_SCAN)) {
            return new IndexScanNode(type2, title);
        }
        if (type2.isKindOf(NodeType.ACCESS)) {
            return new GenericAccessNode(type2, title);
        }
        return new GenericNode(type2, title);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsupported";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/PlanModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/PlanModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsupported";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toStableString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class GenericNode {
        public static final GenericNode[] NO_CHILDREN = new GenericNode[0];
        public static final Hint[] NO_HINTS = new Hint[0];
        private final NodeType myType;
        private final String myTitle;
        private String myRawDescription;
        private GenericNode[] myChildren;
        private BigDecimal myNumRows;
        private BigDecimal myActualNumRows;
        private Double myTotalCost;
        private Double myActualTotalTime;
        private Double myStartupCost;
        private Double myActualStartupTime;
        private Object myParent;
        private Hint[] myHints;

        public GenericNode(@NotNull NodeType type2, @Nullable String altTitle) {
            if (type2 == null) {
                GenericNode.$$$reportNull$$$0(0);
            }
            this.myRawDescription = "";
            this.myChildren = NO_CHILDREN;
            this.myHints = NO_HINTS;
            this.myType = type2;
            this.myTitle = altTitle;
        }

        @NotNull
        public @NotNull GenericNode @NotNull [] getChildren() {
            if (this.myChildren == null) {
                GenericNode.$$$reportNull$$$0(1);
            }
            return this.myChildren;
        }

        @Nullable
        public BigDecimal getPlanNumRows() {
            return this.myNumRows;
        }

        public void setPlanNumRows(@Nullable BigDecimal numRows) {
            this.myNumRows = numRows;
        }

        @Nullable
        public BigDecimal getActualNumRows() {
            return this.myActualNumRows;
        }

        public void setActualNumRows(@Nullable BigDecimal numRows) {
            this.myActualNumRows = numRows;
        }

        public Double getTotalCost() {
            return this.myTotalCost;
        }

        public void setTotalCost(Double totalCost) {
            this.myTotalCost = totalCost;
        }

        public Double getActualTotalTime() {
            return this.myActualTotalTime;
        }

        public void setActualTotalTime(Double totalTime) {
            this.myActualTotalTime = totalTime;
        }

        public Double getStartupCost() {
            return this.myStartupCost;
        }

        public void setStartupCost(Double startupCost) {
            this.myStartupCost = startupCost;
        }

        public Double getActualStartupTime() {
            return this.myActualStartupTime;
        }

        public void setActualStartupTime(Double startupTime) {
            this.myActualStartupTime = startupTime;
        }

        @NlsSafe
        @NotNull
        public String getRawDescription() {
            String string = this.myRawDescription;
            if (string == null) {
                GenericNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void setRawDescription(@NotNull @NlsSafe String rawDescription) {
            if (rawDescription == null) {
                GenericNode.$$$reportNull$$$0(3);
            }
            this.myRawDescription = rawDescription;
        }

        public void setChildren(@NotNull @NotNull GenericNode @NotNull [] children2) {
            if (children2 == null) {
                GenericNode.$$$reportNull$$$0(4);
            }
            for (GenericNode child : this.myChildren) {
                child.myParent = null;
            }
            this.myChildren = children2;
            for (GenericNode child : children2) {
                child.myParent = this;
            }
        }

        @NotNull
        public String getTitle() {
            String string = StringUtil.notNullize((String)this.myTitle, (String)this.myType.display);
            if (string == null) {
                GenericNode.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public NodeType getType() {
            NodeType nodeType = this.myType;
            if (nodeType == null) {
                GenericNode.$$$reportNull$$$0(6);
            }
            return nodeType;
        }

        @NotNull
        protected String getDisplayTitleSuffix() {
            Object object = this.myTitle == null ? "" : " (" + this.myTitle + ")";
            if (object == null) {
                GenericNode.$$$reportNull$$$0(7);
            }
            return object;
        }

        @NlsSafe
        @NotNull
        public String getDisplayTitle() {
            String string = StringUtil.capitalizeWords((String)this.getType().display, (boolean)true) + this.getDisplayTitleSuffix();
            if (string == null) {
                GenericNode.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFullTitle() {
            String string = this.getDisplayTitle();
            if (string == null) {
                GenericNode.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        public String getExtraInfo() {
            return "";
        }

        @NotNull
        public @NotNull Hint @NotNull [] getHints() {
            if (this.myHints == null) {
                GenericNode.$$$reportNull$$$0(10);
            }
            return this.myHints;
        }

        public void setHints(Hint ... hints) {
            if (hints == null) {
                GenericNode.$$$reportNull$$$0(11);
            }
            this.myHints = hints;
        }

        public void accept(@NotNull PlanVisitor visitor2) {
            if (visitor2 == null) {
                GenericNode.$$$reportNull$$$0(12);
            }
            visitor2.visit(this);
        }

        @Nullable
        public GenericNode getParentNode() {
            return (GenericNode)ObjectUtils.tryCast((Object)this.myParent, GenericNode.class);
        }

        @Nullable
        public PlanModel getModel() {
            GenericNode n = this;
            while (n.getParentNode() != null) {
                n = n.getParentNode();
            }
            return (PlanModel)ObjectUtils.tryCast((Object)n.myParent, PlanModel.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 5, 6, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$GenericNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rawDescription";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hints";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$GenericNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawDescription";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayTitleSuffix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayTitle";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullTitle";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHints";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setRawDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildren";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setHints";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    public static enum NodeType {
        ROOT("root", null),
        RECURSION("recursion", null),
        REUSE("reuse", null),
        OPTIMIZE("optimize", null),
        UNKNOWN("unknown", null),
        OPERATION("operation", UNKNOWN),
        LOCK_ROWS("lock rows", OPERATION),
        SEQUENTIALLY("sequentially", OPERATION),
        SUBPLAN("subplan", OPERATION),
        DATA("data", UNKNOWN),
        VALUE("value", DATA),
        TABLE_FUNCTION("table function", DATA),
        ACCESS("access", DATA),
        ROWID_ACCESS("row id access", ACCESS),
        SEQ_SCAN("full scan", ACCESS),
        INDEX_SCAN("index scan", ACCESS),
        FULL_INDEX_SCAN("full index scan", INDEX_SCAN),
        UNIQUE_INDEX_SCAN("unique index scan", INDEX_SCAN),
        BITMAP_INDEX_SCAN("bitmap index scan", INDEX_SCAN),
        TEMPORARY("temporary", UNKNOWN),
        TRANSFORM("transformation", UNKNOWN),
        AGGREGATE("aggregate", TRANSFORM),
        FILTER("filter", TRANSFORM),
        GROUP_BY("group by", TRANSFORM),
        ORDER_BY("order by", TRANSFORM),
        SORT("sort", TRANSFORM),
        UNIQUE("unique", TRANSFORM),
        HASH_UNIQUE("hash unique", UNIQUE),
        SORT_UNIQUE("sort unique", UNIQUE),
        SET_OP("set operation", UNKNOWN),
        JOIN("join", SET_OP),
        NESTED_LOOPS("nested loops", SET_OP),
        MERGE_JOIN("merge join", SET_OP),
        HASH_JOIN("hash join", SET_OP),
        UNION_ALL("union all", SET_OP),
        UNION("union", SET_OP),
        EXCEPT("except", SET_OP),
        INTERSECT("intersection", SET_OP),
        SUBQUERY("subquery", UNKNOWN),
        DIRECT_LOAD("direct load", UNKNOWN),
        NETWORK("network", UNKNOWN),
        STATEMENT("statement", null),
        SELECT("select", STATEMENT),
        MERGE("merge", STATEMENT),
        INSERT("insert", STATEMENT),
        UPDATE("update", STATEMENT),
        DELETE("delete", STATEMENT);

        public final String display;
        private final NodeType myParent;

        private NodeType(String display, NodeType parent2) {
            this.display = display;
            this.myParent = parent2;
        }

        public boolean isKindOf(@NotNull NodeType type2) {
            if (type2 == null) {
                NodeType.$$$reportNull$$$0(0);
            }
            if (type2 == this) {
                return true;
            }
            if (this.myParent == null) {
                return false;
            }
            return this.myParent.isKindOf(type2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/plan/PlanModel$NodeType", "isKindOf"));
        }
    }

    public static class SubQueryNode
    extends GenericNode {
        private boolean myScalar;
        private boolean myCorrelated;

        public SubQueryNode(@NotNull NodeType type2, @Nullable String altTitle) {
            if (type2 == null) {
                SubQueryNode.$$$reportNull$$$0(0);
            }
            super(type2, altTitle);
        }

        public boolean isScalar() {
            return this.myScalar;
        }

        public void setScalar(boolean scalar) {
            this.myScalar = scalar;
        }

        public boolean isCorrelated() {
            return this.myCorrelated;
        }

        public void setCorrelated(boolean correlated) {
            this.myCorrelated = correlated;
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (this.myScalar ? " Scalar;" : "") + (this.myCorrelated ? " Correlated;" : "");
            if (string == null) {
                SubQueryNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor2) {
            if (visitor2 == null) {
                SubQueryNode.$$$reportNull$$$0(2);
            }
            visitor2.visit(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$SubQueryNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$SubQueryNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class IndexScanNode
    extends GenericAccessNode {
        private String myIndex;

        public IndexScanNode(@NotNull NodeType type2, @Nullable String title) {
            if (type2 == null) {
                IndexScanNode.$$$reportNull$$$0(0);
            }
            super(type2, title);
        }

        @Nullable
        public String getIndex() {
            return this.myIndex;
        }

        public void setIndex(@Nullable String index2) {
            this.myIndex = index2;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor2) {
            if (visitor2 == null) {
                IndexScanNode.$$$reportNull$$$0(1);
            }
            visitor2.visit(this);
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (String)(this.myIndex == null ? "" : " index: " + this.myIndex + ";");
            if (string == null) {
                IndexScanNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$IndexScanNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$IndexScanNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class GenericAccessNode
    extends GenericNode {
        private String myRelation;

        public GenericAccessNode(@NotNull NodeType type2, @Nullable String title) {
            if (type2 == null) {
                GenericAccessNode.$$$reportNull$$$0(0);
            }
            super(type2, title);
        }

        @Override
        @NotNull
        public String getFullTitle() {
            String title = super.getFullTitle();
            Object object = this.myRelation == null ? title : title + " of " + this.myRelation;
            if (object == null) {
                GenericAccessNode.$$$reportNull$$$0(1);
            }
            return object;
        }

        @Nullable
        public String getRelation() {
            return this.myRelation;
        }

        public void setRelation(@Nullable String relation) {
            this.myRelation = relation;
        }

        @Override
        public void accept(@NotNull PlanVisitor visitor2) {
            if (visitor2 == null) {
                GenericAccessNode.$$$reportNull$$$0(2);
            }
            visitor2.visit(this);
        }

        @Override
        @NotNull
        public String getExtraInfo() {
            String string = super.getExtraInfo() + (String)(this.myRelation == null ? "" : " table: " + this.myRelation + ";");
            if (string == null) {
                GenericAccessNode.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$GenericAccessNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$GenericAccessNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullTitle";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtraInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface PlanVisitor {
        public void visit(@NotNull GenericNode var1);

        public void visit(@NotNull GenericAccessNode var1);

        public void visit(@NotNull IndexScanNode var1);

        public void visit(@NotNull SubQueryNode var1);

        public void visit(@NotNull RefNode var1);
    }

    public static class RefNode
    extends GenericNode {
        private final GenericNode myRef;

        public RefNode(@NotNull GenericNode ref2, @NotNull NodeType type2) {
            if (ref2 == null) {
                RefNode.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                RefNode.$$$reportNull$$$0(1);
            }
            super(type2, ref2.getTitle());
            this.myRef = ref2;
        }

        @NotNull
        public GenericNode getRef() {
            GenericNode genericNode = this.myRef;
            if (genericNode == null) {
                RefNode.$$$reportNull$$$0(2);
            }
            return genericNode;
        }

        @NotNull
        public static GenericNode closeReference(@NotNull GenericNode n) {
            RefNode rec;
            if (n == null) {
                RefNode.$$$reportNull$$$0(3);
            }
            GenericNode genericNode = (rec = (RefNode)ObjectUtils.tryCast((Object)n, RefNode.class)) == null ? n : rec.getRef();
            if (genericNode == null) {
                RefNode.$$$reportNull$$$0(4);
            }
            return genericNode;
        }

        @NotNull
        public static GenericNode closeReuse(@NotNull GenericNode n) {
            if (n == null) {
                RefNode.$$$reportNull$$$0(5);
            }
            GenericNode genericNode = n.getType() == NodeType.REUSE ? RefNode.closeReference(n) : n;
            if (genericNode == null) {
                RefNode.$$$reportNull$$$0(6);
            }
            return genericNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/PlanModel$RefNode";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/PlanModel$RefNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRef";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "closeReference";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "closeReuse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "closeReference";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "closeReuse";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static class Hint {
        private final @NlsContexts.DialogMessage String myText;
        private final Action[] myActions;

        public Hint(@NlsContexts.DialogMessage @NotNull String text2, Action ... actions) {
            if (text2 == null) {
                Hint.$$$reportNull$$$0(0);
            }
            if (actions == null) {
                Hint.$$$reportNull$$$0(1);
            }
            this.myText = text2;
            this.myActions = actions;
        }

        @NlsContexts.DialogMessage
        public String getText() {
            return this.myText;
        }

        public Action[] getActions() {
            return this.myActions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actions";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/plan/PlanModel$Hint";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Action {
        public void perform(@NotNull DbDataSource var1);
    }

    public static enum Feature {
        NUM_ROWS,
        TOTAL_COST,
        STARTUP_COST;

    }
}

