/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicHierarchicalObject;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaReferenceList;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolvableMetaProperty;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelLightCopier {
    @NotNull
    private static BasicModElement lightInstantiate(@NotNull BasicMetaObject<?> object, @NotNull BasicModRoot root2) {
        if (object == null) {
            ModelLightCopier.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            ModelLightCopier.$$$reportNull$$$0(1);
        }
        if (object.kind == ObjectKind.ROOT) {
            BasicModRoot basicModRoot = root2;
            if (basicModRoot == null) {
                ModelLightCopier.$$$reportNull$$$0(2);
            }
            return basicModRoot;
        }
        BasicModElement parent2 = ModelLightCopier.lightInstantiate(Objects.requireNonNull(object.getParent()), root2);
        Object e2 = ((ModFamily)Objects.requireNonNull(parent2.familyOf(object.kind))).createNewOne();
        if (e2 == null) {
            ModelLightCopier.$$$reportNull$$$0(3);
        }
        return e2;
    }

    @NotNull
    public static BasicModElement lightInstantiate(@NotNull BasicMetaObject<?> object, @NotNull ModelFactory mf) {
        if (object == null) {
            ModelLightCopier.$$$reportNull$$$0(4);
        }
        if (mf == null) {
            ModelLightCopier.$$$reportNull$$$0(5);
        }
        BasicModModel model2 = mf.createModel(object.getModel().dbms);
        Ref res2 = Ref.create();
        model2.modify(BasicModRoot.class, r -> res2.set((Object)ModelLightCopier.lightInstantiate(object, r)));
        BasicModElement basicModElement = (BasicModElement)res2.get();
        if (basicModElement == null) {
            ModelLightCopier.$$$reportNull$$$0(6);
        }
        return basicModElement;
    }

    public static JBIterable<Family<?>> getDependencies(@NotNull BasicElement e2) {
        if (e2 == null) {
            ModelLightCopier.$$$reportNull$$$0(7);
        }
        return BasicMetaUtils.getMetaObject(e2).getAllProperties().filterMap(BasicMetaReference::asRef).filter(r -> !r.isAbstract()).flatten(r -> r.getReferenceDesc().candidateFamilies(e2, BasicResolveAssistant.DEFAULT));
    }

    public static JBIterable<Family<?>> getGrantees(@NotNull BasicElement e2) {
        Grants.Controller<?, ?> controller;
        if (e2 == null) {
            ModelLightCopier.$$$reportNull$$$0(8);
        }
        if ((controller = ModelFacade.forDbms(DbImplUtilCore.getDbms(e2)).getModelHelper().getGrantController()) == null) {
            return JBIterable.empty();
        }
        return controller.granteeFamiliesFor(e2);
    }

    public static void copyProperties(@NotNull BasicElement from, @NotNull BasicModElement to, boolean withSources, boolean makePortable) {
        if (from == null) {
            ModelLightCopier.$$$reportNull$$$0(9);
        }
        if (to == null) {
            ModelLightCopier.$$$reportNull$$$0(10);
        }
        if (to instanceof BasicHierarchicalObject && from instanceof BasicHierarchicalObject && !ModelLightCopier.shouldMakePortable(from, makePortable) && ((BasicHierarchicalObject)to).applyData(((BasicHierarchicalObject)from).frozenData())) {
            BasicMetaUtils.copySources(from, to, withSources);
        } else {
            BasicMetaUtils.copyProperties(from, to, withSources, makePortable);
        }
    }

    private static boolean shouldMakePortable(BasicElement from, boolean makePortable) {
        if (!makePortable) {
            return false;
        }
        BasicMetaObject<BasicElement> meta = BasicMetaUtils.getMetaObject(from);
        for (BasicMetaReference r : meta.getAllProperties().filterMap(BasicMetaReference::asRef)) {
            BasicReference ref2;
            if (r.isAbstract() || (ref2 = (BasicReference)r.get(from)) == null || ref2.isPortable()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static BasicModModel copy(@NotNull BasicModel from, @NotNull ModelFactory mf, boolean sources, boolean makePortable) {
        if (from == null) {
            ModelLightCopier.$$$reportNull$$$0(11);
        }
        if (mf == null) {
            ModelLightCopier.$$$reportNull$$$0(12);
        }
        BasicModModel to = mf.createModel(from.getDbms());
        DbImplUtilCore.performSrcOperation(null, to, ModalityState.nonModal(), false, () -> to.modify(BasicModRoot.class, r -> ModelLightCopier.copyFull(null, from.getRoot(), r, sources, makePortable)));
        BasicModModel basicModModel = to;
        if (basicModModel == null) {
            ModelLightCopier.$$$reportNull$$$0(13);
        }
        return basicModModel;
    }

    public static BasicModElement copy(@NotNull BasicModModel tm, @NotNull BasicElement obj2, boolean makePortable) {
        if (tm == null) {
            ModelLightCopier.$$$reportNull$$$0(14);
        }
        if (obj2 == null) {
            ModelLightCopier.$$$reportNull$$$0(15);
        }
        Ref result2 = Ref.create();
        tm.modify(BasicModRoot.class, r -> result2.set((Object)ModelLightCopier.copy(obj2, tm, makePortable)));
        return (BasicModElement)result2.get();
    }

    public static <T extends BasicElement> T copyData(@NotNull T obj2, boolean makePortable) {
        if (obj2 == null) {
            ModelLightCopier.$$$reportNull$$$0(16);
        }
        T res2 = BasicMetaUtils.getMetaObject(obj2).newDataObject();
        ModelLightCopier.copyProperties(obj2, (BasicModElement)res2, false, makePortable);
        return res2;
    }

    public static BasicModElement copy(@NotNull BasicElement obj2, @NotNull BasicModModel tm, boolean makePortable) {
        if (obj2 == null) {
            ModelLightCopier.$$$reportNull$$$0(17);
        }
        if (tm == null) {
            ModelLightCopier.$$$reportNull$$$0(18);
        }
        return ModelLightCopier.copy(obj2, tm, false, makePortable);
    }

    public static BasicModElement copy(final @NotNull BasicElement obj2, final @NotNull BasicModModel tm, boolean forceFull, final boolean makePortable) {
        if (obj2 == null) {
            ModelLightCopier.$$$reportNull$$$0(19);
        }
        if (tm == null) {
            ModelLightCopier.$$$reportNull$$$0(20);
        }
        final HashSet<BasicElement> toCopy = new HashSet<BasicElement>();
        ModelLightCopier.collectCopyTargets(obj2, forceFull, toCopy);
        final boolean withSources = !forceFull;
        return new Object(){
            BasicModElement found;

            void copySpecified(BasicElement from, BasicModElement to) {
                ModelLightCopier.copyProperties(from, to, withSources || from == obj2, makePortable);
                if (from == obj2) {
                    this.found = to;
                }
                for (Family<? extends BasicElement> family : from.getFamilies()) {
                    Family toF = to.familyOf(family.getMetaObject().kind);
                    if (toF == null) continue;
                    for (BasicElement basicElement : family) {
                        if (!toCopy.contains(basicElement)) continue;
                        this.copySpecified(basicElement, (BasicModElement)toF.createNewOne());
                    }
                }
            }

            BasicModElement run() {
                this.copySpecified(Objects.requireNonNull(obj2.getModel()).getRoot(), (BasicModElement)((Object)tm.getRoot()));
                return this.found;
            }
        }.run();
    }

    private static void copySources(@NotNull BasicElement src2, @NotNull BasicModElement tgt) {
        if (src2 == null) {
            ModelLightCopier.$$$reportNull$$$0(21);
        }
        if (tgt == null) {
            ModelLightCopier.$$$reportNull$$$0(22);
        }
        if (tgt instanceof BasicModSourceAware) {
            BasicSourceAware s2 = (BasicSourceAware)ObjectUtils.tryCast((Object)src2, BasicSourceAware.class);
            ((BasicModSourceAware)tgt).setSourceText(s2 == null ? null : s2.getSourceText());
        }
        BasicElement pSrc = src2.getParent();
        BasicModElement pTgt = (BasicModElement)tgt.getParent();
        if (pSrc != null && pTgt != null) {
            ModelLightCopier.copySources(pSrc, pTgt);
        }
    }

    private static boolean isFullCopyRoot(DasObject obj2) {
        return obj2 instanceof DasSchemaChild;
    }

    public static void copyFamily(@NotNull Family<?> src2, ModFamily<?> tgt, boolean makePortable) {
        if (src2 == null) {
            ModelLightCopier.$$$reportNull$$$0(23);
        }
        for (BasicElement srcE : src2) {
            ModelLightCopier.copySingle(srcE, tgt, makePortable);
        }
    }

    @NotNull
    public static BasicModElement copySingle(@NotNull BasicElement obj2, @NotNull ModFamily<?> tgtFamily, boolean makePortable) {
        if (obj2 == null) {
            ModelLightCopier.$$$reportNull$$$0(24);
        }
        if (tgtFamily == null) {
            ModelLightCopier.$$$reportNull$$$0(25);
        }
        Object tgt = tgtFamily.createNewOne();
        ModelLightCopier.copyProperties(obj2, tgt, true, makePortable);
        Object obj3 = tgt;
        if (obj3 == null) {
            ModelLightCopier.$$$reportNull$$$0(26);
        }
        return obj3;
    }

    @Contract(value="!null,_,_,_,_->!null")
    private static BasicModElement copyFull(@Nullable BasicElement obj2, @NotNull BasicElement srcParent, @NotNull BasicModElement parent2, boolean sources, boolean makePortable) {
        if (srcParent == null) {
            ModelLightCopier.$$$reportNull$$$0(27);
        }
        if (parent2 == null) {
            ModelLightCopier.$$$reportNull$$$0(28);
        }
        BasicModElement res2 = null;
        ModelLightCopier.copyProperties(srcParent, parent2, sources, makePortable);
        for (Family<? extends BasicElement> family : srcParent.getFamilies()) {
            if (family.isEmpty()) continue;
            ModFamily tgtFamily = (ModFamily)Objects.requireNonNull(parent2.familyOf(family.first().getKind()));
            for (BasicElement basicElement : family) {
                Object tgt = tgtFamily.createNewOne();
                if (basicElement == obj2) {
                    res2 = (BasicModElement)tgt;
                    continue;
                }
                ModelLightCopier.copyFull(null, basicElement, tgt, sources, makePortable);
            }
        }
        return res2;
    }

    public static void collectCopyTargetsRec(@NotNull BasicElement obj2, @NotNull Set<BasicElement> collected, boolean full) {
        if (obj2 == null) {
            ModelLightCopier.$$$reportNull$$$0(29);
        }
        if (collected == null) {
            ModelLightCopier.$$$reportNull$$$0(30);
        }
        ModelLightCopier.collectDependencies(obj2, collected);
        if (full) {
            for (BasicElement child : obj2.getChildren()) {
                ModelLightCopier.collectCopyTargetsRec(child, collected, true);
            }
        }
    }

    private static boolean collectCopyTargets(@NotNull BasicElement e2, boolean forceFull, @NotNull Set<BasicElement> collected) {
        boolean full;
        BasicElement parent2;
        if (e2 == null) {
            ModelLightCopier.$$$reportNull$$$0(31);
        }
        if (collected == null) {
            ModelLightCopier.$$$reportNull$$$0(32);
        }
        if ((parent2 = e2.getParent()) != null && (full = ModelLightCopier.collectCopyTargets(parent2, false, collected))) {
            return true;
        }
        full = ModelLightCopier.isFullCopyRoot(e2) || forceFull;
        ModelLightCopier.collectCopyTargetsRec(e2, collected, full);
        return full;
    }

    private static <T extends BasicElement> void collectDependencies(@Nullable T e2, @NotNull Set<BasicElement> collected) {
        if (collected == null) {
            ModelLightCopier.$$$reportNull$$$0(33);
        }
        if (e2 == null) {
            return;
        }
        if (!collected.add(e2)) {
            return;
        }
        for (BasicMetaProperty prop : BasicMetaUtils.getMetaObject(e2).getAllProperties()) {
            BasicMetaReferenceDesc desc;
            BasicResolvableMetaProperty metaRef;
            if (prop instanceof BasicMetaReference) {
                metaRef = BasicMetaReference.asRef(prop);
                BasicReference ref2 = (BasicReference)metaRef.get(e2);
                desc = metaRef.getReferenceDesc();
                Object tgt = BasicMetaUtils.resolve(e2, desc, ref2);
                if (tgt == null) continue;
                ModelLightCopier.collectCopyTargets(tgt, false, collected);
                continue;
            }
            if (!(prop instanceof BasicMetaReferenceList)) continue;
            metaRef = BasicMetaReferenceList.asRefList(prop);
            List refs = (List)metaRef.get(e2);
            desc = metaRef.getReferenceDesc();
            for (BasicReference ref3 : refs) {
                Object tgt = BasicMetaUtils.resolve(e2, desc, ref3);
                if (tgt == null) continue;
                ModelLightCopier.collectCopyTargets(tgt, false, collected);
            }
        }
    }

    private static <T extends BasicElement> void copyDependency(@NotNull T from, BasicModModel model2, BasicReference ref2, BasicMetaReferenceDesc<T, ?> desc, boolean makePortable) {
        Object dep;
        if (from == null) {
            ModelLightCopier.$$$reportNull$$$0(34);
        }
        if ((dep = BasicMetaUtils.resolve(from, desc, ref2)) != null) {
            ModelLightCopier.copy(dep, model2, makePortable);
        }
    }

    public static int hashCode(@NotNull BasicElement element2) {
        int stored;
        if (element2 == null) {
            ModelLightCopier.$$$reportNull$$$0(35);
        }
        return (stored = element2.getStoredHashCode()) == 0 ? BasicMetaUtils.hashCode(element2) : stored;
    }

    public static boolean equals(@NotNull BasicElement o1, @NotNull BasicElement o2) {
        if (o1 == null) {
            ModelLightCopier.$$$reportNull$$$0(36);
        }
        if (o2 == null) {
            ModelLightCopier.$$$reportNull$$$0(37);
        }
        if (o1 == o2) {
            return true;
        }
        int hc1 = o1.getStoredHashCode();
        int hc2 = o2.getStoredHashCode();
        if (hc1 != 0 && hc2 != 0 && hc1 != hc2) {
            return false;
        }
        return BasicMetaUtils.equals(o1, o2);
    }

    public static BasicModModel snapshot(@NotNull ModelFactory factory, @NotNull BasicModel model2) {
        if (factory == null) {
            ModelLightCopier.$$$reportNull$$$0(38);
        }
        if (model2 == null) {
            ModelLightCopier.$$$reportNull$$$0(39);
        }
        BasicModModel target2 = factory.createModel(model2.getDbms());
        target2.modify(BasicModRoot.class, r -> ModelLightCopier.copyFull(null, model2.getRoot(), r, false, false));
        return target2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 13, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelLightCopier";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mf";
                break;
            }
            case 7: 
            case 8: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 11: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 14: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tm";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgtFamily";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcParent";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collected";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelLightCopier";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lightInstantiate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "copySingle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lightInstantiate";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 13: 
            case 26: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGrantees";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyProperties";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "copySources";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "copyFamily";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "copySingle";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "copyFull";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectCopyTargetsRec";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectCopyTargets";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyDependency";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hashCode";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "snapshot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 13, 26 -> new IllegalStateException(string);
        };
    }
}

