/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.BlackHoleTextStorage;
import com.intellij.database.model.ModelEntityStorage;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicModModel;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ+\u0010\u0007\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/model/ModelFactory;", "", "textStorage", "Lcom/intellij/database/model/ModelTextStorage;", "(Lcom/intellij/database/model/ModelTextStorage;)V", "getTextStorage", "()Lcom/intellij/database/model/ModelTextStorage;", "createModel", "Lcom/intellij/database/model/basic/BasicModModel;", "dbms", "Lcom/intellij/database/Dbms;", "M", "modelClass", "Ljava/lang/Class;", "(Lcom/intellij/database/Dbms;Ljava/lang/Class;)Lcom/intellij/database/model/basic/BasicModModel;", "keepPersistentData", "", "Companion", "intellij.database.core.impl"})
public final class ModelFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModelTextStorage textStorage;
    @JvmField
    @NotNull
    public static final ModelFactory BLACK_HOLE = new ModelFactory(BlackHoleTextStorage.INSTANCE);

    public ModelFactory(@NotNull ModelTextStorage textStorage) {
        Intrinsics.checkNotNullParameter((Object)textStorage, (String)"textStorage");
        this.textStorage = textStorage;
    }

    @NotNull
    public final ModelTextStorage getTextStorage() {
        return this.textStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BasicModModel createModel(@NotNull Dbms dbms, boolean keepPersistentData) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        ModelFacade modelFacade = ModelFacade.forDbms(dbms);
        Intrinsics.checkNotNullExpressionValue((Object)modelFacade, (String)"forDbms(...)");
        ModelFacade factory = modelFacade;
        if (!keepPersistentData) {
            ModelEntityStorage.Backend storage = this.textStorage.createEntityStorage();
            try {
                storage.clear();
            }
            finally {
                storage.shelve();
            }
        }
        BasicModModel basicModModel = factory.createModel(this.textStorage);
        Intrinsics.checkNotNullExpressionValue((Object)basicModModel, (String)"createModel(...)");
        return basicModModel;
    }

    @NotNull
    public final BasicModModel createModel(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return this.createModel(dbms, false);
    }

    @NotNull
    public final <M extends BasicModModel> M createModel(@NotNull Dbms dbms, @NotNull Class<M> modelClass) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
        BasicModModel model2 = this.createModel(dbms);
        if (modelClass.isAssignableFrom(model2.getClass())) {
            Intrinsics.checkNotNull((Object)model2, (String)"null cannot be cast to non-null type M of com.intellij.database.model.ModelFactory.createModel");
            return (M)model2;
        }
        throw new IllegalArgumentException("Cannot cast " + dbms + " model to " + modelClass.getSimpleName());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/model/ModelFactory$Companion;", "", "()V", "BLACK_HOLE", "Lcom/intellij/database/model/ModelFactory;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

