/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.Dbms;
import com.intellij.database.model.DescriptionOptions;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.ModelDescribing;
import com.intellij.database.model.ModelDescriptionAnnotation;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicMultiLevelIntrospectableArea;
import com.intellij.database.model.basic.BasicMultiLevelObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.properties.Level;
import com.intellij.database.util.CodeBuilder;
import com.intellij.database.util.CodeWithMarkers;
import com.intellij.database.util.common.NumberFun;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00140\u0013\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u0007*\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u001c\u0010\u0017\u001a\u00020\t*\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\"\u0010\u0017\u001a\u00020\t*\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"braceLAL", "", "braceLAR", "braceLDL", "braceLDR", "eoln", "indentStep", "", "describeTreeRecursively", "", "service", "Lcom/intellij/database/model/DescriptionService;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "describeForest", "Lcom/intellij/database/util/CodeWithMarkers;", "Lcom/intellij/database/model/ModelDescriptionAnnotation;", "", "Lcom/intellij/database/model/basic/BasicNode;", "options", "Lcom/intellij/database/model/DescriptionOptions;", "describeTree", "cb", "Lcom/intellij/database/util/CodeBuilder;", "intellij.database.impl"})
@JvmName(name="ModelDescribing")
@SourceDebugExtension(value={"SMAP\nModelDescribing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelDescribing.kt\ncom/intellij/database/model/ModelDescribing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CodeBuilder.kt\ncom/intellij/database/util/CodeBuilder\n+ 4 DescriptionService.kt\ncom/intellij/database/model/DescriptionService$Context\n*L\n1#1,181:1\n1855#2,2:182\n1855#2,2:184\n71#3:186\n73#4:187\n*S KotlinDebug\n*F\n+ 1 ModelDescribing.kt\ncom/intellij/database/model/ModelDescribing\n*L\n37#1:182,2\n60#1:184,2\n61#1:186\n72#1:187\n*E\n"})
public final class ModelDescribing {
    @NotNull
    private static final String indentStep = "    ";
    private static final char eoln = '\n';
    public static final char braceLAL = '\u2308';
    public static final char braceLAR = '\u2309';
    public static final char braceLDL = '\u230a';
    public static final char braceLDR = '\u230b';

    @NotNull
    public static final CodeWithMarkers<ModelDescriptionAnnotation> describeForest(@NotNull Iterable<? extends BasicNode> $this$describeForest) {
        Intrinsics.checkNotNullParameter($this$describeForest, (String)"<this>");
        return ModelDescribing.describeForest($this$describeForest, DescriptionOptions.EMPTY);
    }

    @NotNull
    public static final CodeWithMarkers<ModelDescriptionAnnotation> describeForest(@NotNull Iterable<? extends BasicNode> $this$describeForest, @NotNull DescriptionOptions options2) {
        Intrinsics.checkNotNullParameter($this$describeForest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        CodeBuilder<ModelDescriptionAnnotation> cb = new CodeBuilder<ModelDescriptionAnnotation>();
        cb.setDefaultIndentation(indentStep);
        Iterable<? extends BasicNode> $this$forEach$iv = $this$describeForest;
        boolean $i$f$forEach = false;
        Iterator<? extends BasicNode> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            BasicNode element$iv;
            BasicNode it2 = element$iv = iterator.next();
            boolean bl = false;
            ModelDescribing.describeTree(it2, cb, options2);
        }
        return cb.getResult();
    }

    @JvmOverloads
    @NotNull
    public static final String describeTree(@NotNull BasicNode $this$describeTree, @NotNull DescriptionOptions options2) {
        Intrinsics.checkNotNullParameter((Object)$this$describeTree, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        CodeBuilder<ModelDescriptionAnnotation> cb = new CodeBuilder<ModelDescriptionAnnotation>();
        cb.setDefaultIndentation(indentStep);
        ModelDescribing.describeTree($this$describeTree, cb, options2);
        return cb.getText();
    }

    public static /* synthetic */ String describeTree$default(BasicNode basicNode, DescriptionOptions descriptionOptions, int n, Object object) {
        if ((n & 1) != 0) {
            descriptionOptions = DescriptionOptions.EMPTY;
        }
        return ModelDescribing.describeTree(basicNode, descriptionOptions);
    }

    private static final void describeTree(BasicNode $this$describeTree, CodeBuilder<ModelDescriptionAnnotation> cb, DescriptionOptions options2) {
        Object object = $this$describeTree.getModel();
        if (object == null || (object = object.getDbms()) == null) {
            object = Dbms.UNKNOWN;
        }
        DescriptionService descriptionService = ModelFacade.forDbms((Dbms)object).getDescriptionService();
        Intrinsics.checkNotNullExpressionValue((Object)descriptionService, (String)"getDescriptionService(...)");
        DescriptionService service = descriptionService;
        DescriptionService.Context context = new DescriptionService.Context(options2, cb);
        context.setIndent("");
        ModelDescribing.describeTree($this$describeTree, service, context);
    }

    /*
     * WARNING - void declaration
     */
    private static final void describeTree(BasicNode $this$describeTree, DescriptionService service, DescriptionService.Context context) {
        BasicNode basicNode = $this$describeTree;
        if (basicNode instanceof BasicElement) {
            ModelDescribing.describeTreeRecursively(service, context, (BasicElement)$this$describeTree);
        } else if (basicNode instanceof Family) {
            Iterable $this$forEach$iv = (Iterable)((Object)$this$describeTree);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicElement it2 = (BasicElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                ModelDescribing.describeTree((BasicNode)it2, service, context);
            }
        } else {
            void $this$iv;
            CodeBuilder<ModelDescriptionAnnotation> $this$forEach$iv = context.getCb();
            CharSequence[] $i$f$forEach = new CharSequence[]{$this$describeTree.toString()};
            CharSequence[] words$iv = $i$f$forEach;
            Object annotation$iv = null;
            boolean $i$f$phraseLn = false;
            $this$iv.phrase(Arrays.copyOf(words$iv, words$iv.length), annotation$iv, true);
        }
    }

    private static final void describeTreeRecursively(DescriptionService service, DescriptionService.Context context, BasicElement e2) {
        List<NameValue> describedReferences;
        List<DescriptionService.NameAndValue> describedProperties;
        Collection<String> dependsOnNames;
        CharSequence[] charSequenceArray;
        String name2;
        context.getDescribed().clear();
        service.considerAlwaysDescribedProperties(context);
        CodeBuilder<ModelDescriptionAnnotation> cb = context.getCb();
        DescriptionService.Context this_$iv = context;
        boolean $i$f$getWithSurrogates = false;
        boolean withSurrogates = this_$iv.getOptions().getWithSurrogates();
        String string = name2 = e2.getParent() instanceof BasicView && Intrinsics.areEqual((Object)e2.getKind(), (Object)ObjectKind.COLUMN) && e2 instanceof BasicNamedElement && ((BasicNamedElement)e2).isNameSurrogate() && ((BasicNamedElement)e2).isNameScripted() ? ((BasicNamedElement)e2).getRealName() : e2.identity(withSurrogates);
        if (context.getOptions().getWithLevels()) {
            if (e2 instanceof BasicMultiLevelObject) {
                Level detailsLevel;
                Level level = detailsLevel = ((BasicMultiLevelObject)e2).getDetailsLevel();
                char dlc = level != null ? NumberFun.getOneDigitChar(level.level) : (char)'-';
                charSequenceArray = new CharSequence[]{"\u230a" + dlc + "\u230b"};
                CodeBuilder.phrase$default(cb, charSequenceArray, (Object)ModelDescriptionAnnotation.MdaDetailsLevel, false, 4, null);
            }
            if (e2 instanceof BasicMultiLevelIntrospectableArea) {
                Level introspectionLevel;
                Level level = introspectionLevel = ((BasicMultiLevelIntrospectableArea)e2).getExplicitIntrospectionLevel();
                char ilc = level != null ? NumberFun.getOneDigitChar(level.level) : (char)'-';
                charSequenceArray = new CharSequence[]{"\u2308" + ilc + "\u2309"};
                CodeBuilder.phrase$default(cb, charSequenceArray, (Object)ModelDescriptionAnnotation.MdaIntrospectionLevel, false, 4, null);
            }
        }
        if (withSurrogates && e2 instanceof BasicArrangedElement && ((BasicArrangedElement)e2).getPosition() != 0) {
            String position = String.valueOf(((BasicArrangedElement)e2).getPosition());
            CharSequence[] ilc = new CharSequence[]{"[" + position + "]"};
            CodeBuilder.phrase$default(cb, ilc, (Object)ModelDescriptionAnnotation.MdaPosition, false, 4, null);
        }
        CharSequence[] position = new CharSequence[]{name2};
        CodeBuilder.phrase$default(cb, position, (Object)ModelDescriptionAnnotation.MdaName, false, 4, null);
        if (withSurrogates && e2 instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)e2).getObjectId() != Long.MIN_VALUE) {
            String objectId = String.valueOf(((BasicIdentifiedElement)e2).getObjectId());
            CharSequence[] ilc = new CharSequence[]{"#" + objectId};
            CodeBuilder.phrase$default(cb, ilc, (Object)ModelDescriptionAnnotation.MdaObjectId, false, 4, null);
        }
        cb.append(":");
        String content = ((Object)StringsKt.trim((CharSequence)service.content(e2, context))).toString();
        String options2 = ((Object)StringsKt.trim((CharSequence)service.options(e2, context))).toString();
        charSequenceArray = new CharSequence[]{content};
        CodeBuilder.phrase$default(cb, charSequenceArray, null, false, 6, null);
        charSequenceArray = new CharSequence[]{options2};
        CodeBuilder.phrase$default(cb, charSequenceArray, (Object)ModelDescriptionAnnotation.MdaAdditionalOptions, false, 4, null);
        cb.nl();
        String comment = e2.getComment();
        CharSequence charSequence = comment;
        if (!(charSequence == null || charSequence.length() == 0)) {
            StringBuilder stringBuilder = StringUtil.escapeStringCharacters((int)comment.length(), (String)comment, null, (boolean)false, (boolean)false, (StringBuilder)new StringBuilder(comment.length()));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"escapeStringCharacters(...)");
            StringBuilder escapedComment = stringBuilder;
            cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(cb, escapedComment){
                final /* synthetic */ CodeBuilder<ModelDescriptionAnnotation> $cb;
                final /* synthetic */ StringBuilder $escapedComment;
                {
                    this.$cb = $cb;
                    this.$escapedComment = $escapedComment;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void words$iv;
                    void this_$iv;
                    CodeBuilder<ModelDescriptionAnnotation> codeBuilder = this.$cb;
                    CharSequence[] charSequenceArray = new CharSequence[]{"--  ", this.$escapedComment};
                    ModelDescriptionAnnotation annotation$iv = ModelDescriptionAnnotation.MdaComment;
                    boolean $i$f$phraseLn = false;
                    this_$iv.phrase((CharSequence[])Arrays.copyOf(words$iv, ((void)words$iv).length), annotation$iv, true);
                }
            }));
        }
        if (!(dependsOnNames = service.getDependsOnNames(e2, context.getOptions().getWithSurrogates())).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(cb, dependsOnNames){
                final /* synthetic */ CodeBuilder<ModelDescriptionAnnotation> $cb;
                final /* synthetic */ Collection<String> $dependsOnNames;
                {
                    this.$cb = $cb;
                    this.$dependsOnNames = $dependsOnNames;
                    super(0);
                }

                public final void invoke() {
                    CharSequence[] charSequenceArray = new CharSequence[]{"^", "depends on"};
                    CodeBuilder.phrase$default(this.$cb, charSequenceArray, null, false, 6, null);
                    charSequenceArray = new CharSequence[]{CollectionsKt.joinToString$default((Iterable)this.$dependsOnNames, null, null, null, (int)0, null, null, (int)63, null)};
                    CodeBuilder.phrase$default(this.$cb, charSequenceArray, null, false, 6, null);
                    this.$cb.nl();
                }
            }));
        }
        if (!((Collection)(describedProperties = service.describeProperties(e2, context))).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(cb, describedProperties){
                final /* synthetic */ CodeBuilder<ModelDescriptionAnnotation> $cb;
                final /* synthetic */ List<DescriptionService.NameAndValue> $describedProperties;
                {
                    this.$cb = $cb;
                    this.$describedProperties = $describedProperties;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void words$iv;
                    void $this$iv;
                    CodeBuilder<ModelDescriptionAnnotation> codeBuilder = this.$cb;
                    CharSequence[] charSequenceArray = new CharSequence[]{".", "properties"};
                    A annotation$iv = null;
                    boolean $i$f$phraseLn = false;
                    $this$iv.phrase((CharSequence[])Arrays.copyOf(words$iv, ((void)words$iv).length), annotation$iv, true);
                    this.$cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(this.$describedProperties, this.$cb){
                        final /* synthetic */ List<DescriptionService.NameAndValue> $describedProperties;
                        final /* synthetic */ CodeBuilder<ModelDescriptionAnnotation> $cb;
                        {
                            this.$describedProperties = $describedProperties;
                            this.$cb = $cb;
                            super(0);
                        }

                        public final void invoke() {
                            for (DescriptionService.NameAndValue p2 : this.$describedProperties) {
                                CharSequence[] charSequenceArray = new CharSequence[]{p2.getName()};
                                CodeBuilder.phrase$default(this.$cb, charSequenceArray, null, false, 6, null);
                                String v2 = p2.getValue();
                                if (v2 == DescriptionService.Companion.getNULL_STR()) {
                                    var4_4 = new CharSequence[]{"is null"};
                                    CodeBuilder.phrase$default(this.$cb, var4_4, null, false, 6, null);
                                } else if (v2 == DescriptionService.Companion.getTRUE_STR()) {
                                    var4_4 = new CharSequence[]{"+"};
                                    CodeBuilder.phrase$default(this.$cb, var4_4, null, false, 6, null);
                                } else if (v2 == DescriptionService.Companion.getFALSE_STR()) {
                                    var4_4 = new CharSequence[]{"-"};
                                    CodeBuilder.phrase$default(this.$cb, var4_4, null, false, 6, null);
                                } else {
                                    var4_4 = new CharSequence[]{"=", v2};
                                    CodeBuilder.phrase$default(this.$cb, var4_4, null, false, 6, null);
                                }
                                this.$cb.nl();
                            }
                        }
                    }));
                }
            }));
        }
        if (!((Collection)(describedReferences = service.describeReferences(e2, context))).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(cb, describedReferences){
                final /* synthetic */ CodeBuilder<ModelDescriptionAnnotation> $cb;
                final /* synthetic */ List<NameValue> $describedReferences;
                {
                    this.$cb = $cb;
                    this.$describedReferences = $describedReferences;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void words$iv;
                    void $this$iv;
                    CodeBuilder<ModelDescriptionAnnotation> codeBuilder = this.$cb;
                    CharSequence[] charSequenceArray = new CharSequence[]{".", "references"};
                    A annotation$iv = null;
                    boolean $i$f$phraseLn = false;
                    $this$iv.phrase((CharSequence[])Arrays.copyOf(words$iv, ((void)words$iv).length), annotation$iv, true);
                    this.$cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(this.$describedReferences, this.$cb){
                        final /* synthetic */ List<NameValue> $describedReferences;
                        final /* synthetic */ CodeBuilder<ModelDescriptionAnnotation> $cb;
                        {
                            this.$describedReferences = $describedReferences;
                            this.$cb = $cb;
                            super(0);
                        }

                        public final void invoke() {
                            for (NameValue r : this.$describedReferences) {
                                CharSequence[] charSequenceArray = new CharSequence[]{r.getName()};
                                CodeBuilder.phrase$default(this.$cb, charSequenceArray, null, false, 6, null);
                                String v2 = r.getValue();
                                if (v2 == DescriptionService.Companion.getNULL_STR()) {
                                    var4_4 = new CharSequence[]{DescriptionService.Companion.getNULL_STR()};
                                    CodeBuilder.phrase$default(this.$cb, var4_4, null, false, 6, null);
                                } else {
                                    var4_4 = new CharSequence[]{"=", v2};
                                    CodeBuilder.phrase$default(this.$cb, var4_4, null, false, 6, null);
                                }
                                this.$cb.nl();
                            }
                        }
                    }));
                }
            }));
        }
        List<? extends Family<? extends BasicElement>> list = e2.getFamilies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
        List families = CollectionsKt.toMutableList((Collection)list);
        if (!((Collection)families).isEmpty()) {
            cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(context, (List<Family<? extends BasicElement>>)families, cb, service){
                final /* synthetic */ DescriptionService.Context $context;
                final /* synthetic */ List<Family<? extends BasicElement>> $families;
                final /* synthetic */ CodeBuilder<ModelDescriptionAnnotation> $cb;
                final /* synthetic */ DescriptionService $service;
                {
                    this.$context = $context;
                    this.$families = $families;
                    this.$cb = $cb;
                    this.$service = $service;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    if (this.$context.getOptions().getOrdered()) {
                        List<Family<? extends BasicElement>> $this$sortBy$iv = this.$families;
                        boolean $i$f$sortBy = false;
                        if ($this$sortBy$iv.size() > 1) {
                            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b2) {
                                    Family it2 = (Family)a;
                                    boolean bl = false;
                                    it2 = (Family)b2;
                                    Comparable comparable = it2.getMetaObject().kind;
                                    bl = false;
                                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)it2.getMetaObject().kind);
                                }
                            });
                        }
                    }
                    for (Family<? extends BasicElement> family : this.$families) {
                        void $this$iv;
                        JBIterable children2;
                        if (family.isEmpty()) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)family.jbi().filter(arg_0 -> describeTreeRecursively.5.invoke$lambda$1(describeTreeRecursively.children.1.INSTANCE, arg_0)), (String)"filter(...)");
                        if (!children2.isNotEmpty()) continue;
                        CodeBuilder<ModelDescriptionAnnotation> codeBuilder = this.$cb;
                        CharSequence[] charSequenceArray = new CharSequence[]{"+", StringUtil.pluralize((String)family.getMetaObject().kind.code())};
                        CharSequence[] words$iv = charSequenceArray;
                        A annotation$iv = null;
                        boolean $i$f$phraseLn = false;
                        $this$iv.phrase(Arrays.copyOf(words$iv, words$iv.length), annotation$iv, true);
                        for (BasicElement child : children2) {
                            this.$cb.indenting((Function0<Unit>)((Function0)new Function0<Unit>(this.$service, this.$context, child){
                                final /* synthetic */ DescriptionService $service;
                                final /* synthetic */ DescriptionService.Context $context;
                                final /* synthetic */ BasicElement $child;
                                {
                                    this.$service = $service;
                                    this.$context = $context;
                                    this.$child = $child;
                                    super(0);
                                }

                                public final void invoke() {
                                    BasicElement basicElement = this.$child;
                                    Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"$child");
                                    ModelDescribing.access$describeTreeRecursively(this.$service, this.$context, basicElement);
                                }
                            }));
                        }
                    }
                }

                private static final boolean invoke$lambda$1(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Boolean)$tmp0.invoke(p0);
                }
            }));
        }
    }

    @JvmOverloads
    @NotNull
    public static final String describeTree(@NotNull BasicNode $this$describeTree) {
        Intrinsics.checkNotNullParameter((Object)$this$describeTree, (String)"<this>");
        return ModelDescribing.describeTree$default($this$describeTree, null, 1, null);
    }

    public static final /* synthetic */ void access$describeTreeRecursively(DescriptionService service, DescriptionService.Context context, BasicElement e2) {
        ModelDescribing.describeTreeRecursively(service, context, e2);
    }
}

