/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergingRenameQueue<P> {
    private final Int2ObjectMap<List<StampedRenameItem<P>>> myQueues = new Int2ObjectOpenHashMap();
    private int stamp;
    private int count;

    public void queueRename(@NotNull P path, @NotNull P oldPath, int mark2) {
        StampedRenameItem prevRename;
        if (path == null) {
            MergingRenameQueue.$$$reportNull$$$0(0);
        }
        if (oldPath == null) {
            MergingRenameQueue.$$$reportNull$$$0(1);
        }
        if (oldPath.equals(path)) {
            return;
        }
        ArrayList<StampedRenameItem<P>> queue = (ArrayList<StampedRenameItem<P>>)this.myQueues.get(mark2);
        if (queue == null) {
            queue = new ArrayList<StampedRenameItem<P>>();
            this.myQueues.put(mark2, queue);
        }
        StampedRenameItem stampedRenameItem = prevRename = queue.isEmpty() ? null : (StampedRenameItem)queue.get(queue.size() - 1);
        if (prevRename != null && prevRename.to.equals(oldPath)) {
            if (prevRename.from.equals(path)) {
                queue.remove(queue.size() - 1);
            } else {
                queue.set(queue.size() - 1, new StampedRenameItem<Object>(prevRename.from, path, ++this.stamp));
            }
        } else {
            queue.add(new StampedRenameItem<P>(oldPath, path, ++this.stamp));
            ++this.count;
        }
    }

    @NotNull
    public List<? extends RenameItem<P>> clear() {
        if (this.myQueues.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                MergingRenameQueue.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<StampedRenameItem> res2 = new ArrayList<StampedRenameItem>(this.count);
        for (List value2 : this.myQueues.values()) {
            res2.addAll(value2);
        }
        res2.sort(Comparator.comparing(i2 -> i2.stamp));
        this.myQueues.clear();
        ArrayList<StampedRenameItem> arrayList = res2;
        if (arrayList == null) {
            MergingRenameQueue.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/MergingRenameQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/MergingRenameQueue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "clear";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queueRename";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class StampedRenameItem<P>
    extends RenameItem<P> {
        public final int stamp;

        private StampedRenameItem(@NotNull P from, @NotNull P to, int stamp) {
            if (from == null) {
                StampedRenameItem.$$$reportNull$$$0(0);
            }
            if (to == null) {
                StampedRenameItem.$$$reportNull$$$0(1);
            }
            super(from, to);
            this.stamp = stamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "to";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/model/MergingRenameQueue$StampedRenameItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class RenameProcessor<P> {
        public abstract boolean exists(@NotNull P var1);

        @Nullable
        public abstract P getParent(@NotNull P var1);

        @NotNull
        public abstract P createTempName(@NotNull P var1);

        public abstract void processRename(@NotNull P var1, @NotNull P var2);

        public void performRenamesBlock(@NotNull Runnable r) {
            if (r == null) {
                RenameProcessor.$$$reportNull$$$0(0);
            }
            r.run();
        }

        public void perform(@NotNull List<? extends RenameItem<P>> queue) {
            if (queue == null) {
                RenameProcessor.$$$reportNull$$$0(1);
            }
            this.clearUnneededRenames(queue);
            if (queue.isEmpty()) {
                return;
            }
            this.flushRenameQueue(queue);
        }

        void flushRenameQueue(@NotNull List<? extends RenameItem<P>> queue) {
            if (queue == null) {
                RenameProcessor.$$$reportNull$$$0(2);
            }
            LinkedHashMap toHandle = new LinkedHashMap();
            for (RenameItem<P> couple : queue) {
                toHandle.put(couple.from, couple.to);
            }
            this.performRenamesBlock(() -> this.clearAndProcessGroupRename(toHandle));
        }

        private void clearAndProcessGroupRename(Map<P, P> renames) {
            if (renames.isEmpty()) {
                return;
            }
            this.processGroupRename(renames);
        }

        private void processGroupRename(Map<P, P> renames) {
            HashSet<P> targets2 = new HashSet<P>(renames.values());
            this.processSimpleRenames(renames, targets2);
            while (!renames.isEmpty()) {
                Iterator<Map.Entry<P, P>> it2 = renames.entrySet().iterator();
                Map.Entry<P, P> breaker = it2.next();
                it2.remove();
                P tmp = this.createTempName(breaker.getKey());
                this.processRename(breaker.getKey(), tmp);
                this.processSimpleRenames(renames, targets2);
                this.processRename(tmp, breaker.getValue());
            }
        }

        private void clearUnneededRenames(List<? extends RenameItem<P>> renames) {
            HashSet validRenames = new HashSet();
            HashSet ignoredRenames = new HashSet();
            Iterator<RenameItem<P>> iterator = renames.iterator();
            while (iterator.hasNext()) {
                RenameItem<P> entry = iterator.next();
                if (!this.renameMakesSense(entry.from, validRenames, ignoredRenames)) {
                    ignoredRenames.add(entry.to);
                    iterator.remove();
                    continue;
                }
                validRenames.remove(entry.from);
                validRenames.add(entry.to);
                ignoredRenames.remove(entry.to);
            }
        }

        private boolean renameMakesSense(@NotNull P oldPath, Set<P> validRenames, Set<P> ignoredRenames) {
            if (oldPath == null) {
                RenameProcessor.$$$reportNull$$$0(3);
            }
            if (ignoredRenames.contains(oldPath)) {
                return false;
            }
            if (this.exists(oldPath)) {
                return true;
            }
            return this.wasRenamed(oldPath, validRenames);
        }

        private boolean wasRenamed(@NotNull P oldPath, Set<P> validRenames) {
            if (oldPath == null) {
                RenameProcessor.$$$reportNull$$$0(4);
            }
            if (validRenames.contains(oldPath)) {
                return true;
            }
            P parent2 = this.getParent(oldPath);
            return parent2 != null && this.wasRenamed(parent2, validRenames);
        }

        private void processSimpleRenames(Map<P, P> renames, Set<P> targets2) {
            while (!renames.isEmpty()) {
                int before2 = renames.size();
                Iterator<Map.Entry<P, P>> it2 = renames.entrySet().iterator();
                block1: while (it2.hasNext()) {
                    Map.Entry<P, P> entry = it2.next();
                    if (renames.containsKey(entry.getValue())) continue;
                    P tmp = this.getParent(entry.getKey());
                    while (tmp != null) {
                        if (targets2.contains(tmp)) continue block1;
                        tmp = this.getParent(tmp);
                    }
                    it2.remove();
                    this.processRename(entry.getKey(), entry.getValue());
                }
                if (before2 != renames.size()) continue;
                break;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldPath";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/MergingRenameQueue$RenameProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performRenamesBlock";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "flushRenameQueue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renameMakesSense";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wasRenamed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RenameItem<P> {
        public final P from;
        public final P to;

        public RenameItem(@NotNull P from, @NotNull P to) {
            if (from == null) {
                RenameItem.$$$reportNull$$$0(0);
            }
            if (to == null) {
                RenameItem.$$$reportNull$$$0(1);
            }
            this.from = from;
            this.to = to;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "to";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/model/MergingRenameQueue$RenameItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

