/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.fulltextsearch;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.psi.DbColumnImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementUsageBase;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.WhereClauseTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.TriConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001\u0018B;\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/fulltextsearch/FullTextSearchDbElementUsage;", "Lcom/intellij/database/psi/DbElementUsageBase;", "Lcom/intellij/database/psi/DbElement;", "", "text", "", "element", "chunks", "", "Lcom/intellij/usages/TextChunk;", "usagesCount", "", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "(Ljava/lang/String;Lcom/intellij/database/psi/DbElement;[Lcom/intellij/usages/TextChunk;ILjava/util/List;)V", "getUsagesCount", "()I", "compareTo", "other", "doNavigate", "", "requestFocus", "", "Companion", "intellij.database.impl"})
public final class FullTextSearchDbElementUsage
extends DbElementUsageBase<DbElement>
implements Comparable<FullTextSearchDbElementUsage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int usagesCount;
    @NotNull
    private final List<PredicatesHelper.PredicateProducer> predicates;

    private FullTextSearchDbElementUsage(String text2, DbElement element2, TextChunk[] chunks, int usagesCount, List<PredicatesHelper.PredicateProducer> predicates) {
        super(text2, element2, chunks);
        this.usagesCount = usagesCount;
        this.predicates = predicates;
    }

    public final int getUsagesCount() {
        return this.usagesCount;
    }

    @Override
    protected void doNavigate(boolean requestFocus) {
        DbTableImpl table;
        DbElement dbElement = this.myElement;
        if (dbElement instanceof DbTableImpl) {
            v0 = (DbTableImpl)this.myElement;
        } else if (dbElement instanceof DbColumnImpl) {
            PsiElement psiElement = ((DbColumnImpl)this.myElement).getParent();
            v0 = psiElement instanceof DbTableImpl ? (DbTableImpl)psiElement : null;
            if (v0 == null) {
                return;
            }
        } else {
            v0 = table = null;
        }
        if (table != null) {
            DbNavigationUtils.navigateToData(table, requestFocus, null, (TriConsumer<DdlBuilder, List<DasColumn>, Dbms>)((TriConsumer)(arg_0, arg_1, arg_2) -> FullTextSearchDbElementUsage.doNavigate$lambda$0(this, arg_0, arg_1, arg_2)));
        }
    }

    @Override
    public int compareTo(@NotNull FullTextSearchDbElementUsage other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (Intrinsics.areEqual((Object)this, (Object)other)) {
            return 0;
        }
        String string = other.myText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myText");
        return this.myText.compareTo(string);
    }

    private static final void doNavigate$lambda$0(FullTextSearchDbElementUsage this$0, DdlBuilder b2, List list, Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PredicatesWhereClause whereClause2 = new PredicatesWhereClause(this$0.predicates, "OR", null, 4, null);
        Intrinsics.checkNotNull((Object)dbms);
        DmlHelper dmlHelper = DmlUtilKt.dmlGenerator(dbms);
        WhereClauseTask.Companion.Builder builder = DmlTaskKt.whereClause(whereClause2);
        Intrinsics.checkNotNull((Object)b2);
        dmlHelper.generate(builder.build(b2));
    }

    public /* synthetic */ FullTextSearchDbElementUsage(String text2, DbElement element2, TextChunk[] chunks, int usagesCount, List predicates, DefaultConstructorMarker $constructor_marker) {
        this(text2, element2, chunks, usagesCount, predicates);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/database/fulltextsearch/FullTextSearchDbElementUsage$Companion;", "", "()V", "create", "Lcom/intellij/database/fulltextsearch/FullTextSearchDbElementUsage;", "element", "Lcom/intellij/database/psi/DbElement;", "usagesCount", "", "maxNumOfFetchedRows", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FullTextSearchDbElementUsage create(@NotNull DbElement element2, int usagesCount, int maxNumOfFetchedRows, @NotNull List<PredicatesHelper.PredicateProducer> predicates) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter(predicates, (String)"predicates");
            String string = element2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String name2 = string;
            String desc = usagesCount == maxNumOfFetchedRows ? " (" + usagesCount + "+)" : " (" + usagesCount + ")";
            TextChunk[] textChunkArray = new TextChunk[]{new TextChunk(SimpleTextAttributes.REGULAR_ATTRIBUTES.toTextAttributes(), name2), new TextChunk(SimpleTextAttributes.GRAYED_ATTRIBUTES.toTextAttributes(), desc)};
            TextChunk[] chunks = textChunkArray;
            return new FullTextSearchDbElementUsage(name2 + desc, element2, chunks, usagesCount, predicates, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

